/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class OrderBySet
implements Measurable,
Serializable {
    private static final long serialVersionUID = -3519009335311129479L;
    private boolean order;
    private char[] field;
    private byte operation;

    public OrderBySet(boolean order, char[] field, byte operation) {
        this.order = order;
        this.field = field;
        this.operation = operation;
    }

    public OrderBySet(boolean order, char[] field) {
        this(order, field, 99);
    }

    public OrderBySet(boolean order, String field, byte operation) {
        this(order, field.toCharArray(), operation);
    }

    public OrderBySet(boolean order, String field) {
        this(order, field.toCharArray(), 99);
    }

    public int size() {
        if (this.field != null) {
            return 2 + SizeUtil.sizeOf((char[])this.field) + SizeUtil.OBJECT_OVERHEAD;
        }
        return 2 + SizeUtil.OBJECT_OVERHEAD;
    }

    public char[] getField() {
        return this.field;
    }

    public boolean getOrder() {
        return this.order;
    }

    public byte getOperation() {
        return this.operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        OrderBySet castedObj = (OrderBySet)o;
        return this.order == castedObj.order && this.operation == castedObj.operation && Arrays.equals(this.field, castedObj.field);
    }

    public String toString() {
        return "[OrderBySet [order = " + this.order + "][field = " + new String(this.field) + "][operation = " + this.operation + "]";
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.order);
        ByteUtil.writeChars((OutputStream)out, (char[])this.field);
        ByteUtil.writeByte((OutputStream)out, (byte)this.operation);
    }

    public static OrderBySet deserialize(InputStream in) throws IOException {
        return new OrderBySet(ByteUtil.readBoolean((InputStream)in), ByteUtil.readChars((InputStream)in), ByteUtil.readByte((InputStream)in));
    }
}

