/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.common.msg.protocol.Protocol;
import com.diquest.ir.common.msg.protocol.StringKeyValueSet;
import com.diquest.ir.common.msg.protocol.query.DistanceSet;
import com.diquest.ir.common.msg.protocol.query.FilterSet;
import com.diquest.ir.common.msg.protocol.query.GroupBySet;
import com.diquest.ir.common.msg.protocol.query.OrderBySet;
import com.diquest.ir.common.msg.protocol.query.SelectSet;
import com.diquest.ir.common.msg.protocol.query.WhereSet;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.TransmitableKnownFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Query
extends Transmitable
implements Cloneable,
Measurable {
    private static final char[] EMPTY_CHARS = new char[0];
    protected static final int typecode;
    private int searchOption = 0;
    private int thesaurusOption = 0;
    private int rankingOption = 0;
    private int categoryRankingOption = 0;
    private char[] highLightStartTag;
    private char[] highLightEndTag;
    private SelectSet[] selectFields = new SelectSet[0];
    private int resultStart = -1;
    private int resultEnd = -1;
    private GroupBySet[] groupSelectFields = new GroupBySet[0];
    private char[] fromField = null;
    private char[] profile = null;
    private char[] searchKeyword;
    private FilterSet[] filterFields = new FilterSet[0];
    private WhereSet[] whereFields = new WhereSet[0];
    private OrderBySet[] orderbyFields = new OrderBySet[0];
    private DistanceSet distanceField;
    private char[] queryModifier;
    private char[] resultModifier;
    private StringKeyValueSet data;
    private boolean loggable;
    private char[] logKeyword = null;
    private char[] logExtractor = null;
    private char[] logExtractorOption = null;
    private int resultCutOffSize = -1;
    private int maxHighlight = -1;
    private char[] userName;
    private char[] extData;
    private boolean debug = false;
    private boolean search = true;
    private char[] recommend;
    private char[] redirect;
    private boolean faultless;
    private boolean printQuery = false;
    private char[] queryModifierList;
    private char[] resultModifierList;
    private boolean ignoreBrokerTimeout = false;
    private char[] brokerPagingInfo;
    private boolean brokerPrevious = false;
    private boolean keywordProfile = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.protocol.query.Query");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typecode = TransmitableKnownFactory.getType((String)clazz.getName());
    }

    protected int typecode() {
        return typecode;
    }

    public Query() {
        this.highLightStartTag = EMPTY_CHARS;
        this.highLightEndTag = EMPTY_CHARS;
        this.highLightStartTag = EMPTY_CHARS;
        this.highLightEndTag = EMPTY_CHARS;
        this.queryModifier = EMPTY_CHARS;
        this.resultModifier = EMPTY_CHARS;
        this.data = new StringKeyValueSet();
    }

    public Query(char[] highLightStartTag, char[] highLightEndTag) {
        this();
        this.highLightStartTag = highLightStartTag;
        this.highLightEndTag = highLightEndTag;
    }

    public Query(String highLightStartTag, String highLightEndTag) {
        this(highLightStartTag.toCharArray(), highLightEndTag.toCharArray());
    }

    public void setSearchOption(int searchOption) {
        this.searchOption = searchOption;
    }

    public void setThesaurusOption(int thesaurusOption) {
        this.thesaurusOption = thesaurusOption;
    }

    public void setRankingOption(int rankingOption) {
        this.rankingOption = rankingOption;
    }

    public void setCategoryRankingOption(int categoryRankingOption) {
        this.categoryRankingOption = categoryRankingOption;
    }

    public void setSelect(SelectSet[] fields) {
        this.selectFields = fields;
    }

    public void setResult(int startValue, int endValue) {
        this.resultStart = startValue;
        this.resultEnd = endValue;
    }

    public void setGroupBy(GroupBySet[] groupBys) {
        this.groupSelectFields = groupBys;
    }

    public void setFrom(char[] froms) {
        this.fromField = froms;
    }

    public void setFrom(String froms) {
        this.fromField = froms.toCharArray();
    }

    public void setProfile(char[] profileID) {
        this.profile = profileID;
    }

    public void setProfile(String profileID) {
        this.profile = profileID.toCharArray();
    }

    public void setWhere(WhereSet[] wheres) {
        this.whereFields = wheres;
    }

    public void setOrderby(OrderBySet[] orderbys) {
        this.orderbyFields = orderbys;
    }

    public void setFilter(FilterSet[] filter) {
        if (filter == null) {
            return;
        }
        this.filterFields = new FilterSet[filter.length];
        int successCount = 0;
        int fIdx = 0;
        while (fIdx < filter.length) {
            if (!this.isBadFilter(filter[fIdx])) {
                this.filterFields[successCount++] = filter[fIdx];
            }
            ++fIdx;
        }
        if (successCount != filter.length) {
            FilterSet[] temp = new FilterSet[successCount];
            System.arraycopy(this.filterFields, 0, temp, 0, successCount);
            this.filterFields = temp;
        }
    }

    private boolean isBadFilter(FilterSet filter) {
        if (filter == null) {
            return true;
        }
        char[][] keywords = filter.getKeyword();
        if (keywords == null) {
            return true;
        }
        int i = 0;
        while (i < keywords.length) {
            if (keywords[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setQueryModifier(String str) {
        this.queryModifier = str.toCharArray();
    }

    public void setResultModifier(String str) {
        this.resultModifier = str.toCharArray();
    }

    public void setValue(String key, String value) {
        this.data.put(key, value);
    }

    public void setQueryLogger(char[] queryLogger) {
    }

    public void setQueryLogger(String queryLogger) {
    }

    public char[] getFromField() {
        return this.fromField;
    }

    public GroupBySet[] getGroupSelectFields() {
        return this.groupSelectFields;
    }

    public OrderBySet[] getOrderbyFields() {
        return this.orderbyFields;
    }

    public int getResultStart() {
        return this.resultStart;
    }

    public int getResultEnd() {
        return this.resultEnd;
    }

    public SelectSet[] getSelectFields() {
        return this.selectFields;
    }

    public WhereSet[] getWhereFields() {
        return this.whereFields;
    }

    public FilterSet[] getFilterFields() {
        return this.filterFields;
    }

    public char[] getHighLightEndTag() {
        return this.highLightEndTag;
    }

    public char[] getHighLightStartTag() {
        return this.highLightStartTag;
    }

    public int getSearchOption() {
        return this.searchOption;
    }

    public int getThesaurusOption() {
        return this.thesaurusOption;
    }

    public int getCategoryRankingOption() {
        return this.categoryRankingOption;
    }

    public int getMagicHeader() {
        return typecode;
    }

    public String getQueryModifier() {
        if (this.queryModifier == null || this.queryModifier.length == 0) {
            return null;
        }
        return new String(this.queryModifier);
    }

    public String getResultModifier() {
        if (this.resultModifier == null || this.resultModifier.length == 0) {
            return null;
        }
        return new String(this.resultModifier);
    }

    public String getValue(String key) {
        return this.data.get(key);
    }

    public String[] getKeys() {
        return this.data.getKeys();
    }

    public String getQueryLogger() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Query castedObj = (Query)o;
        return Arrays.equals(this.whereFields, castedObj.whereFields) && this.resultStart == castedObj.resultStart && this.resultEnd == castedObj.resultEnd && this.searchOption == castedObj.searchOption && this.thesaurusOption == castedObj.thesaurusOption && this.rankingOption == castedObj.rankingOption && this.categoryRankingOption == castedObj.categoryRankingOption && Arrays.equals(this.selectFields, castedObj.selectFields) && Arrays.equals(this.groupSelectFields, castedObj.groupSelectFields) && Arrays.equals(this.fromField, castedObj.fromField) && Arrays.equals(this.profile, castedObj.profile) && Arrays.equals(this.orderbyFields, castedObj.orderbyFields) && Arrays.equals(this.filterFields, castedObj.filterFields) && Arrays.equals(this.highLightStartTag, castedObj.highLightStartTag) && Arrays.equals(this.highLightEndTag, castedObj.highLightEndTag) && Arrays.equals(this.queryModifier, castedObj.queryModifier) && Arrays.equals(this.resultModifier, castedObj.resultModifier) && (this.distanceField == castedObj.distanceField || this.distanceField != null && this.distanceField.equals(castedObj.distanceField)) && (this.searchKeyword == null && castedObj.searchKeyword == null || Arrays.equals(this.searchKeyword, castedObj.searchKeyword)) && this.data.equals(castedObj.data);
    }

    public int size() {
        int i;
        int size = SizeUtil.OBJECT_OVERHEAD + 49;
        size += SizeUtil.sizeOf((char[])this.highLightStartTag);
        size += SizeUtil.sizeOf((char[])this.highLightEndTag);
        if (this.selectFields != null) {
            size += 2;
            i = 0;
            while (i < this.selectFields.length) {
                size += this.selectFields[i].size();
                ++i;
            }
        }
        if (this.groupSelectFields != null) {
            size += 2;
            i = 0;
            while (i < this.groupSelectFields.length) {
                size += this.groupSelectFields[i].size();
                ++i;
            }
        }
        if (this.fromField != null) {
            size += SizeUtil.sizeOf((char[])this.fromField);
        }
        if (this.profile != null) {
            size += SizeUtil.sizeOf((char[])this.profile);
        }
        if (this.searchKeyword != null) {
            size += SizeUtil.sizeOf((char[])this.searchKeyword);
        }
        if (this.filterFields != null) {
            size += 2;
            i = 0;
            while (i < this.filterFields.length) {
                size += this.filterFields[i].size();
                ++i;
            }
        }
        if (this.whereFields != null) {
            size += 2;
            i = 0;
            while (i < this.whereFields.length) {
                size += this.whereFields[i].size();
                ++i;
            }
        }
        if (this.orderbyFields != null) {
            size += 2;
            i = 0;
            while (i < this.orderbyFields.length) {
                size += this.orderbyFields[i].size();
                ++i;
            }
        }
        if (this.distanceField != null) {
            size += this.distanceField.size();
        }
        size += SizeUtil.sizeOf((char[])this.queryModifier);
        size += SizeUtil.sizeOf((char[])this.resultModifier);
        size += this.data.size();
        if (this.logKeyword != null) {
            size += SizeUtil.sizeOf((char[])this.logKeyword);
        }
        if (this.logExtractor != null) {
            size += SizeUtil.sizeOf((char[])this.logExtractor);
        }
        if (this.logExtractorOption != null) {
            size += SizeUtil.sizeOf((char[])this.logExtractorOption);
        }
        size += SizeUtil.sizeOf((char[])this.userName);
        size += SizeUtil.sizeOf((char[])this.extData);
        size += SizeUtil.sizeOf((char[])this.recommend);
        size += SizeUtil.sizeOf((char[])this.redirect);
        size += SizeUtil.sizeOf((char[])this.queryModifierList);
        size += SizeUtil.sizeOf((char[])this.resultModifierList);
        return size += SizeUtil.sizeOf((char[])this.brokerPagingInfo);
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        int j;
        ByteUtil.writeInt((OutputStream)out, (int)this.searchOption);
        ByteUtil.writeInt((OutputStream)out, (int)this.thesaurusOption);
        ByteUtil.writeInt((OutputStream)out, (int)this.rankingOption);
        ByteUtil.writeInt((OutputStream)out, (int)this.categoryRankingOption);
        ByteUtil.writeChars((OutputStream)out, (char[])this.highLightStartTag);
        ByteUtil.writeChars((OutputStream)out, (char[])this.highLightEndTag);
        if (this.selectFields == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)this.selectFields.length);
            j = 0;
            while (j < this.selectFields.length) {
                this.selectFields[j].serialize(out);
                ++j;
            }
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.resultStart);
        ByteUtil.writeInt((OutputStream)out, (int)this.resultEnd);
        if (this.groupSelectFields == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)this.groupSelectFields.length);
            j = 0;
            while (j < this.groupSelectFields.length) {
                this.groupSelectFields[j].serialize(out);
                ++j;
            }
        }
        ByteUtil.writeChars((OutputStream)out, (char[])this.fromField);
        ByteUtil.writeChars((OutputStream)out, (char[])this.profile);
        ByteUtil.writeChars((OutputStream)out, (char[])this.searchKeyword);
        if (this.whereFields == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)((short)this.whereFields.length));
            j = 0;
            while (j < this.whereFields.length) {
                this.whereFields[j].serialize(out);
                ++j;
            }
        }
        if (this.orderbyFields == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)((short)this.orderbyFields.length));
            j = 0;
            while (j < this.orderbyFields.length) {
                this.orderbyFields[j].serialize(out);
                ++j;
            }
        }
        if (this.filterFields == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)((short)this.filterFields.length));
            j = 0;
            while (j < this.filterFields.length) {
                this.filterFields[j].serialize(out);
                ++j;
            }
        }
        if (this.distanceField == null) {
            ByteUtil.writeBoolean((OutputStream)out, (boolean)false);
        } else {
            ByteUtil.writeBoolean((OutputStream)out, (boolean)true);
            this.distanceField.serialize(out);
        }
        ByteUtil.writeChars((OutputStream)out, (char[])this.queryModifier);
        ByteUtil.writeChars((OutputStream)out, (char[])this.resultModifier);
        this.data.serialize(out);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.loggable);
        ByteUtil.writeChars((OutputStream)out, (char[])this.logKeyword);
        ByteUtil.writeChars((OutputStream)out, (char[])this.logExtractor);
        ByteUtil.writeChars((OutputStream)out, (char[])this.logExtractorOption);
        ByteUtil.writeInt((OutputStream)out, (int)this.resultCutOffSize);
        ByteUtil.writeInt((OutputStream)out, (int)this.maxHighlight);
        ByteUtil.writeChars((OutputStream)out, (char[])this.userName);
        ByteUtil.writeChars((OutputStream)out, (char[])this.extData);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.debug);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.search);
        ByteUtil.writeChars((OutputStream)out, (char[])this.recommend);
        ByteUtil.writeChars((OutputStream)out, (char[])this.redirect);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.faultless);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.printQuery);
        ByteUtil.writeChars((OutputStream)out, (char[])this.queryModifierList);
        ByteUtil.writeChars((OutputStream)out, (char[])this.resultModifierList);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.ignoreBrokerTimeout);
        ByteUtil.writeChars((OutputStream)out, (char[])this.brokerPagingInfo);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.brokerPrevious);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.keywordProfile);
    }

    public void deserialize(InputStream in) throws IOException {
        this.searchOption = ByteUtil.readInt((InputStream)in);
        this.thesaurusOption = ByteUtil.readInt((InputStream)in);
        this.rankingOption = ByteUtil.readInt((InputStream)in);
        this.categoryRankingOption = ByteUtil.readInt((InputStream)in);
        this.highLightStartTag = ByteUtil.readChars((InputStream)in);
        this.highLightEndTag = ByteUtil.readChars((InputStream)in);
        int selectLength = ByteUtil.readInt((InputStream)in);
        this.selectFields = new SelectSet[selectLength];
        int j = 0;
        while (j < selectLength) {
            this.selectFields[j] = SelectSet.deserialize(in);
            ++j;
        }
        this.resultStart = ByteUtil.readInt((InputStream)in);
        this.resultEnd = ByteUtil.readInt((InputStream)in);
        int groupSize = ByteUtil.readInt((InputStream)in);
        this.groupSelectFields = new GroupBySet[groupSize];
        int j2 = 0;
        while (j2 < groupSize) {
            this.groupSelectFields[j2] = GroupBySet.deserialize(in);
            ++j2;
        }
        this.fromField = ByteUtil.readChars((InputStream)in);
        this.profile = ByteUtil.readChars((InputStream)in);
        this.searchKeyword = ByteUtil.readChars((InputStream)in);
        int whereSize = ByteUtil.readInt((InputStream)in);
        this.whereFields = new WhereSet[whereSize];
        int j3 = 0;
        while (j3 < whereSize) {
            this.whereFields[j3] = WhereSet.deserialize(in);
            ++j3;
        }
        int ordersize = ByteUtil.readInt((InputStream)in);
        this.orderbyFields = new OrderBySet[ordersize];
        int j4 = 0;
        while (j4 < ordersize) {
            this.orderbyFields[j4] = OrderBySet.deserialize(in);
            ++j4;
        }
        int filterLength = ByteUtil.readInt((InputStream)in);
        this.filterFields = new FilterSet[filterLength];
        int j5 = 0;
        while (j5 < filterLength) {
            this.filterFields[j5] = FilterSet.deserialize(in);
            ++j5;
        }
        if (ByteUtil.readBoolean((InputStream)in)) {
            this.distanceField = DistanceSet.deserialize(in);
        }
        this.queryModifier = ByteUtil.readChars((InputStream)in);
        this.resultModifier = ByteUtil.readChars((InputStream)in);
        this.data.deserialize(in);
        this.loggable = ByteUtil.readBoolean((InputStream)in);
        this.logKeyword = ByteUtil.readChars((InputStream)in);
        this.logExtractor = ByteUtil.readChars((InputStream)in);
        this.logExtractorOption = ByteUtil.readChars((InputStream)in);
        this.resultCutOffSize = ByteUtil.readInt((InputStream)in);
        this.maxHighlight = ByteUtil.readInt((InputStream)in);
        this.userName = ByteUtil.readChars((InputStream)in);
        this.extData = ByteUtil.readChars((InputStream)in);
        this.debug = ByteUtil.readBoolean((InputStream)in);
        this.search = ByteUtil.readBoolean((InputStream)in);
        this.recommend = ByteUtil.readChars((InputStream)in);
        this.redirect = ByteUtil.readChars((InputStream)in);
        this.faultless = ByteUtil.readBoolean((InputStream)in);
        this.printQuery = ByteUtil.readBoolean((InputStream)in);
        this.queryModifierList = ByteUtil.readChars((InputStream)in);
        this.resultModifierList = ByteUtil.readChars((InputStream)in);
        this.ignoreBrokerTimeout = ByteUtil.readBoolean((InputStream)in);
        this.brokerPagingInfo = ByteUtil.readChars((InputStream)in);
        this.brokerPrevious = ByteUtil.readBoolean((InputStream)in);
        this.keywordProfile = ByteUtil.readBoolean((InputStream)in);
    }

    public Transmitable getInstance() {
        return new Query();
    }

    public static boolean isStopwordExtend(int option) {
        if (option > 100) {
            return Query.getOption(option, 1000000);
        }
        byte op = (byte)option;
        return (op & 2) == 2;
    }

    public static boolean isUsePercentage(int option) {
        byte op = (byte)option;
        return (op & 4) == 4;
    }

    public static boolean[] isThesaurusExtend(int option) {
        boolean[] isThesaurusExtend = new boolean[2];
        byte op = (byte)option;
        int i = 0;
        while (i < 2) {
            byte mask = (byte)(1 << i);
            isThesaurusExtend[i] = (op & mask) == mask;
            ++i;
        }
        return isThesaurusExtend;
    }

    public static boolean isCacheUse(int option) {
        if (option >= 100) {
            return Query.getOption(option, 100);
        }
        byte op = (byte)option;
        return (op & 1) == 1;
    }

    public static boolean isPhraseExact(int option) {
        if (option >= 100) {
            return Query.getOption(option, 100000000);
        }
        byte op = (byte)option;
        return (op & 0x10) == 16;
    }

    public static boolean isBannedWordExtend(int option) {
        byte op = (byte)option;
        return (op & 8) == 8;
    }

    public static boolean isCategoryRanking(int option) {
        byte op = (byte)option;
        return (op & 1) == 1;
    }

    public static boolean isDocumentRanking(int option) {
        byte op = (byte)option;
        return (op & 2) == 2;
    }

    public static boolean isRankingModel(int option) {
        byte op = (byte)option;
        return (op & 4) == 4;
    }

    private static boolean getOption(int option, int order) {
        return option % (100 * order) / order == 1;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer(256);
        strbuf.append("[Query]\n");
        strbuf.append("[SearchOption = ").append(this.searchOption).append("]\n");
        strbuf.append("[ThesaurusOption = ").append(this.thesaurusOption).append("]\n");
        strbuf.append("[RankingOption = ").append(this.rankingOption).append("]\n");
        strbuf.append("[CategoryRankingOption = ").append(this.categoryRankingOption).append("]\n");
        if (this.highLightStartTag != null) {
            strbuf.append("[highlight start tag = ").append(new String(this.highLightStartTag)).append("]");
        }
        if (this.highLightEndTag != null) {
            strbuf.append("[highlight end tag = ").append(new String(this.highLightEndTag)).append("]\n");
        }
        strbuf.append("[SelectSet]\n");
        int i = 0;
        while (i < this.selectFields.length) {
            strbuf.append("[Field = ").append(new String(this.selectFields[i].getField())).append("]");
            strbuf.append("[Option = ").append(this.selectFields[i].getOption()).append("]\n");
            ++i;
        }
        strbuf.append("[ResultStart = ").append(this.resultStart).append("][ResultEnd = ").append(this.resultEnd).append("]\n");
        strbuf.append("[GroupBySet]\n");
        i = 0;
        while (i < this.groupSelectFields.length) {
            strbuf.append(this.groupSelectFields[i].toString()).append("\n");
            ++i;
        }
        strbuf.append("[FromSet]\n");
        if (this.fromField != null) {
            strbuf.append(new String(this.fromField)).append("\n");
        }
        strbuf.append("[Profile]\n");
        if (this.profile != null) {
            strbuf.append(new String(this.profile)).append("\n");
        }
        strbuf.append("[SearchKeyword]\n");
        if (this.searchKeyword != null) {
            strbuf.append(new String(this.searchKeyword)).append("\n");
        }
        strbuf.append("[WhereSet]\n");
        i = 0;
        while (i < this.whereFields.length) {
            strbuf.append(this.whereFields[i].toString()).append("\n");
            ++i;
        }
        strbuf.append("[OrderBySet]\n");
        i = 0;
        while (i < this.orderbyFields.length) {
            strbuf.append(this.orderbyFields[i].toString()).append("\n");
            ++i;
        }
        strbuf.append("[FilterSet]\n");
        i = 0;
        while (i < this.filterFields.length) {
            strbuf.append(this.filterFields[i].toString()).append("\n");
            ++i;
        }
        strbuf.append("[DistanceSet]\n");
        if (this.distanceField != null) {
            strbuf.append(this.distanceField.toString()).append("\n");
        }
        if (this.queryModifier != null) {
            strbuf.append("[query modifier = ").append(new String(this.queryModifier)).append("]\n");
        }
        if (this.resultModifier != null) {
            strbuf.append("[result modifier = ").append(new String(this.resultModifier)).append("]\n");
        }
        strbuf.append(this.data.toString()).append("\n");
        strbuf.append("[result cutoff size = ").append(this.resultCutOffSize).append("]\n");
        strbuf.append("[maxHighlight = ").append(this.maxHighlight).append("]\n");
        if (this.userName != null) {
            strbuf.append("[userName = ").append(this.userName).append("]\n");
        }
        if (this.extData != null) {
            strbuf.append("[extData = ").append(this.extData).append("]\n");
        }
        if (this.recommend != null) {
            strbuf.append("[recommend = ").append(this.recommend).append("]\n");
        }
        if (this.redirect != null) {
            strbuf.append("[redirect = ").append(this.redirect).append("]\n");
        }
        strbuf.append("[debug = ").append(this.debug).append("]\n");
        strbuf.append("[search = ").append(this.search).append("]\n");
        strbuf.append("[faultless = ").append(this.faultless).append("]\n");
        strbuf.append("[printQuery = ").append(this.printQuery).append("]\n");
        if (this.queryModifierList != null) {
            strbuf.append("[queryModifierList = ").append(this.queryModifierList).append("]\n");
        }
        if (this.resultModifierList != null) {
            strbuf.append("[resultModifierList = ").append(this.resultModifierList).append("]\n");
        }
        strbuf.append("[ignoreBrokerTimeout = ").append(this.ignoreBrokerTimeout).append("]\n");
        strbuf.append("[brokerPrevious = ").append(this.brokerPrevious).append("]\n");
        if (this.brokerPagingInfo != null) {
            strbuf.append("[brokerPagingInfo = ").append(this.brokerPagingInfo).append("]\n");
        }
        strbuf.append("[useKeywordProfile = ").append(this.keywordProfile).append("]\n");
        return strbuf.toString();
    }

    public int hashCode() {
        int hashCode = 31;
        if (this.fromField != null) {
            hashCode = 31 + this.charsHashCode(this.fromField);
        }
        if (this.profile != null) {
            hashCode += 31 + this.charsHashCode(this.profile);
        }
        hashCode += this.charsHashCode(this.getSearchKeyword());
        hashCode += 31 + this.getResultStart();
        return hashCode += 31 + this.getResultEnd();
    }

    private int charsHashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int len = array.length;
        int h = 0;
        int off = 0;
        int i = 0;
        while (i < len) {
            h = 31 * h + array[off++];
            ++i;
        }
        return h;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final boolean isLoggable() {
        return this.loggable;
    }

    public final void setLoggable(boolean loggable) {
        this.loggable = loggable;
    }

    public final char[] getLogKeyword() {
        if (this.logKeyword == null || this.logKeyword.length == 0) {
            return null;
        }
        return this.logKeyword;
    }

    public final void setLogKeyword(char[] logKeyword) {
        this.logKeyword = logKeyword;
    }

    public final char[] getLogExtractor() {
        if (this.logExtractor == null || this.logExtractor.length == 0) {
            return null;
        }
        return this.logExtractor;
    }

    public final void setLogExtractor(char[] logExtractor) {
        this.logExtractor = logExtractor;
    }

    public final void setLogExtractor(char[] logExtractor, char[] logExtractorOption) {
        this.setLogExtractor(logExtractor);
        this.setLogExtractorOption(logExtractorOption);
    }

    public final char[] getLogExtractorOption() {
        if (this.logExtractorOption == null || this.logExtractorOption.length == 0) {
            return null;
        }
        return this.logExtractorOption;
    }

    public final void setLogExtractorOption(char[] logExtractorOption) {
        this.logExtractorOption = logExtractorOption;
    }

    public char[] getProfile() {
        if (this.profile == null || this.profile.length == 0) {
            return null;
        }
        return this.profile;
    }

    public final boolean isUseProfile() {
        return this.profile != null && this.profile.length > 0;
    }

    public int getRankingOption() {
        return this.rankingOption;
    }

    public char[] getSearchKeyword() {
        if (this.searchKeyword != null && this.searchKeyword.length != 0) {
            return this.searchKeyword;
        }
        int i = 0;
        while (i < this.whereFields.length) {
            if (!this.whereFields[i].isOperation() && this.whereFields[i].getKeywords().length > 0) {
                return this.whereFields[i].getKeywords()[0];
            }
            ++i;
        }
        return new char[0];
    }

    public void setSearchKeyword(char[] searchKeyword) {
        this.searchKeyword = searchKeyword;
    }

    public void setSearchKeyword(String searchKeyword) {
        this.searchKeyword = searchKeyword.toCharArray();
    }

    public void setDistance(DistanceSet distanceSet) {
        this.distanceField = distanceSet;
    }

    public DistanceSet getDistance() {
        return this.distanceField;
    }

    public byte getDistanceOption() {
        byte orderOption;
        byte option = 0;
        if (this.distanceField == null) {
            return option;
        }
        int i = 0;
        while (i < this.filterFields.length) {
            byte filterOption = this.filterFields[i].getOperation();
            if (Protocol.checkOption((byte)12, filterOption) || Protocol.checkOption((byte)11, filterOption) || Protocol.checkOption((byte)13, filterOption)) {
                option = (byte)(option | 1);
            }
            ++i;
        }
        if (this.orderbyFields.length > 0 && (Protocol.checkOption((byte)102, orderOption = this.orderbyFields[0].getOperation()) || Protocol.checkOption((byte)103, orderOption) || Protocol.checkOption((byte)104, orderOption))) {
            option = (byte)(option | 2);
        }
        i = 0;
        while (i < this.selectFields.length) {
            if (Protocol.checkOption((byte)24, this.selectFields[i].getOption())) {
                option = (byte)(option | 4);
            }
            ++i;
        }
        return option;
    }

    public int getResultCutOffSize() {
        return this.resultCutOffSize;
    }

    public void setResultCutOffSize(int cutOffSize) {
        this.resultCutOffSize = cutOffSize;
    }

    public int getMaxHighlight() {
        return this.maxHighlight;
    }

    public void setMaxHighlight(int maxHighlight) {
        this.maxHighlight = maxHighlight;
    }

    public char[] getUserName() {
        if (this.userName == null || this.userName.length == 0) {
            return null;
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName.toCharArray();
    }

    public void setUserName(char[] userName) {
        this.userName = userName;
    }

    public char[] getExtData() {
        if (this.extData == null || this.extData.length == 0) {
            return null;
        }
        return this.extData;
    }

    public void setExtData(String extData) {
        this.extData = extData.toCharArray();
    }

    public void setExtData(char[] extData) {
        this.extData = extData;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isSearch() {
        return this.search;
    }

    public void setSearch(boolean search) {
        this.search = search;
    }

    public char[] getRecommend() {
        if (this.recommend == null || this.recommend.length == 0) {
            return null;
        }
        return this.recommend;
    }

    public void setRecommend(String recommend) {
        this.recommend = recommend.toCharArray();
    }

    public void setRecommend(char[] recommend) {
        this.recommend = recommend;
    }

    public char[] getRedirect() {
        if (this.redirect == null || this.redirect.length == 0) {
            return null;
        }
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect.toCharArray();
    }

    public void setRedirect(char[] redirect) {
        this.redirect = redirect;
    }

    public boolean isFaultless() {
        return this.faultless;
    }

    public void setFaultless(boolean faultless) {
        this.faultless = faultless;
    }

    public boolean isPrintQuery() {
        return this.printQuery;
    }

    public void setPrintQuery(boolean printQuery) {
        this.printQuery = printQuery;
    }

    public char[] getQueryModifierList() {
        if (this.queryModifierList == null || this.queryModifierList.length == 0) {
            return null;
        }
        return this.queryModifierList;
    }

    public void setQueryModifierList(char[] queryModifierList) {
        this.queryModifierList = queryModifierList;
    }

    public void setQueryModifierList(String queryModifierList) {
        this.queryModifierList = queryModifierList.toCharArray();
    }

    public char[] getResultModifierList() {
        if (this.resultModifierList == null || this.resultModifierList.length == 0) {
            return null;
        }
        return this.resultModifierList;
    }

    public void setResultModifierList(char[] resultModifierList) {
        this.resultModifierList = resultModifierList;
    }

    public void setResultModifierList(String resultModifierList) {
        this.resultModifierList = resultModifierList.toCharArray();
    }

    public boolean isIgnoreBrokerTimeout() {
        return this.ignoreBrokerTimeout;
    }

    public void setIgnoreBrokerTimeout(boolean ignoreBrokerTimeout) {
        this.ignoreBrokerTimeout = ignoreBrokerTimeout;
    }

    public char[] getBrokerPagingInfo() {
        if (this.brokerPagingInfo == null || this.brokerPagingInfo.length == 0) {
            return null;
        }
        return this.brokerPagingInfo;
    }

    public void setBrokerPagingInfo(char[] pagingInfo) {
        this.brokerPagingInfo = pagingInfo;
    }

    public void setBrokerPagingInfo(String pagingInfo) {
        this.brokerPagingInfo = pagingInfo.toCharArray();
    }

    public boolean isBrokerPrevious() {
        return this.brokerPrevious;
    }

    public boolean isKeywordProfileDic() {
        return this.keywordProfile;
    }

    public void setBrokerPrevious(boolean previous) {
        this.brokerPrevious = previous;
    }

    public void setKeywordProfile(boolean keywordProfile) {
        this.keywordProfile = keywordProfile;
    }

    public static int log2(int num) {
        return (int)(Math.log(num) / Math.log(2.0));
    }
}

