/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.protocol.query.DistanceSet;
import com.diquest.ir.common.msg.protocol.query.FilterSet;
import com.diquest.ir.common.msg.protocol.query.GroupBySet;
import com.diquest.ir.common.msg.protocol.query.OrderBySet;
import com.diquest.ir.common.msg.protocol.query.Query;
import com.diquest.ir.common.msg.protocol.query.SelectSet;
import com.diquest.ir.common.msg.protocol.query.WhereSet;

public class QueryParser {
    private static final String SELECT = "@select";
    private static final String FROM = "@from";
    private static final String PROFILE = "@profile";
    private static final String SEARCHKEYWORD = "@keyword";
    private static final String WHERE = "@where";
    private static final String FILTERBY = "@filterby";
    private static final String ORDERBY = "@orderby";
    private static final String GROUPBY = "@groupby";
    private static final String DISTANCE = "@distance";
    private static final String MODIFIER = "@modifier";
    private static final String QUERYLOGGER = "@querylogger";
    private static final String RECOMMEND = "@recommend";
    private static final String REDIRECT = "@redirect";
    private static final String FAULTLESS = "@faultless";
    private static final String DEBUG = "@debug";
    private static final String PRINTQUERY = "@printquery";
    private static final String LOGGABLE = "@loggable";
    private static final String DATA = "@data";
    private static final char AT_SIGN = '@';
    private static final char LEFT_ROUNDBRACKET = '(';
    private static final char RIGHT_ROUNDBRACKET = ')';
    private static final char SINGLE_QUOTATION = '\'';
    private static final char BLANK = ' ';
    private static final char COMMA = ',';
    private static final char VERTICAL_BAR = '|';
    private static final char SEMICOLON = ';';
    private static final char EQUAL = '=';
    private static final char LEFT_BRACKET = '{';
    private static final char RIGHT_BRACKET = '}';
    private static final char CHAR_BACK_SLASH = '\\';
    private static final char CHAR_SINGLE_QUOTATION = '\'';
    private static final char CHAR_QUOTATION = '\"';
    private static final char CHAR_PERCENT = '%';
    private static final char CHAR_S = 'S';
    private static final char CHAR_Q = 'Q';
    private static final char CHAR_P = 'P';
    private static final String DQ_BACK_SLASH = "\\\\";
    private static final String DQ_SINGLE_QUOTATION = "\\S";
    private static final String DQ_QUOTATION = "\\Q";
    private static final String DQ_PERCENT = "\\P";
    private char[] str;
    private final String[] reservedWords = new String[]{"@select", "@from", "@profile", "@keyword", "@where", "@filterby", "@orderby", "@groupby", "@distance", "@modifier", "@querylogger", "@recommend", "@redirect", "@faultless", "@debug", "@printquery", "@loggable", "@data"};
    private int[] startIndex;
    private int[] endIndex;
    private int[] sPartIndex;
    private int[] ePartIndex;
    private Query query;
    public static final String NEW_LINE = "\n";
    public static final String NEW_LINE_HTML = "<BR>";
    public static final String WHITESPACE_HTML = "&nbsp;";

    private void init() {
        this.startIndex = new int[this.reservedWords.length];
        this.endIndex = new int[this.reservedWords.length];
        int i = 0;
        while (i < this.reservedWords.length) {
            this.startIndex[i] = -1;
            this.endIndex[i] = -1;
            ++i;
        }
        this.sPartIndex = new int[200];
        this.ePartIndex = new int[200];
    }

    public Query parseQuery(String str) throws IRException {
        this.init();
        if (str.trim().equals("")) {
            throw new IRException(2, "Protocol Error : input string is empty.");
        }
        this.str = str.trim().toCharArray();
        this.parseReservedWord();
        this.parseFrom();
        if (this.query == null) {
            this.query = new Query();
        }
        this.parseProfile();
        this.parseSearchKeyword();
        this.parseSelect();
        this.parseWhere();
        this.parseFilterBy();
        this.parseOrderBy();
        this.parseGroupBy();
        this.parseDistance();
        this.parseModifier();
        this.parseQueryLogger();
        this.parseRecommend();
        this.parseRedireict();
        this.parseLoggable();
        this.parseFaultless();
        this.parseDebug();
        this.parsePrintQuery();
        this.parseData();
        return this.query;
    }

    public WhereSet[] getWhereSet() throws IRException {
        if (this.query == null) {
            return new WhereSet[0];
        }
        return this.query.getWhereFields();
    }

    public FilterSet[] getFilterSet() throws IRException {
        if (this.query == null) {
            return new FilterSet[0];
        }
        return this.query.getFilterFields();
    }

    public WhereSet[] parseWhereSet(String str) throws IRException {
        this.init();
        if (str.trim().equals("")) {
            throw new IRException(2, "Protocol Error : input string is empty.");
        }
        this.str = str.trim().toCharArray();
        this.parseReservedWord();
        if (this.query == null) {
            this.query = new Query();
        }
        this.parseWhere();
        return this.query.getWhereFields();
    }

    public FilterSet[] parseFilterSet(String str) throws IRException {
        this.init();
        if (str.trim().equals("")) {
            throw new IRException(2, "Protocol Error : input string is empty.");
        }
        this.str = str.trim().toCharArray();
        this.parseReservedWord();
        if (this.query == null) {
            this.query = new Query();
        }
        this.parseFilterBy();
        return this.query.getFilterFields();
    }

    private String getReservedWord(int index) {
        return this.reservedWords[index];
    }

    private int getReservedWordIndex(String reservedWord) {
        int i = 0;
        while (i < this.reservedWords.length) {
            if (reservedWord.equalsIgnoreCase(this.reservedWords[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isExistValue(int index) {
        if (this.startIndex[index] == -1 || this.endIndex[index] == -1 || this.startIndex[index] == this.endIndex[index]) {
            return false;
        }
        boolean empty = true;
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            if (this.str[i] != ' ') {
                empty = false;
                break;
            }
            ++i;
        }
        return !empty;
    }

    private void ensureCapacity() {
        int[] new_sIndex = new int[this.sPartIndex.length * 2];
        System.arraycopy(this.sPartIndex, 0, new_sIndex, 0, this.sPartIndex.length);
        this.sPartIndex = new_sIndex;
        int[] new_eIndex = new int[this.ePartIndex.length * 2];
        System.arraycopy(this.ePartIndex, 0, new_eIndex, 0, this.ePartIndex.length);
        this.ePartIndex = new_eIndex;
    }

    private void parseReservedWord() throws IRException {
        int count = 0;
        int i = 0;
        while (i < this.str.length) {
            if (this.str[i] == '\'') {
                ++count;
            }
            ++i;
        }
        if (count % 2 != 0) {
            throw new IRException(2, "Protocol Error : Number of ' is not correct.");
        }
        String word = "";
        int pos = -1;
        int start = 0;
        int end = 0;
        int lBracketCount = 0;
        int rBracketCount = 0;
        int quotCount = 0;
        boolean find = false;
        int i2 = 0;
        while (i2 < this.str.length) {
            if (i2 == 0 && this.str[i2] != '@') {
                throw new IRException(2, "Protocol Error: Input protocol must be started with '@'");
            }
            switch (this.str[i2]) {
                case '@': {
                    if (quotCount % 2 != 0) break;
                    find = true;
                    break;
                }
                case '(': {
                    if (quotCount % 2 != 0) break;
                    if (lBracketCount != rBracketCount) {
                        throw new IRException(2, "Protocol Error : () is not correct in " + this.getReservedWord(pos) + ".");
                    }
                    ++lBracketCount;
                    break;
                }
                case ')': {
                    if (quotCount % 2 != 0 || lBracketCount == ++rBracketCount) break;
                    throw new IRException(2, "Protocol Error : () is not correct in " + this.getReservedWord(pos) + ".");
                }
                case '\'': {
                    ++quotCount;
                }
            }
            if (find || i2 == this.str.length - 1) {
                if (i2 == this.str.length - 1) {
                    end = i2;
                    word = "";
                } else {
                    end = i2 - 1;
                    word = "";
                    while (i2 < this.str.length && this.str[i2] != ' ') {
                        word = String.valueOf(word) + this.str[i2++];
                    }
                    --i2;
                    if (!(word.equalsIgnoreCase(SELECT) || word.equalsIgnoreCase(FROM) || word.equalsIgnoreCase(PROFILE) || word.equalsIgnoreCase(SEARCHKEYWORD) || word.equalsIgnoreCase(WHERE) || word.equalsIgnoreCase(FILTERBY) || word.equalsIgnoreCase(ORDERBY) || word.equalsIgnoreCase(GROUPBY) || word.equalsIgnoreCase(MODIFIER) || word.equalsIgnoreCase(QUERYLOGGER) || word.equalsIgnoreCase(DATA) || word.equalsIgnoreCase(DISTANCE) || word.equalsIgnoreCase(RECOMMEND) || word.equalsIgnoreCase(REDIRECT) || word.equalsIgnoreCase(FAULTLESS) || word.equalsIgnoreCase(DEBUG) || word.equalsIgnoreCase(PRINTQUERY) || word.equalsIgnoreCase(LOGGABLE))) {
                        throw new IRException(2, "Protocol Error: Unknown reserved word : " + word + ". " + "Reserved Words : " + SELECT + ", " + FROM + ", " + PROFILE + ", " + SEARCHKEYWORD + ", " + WHERE + ", " + FILTERBY + ", " + ORDERBY + ", " + GROUPBY + ", " + MODIFIER + ", " + QUERYLOGGER + ", " + DATA + ", " + DISTANCE + ", " + RECOMMEND + ", " + REDIRECT + ", " + FAULTLESS + ", " + DEBUG + ", " + PRINTQUERY + ", " + LOGGABLE);
                    }
                }
                if (quotCount % 2 != 0) {
                    throw new IRException(2, "Protocol Error : Incorrect number of ' in " + this.getReservedWord(pos) + "(" + '\'' + " cannot be placed between " + '\'' + '\'' + ".");
                }
                if (lBracketCount != rBracketCount) {
                    throw new IRException(2, "Protocol Error : () is not correct in " + this.getReservedWord(pos) + ".");
                }
                if (pos == -1) {
                    pos = this.getReservedWordIndex(word);
                    if (i2 == this.str.length - 1) {
                        this.startIndex[pos] = start;
                        this.endIndex[pos] = end;
                    }
                    quotCount = 0;
                    lBracketCount = 0;
                    rBracketCount = 0;
                    start = i2 + 1;
                    find = false;
                } else {
                    this.startIndex[pos] = start;
                    this.endIndex[pos] = end;
                    pos = this.getReservedWordIndex(word);
                    if (i2 == this.str.length - 1 && (word.equalsIgnoreCase(SELECT) || word.equalsIgnoreCase(FROM) || word.equalsIgnoreCase(WHERE) || word.equalsIgnoreCase(FILTERBY) || word.equalsIgnoreCase(ORDERBY) || word.equalsIgnoreCase(GROUPBY) || word.equalsIgnoreCase(MODIFIER) || word.equalsIgnoreCase(QUERYLOGGER) || word.equalsIgnoreCase(DATA) || word.equalsIgnoreCase(DISTANCE) || word.equalsIgnoreCase(RECOMMEND) || word.equalsIgnoreCase(REDIRECT) || word.equalsIgnoreCase(FAULTLESS) || word.equalsIgnoreCase(DEBUG) || word.equalsIgnoreCase(PRINTQUERY) || word.equalsIgnoreCase(LOGGABLE))) {
                        this.startIndex[pos] = start;
                        this.endIndex[pos] = -1;
                    }
                    quotCount = 0;
                    lBracketCount = 0;
                    rBracketCount = 0;
                    start = i2 + 1;
                    find = false;
                }
            }
            ++i2;
        }
    }

    private int[] charTrim(int startPos, int endPos) {
        int[] result = new int[2];
        if (startPos > endPos) {
            result[0] = -1;
            result[1] = -1;
            return result;
        }
        int start = startPos;
        int end = endPos;
        int i = startPos;
        while (i <= end) {
            if (this.str[i] != ' ') {
                start = i;
                break;
            }
            if (i == end) {
                start = i;
            }
            ++i;
        }
        if (start == end) {
            if (this.str[start] == ' ') {
                result[0] = -1;
                result[1] = -1;
                return result;
            }
            result[0] = start;
            result[1] = end;
            return result;
        }
        i = end;
        while (i >= start) {
            if (this.str[i] != ' ') {
                end = i;
                break;
            }
            if (i == start) {
                end = i;
            }
            --i;
        }
        if (start == end) {
            if (this.str[start] == ' ') {
                result[0] = -1;
                result[1] = -1;
                return result;
            }
            result[0] = start;
            result[1] = end;
            return result;
        }
        result[0] = start;
        result[1] = end;
        return result;
    }

    private int parseCommaToBracket(int startPos, int endPos) {
        String a = "";
        int k = startPos;
        while (k <= endPos) {
            a = String.valueOf(a) + this.str[k];
            ++k;
        }
        int start = startPos;
        int end = 0;
        boolean lBracketUse = false;
        boolean rBracketUse = false;
        boolean quotUse = false;
        int count = 0;
        int[] trimResult = null;
        boolean create = false;
        int i = startPos;
        while (i <= endPos) {
            switch (this.str[i]) {
                case '(': {
                    if (quotUse) break;
                    if (lBracketUse) {
                        return -1;
                    }
                    create = true;
                    lBracketUse = true;
                    break;
                }
                case ')': {
                    if (quotUse) break;
                    if (rBracketUse) {
                        return -1;
                    }
                    create = true;
                    rBracketUse = true;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (create || i == endPos) {
                if (count > this.sPartIndex.length) {
                    this.ensureCapacity();
                }
                if ((trimResult = this.charTrim(start, end = !create && i == endPos ? i : i - 1))[0] != -1 && trimResult[1] != -1) {
                    this.sPartIndex[count] = trimResult[0];
                    this.ePartIndex[count] = trimResult[1];
                    ++count;
                }
                start = i + 1;
                create = false;
            }
            ++i;
        }
        return count;
    }

    private int parseCommaToEqual(int startPos, int endPos) {
        int start = startPos;
        int end = 0;
        boolean equalUse = false;
        boolean quotUse = false;
        int count = 0;
        int[] trimResult = null;
        boolean create = false;
        int i = startPos;
        while (i <= endPos) {
            switch (this.str[i]) {
                case '=': {
                    if (quotUse) break;
                    if (equalUse) {
                        return -1;
                    }
                    create = true;
                    equalUse = true;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (create || i == endPos) {
                if (count > this.sPartIndex.length) {
                    this.ensureCapacity();
                }
                if ((trimResult = this.charTrim(start, end = !create && i == endPos ? i : i - 1))[0] != -1 && trimResult[1] != -1) {
                    this.sPartIndex[count] = trimResult[0];
                    this.ePartIndex[count] = trimResult[1];
                    ++count;
                }
                start = i + 1;
                create = false;
            }
            ++i;
        }
        return count;
    }

    private int[] parseRoundBracket(int startPos, int endPos) {
        int max = 1;
        int i = startPos;
        while (i <= endPos) {
            if (this.str[i] == '|') {
                ++max;
            }
            ++i;
        }
        int[] result = new int[max];
        int start = startPos;
        boolean quotUse = false;
        int aPos = 0;
        int vPos = 0;
        int sCount = 1;
        int i2 = startPos;
        while (i2 <= endPos) {
            switch (this.str[i2]) {
                case '|': {
                    if (quotUse) break;
                    if (aPos > this.sPartIndex.length) {
                        this.ensureCapacity();
                    }
                    this.sPartIndex[aPos] = start;
                    this.ePartIndex[aPos] = i2 - 1;
                    result[vPos] = sCount;
                    ++aPos;
                    ++vPos;
                    sCount = 1;
                    start = i2 + 1;
                    break;
                }
                case ';': {
                    if (quotUse) break;
                    if (aPos > this.sPartIndex.length) {
                        this.ensureCapacity();
                    }
                    this.sPartIndex[aPos] = start;
                    this.ePartIndex[aPos] = i2 - 1;
                    ++aPos;
                    ++sCount;
                    start = i2 + 1;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (i2 == endPos) {
                if (aPos > this.sPartIndex.length) {
                    this.ensureCapacity();
                }
                this.sPartIndex[aPos] = start;
                this.ePartIndex[aPos] = i2;
                result[vPos] = sCount;
            }
            ++i2;
        }
        if (result.length == vPos + 1) {
            return result;
        }
        int[] new_result = new int[vPos + 1];
        System.arraycopy(result, 0, new_result, 0, new_result.length);
        return new_result;
    }

    private void parseFrom() throws IRException {
        int index = this.getReservedWordIndex(FROM);
        if (!this.isExistValue(index)) {
            return;
        }
        String collectionID = "";
        String hStartTag = "";
        String hEndTag = "";
        int startValue = -1;
        int endValue = -1;
        int searchOption = 0;
        int thesaurusOption = 0;
        int rankingOption = 0;
        int categoryRankingOption = 0;
        int argumentCount = this.parseCommaToBracket(this.startIndex[index], this.endIndex[index]);
        if (argumentCount != 1 && argumentCount != 2) {
            throw new IRException(2, "Protocol Error : Incorrect format in @from. regular format is \"Collection ID('Highlight start tag'|'Highlight end tag'|Result start number|Result end number|search option)\"");
        }
        int j = this.sPartIndex[0];
        while (j <= this.ePartIndex[0]) {
            collectionID = String.valueOf(collectionID) + this.str[j];
            ++j;
        }
        if ((collectionID = this.decode(collectionID)).equals("")) {
            throw new IRException(2, "Protocol Error: Collection ID is not defined in @from.");
        }
        if (collectionID.indexOf(32) != -1) {
            throw new IRException(2, "Protocol Error: Collection ID cannot contains empty chractor(space) in @from.");
        }
        if (argumentCount == 2) {
            int[] arguments = this.parseRoundBracket(this.sPartIndex[1], this.ePartIndex[1]);
            if (arguments.length != 8) {
                throw new IRException(2, "Protocol Error: Incorrect number of arguments in @from. Number of arguments is 8 ('Highlight start tag'|'Highlight end tag'|Result start number|Result end number|SearchOption|ThesaurusOption|RankingOption|CategoryRankingOption)");
            }
            if (arguments[0] != 1) {
                throw new IRException(2, "Protocol Error: Highlight start tag cannot be multiple in @from.");
            }
            int pos = 0;
            int k = this.sPartIndex[pos];
            while (k <= this.ePartIndex[pos]) {
                hStartTag = String.valueOf(hStartTag) + this.str[k];
                ++k;
            }
            hStartTag = this.decode(hStartTag);
            if (!(hStartTag = hStartTag.trim()).equals("")) {
                if (hStartTag.charAt(0) != '\'' || hStartTag.charAt(hStartTag.length() - 1) != '\'') {
                    throw new IRException(2, "Protocol Error: Highlight start tag must be placed between single quotation mark(').");
                }
                hStartTag = hStartTag.substring(1, hStartTag.length() - 1);
            }
            if (arguments[1] != 1) {
                throw new IRException(2, "Protocol Error: Highlight end tag cannot be multiple in @from.");
            }
            k = this.sPartIndex[pos += arguments[0]];
            while (k <= this.ePartIndex[pos]) {
                hEndTag = String.valueOf(hEndTag) + this.str[k];
                ++k;
            }
            hEndTag = this.decode(hEndTag);
            if (!(hEndTag = hEndTag.trim()).equals("")) {
                if (hEndTag.charAt(0) != '\'' || hEndTag.charAt(hEndTag.length() - 1) != '\'') {
                    throw new IRException(2, "Protocol Error: Highlight end tag must be placed between single quotation mark(').");
                }
                hEndTag = hEndTag.substring(1, hEndTag.length() - 1);
            }
            if (arguments[2] != 1) {
                throw new IRException(2, "Protocol Error: Result start number cannot be multiple in @from.");
            }
            String startValueStr = "";
            int k2 = this.sPartIndex[pos += arguments[1]];
            while (k2 <= this.ePartIndex[pos]) {
                startValueStr = String.valueOf(startValueStr) + this.str[k2];
                ++k2;
            }
            if (!(startValueStr = startValueStr.trim()).equals("")) {
                try {
                    startValue = Integer.parseInt(startValueStr);
                    if (startValue < 0) {
                        throw new IRException(2, "Protocol Error : Result start number must be greater than or equal 0 in @from.");
                    }
                }
                catch (IRException e) {
                    throw new IRException(2, "Protocol Error : Result start number must be a number in @from.");
                }
            }
            if (arguments[3] != 1) {
                throw new IRException(2, "Protocol Error : Result end number cannot be multiple in @from.");
            }
            String endValueStr = "";
            int k3 = this.sPartIndex[pos += arguments[2]];
            while (k3 <= this.ePartIndex[pos]) {
                endValueStr = String.valueOf(endValueStr) + this.str[k3];
                ++k3;
            }
            if (!(endValueStr = endValueStr.trim()).equals("")) {
                try {
                    endValue = Integer.parseInt(endValueStr);
                    if (endValue < 0) {
                        throw new IRException(2, "Protocol Error : Result end number must be greater than or equal 0 in @from.");
                    }
                }
                catch (IRException e) {
                    throw new IRException(2, "Protocol Error : Result end number must be a number in @from.");
                }
            }
            String[] searchOptionStr = new String[arguments[4]];
            int count = 0;
            int j2 = pos += arguments[3];
            while (j2 < pos + arguments[4]) {
                String option = "";
                int k4 = this.sPartIndex[j2];
                while (k4 <= this.ePartIndex[j2]) {
                    option = String.valueOf(option) + this.str[k4];
                    ++k4;
                }
                if (!(option = option.trim()).equals("")) {
                    searchOptionStr[count++] = option;
                }
                ++j2;
            }
            if (count > 0) {
                j2 = 0;
                while (j2 < count) {
                    if (searchOptionStr[j2].equalsIgnoreCase("CACHE")) {
                        searchOption |= 1;
                    } else if (searchOptionStr[j2].equalsIgnoreCase("STOPWORD")) {
                        searchOption |= 2;
                    } else if (searchOptionStr[j2].equalsIgnoreCase("PERCENT")) {
                        searchOption |= 4;
                    } else if (searchOptionStr[j2].equalsIgnoreCase("BANNED")) {
                        searchOption |= 8;
                    } else {
                        try {
                            searchOption |= Integer.parseInt(searchOptionStr[j2]);
                        }
                        catch (Exception e) {
                            throw new IRException(2, "Protocol Error : Unknown search option " + searchOptionStr[j2] + " in " + FROM + ". (search option : 'CACHE', 'STOPWORD', 'PERCENT', 'BANNED', or number");
                        }
                    }
                    ++j2;
                }
            }
            String[] thesaurusOptionStr = new String[arguments[5]];
            count = 0;
            int j3 = pos += arguments[4];
            while (j3 < pos + arguments[5]) {
                String option = "";
                int k5 = this.sPartIndex[j3];
                while (k5 <= this.ePartIndex[j3]) {
                    option = String.valueOf(option) + this.str[k5];
                    ++k5;
                }
                if (!(option = option.trim()).equals("")) {
                    thesaurusOptionStr[count++] = option;
                }
                ++j3;
            }
            if (count > 0) {
                j3 = 0;
                while (j3 < count) {
                    if (thesaurusOptionStr[j3].equalsIgnoreCase("EQUIV_SYNONYM")) {
                        thesaurusOption |= 1;
                    } else if (thesaurusOptionStr[j3].equalsIgnoreCase("QUASI_SYNONYM")) {
                        thesaurusOption |= 2;
                    } else if (thesaurusOptionStr[j3].equalsIgnoreCase("SUPERORDINATE")) {
                        thesaurusOption |= 4;
                    } else if (thesaurusOptionStr[j3].equalsIgnoreCase("HYPONYM")) {
                        thesaurusOption |= 8;
                    } else {
                        try {
                            thesaurusOption |= Integer.parseInt(thesaurusOptionStr[j3]);
                        }
                        catch (Exception e) {
                            throw new IRException(2, "Protocol Error : Unknown thesaurus option " + thesaurusOptionStr[j3] + " in " + FROM + ". (thesaurus option : 'EQUIV_SYONYM', 'QUASI_SYNONYM', 'SUPERORDINATE', 'HYPONYM', or number");
                        }
                    }
                    ++j3;
                }
            }
            String[] rankingOptionStr = new String[arguments[6]];
            count = 0;
            int j4 = pos += arguments[5];
            while (j4 < pos + arguments[6]) {
                String option = "";
                int k6 = this.sPartIndex[j4];
                while (k6 <= this.ePartIndex[j4]) {
                    option = String.valueOf(option) + this.str[k6];
                    ++k6;
                }
                if (!(option = option.trim()).equals("")) {
                    rankingOptionStr[count++] = option;
                }
                ++j4;
            }
            if (count > 0) {
                j4 = 0;
                while (j4 < count) {
                    if (rankingOptionStr[j4].equalsIgnoreCase("CATEGORY_RANKING")) {
                        rankingOption |= 1;
                    } else if (rankingOptionStr[j4].equalsIgnoreCase("DOCUMENT_RANKING")) {
                        rankingOption |= 2;
                    } else if (rankingOptionStr[j4].equalsIgnoreCase("RANKING_MODEL")) {
                        rankingOption |= 4;
                    } else {
                        try {
                            rankingOption |= Integer.parseInt(rankingOptionStr[j4]);
                        }
                        catch (Exception e) {
                            throw new IRException(2, "Protocol Error : Unknown ranking option " + rankingOptionStr[j4] + " in " + FROM + ". (ranking option : 'CATEGORY_RANKING', 'DOCUMENT_RANKING', 'RANKING_MODEL' , or number");
                        }
                    }
                    ++j4;
                }
            }
            String[] cateOptionStr = new String[arguments[7]];
            count = 0;
            int j5 = pos += arguments[6];
            while (j5 < pos + arguments[7]) {
                String option = "";
                int k7 = this.sPartIndex[j5];
                while (k7 <= this.ePartIndex[j5]) {
                    option = String.valueOf(option) + this.str[k7];
                    ++k7;
                }
                if (!(option = option.trim()).equals("")) {
                    cateOptionStr[count++] = option;
                }
                ++j5;
            }
            if (count > 0) {
                j5 = 0;
                while (j5 < count) {
                    if (cateOptionStr[j5].equalsIgnoreCase("MULTI_TERM_WHITESPACE")) {
                        categoryRankingOption |= 1;
                    } else if (cateOptionStr[j5].equalsIgnoreCase("MULTI_TERM_KOREAN")) {
                        categoryRankingOption |= 2;
                    } else if (cateOptionStr[j5].equalsIgnoreCase("EQUIV_SYNONYM")) {
                        categoryRankingOption |= 4;
                    } else if (cateOptionStr[j5].equalsIgnoreCase("QUASI_SYNONYM")) {
                        categoryRankingOption |= 8;
                    } else {
                        try {
                            categoryRankingOption |= Integer.parseInt(cateOptionStr[j5]);
                        }
                        catch (Exception e) {
                            throw new IRException(2, "Protocol Error : Unknown category ranking option " + cateOptionStr[j5] + " in " + FROM + ". (category ranking option : 'MULTI_TERM_WHITESPACE', 'MULTI_TERM_KOREAN', 'EQUIV_SYNONYM' , 'QUASI_SYNONYM' , or number");
                        }
                    }
                    ++j5;
                }
            }
        }
        this.query = hStartTag.equals("") && hEndTag.equals("") ? new Query() : new Query(hStartTag, hEndTag);
        this.query.setFrom(collectionID);
        if (startValue != -1 && endValue != -1) {
            this.query.setResult(startValue, endValue);
        }
        if (searchOption != 0) {
            this.query.setSearchOption(searchOption);
        }
        if (thesaurusOption != 0) {
            this.query.setThesaurusOption(thesaurusOption);
        }
        if (rankingOption != 0) {
            this.query.setRankingOption(rankingOption);
        }
        if (categoryRankingOption != 0) {
            this.query.setCategoryRankingOption(categoryRankingOption);
        }
    }

    private void parseProfile() throws IRException {
        int index = this.getReservedWordIndex(PROFILE);
        if (!this.isExistValue(index)) {
            return;
        }
        String profileID = "";
        int argumentCount = this.parseCommaToBracket(this.startIndex[index], this.endIndex[index]);
        if (argumentCount != 1 && argumentCount != 2) {
            throw new IRException(2, "Protocol Error : Incorrect format in @profile. regular format is \"profile ID or 'null' (search option)\"");
        }
        int j = this.sPartIndex[0];
        while (j <= this.ePartIndex[0]) {
            profileID = String.valueOf(profileID) + this.str[j];
            ++j;
        }
        if ((profileID = this.decode(profileID)).equals("")) {
            throw new IRException(2, "Protocol Error: Profile ID is not defined in @profile.");
        }
        if (profileID.indexOf(32) != -1) {
            throw new IRException(2, "Protocol Error: Profile ID cannot contains empty chractor(space) in @profile.");
        }
        if (profileID.equalsIgnoreCase("NULL")) {
            profileID = "";
        }
        this.query.setProfile(profileID);
    }

    private void parseSearchKeyword() throws IRException {
        int index = this.getReservedWordIndex(SEARCHKEYWORD);
        if (!this.isExistValue(index)) {
            return;
        }
        String searchKeyword = "";
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            searchKeyword = String.valueOf(searchKeyword) + this.str[i];
            ++i;
        }
        searchKeyword = this.decode(searchKeyword);
        searchKeyword = searchKeyword.trim();
        if (!(searchKeyword = searchKeyword.substring(1, searchKeyword.length() - 1)).equals("")) {
            this.query.setSearchKeyword(searchKeyword);
        }
    }

    private void parseSelect() throws IRException {
        int index = this.getReservedWordIndex(SELECT);
        if (!this.isExistValue(index)) {
            return;
        }
        int max = 1;
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            if (this.str[i] == ',') {
                ++max;
            }
            ++i;
        }
        SelectSet[] selectSet = new SelectSet[max];
        String schemaID = "";
        byte operation = 0;
        int summarySize = -1;
        int start = this.startIndex[index];
        boolean quotUse = false;
        int setCount = 0;
        boolean create = false;
        int i2 = this.startIndex[index];
        while (i2 <= this.endIndex[index]) {
            switch (this.str[i2]) {
                case ',': {
                    if (quotUse) break;
                    create = true;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (create || i2 == this.endIndex[index]) {
                int argumentCount = -1;
                argumentCount = i2 == this.endIndex[index] ? this.parseCommaToBracket(start, i2) : this.parseCommaToBracket(start, i2 - 1);
                if (argumentCount != 1 && argumentCount != 2) {
                    throw new IRException(2, "Protocol Error : Incorrect @select format. Schema ID(option;option|summary size)");
                }
                int j = this.sPartIndex[0];
                while (j <= this.ePartIndex[0]) {
                    schemaID = String.valueOf(schemaID) + this.str[j];
                    ++j;
                }
                if ((schemaID = this.decode(schemaID)).equals("")) {
                    throw new IRException(2, "Protocol Error : Schema ID is not defined in @select.");
                }
                if (schemaID.indexOf(32) != -1) {
                    throw new IRException(2, "Protocol Error : Schema ID cannot contains empty character(space) in @select.");
                }
                if (argumentCount == 2) {
                    int[] arguments = this.parseRoundBracket(this.sPartIndex[1], this.ePartIndex[1]);
                    if (arguments.length != 2) {
                        throw new IRException(2, "Protocol Error : Incorrect number of arguments in @select. Number of arguments is 2, (option;option;summary size)");
                    }
                    String[] operationStr = new String[arguments[0]];
                    int pos = 0;
                    int count = 0;
                    int j2 = pos;
                    while (j2 < arguments[0]) {
                        String oper = "";
                        int k = this.sPartIndex[j2];
                        while (k <= this.ePartIndex[j2]) {
                            oper = String.valueOf(oper) + this.str[k];
                            ++k;
                        }
                        if (!(oper = oper.trim()).equals("")) {
                            operationStr[count++] = oper;
                        }
                        ++j2;
                    }
                    if (count > 0) {
                        j2 = 0;
                        while (j2 < count) {
                            block41: {
                                if (operationStr[j2].equalsIgnoreCase("SUMMARIZE")) {
                                    operation = (byte)(operation | 0x11);
                                } else if (operationStr[j2].equalsIgnoreCase("HIGHLIGHT")) {
                                    operation = (byte)(operation | 0x12);
                                } else if (operationStr[j2].equalsIgnoreCase("SYNONYM_HIGHLIGHT")) {
                                    operation = (byte)(operation | 0x14);
                                } else if (operationStr[j2].equalsIgnoreCase("DISTANCE")) {
                                    operation = (byte)(operation | 0x18);
                                } else if (operationStr[j2].equalsIgnoreCase("NONE")) {
                                    operation = (byte)(operation | 0x10);
                                } else {
                                    try {
                                        byte op = Byte.parseByte(operationStr[j2]);
                                        if (op == 17 || op == 18 || op == 20 || op == 24 || op == 16) {
                                            operation = (byte)(operation | op);
                                            break block41;
                                        }
                                        throw new IRException(2, "Protocol Error : " + operationStr[0] + " is unknown option in " + SELECT + ". (SUMMARIZE, HIGHLIGHT, SYNONYM_HIGHLIGHT, DISTANCE, NONE)");
                                    }
                                    catch (Exception e) {
                                        throw new IRException(2, "Protocol Error : " + operationStr[0] + " is unknown option in " + SELECT + ". (SUMMARIZE, HIGHLIGHT, SYNONYM_HIGHLIGHT, DISTANCE, NONE)");
                                    }
                                }
                            }
                            ++j2;
                        }
                    }
                    if (arguments[1] != 1) {
                        throw new IRException(2, "Protocol Error: Summary size cannot be multiple in @select.");
                    }
                    String summarySizeStr = "";
                    int k = this.sPartIndex[pos += arguments[0]];
                    while (k <= this.ePartIndex[pos]) {
                        summarySizeStr = String.valueOf(summarySizeStr) + this.str[k];
                        ++k;
                    }
                    if (!(summarySizeStr = summarySizeStr.trim()).equals("")) {
                        try {
                            summarySize = Integer.parseInt(summarySizeStr);
                            if (summarySize < 0) {
                                throw new IRException(2, "Protocol Error: Summary size must be greater than or equal 0 in @select.");
                            }
                        }
                        catch (IRException e) {
                            throw new IRException(2, "Protocol Error: Summary size must be a number in @select.");
                        }
                    }
                }
                selectSet[setCount] = operation == -1 ? new SelectSet(schemaID) : (summarySize == -1 ? new SelectSet(schemaID, operation) : new SelectSet(schemaID, operation, summarySize));
                schemaID = "";
                operation = 0;
                summarySize = -1;
                start = i2 + 1;
                ++setCount;
                create = false;
            }
            ++i2;
        }
        if (selectSet.length == setCount) {
            this.query.setSelect(selectSet);
        } else {
            SelectSet[] new_SelectSet = new SelectSet[setCount];
            System.arraycopy(selectSet, 0, new_SelectSet, 0, new_SelectSet.length);
            this.query.setSelect(new_SelectSet);
        }
    }

    private void parseWhere() throws IRException {
        int index = this.getReservedWordIndex(WHERE);
        if (!this.isExistValue(index)) {
            return;
        }
        int max = 1;
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            if (this.str[i] == ' ' || this.str[i] == '{' || this.str[i] == '}') {
                ++max;
            }
            ++i;
        }
        WhereSet[] whereSet = new WhereSet[max];
        String indexID = "";
        byte operation = -1;
        String[] keywords = null;
        int[] weights = null;
        int start = this.startIndex[index];
        int lBracketCount = 0;
        int rBracketCount = 0;
        boolean quotUse = false;
        int setCount = 0;
        boolean create = false;
        int i2 = this.startIndex[index];
        while (i2 <= this.endIndex[index]) {
            switch (this.str[i2]) {
                case '{': {
                    if (quotUse) break;
                    operation = 9;
                    whereSet[setCount] = new WhereSet(operation);
                    operation = -1;
                    start = i2 + 1;
                    lBracketCount = 0;
                    rBracketCount = 0;
                    ++setCount;
                    break;
                }
                case '}': {
                    if (quotUse) break;
                    operation = 10;
                    whereSet[setCount] = new WhereSet(operation);
                    operation = -1;
                    start = i2 + 1;
                    lBracketCount = 0;
                    rBracketCount = 0;
                    ++setCount;
                    break;
                }
                case ' ': {
                    if (quotUse || lBracketCount != rBracketCount) break;
                    create = true;
                    break;
                }
                case '(': {
                    if (quotUse) break;
                    ++lBracketCount;
                    break;
                }
                case ')': {
                    if (quotUse) break;
                    ++rBracketCount;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (create || i2 == this.endIndex[index]) {
                int end = -1;
                end = i2 == this.endIndex[index] ? i2 : i2 - 1;
                String word = "";
                int j = start;
                while (j <= end) {
                    word = String.valueOf(word) + this.str[j];
                    ++j;
                }
                if ((word = word.trim()).equals("")) {
                    start = i2 + 1;
                    create = false;
                } else {
                    if (lBracketCount == 0 && rBracketCount == 0) {
                        block66: {
                            if (word.equalsIgnoreCase("and")) {
                                operation = 5;
                            } else if (word.equalsIgnoreCase("or")) {
                                operation = 6;
                            } else if (word.equalsIgnoreCase("not")) {
                                operation = 7;
                            } else if (word.equalsIgnoreCase("weightand")) {
                                operation = 8;
                            } else {
                                try {
                                    byte op = Byte.parseByte(word);
                                    if (op == 5 || op == 6 || op == 7) {
                                        operation = op;
                                        break block66;
                                    }
                                    throw new IRException(2, "Protocol Error: " + word + " is Unknown single operation in " + WHERE + ". ('{', '}', 'and', 'or', 'not', 'weightand')");
                                }
                                catch (Exception e) {
                                    throw new IRException(2, "Protocol Error: " + word + " is Unknown single operation in " + WHERE + ". ('{', '}', 'and', 'or', 'not', 'weightand')");
                                }
                            }
                        }
                        whereSet[setCount] = new WhereSet(operation);
                    } else {
                        int argumentCount = this.parseCommaToBracket(start, end);
                        if (argumentCount != 2) {
                            throw new IRException(2, "Protocol Error: Incorrect format in @where. SingleOperation/Index ID(search option|keyword;keyword|weight;weight)");
                        }
                        int j2 = this.sPartIndex[0];
                        while (j2 <= this.ePartIndex[0]) {
                            indexID = String.valueOf(indexID) + this.str[j2];
                            ++j2;
                        }
                        if ((indexID = this.decode(indexID)).equals("")) {
                            throw new IRException(2, "Protocol Error: Index ID is not defined in @where.");
                        }
                        if (indexID.indexOf(32) != -1) {
                            throw new IRException(2, "Protocol Error: Index ID cannot contain empty chractor(space) in @where.");
                        }
                        int[] arguments = this.parseRoundBracket(this.sPartIndex[1], this.ePartIndex[1]);
                        if (arguments.length != 3) {
                            throw new IRException(2, "Protocol Error: Incorrect number of arguments in @where. Number of arguments must be 3 (search option|keyword;keyword|weight;weight)");
                        }
                        if (arguments[1] != arguments[2]) {
                            throw new IRException(2, "Protocol Error: Number of arguments and  Number of operations must be equal in @where.");
                        }
                        int pos = 0;
                        operation = 0;
                        int opIndex = pos;
                        while (opIndex < pos + arguments[0]) {
                            block67: {
                                String operationStr = new String(this.str, this.sPartIndex[opIndex], this.ePartIndex[opIndex] - this.sPartIndex[opIndex] + 1);
                                if ("".equals(operationStr = operationStr.trim())) {
                                    throw new IRException(2, "Protocol Error: Operation is not defined in @where.");
                                }
                                if (operationStr.equalsIgnoreCase("HASALL")) {
                                    operation = (byte)(operation | 1);
                                } else if (operationStr.equalsIgnoreCase("HASANY")) {
                                    operation = (byte)(operation | 2);
                                } else if (operationStr.equalsIgnoreCase("SEMIHASANY")) {
                                    operation = (byte)(operation | 4);
                                } else if (operationStr.equalsIgnoreCase("EQUIV_SYNONYM")) {
                                    operation = (byte)(operation | 0x10);
                                } else if (operationStr.equalsIgnoreCase("QUASI_SYNONYM")) {
                                    operation = (byte)(operation | 0x20);
                                } else if (operationStr.equalsIgnoreCase("HASANYONE")) {
                                    operation = (byte)(operation | 3);
                                } else if (operationStr.equalsIgnoreCase("HASALLONE")) {
                                    operation = (byte)(operation | 0xB);
                                } else {
                                    try {
                                        byte op = Byte.parseByte(operationStr);
                                        if (op == 1 || op == 2 || op == 4 || op == 16 || op == 32 || op == 3 || op == 11) {
                                            operation = (byte)(operation | op);
                                            break block67;
                                        }
                                        throw new IRException(2, "Protocol Error: " + operationStr + " is unknown operation in " + WHERE + ". (HASALL, HASANY, SEMIHASANY, EQUIV_SYNONYM, QUASI_SYNONYM, HASANYONE, HASALLONE)");
                                    }
                                    catch (Exception e) {
                                        throw new IRException(2, "Protocol Error: " + operationStr + " is unknown operation in " + WHERE + ". (HASALL, HASANY, SEMIHASANY, EQUIV_SYNONYM, QUASI_SYNONYM, HASANYONE, HASALLONE)");
                                    }
                                }
                            }
                            ++opIndex;
                        }
                        String[] keywordStr = new String[arguments[1]];
                        int keywordCount = 0;
                        int j3 = pos += arguments[0];
                        while (j3 < pos + arguments[1]) {
                            String keyword = "";
                            int k = this.sPartIndex[j3];
                            while (k <= this.ePartIndex[j3]) {
                                keyword = String.valueOf(keyword) + this.str[k];
                                ++k;
                            }
                            keyword = this.decode(keyword);
                            if (!(keyword = keyword.trim()).equals("")) {
                                if (keyword.charAt(0) != '\'' || keyword.charAt(keyword.length() - 1) != '\'') {
                                    throw new IRException(2, "Protocol Error: Keyword must be placed between single quotation markes(') in @where.");
                                }
                                keyword = keyword.substring(1, keyword.length() - 1);
                                keywordStr[keywordCount++] = keyword;
                            }
                            ++j3;
                        }
                        String[] new_keywordStr = new String[keywordCount];
                        System.arraycopy(keywordStr, 0, new_keywordStr, 0, new_keywordStr.length);
                        keywords = new_keywordStr;
                        int[] weightStr = new int[arguments[2]];
                        int weightCount = 0;
                        int j4 = pos += arguments[1];
                        while (j4 < pos + arguments[1]) {
                            String weight = "";
                            int k = this.sPartIndex[j4];
                            while (k <= this.ePartIndex[j4]) {
                                weight = String.valueOf(weight) + this.str[k];
                                ++k;
                            }
                            if ((weight = weight.trim()).equals("")) {
                                weightStr[weightCount++] = -1;
                            } else {
                                try {
                                    weightStr[weightCount++] = Integer.parseInt(weight);
                                }
                                catch (Exception e) {
                                    throw new IRException(2, "Protocol Error: Weight must be a number in @where.");
                                }
                            }
                            ++j4;
                        }
                        int[] new_weightStr = new int[weightCount];
                        System.arraycopy(weightStr, 0, new_weightStr, 0, new_weightStr.length);
                        weights = new_weightStr;
                        whereSet[setCount] = weights == null || weights.length == 0 ? new WhereSet(indexID, operation, keywords) : new WhereSet(indexID, operation, keywords, weights);
                    }
                    indexID = "";
                    operation = -1;
                    keywords = null;
                    weights = null;
                    start = i2 + 1;
                    lBracketCount = 0;
                    rBracketCount = 0;
                    ++setCount;
                    create = false;
                }
            }
            ++i2;
        }
        if (whereSet.length == setCount) {
            this.query.setWhere(whereSet);
        } else {
            WhereSet[] new_WhereSet = new WhereSet[setCount];
            System.arraycopy(whereSet, 0, new_WhereSet, 0, new_WhereSet.length);
            this.query.setWhere(new_WhereSet);
        }
    }

    private void parseFilterBy() throws IRException {
        int index = this.getReservedWordIndex(FILTERBY);
        if (!this.isExistValue(index)) {
            return;
        }
        int max = 1;
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            if (this.str[i] == ',') {
                ++max;
            }
            ++i;
        }
        FilterSet[] filterSet = new FilterSet[max];
        String filterID = "";
        byte operation = 0;
        String[] keywords = null;
        int weight = -1;
        int start = this.startIndex[index];
        boolean quotUse = false;
        int setCount = 0;
        boolean create = false;
        int i2 = this.startIndex[index];
        while (i2 <= this.endIndex[index]) {
            switch (this.str[i2]) {
                case ',': {
                    if (quotUse) break;
                    create = true;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (create || i2 == this.endIndex[index]) {
                int k;
                int argumentCount = -1;
                argumentCount = i2 == this.endIndex[index] ? this.parseCommaToBracket(start, i2) : this.parseCommaToBracket(start, i2 - 1);
                if (argumentCount != 2) {
                    throw new IRException(2, "Protocol Error: Incorrect format in @filterby. Filter ID(opeartion|keyword;keyword|weight|");
                }
                int j = this.sPartIndex[0];
                while (j <= this.ePartIndex[0]) {
                    filterID = String.valueOf(filterID) + this.str[j];
                    ++j;
                }
                if ((filterID = this.decode(filterID)).equals("")) {
                    throw new IRException(2, "Protocol Error: Filter ID is not defined in @filterby.");
                }
                if (filterID.indexOf(32) != -1) {
                    throw new IRException(2, "Protocol Error: Filter ID cannot contains empty chractor(space) in @filterby.");
                }
                int[] arguments = this.parseRoundBracket(this.sPartIndex[1], this.ePartIndex[1]);
                if (arguments.length != 3) {
                    throw new IRException(2, "Protocol Error : Incorrect number of arguments in @filterby. Number of arguments is 3, (operation|keyword;keyword|weight)");
                }
                operation = 0;
                String[] operationStr = new String[arguments[0]];
                int pos = 0;
                int count = 0;
                int j2 = pos;
                while (j2 < arguments[0]) {
                    String oper = "";
                    int k2 = this.sPartIndex[j2];
                    while (k2 <= this.ePartIndex[j2]) {
                        oper = String.valueOf(oper) + this.str[k2];
                        ++k2;
                    }
                    if (!(oper = oper.trim()).equals("")) {
                        operationStr[count++] = oper;
                    }
                    ++j2;
                }
                if (count > 0) {
                    j2 = 0;
                    while (j2 < count) {
                        block71: {
                            if (operationStr[j2].equalsIgnoreCase("MATCH")) {
                                operation = (byte)(operation | 1);
                            } else if (operationStr[j2].equalsIgnoreCase("NOT")) {
                                operation = (byte)(operation | 2);
                            } else if (operationStr[j2].equalsIgnoreCase("RANGE")) {
                                operation = (byte)(operation | 3);
                            } else if (operationStr[j2].equalsIgnoreCase("PARTIAL")) {
                                operation = (byte)(operation | 4);
                            } else if (operationStr[j2].equalsIgnoreCase("PREFIX_MATCH")) {
                                operation = (byte)(operation | 5);
                            } else if (operationStr[j2].equalsIgnoreCase("SUFFIX_MATCH")) {
                                operation = (byte)(operation | 6);
                            } else if (operationStr[j2].equalsIgnoreCase("PARTIAL_NOT")) {
                                operation = (byte)(operation | 7);
                            } else if (operationStr[j2].equalsIgnoreCase("PREFIX_NOT")) {
                                operation = (byte)(operation | 8);
                            } else if (operationStr[j2].equalsIgnoreCase("SUFFIX_NOT")) {
                                operation = (byte)(operation | 9);
                            } else if (operationStr[j2].equalsIgnoreCase("SECURE")) {
                                operation = (byte)10;
                            } else if (operationStr[j2].equalsIgnoreCase("SECURE_ECM")) {
                                operation = (byte)14;
                            } else if (operationStr[j2].equalsIgnoreCase("DISTANCE_NEAR")) {
                                operation = (byte)11;
                            } else if (operationStr[j2].equalsIgnoreCase("DISTANCE_FAR")) {
                                operation = (byte)12;
                            } else if (operationStr[j2].equalsIgnoreCase("DISTANCE_RANGE")) {
                                operation = (byte)13;
                            } else if (operationStr[j2].equalsIgnoreCase("CONDITION_ALL")) {
                                operation = (byte)(operation | 0x20);
                            } else if (operationStr[j2].equalsIgnoreCase("WEIGHT_ADJUST")) {
                                operation = (byte)(operation | 0x10);
                            } else if (operationStr[j2].equalsIgnoreCase("ADDWEIGHT")) {
                                operation = (byte)(operation | 0x41);
                            } else if (operationStr[j2].equalsIgnoreCase("MERGEWEIGHT")) {
                                operation = (byte)(operation | 0x42);
                            } else {
                                try {
                                    byte op = Byte.parseByte(operationStr[j2]);
                                    if (op == 1 || op == 2 || op == 3 || op == 4 || op == 5 || op == 6 || op == 7 || op == 8 || op == 9 || op == 10 || op == 14 || op == 11 || op == 12 || op == 13 || op == 32 || op == 16 || op == 65 || op == 66) {
                                        operation = (byte)(operation | op);
                                        break block71;
                                    }
                                    throw new IRException(2, "Protocol Error: " + operationStr + " is unknown operation in " + FILTERBY + ". (MATCH, NOT, RANGE, PARTIAL, PREFIX_MATCH, SUFFIX_MATCH PARTIAL_NOT, PREFIX_NOT, SUFFIX_NOT, SECURE, SECURE_ECM,DISTANCE_NEAR, DISTANCE_FAR, DISTANCE_RANGE, CONDITION_ALL, WEIGHT_ADJUST, ADDWEIGHT, MERGEWEIGHT)");
                                }
                                catch (Exception e) {
                                    throw new IRException(2, "Protocol Error: " + operationStr + " is unknown operation in " + FILTERBY + ". (MATCH, NOT, RANGE, PARTIAL, PREFIX_MATCH, SUFFIX_MATCH PARTIAL_NOT, PREFIX_NOT, SUFFIX_NOT, SECURE, SECURE_ECM,DISTANCE_NEAR, DISTANCE_FAR, DISTANCE_RANGE, CONDITION_ALL, WEIGHT_ADJUST, ADDWEIGHT, MERGEWEIGHT)");
                                }
                            }
                        }
                        ++j2;
                    }
                } else {
                    throw new IRException(2, "Protocol Error: Operation is not defined in @filterby");
                }
                String[] keywordStr = new String[arguments[1]];
                count = 0;
                int j3 = pos += arguments[0];
                while (j3 < pos + arguments[1]) {
                    String keyword = "";
                    k = this.sPartIndex[j3];
                    while (k <= this.ePartIndex[j3]) {
                        keyword = String.valueOf(keyword) + this.str[k];
                        ++k;
                    }
                    keyword = this.decode(keyword);
                    if (!(keyword = keyword.trim()).equals("")) {
                        if (keyword.charAt(0) != '\'' || keyword.charAt(keyword.length() - 1) != '\'') {
                            throw new IRException(2, "Protocol Error: keyword must be placed between single quotation mark(') in @filterby.");
                        }
                        keyword = keyword.substring(1, keyword.length() - 1);
                        keywordStr[count++] = keyword;
                    }
                    ++j3;
                }
                String[] new_keywordStr = new String[count];
                System.arraycopy(keywordStr, 0, new_keywordStr, 0, new_keywordStr.length);
                keywords = new_keywordStr;
                if (arguments[2] != 1) {
                    throw new IRException(2, "Protocol Error: Weight cannot be multiple in @filterby.");
                }
                String weightStr = "";
                k = this.sPartIndex[pos += arguments[1]];
                while (k <= this.ePartIndex[pos]) {
                    weightStr = String.valueOf(weightStr) + this.str[k];
                    ++k;
                }
                if (!(weightStr = weightStr.trim()).equals("")) {
                    try {
                        weight = Integer.parseInt(weightStr);
                    }
                    catch (Exception e) {
                        throw new IRException(2, "Protocol Error: weight must be a number in @filterby.");
                    }
                }
                if (keywords == null) {
                    keywords = new String[]{};
                }
                filterSet[setCount] = weight == -1 ? new FilterSet(operation, filterID, keywords) : new FilterSet(operation, filterID, keywords, weight);
                filterID = "";
                operation = (byte)-1;
                keywords = null;
                weight = -1;
                start = i2 + 1;
                ++setCount;
                create = false;
            }
            ++i2;
        }
        if (filterSet.length == setCount) {
            this.query.setFilter(filterSet);
        } else {
            FilterSet[] new_FilterSet = new FilterSet[setCount];
            System.arraycopy(filterSet, 0, new_FilterSet, 0, new_FilterSet.length);
            this.query.setFilter(new_FilterSet);
        }
    }

    private void parseOrderBy() throws IRException {
        int operation;
        boolean order;
        String orderID;
        block35: {
            int index = this.getReservedWordIndex(ORDERBY);
            if (!this.isExistValue(index)) {
                return;
            }
            orderID = "";
            order = false;
            operation = -1;
            int argumentCount = this.parseCommaToBracket(this.startIndex[index], this.endIndex[index]);
            if (argumentCount != 2) {
                throw new IRException(2, "Protocol Error: Incorrect format in @orderby. (order option|operation)");
            }
            int j = this.sPartIndex[0];
            while (j <= this.ePartIndex[0]) {
                orderID = String.valueOf(orderID) + this.str[j];
                ++j;
            }
            if ((orderID = this.decode(orderID)).equals("")) {
                throw new IRException(2, "Protocol Error: Order ID is not defined in @orderby.");
            }
            if (orderID.indexOf(32) != -1) {
                throw new IRException(2, "Protocol Error: Order ID cannot contain empty character(space) in @orderby.");
            }
            int[] arguments = this.parseRoundBracket(this.sPartIndex[1], this.ePartIndex[1]);
            if (arguments.length != 2) {
                throw new IRException(2, "Protocol Error: Incorrect number of arguments in @orderby. Number of arguments is 2. (order option|operation)");
            }
            if (arguments[0] != 1) {
                throw new IRException(2, "Protocol Error: Order option cannot be multiple in @orderby.");
            }
            String orderStr = "";
            int pos = 0;
            int k = this.sPartIndex[pos];
            while (k <= this.ePartIndex[pos]) {
                orderStr = String.valueOf(orderStr) + this.str[k];
                ++k;
            }
            if ((orderStr = orderStr.trim()).equals("")) {
                throw new IRException(2, "Protocol Error: Order option is not defined in @orderby.");
            }
            if (orderStr.equalsIgnoreCase("ASC")) {
                order = true;
            } else if (orderStr.equalsIgnoreCase("DESC")) {
                order = false;
            } else {
                throw new IRException(2, "Protocol Error : " + orderStr + " is unknown order option in " + ORDERBY + ". (ASC, DESC)");
            }
            if (arguments[1] != 1) {
                throw new IRException(2, "Protocol Error: operation cannot be multiple in @orderby.");
            }
            String operationStr = "";
            int k2 = this.sPartIndex[pos += arguments[0]];
            while (k2 <= this.ePartIndex[pos]) {
                operationStr = String.valueOf(operationStr) + this.str[k2];
                ++k2;
            }
            if (!(operationStr = operationStr.trim()).equals("")) {
                if (operationStr.equalsIgnoreCase("PREWEIGHT")) {
                    operation = 97;
                } else if (operationStr.equalsIgnoreCase("POSTWEIGHT")) {
                    operation = 98;
                } else if (operationStr.equalsIgnoreCase("ADDWEIGHT")) {
                    operation = 101;
                } else if (operationStr.equalsIgnoreCase("MERGEWEIGHT")) {
                    operation = 100;
                } else if (operationStr.equalsIgnoreCase("DISTANCE")) {
                    operation = 102;
                } else if (operationStr.equalsIgnoreCase("DISTANCE_PREWEIGHT")) {
                    operation = 103;
                } else if (operationStr.equalsIgnoreCase("DISTANCE_POSTWEIGHT")) {
                    operation = 104;
                } else if (operationStr.equalsIgnoreCase("NONE")) {
                    operation = 99;
                } else {
                    try {
                        byte op = Byte.parseByte(operationStr);
                        if (op == 97 || op == 98 || op == 101 || op == 100 || op == 102 || op == 103 || op == 104 || op == 99) {
                            operation = op;
                            break block35;
                        }
                        throw new IRException(2, "Protocol Error: " + operationStr + " is unknown operation in " + ORDERBY + ". (PREWEIGHT, POSTWEIGHT, ADDWEIGHT, MERGEWEIGHT, DISTANCE, DISTANCE_PREWEIGHT, DISTANCE_POSTWEIGHT, NONE)");
                    }
                    catch (Exception e) {
                        throw new IRException(2, "Protocol Error: " + operationStr + " is unknown operation in " + ORDERBY + ". (PREWEIGHT, POSTWEIGHT, ADDWEIGHT, MERGEWEIGHT, DISTANCE, DISTANCE_PREWEIGHT, DISTANCE_POSTWEIGHT, NONE)");
                    }
                }
            }
        }
        OrderBySet[] orderBySet = new OrderBySet[]{operation == -1 ? new OrderBySet(order, orderID) : new OrderBySet(order, orderID, (byte)operation)};
        this.query.setOrderby(orderBySet);
    }

    private void parseGroupBy() throws IRException {
        int index = this.getReservedWordIndex(GROUPBY);
        if (!this.isExistValue(index)) {
            return;
        }
        int max = 1;
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            if (this.str[i] == ',') {
                ++max;
            }
            ++i;
        }
        GroupBySet[] groupBySet = new GroupBySet[max];
        String groupID = "";
        byte[] operation = null;
        String[] operArgument = null;
        String[] filterKeyword = null;
        int start = this.startIndex[index];
        boolean quotUse = false;
        int setCount = 0;
        boolean create = false;
        int i2 = this.startIndex[index];
        while (i2 <= this.endIndex[index]) {
            switch (this.str[i2]) {
                case ',': {
                    if (quotUse) break;
                    create = true;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (create || i2 == this.endIndex[index]) {
                int argumentCount = -1;
                argumentCount = i2 == this.endIndex[index] ? this.parseCommaToBracket(start, i2) : this.parseCommaToBracket(start, i2 - 1);
                if (argumentCount != 1 && argumentCount != 2) {
                    throw new IRException(2, "Protocol Error: Incorrect format in@groupby. Group ID(opeartion;operation|opeartion argument;operation argument|group filter keyword)");
                }
                int j = this.sPartIndex[0];
                while (j <= this.ePartIndex[0]) {
                    groupID = String.valueOf(groupID) + this.str[j];
                    ++j;
                }
                if ((groupID = this.decode(groupID)).equals("")) {
                    throw new IRException(2, "Protocol Error: Group ID is not defined in@groupby.");
                }
                if (groupID.indexOf(32) != -1) {
                    throw new IRException(2, "Protocol Error: Group ID cannot contain empty character(space)in@groupby.");
                }
                if (argumentCount == 2) {
                    int[] arguments = this.parseRoundBracket(this.sPartIndex[1], this.ePartIndex[1]);
                    if (arguments.length != 3) {
                        throw new IRException(2, "Protocol Error: Incorrect number or arguments in@groupby. Number of arguments must be 3. (operation;operation|operation argument;operation argument|group filter keyword)");
                    }
                    if (arguments[1] < 0 || arguments[0] < arguments[1]) {
                        throw new IRException(2, "Protocol Error: Number of operation and  Number of operation argument must be equal in @groupby.");
                    }
                    String[] operationStr = new String[arguments[0]];
                    int pos = 0;
                    int count = 0;
                    int j2 = 0;
                    while (j2 < arguments[0]) {
                        String oper = "";
                        int k = this.sPartIndex[j2];
                        while (k <= this.ePartIndex[j2]) {
                            oper = String.valueOf(oper) + this.str[k];
                            ++k;
                        }
                        if (!(oper = oper.trim()).equals("")) {
                            operationStr[count++] = oper;
                        }
                        ++j2;
                    }
                    operation = new byte[count];
                    j2 = 0;
                    while (j2 < count) {
                        block47: {
                            operationStr[j2] = operationStr[j2].trim();
                            if (operationStr[j2].equalsIgnoreCase("COUNT")) {
                                operation[j2] = 33;
                            } else if (operationStr[j2].equalsIgnoreCase("RANGE_COUNT")) {
                                operation[j2] = 34;
                            } else if (operationStr[j2].equalsIgnoreCase("ORDER_COUNT")) {
                                operation[j2] = 40;
                            } else if (operationStr[j2].equalsIgnoreCase("ORDER_NAME")) {
                                operation[j2] = 36;
                            } else if (operationStr[j2].equalsIgnoreCase("ORDER_NONE")) {
                                operation[j2] = 32;
                            } else {
                                try {
                                    byte op = Byte.parseByte(operationStr[j2]);
                                    if (op == 33 || op == 34 || op == 40 || op == 36 || op == 32) {
                                        operation[j2] = op;
                                        break block47;
                                    }
                                    throw new IRException(2, "Protocol Error: " + operationStr[j2] + " is unknown operation in " + GROUPBY + ". (COUNT, RANGE_COUNT, ORDER_COUNT, ORDER_NAME, ORDER_NONE)");
                                }
                                catch (Exception e) {
                                    throw new IRException(2, "Protocol Error: " + operationStr[j2] + " is unknown operation in " + GROUPBY + ". (COUNT, RANGE_COUNT, ORDER_COUNT, ORDER_NAME, ORDER_NONE)");
                                }
                            }
                        }
                        ++j2;
                    }
                    String[] operArgumentStr = new String[arguments[1]];
                    count = 0;
                    int j3 = pos += arguments[0];
                    while (j3 < pos + arguments[1]) {
                        String operArgu = "";
                        int k = this.sPartIndex[j3];
                        while (k <= this.ePartIndex[j3]) {
                            operArgu = String.valueOf(operArgu) + this.str[k];
                            ++k;
                        }
                        operArgu = this.decode(operArgu);
                        if ((operArgu = operArgu.trim()).equals("")) {
                            operArgumentStr[count++] = operArgu;
                        } else {
                            if (operArgu.charAt(0) != '\'' || operArgu.charAt(operArgu.length() - 1) != '\'') {
                                throw new IRException(2, "Protocol Error: Operation argument must be placed between single quotation marks(') in @groupby.");
                            }
                            operArgu = operArgu.substring(1, operArgu.length() - 1);
                            operArgumentStr[count++] = operArgu;
                        }
                        ++j3;
                    }
                    String[] new_operArgumentStr = new String[count];
                    System.arraycopy(operArgumentStr, 0, new_operArgumentStr, 0, new_operArgumentStr.length);
                    operArgument = new_operArgumentStr;
                    String[] filterKeywordStr = new String[arguments[2]];
                    count = 0;
                    int j4 = pos += arguments[1];
                    while (j4 < pos + arguments[2]) {
                        String keyword = "";
                        int k = this.sPartIndex[j4];
                        while (k <= this.ePartIndex[j4]) {
                            keyword = String.valueOf(keyword) + this.str[k];
                            ++k;
                        }
                        keyword = this.decode(keyword);
                        if (!(keyword = keyword.trim()).equals("")) {
                            if (keyword.charAt(0) != '\'' || keyword.charAt(keyword.length() - 1) != '\'') {
                                throw new IRException(2, "Protocol Error: keyword must be placed between single quotation mark(') in @filterby.");
                            }
                            keyword = keyword.substring(1, keyword.length() - 1);
                            filterKeywordStr[count++] = keyword;
                        }
                        ++j4;
                    }
                    String[] new_keywordStr = new String[count];
                    System.arraycopy(filterKeywordStr, 0, new_keywordStr, 0, new_keywordStr.length);
                    filterKeyword = new_keywordStr;
                }
                if (operation == null || operation.length == 0) {
                    groupBySet[setCount] = new GroupBySet(groupID, 0, "", filterKeyword);
                } else {
                    byte operationOred = 0;
                    int j5 = 0;
                    while (j5 < operation.length) {
                        operationOred = (byte)(operationOred | operation[j5]);
                        ++j5;
                    }
                    groupBySet[setCount] = new GroupBySet(groupID, operationOred, (String)operArgument[0], filterKeyword);
                }
                groupID = "";
                operation = null;
                operArgument = null;
                filterKeyword = null;
                start = i2 + 1;
                ++setCount;
                create = false;
            }
            ++i2;
        }
        if (groupBySet.length == setCount) {
            this.query.setGroupBy(groupBySet);
        } else {
            GroupBySet[] new_GroupBySet = new GroupBySet[setCount];
            System.arraycopy(groupBySet, 0, new_GroupBySet, 0, new_GroupBySet.length);
            this.query.setGroupBy(new_GroupBySet);
        }
    }

    private void parseModifier() throws IRException {
        int index = this.getReservedWordIndex(MODIFIER);
        if (!this.isExistValue(index)) {
            return;
        }
        String queryModifier = "";
        String resultModifier = "";
        int start = this.startIndex[index];
        boolean create = false;
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            switch (this.str[i]) {
                case ',': {
                    create = true;
                }
            }
            if (create || i == this.endIndex[index]) {
                int argumentCount = -1;
                argumentCount = i == this.endIndex[index] ? this.parseCommaToEqual(start, i) : this.parseCommaToEqual(start, i - 1);
                if (argumentCount != 2) {
                    throw new IRException(2, "Protocol Error: Incorrect format in @modifier. (q=QueryModifier class name / r=ResultModifier class name)");
                }
                String key = "";
                int j = this.sPartIndex[0];
                while (j <= this.ePartIndex[0]) {
                    key = String.valueOf(key) + this.str[j];
                    ++j;
                }
                if (key.length() != 1 || !key.equalsIgnoreCase("q") && !key.equalsIgnoreCase("r")) {
                    throw new IRException(2, "Protocol Error: Unknown key (" + key + ") in " + MODIFIER + ". (Key is 'q' or 'r')");
                }
                if (key.equalsIgnoreCase("q")) {
                    if (!queryModifier.equals("")) {
                        throw new IRException(2, "Protocol Error: QueryModifier must be one and only in @modifier.");
                    }
                    j = this.sPartIndex[1];
                    while (j <= this.ePartIndex[1]) {
                        queryModifier = String.valueOf(queryModifier) + this.str[j];
                        ++j;
                    }
                    queryModifier = this.decode(queryModifier);
                    if (!(queryModifier = queryModifier.trim()).equals("")) {
                        if (queryModifier.indexOf(32) != -1) {
                            throw new IRException(2, "Protocol Error: QueryModifier cannot contain empty character(space) in @modifier.");
                        }
                        this.query.setQueryModifier(queryModifier);
                    }
                } else if (key.equalsIgnoreCase("r")) {
                    if (!resultModifier.equals("")) {
                        throw new IRException(2, "Protocol Error: ResultModifier must be one and only in @modifier.");
                    }
                    j = this.sPartIndex[1];
                    while (j <= this.ePartIndex[1]) {
                        resultModifier = String.valueOf(resultModifier) + this.str[j];
                        ++j;
                    }
                    resultModifier = this.decode(resultModifier);
                    if (!(resultModifier = resultModifier.trim()).equals("")) {
                        if (resultModifier.indexOf(32) != -1) {
                            throw new IRException(2, "Protocol Error: ResultModifier cannot contain empty character(space) in @modifier.");
                        }
                        this.query.setResultModifier(resultModifier);
                    }
                }
                start = i + 1;
                create = false;
            }
            ++i;
        }
    }

    private void parseQueryLogger() throws IRException {
        int index = this.getReservedWordIndex(QUERYLOGGER);
        if (!this.isExistValue(index)) {
            return;
        }
        String queryLogger = "";
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            queryLogger = String.valueOf(queryLogger) + this.str[i];
            ++i;
        }
        queryLogger = this.decode(queryLogger);
        if (!(queryLogger = queryLogger.trim()).equals("")) {
            if (queryLogger.indexOf(32) != -1) {
                throw new IRException(2, "Protocol Error: Logger name cannot contain empty character(space) in @querylogger. (" + queryLogger + ")");
            }
            this.query.setQueryLogger(queryLogger);
        }
    }

    private void parseRecommend() throws IRException {
        int index = this.getReservedWordIndex(RECOMMEND);
        if (!this.isExistValue(index)) {
            return;
        }
        String recommend = "";
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            recommend = String.valueOf(recommend) + this.str[i];
            ++i;
        }
        recommend = this.decode(recommend);
        if (!(recommend = recommend.trim()).equals("")) {
            if (recommend.indexOf(32) != -1) {
                throw new IRException(2, "Protocol Error: Recommend keyword cannot contain empty character(space) in @recommend. (" + recommend + ")");
            }
            this.query.setRecommend(recommend);
        }
    }

    private void parseRedireict() {
        int index = this.getReservedWordIndex(REDIRECT);
        if (!this.isExistValue(index)) {
            return;
        }
        String redirect = "";
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            redirect = String.valueOf(redirect) + this.str[i];
            ++i;
        }
        redirect = this.decode(redirect);
        if (!(redirect = redirect.trim()).equals("")) {
            this.query.setRedirect(redirect);
        }
    }

    private void parseLoggable() throws IRException {
        int index = this.getReservedWordIndex(LOGGABLE);
        if (!this.isExistValue(index)) {
            return;
        }
        String loggable = "";
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            loggable = String.valueOf(loggable) + this.str[i];
            ++i;
        }
        loggable = this.decode(loggable);
        if (!(loggable = loggable.trim()).equals("")) {
            if (!loggable.equalsIgnoreCase("true") && !loggable.equalsIgnoreCase("false")) {
                throw new IRException(2, "Protocol Error: loggable keyword must be boolean type (true/false) in@loggable. (" + loggable + ")");
            }
            this.query.setLoggable(Boolean.valueOf(loggable));
        }
    }

    private void parseFaultless() throws IRException {
        int index = this.getReservedWordIndex(FAULTLESS);
        if (!this.isExistValue(index)) {
            return;
        }
        String faultless = "";
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            faultless = String.valueOf(faultless) + this.str[i];
            ++i;
        }
        faultless = this.decode(faultless);
        if (!(faultless = faultless.trim()).equals("")) {
            if (!faultless.equalsIgnoreCase("true") && !faultless.equalsIgnoreCase("false")) {
                throw new IRException(2, "Protocol Error: faultless keyword must be boolean type (true/false) in@faultless. (" + faultless + ")");
            }
            this.query.setFaultless(Boolean.valueOf(faultless));
        }
    }

    private void parseDebug() throws IRException {
        int index = this.getReservedWordIndex(DEBUG);
        if (!this.isExistValue(index)) {
            return;
        }
        String debug = "";
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            debug = String.valueOf(debug) + this.str[i];
            ++i;
        }
        debug = this.decode(debug);
        if (!(debug = debug.trim()).equals("")) {
            if (!debug.equalsIgnoreCase("true") && !debug.equalsIgnoreCase("false")) {
                throw new IRException(2, "Protocol Error: debug keyword must be boolean type (true/false) in@debug. (" + debug + ")");
            }
            this.query.setDebug(Boolean.valueOf(debug));
        }
    }

    private void parsePrintQuery() throws IRException {
        int index = this.getReservedWordIndex(PRINTQUERY);
        if (!this.isExistValue(index)) {
            return;
        }
        String printQuery = "";
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            printQuery = String.valueOf(printQuery) + this.str[i];
            ++i;
        }
        printQuery = this.decode(printQuery);
        if (!(printQuery = printQuery.trim()).equals("")) {
            if (!printQuery.equalsIgnoreCase("true") && !printQuery.equalsIgnoreCase("false")) {
                throw new IRException(2, "Protocol Error: printQuery keyword must be boolean type (true/false) in@printquery. (" + printQuery + ")");
            }
            this.query.setPrintQuery(Boolean.valueOf(printQuery));
        }
    }

    private void parseData() throws IRException {
        int index = this.getReservedWordIndex(DATA);
        if (!this.isExistValue(index)) {
            return;
        }
        String key = "";
        String value = "";
        int start = this.startIndex[index];
        boolean quotUse = false;
        boolean create = false;
        int i = this.startIndex[index];
        while (i <= this.endIndex[index]) {
            switch (this.str[i]) {
                case ',': {
                    if (quotUse) break;
                    create = true;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (create || i == this.endIndex[index]) {
                int argumentCount = -1;
                argumentCount = i == this.endIndex[index] ? this.parseCommaToEqual(start, i) : this.parseCommaToEqual(start, i - 1);
                if (argumentCount != 2) {
                    throw new IRException(2, "Protocol Error: Incorrect format in @data. ('key'='value')");
                }
                key = "";
                int j = this.sPartIndex[0];
                while (j <= this.ePartIndex[0]) {
                    key = String.valueOf(key) + this.str[j];
                    ++j;
                }
                key = this.decode(key);
                if ((key = key.trim()).charAt(0) != '\'' || key.charAt(key.length() - 1) != '\'') {
                    throw new IRException(2, "Protocol Error: Key must be placed in single quotation marks(') in @data.");
                }
                key = key.substring(1, key.length() - 1);
                value = "";
                j = this.sPartIndex[1];
                while (j <= this.ePartIndex[1]) {
                    value = String.valueOf(value) + this.str[j];
                    ++j;
                }
                value = this.decode(value);
                if ((value = value.trim()).charAt(0) != '\'' || value.charAt(value.length() - 1) != '\'') {
                    throw new IRException(2, "Protocol Error: Value must be placed in single quotation marks(') in @data.");
                }
                value = value.substring(1, value.length() - 1);
                this.query.setValue(key, value);
                start = i + 1;
                create = false;
            }
            ++i;
        }
    }

    public String queryToString(Query query) {
        char[] redirect;
        StringBuffer sb = new StringBuffer();
        SelectSet[] selectSets = query.getSelectFields();
        int i = 0;
        while (i < selectSets.length) {
            if (i == 0) {
                sb.append(" @select ");
            }
            sb.append(this.encode(String.valueOf(selectSets[i].getField())));
            String operStr = "";
            if ((selectSets[i].getOption() & 0x12) == 18) {
                operStr = String.valueOf(operStr) + "HIGHLIGHT;";
            }
            if ((selectSets[i].getOption() & 0x11) == 17) {
                operStr = String.valueOf(operStr) + "SUMMARIZE;";
            }
            if ((selectSets[i].getOption() & 0x14) == 20) {
                operStr = String.valueOf(operStr) + "SYNONYM_HIGHLIGHT;";
            }
            if ((selectSets[i].getOption() & 0x18) == 24) {
                operStr = String.valueOf(operStr) + "DISTANCE;";
            }
            if (operStr.equals("")) {
                sb.append("(NONE|");
            } else {
                sb.append("(" + operStr.substring(0, operStr.length() - 1) + "|");
            }
            sb.append(String.valueOf(selectSets[i].getSummarySize()) + ")");
            if (i != selectSets.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        if (query.getFromField() != null) {
            sb.append(" @from ");
            sb.append(this.encode(String.valueOf(query.getFromField())));
            sb.append("('" + this.encode(String.valueOf(query.getHighLightStartTag())) + "'|");
            sb.append("'" + this.encode(String.valueOf(query.getHighLightEndTag())) + "'|");
            sb.append(String.valueOf(query.getResultStart()) + "|");
            sb.append(String.valueOf(query.getResultEnd()) + "|");
            sb.append(String.valueOf(query.getSearchOption()) + "|");
            sb.append(String.valueOf(query.getThesaurusOption()) + "|");
            sb.append(String.valueOf(query.getRankingOption()) + "|");
            sb.append(String.valueOf(query.getCategoryRankingOption()) + ")");
        }
        if (query.getProfile() != null) {
            sb.append(" @profile ");
            sb.append(this.encode(String.valueOf(query.getProfile())));
        }
        if (query.getProfile() != null) {
            sb.append(" @keyword ");
            sb.append("'" + this.encode(String.valueOf(query.getSearchKeyword())) + "'");
        }
        WhereSet[] whereSets = query.getWhereFields();
        int i2 = 0;
        while (i2 < whereSets.length) {
            if (i2 == 0) {
                sb.append(" @where ");
            }
            if (whereSets[i2].isOperation()) {
                switch (whereSets[i2].getOperation()) {
                    case 9: {
                        sb.append("{");
                        break;
                    }
                    case 10: {
                        sb.append("}");
                        break;
                    }
                    case 5: {
                        sb.append("and");
                        break;
                    }
                    case 6: {
                        sb.append("or");
                        break;
                    }
                    case 7: {
                        sb.append("not");
                        break;
                    }
                    case 8: {
                        sb.append("weightand");
                    }
                }
            } else {
                sb.append(this.encode(String.valueOf(whereSets[i2].getField())));
                sb.append('(');
                if (WhereSet.isHasAll(whereSets[i2].getOperation())) {
                    sb.append("HASALL;");
                } else if (WhereSet.isHasAny(whereSets[i2].getOperation())) {
                    sb.append("HASANY;");
                } else if (WhereSet.isSemiHasAny(whereSets[i2].getOperation())) {
                    sb.append("SEMIHASANY;");
                } else if (WhereSet.isHasAnyOne(whereSets[i2].getOperation())) {
                    sb.append("HASANYONE;");
                }
                if (WhereSet.isThesaurusExtend((byte)1, whereSets[i2].getOperation())) {
                    sb.append("EQUIV_SYNONYM;");
                }
                if (WhereSet.isThesaurusExtend((byte)4, whereSets[i2].getOperation())) {
                    sb.append("QUASI_SYNONYM;");
                }
                if (sb.charAt(sb.length() - 1) == ';') {
                    sb.setLength(sb.length() - 1);
                }
                sb.append('|');
                char[][] keywords = whereSets[i2].getKeywords();
                int j = 0;
                while (j < keywords.length) {
                    sb.append("'" + this.encode(String.valueOf(keywords[j])) + "'");
                    if (j != keywords.length - 1) {
                        sb.append(";");
                    } else {
                        sb.append("|");
                    }
                    ++j;
                }
                int[] weights = whereSets[i2].getWeight();
                int j2 = 0;
                while (j2 < weights.length) {
                    sb.append(weights[j2]);
                    if (j2 != weights.length - 1) {
                        sb.append(";");
                    } else {
                        sb.append(")");
                    }
                    ++j2;
                }
            }
            if (i2 != whereSets.length - 1) {
                sb.append(" ");
            }
            ++i2;
        }
        FilterSet[] filterSets = query.getFilterFields();
        int i3 = 0;
        while (i3 < filterSets.length) {
            if (i3 == 0) {
                sb.append(" @filterby ");
            }
            sb.append(this.encode(String.valueOf(filterSets[i3].getField())));
            String operStr = "";
            byte operation = filterSets[i3].getOperation();
            if ((operation & 0x20) == 32) {
                operStr = String.valueOf(operStr) + "CONDITION_ALL;";
                operation = (byte)(operation - 32);
            }
            if ((operation & 0x10) != 0) {
                operStr = String.valueOf(operStr) + "WEIGHT_ADJUST;";
                operation = (byte)(operation - 16);
            }
            switch (operation) {
                case 1: {
                    operStr = String.valueOf(operStr) + "MATCH;";
                    break;
                }
                case 2: {
                    operStr = String.valueOf(operStr) + "NOT;";
                    break;
                }
                case 3: {
                    operStr = String.valueOf(operStr) + "RANGE;";
                    break;
                }
                case 4: {
                    operStr = String.valueOf(operStr) + "PARTIAL;";
                    break;
                }
                case 5: {
                    operStr = String.valueOf(operStr) + "PREFIX_MATCH;";
                    break;
                }
                case 6: {
                    operStr = String.valueOf(operStr) + "SUFFIX_MATCH;";
                    break;
                }
                case 7: {
                    operStr = String.valueOf(operStr) + "PARTIAL_NOT;";
                    break;
                }
                case 8: {
                    operStr = String.valueOf(operStr) + "PREFIX_NOT;";
                    break;
                }
                case 9: {
                    operStr = String.valueOf(operStr) + "SUFFIX_NOT;";
                    break;
                }
                case 10: {
                    operStr = String.valueOf(operStr) + "SECURE;";
                    break;
                }
                case 14: {
                    operStr = String.valueOf(operStr) + "SECURE_ECM;";
                    break;
                }
                case 11: {
                    operStr = String.valueOf(operStr) + "DISTANCE_NEAR;";
                    break;
                }
                case 12: {
                    operStr = String.valueOf(operStr) + "DISTANCE_FAR;";
                    break;
                }
                case 13: {
                    operStr = String.valueOf(operStr) + "DISTANCE_RANGE;";
                    break;
                }
                case 65: {
                    operStr = String.valueOf(operStr) + "ADDWEIGHT;";
                    break;
                }
                case 66: {
                    operStr = String.valueOf(operStr) + "MERGEWEIGHT;";
                }
            }
            if (operStr.equals("")) {
                sb.append("(|");
            } else {
                sb.append("(" + operStr.substring(0, operStr.length() - 1) + "|");
            }
            char[][] keywords = filterSets[i3].getKeyword();
            int j = 0;
            while (j < keywords.length) {
                sb.append("'" + this.encode(String.valueOf(keywords[j])) + "'");
                if (j != keywords.length - 1) {
                    sb.append(";");
                } else {
                    sb.append("|");
                }
                ++j;
            }
            sb.append(filterSets[i3].getWeight());
            if (i3 == filterSets.length - 1) {
                sb.append(")");
            } else {
                sb.append("), ");
            }
            ++i3;
        }
        OrderBySet[] orderBySets = query.getOrderbyFields();
        int i4 = 0;
        while (i4 < orderBySets.length) {
            if (i4 == 0) {
                sb.append(" @orderby ");
            }
            sb.append(this.encode(String.valueOf(orderBySets[i4].getField())));
            if (orderBySets[i4].getOrder()) {
                sb.append("(ASC|");
            } else {
                sb.append("(DESC|");
            }
            switch (orderBySets[i4].getOperation()) {
                case 97: {
                    sb.append("PREWEIGHT)");
                    break;
                }
                case 98: {
                    sb.append("POSTWEIGHT)");
                    break;
                }
                case 101: {
                    sb.append("ADDWEIGHT)");
                    break;
                }
                case 100: {
                    sb.append("MERGEWEIGHT)");
                    break;
                }
                case 102: {
                    sb.append("DISTANCE)");
                    break;
                }
                case 103: {
                    sb.append("DISTANCE_PREWEIGHT)");
                    break;
                }
                case 104: {
                    sb.append("DISTANCE_POSTWEIGHT)");
                    break;
                }
                case 99: {
                    sb.append("NONE)");
                }
            }
            ++i4;
        }
        GroupBySet[] groupBySets = query.getGroupSelectFields();
        int i5 = 0;
        while (i5 < groupBySets.length) {
            String arguStr;
            if (i5 == 0) {
                sb.append(" @groupby ");
            }
            sb.append(this.encode(String.valueOf(groupBySets[i5].getField())));
            String operStr = "";
            byte operation = groupBySets[i5].getOperation();
            if ((operation & 0x21) == 33) {
                operStr = String.valueOf(operStr) + "COUNT;";
            } else if ((operation & 0x22) == 34) {
                operStr = String.valueOf(operStr) + "RANGE_COUNT;";
            }
            if ((operation & 0x28) == 40) {
                operStr = String.valueOf(operStr) + "ORDER_COUNT;";
            } else if ((operation & 0x24) == 36) {
                operStr = String.valueOf(operStr) + "ORDER_NAME;";
            } else if ((operation & 0x20) == 32) {
                operStr = String.valueOf(operStr) + "ORDER_NONE;";
            }
            if (operStr.equals("")) {
                sb.append("(|");
            } else {
                sb.append("(" + operStr.substring(0, operStr.length() - 1) + "|");
            }
            String string = arguStr = groupBySets[i5].getArgument() == null ? "" : String.valueOf(groupBySets[i5].getArgument());
            if (arguStr.equals("")) {
                sb.append("|");
            } else {
                sb.append("'" + arguStr.substring(0, arguStr.length()) + "'|");
            }
            char[][] groupFilter = groupBySets[i5].getGroupFilter();
            if (groupFilter != null && groupFilter.length != 0) {
                int groupFilterSize = groupFilter.length;
                int gIdx = 0;
                while (gIdx < groupFilterSize) {
                    sb.append("'");
                    sb.append(this.encode(String.valueOf(groupFilter[gIdx])));
                    sb.append("'");
                    if (gIdx < groupFilterSize - 1) {
                        sb.append(";");
                    }
                    ++gIdx;
                }
            } else {
                sb.append("'");
                sb.append("'");
            }
            if (i5 == groupBySets.length - 1) {
                sb.append(")");
            } else {
                sb.append("), ");
            }
            ++i5;
        }
        DistanceSet distance = query.getDistance();
        String distanceID = null;
        char[][] coordinates = null;
        if (distance != null) {
            distanceID = new String(distance.getField());
            coordinates = distance.getCoordinates();
            if (distanceID != null && !distanceID.equals("")) {
                sb.append(" @distance ");
                sb.append(this.encode(String.valueOf(distance.getField()))).append("(");
                int j = 0;
                while (j < coordinates.length) {
                    sb.append("'").append(this.encode(String.valueOf(coordinates[j]))).append("'");
                    if (j != coordinates.length - 1) {
                        sb.append(";");
                    } else {
                        sb.append(")");
                    }
                    ++j;
                }
            }
        }
        String queryModifier = query.getQueryModifier();
        String resultModifier = query.getResultModifier();
        if (queryModifier != null && !queryModifier.equals("")) {
            sb.append(" @modifier ");
            sb.append("q=" + this.encode(queryModifier));
            if (resultModifier != null && !resultModifier.equals("")) {
                sb.append(", r=" + this.encode(resultModifier));
            }
        } else if (resultModifier != null && !resultModifier.equals("")) {
            sb.append(" @modifier ");
            sb.append("r=" + this.encode(resultModifier));
        }
        sb.append(" @loggable ");
        sb.append(query.isLoggable());
        char[] recommend = query.getRecommend();
        if (recommend != null) {
            sb.append(" @recommend ");
            sb.append("'" + this.encode(new String(recommend)) + "'");
        }
        if ((redirect = query.getRedirect()) != null) {
            sb.append(" @redirect ");
            sb.append("'" + this.encode(new String(redirect)) + "'");
        }
        sb.append(" @debug ");
        sb.append(query.isDebug());
        sb.append(" @faultless ");
        sb.append(query.isFaultless());
        sb.append(" @printquery ");
        sb.append(query.isPrintQuery());
        String[] keys = query.getKeys();
        int i6 = 0;
        while (i6 < keys.length) {
            if (i6 == 0) {
                sb.append(" @data ");
            }
            sb.append("'" + this.encode(keys[i6]) + "'=");
            sb.append("'" + this.encode(query.getValue(keys[i6])) + "'");
            if (i6 != keys.length - 1) {
                sb.append(", ");
            }
            ++i6;
        }
        return sb.toString().trim();
    }

    public String whereSetToString(WhereSet[] whereSets) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < whereSets.length) {
            if (i == 0) {
                sb.append(" @where ");
            }
            if (whereSets[i].isOperation()) {
                switch (whereSets[i].getOperation()) {
                    case 9: {
                        sb.append("{");
                        break;
                    }
                    case 10: {
                        sb.append("}");
                        break;
                    }
                    case 5: {
                        sb.append("and");
                        break;
                    }
                    case 6: {
                        sb.append("or");
                        break;
                    }
                    case 7: {
                        sb.append("not");
                        break;
                    }
                    case 8: {
                        sb.append("weightand");
                    }
                }
            } else {
                sb.append(this.encode(String.valueOf(whereSets[i].getField())));
                sb.append('(');
                if (WhereSet.isHasAll(whereSets[i].getOperation())) {
                    sb.append("HASALL;");
                } else if (WhereSet.isHasAny(whereSets[i].getOperation())) {
                    sb.append("HASANY;");
                } else if (WhereSet.isSemiHasAny(whereSets[i].getOperation())) {
                    sb.append("SEMIHASANY;");
                } else if (WhereSet.isHasAnyOne(whereSets[i].getOperation())) {
                    sb.append("HASANYONE;");
                } else if (WhereSet.isHasAllOne(whereSets[i].getOperation())) {
                    sb.append("HASALLONE;");
                }
                if (WhereSet.isThesaurusExtend((byte)1, whereSets[i].getOperation())) {
                    sb.append("EQUIV_SYNONYM;");
                }
                if (WhereSet.isThesaurusExtend((byte)4, whereSets[i].getOperation())) {
                    sb.append("QUASI_SYNONYM;");
                }
                if (sb.charAt(sb.length() - 1) == ';') {
                    sb.setLength(sb.length() - 1);
                }
                sb.append('|');
                char[][] keywords = whereSets[i].getKeywords();
                int j = 0;
                while (j < keywords.length) {
                    sb.append("'" + this.encode(String.valueOf(keywords[j])) + "'");
                    if (j != keywords.length - 1) {
                        sb.append(";");
                    } else {
                        sb.append("|");
                    }
                    ++j;
                }
                int[] weights = whereSets[i].getWeight();
                int j2 = 0;
                while (j2 < weights.length) {
                    sb.append(weights[j2]);
                    if (j2 != weights.length - 1) {
                        sb.append(";");
                    } else {
                        sb.append(")");
                    }
                    ++j2;
                }
            }
            if (i != whereSets.length - 1) {
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString().trim();
    }

    public String filterSetToString(FilterSet[] filterSets) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < filterSets.length) {
            if (i == 0) {
                sb.append(" @filterby ");
            }
            sb.append(this.encode(String.valueOf(filterSets[i].getField())));
            String operStr = "";
            byte operation = filterSets[i].getOperation();
            if ((operation & 0x20) == 32) {
                operStr = String.valueOf(operStr) + "CONDITION_ALL;";
                operation = (byte)(operation - 32);
            }
            if ((operation & 0x10) != 0) {
                operStr = String.valueOf(operStr) + "WEIGHT_ADJUST;";
                operation = (byte)(operation - 16);
            }
            switch (operation) {
                case 1: {
                    operStr = String.valueOf(operStr) + "MATCH;";
                    break;
                }
                case 2: {
                    operStr = String.valueOf(operStr) + "NOT;";
                    break;
                }
                case 3: {
                    operStr = String.valueOf(operStr) + "RANGE;";
                    break;
                }
                case 4: {
                    operStr = String.valueOf(operStr) + "PARTIAL;";
                    break;
                }
                case 5: {
                    operStr = String.valueOf(operStr) + "PREFIX_MATCH;";
                    break;
                }
                case 6: {
                    operStr = String.valueOf(operStr) + "SUFFIX_MATCH;";
                    break;
                }
                case 7: {
                    operStr = String.valueOf(operStr) + "PARTIAL_NOT;";
                    break;
                }
                case 8: {
                    operStr = String.valueOf(operStr) + "PREFIX_NOT;";
                    break;
                }
                case 9: {
                    operStr = String.valueOf(operStr) + "SUFFIX_NOT;";
                    break;
                }
                case 10: {
                    operStr = String.valueOf(operStr) + "SECURE;";
                    break;
                }
                case 14: {
                    operStr = String.valueOf(operStr) + "SECURE_ECM;";
                    break;
                }
                case 11: {
                    operStr = String.valueOf(operStr) + "DISTANCE_NEAR;";
                    break;
                }
                case 12: {
                    operStr = String.valueOf(operStr) + "DISTANCE_FAR;";
                    break;
                }
                case 13: {
                    operStr = String.valueOf(operStr) + "DISTANCE_RANGE;";
                    break;
                }
                case 65: {
                    operStr = String.valueOf(operStr) + "ADDWEIGHT;";
                    break;
                }
                case 66: {
                    operStr = String.valueOf(operStr) + "MERGEWEIGHT;";
                }
            }
            if (operStr.equals("")) {
                sb.append("(|");
            } else {
                sb.append("(" + operStr.substring(0, operStr.length() - 1) + "|");
            }
            char[][] keywords = filterSets[i].getKeyword();
            int j = 0;
            while (j < keywords.length) {
                sb.append("'" + this.encode(String.valueOf(keywords[j])) + "'");
                if (j != keywords.length - 1) {
                    sb.append(";");
                } else {
                    sb.append("|");
                }
                ++j;
            }
            sb.append(filterSets[i].getWeight());
            if (i == filterSets.length - 1) {
                sb.append(")");
            } else {
                sb.append("), ");
            }
            ++i;
        }
        return sb.toString().trim();
    }

    private String encode(String str) {
        char[] strs = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            switch (strs[i]) {
                case '\\': {
                    sb.append(DQ_BACK_SLASH);
                    break;
                }
                case '\'': {
                    sb.append(DQ_SINGLE_QUOTATION);
                    break;
                }
                case '\"': {
                    sb.append(DQ_QUOTATION);
                    break;
                }
                case '%': {
                    sb.append(DQ_PERCENT);
                    break;
                }
                default: {
                    sb.append(strs[i]);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String decode(String str) {
        char[] strs = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            if (strs[i] == '\\' && i < strs.length - 1) {
                if (strs[++i] == '\\') {
                    sb.append('\\');
                } else if (strs[i] == 'S') {
                    sb.append('\'');
                } else if (strs[i] == 'Q') {
                    sb.append('\"');
                } else if (strs[i] == 'P') {
                    sb.append('%');
                }
            } else {
                sb.append(strs[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    private void parseDistance() throws IRException {
        int index = this.getReservedWordIndex(DISTANCE);
        if (!this.isExistValue(index)) {
            return;
        }
        String field = "";
        int argumentCount = this.parseCommaToBracket(this.startIndex[index], this.endIndex[index]);
        if (argumentCount != 2) {
            throw new IRException(2, "Protocol Error : Incorrect format in @distance. regular format is \"field('coordinates')\"");
        }
        int j = this.sPartIndex[0];
        while (j <= this.ePartIndex[0]) {
            field = String.valueOf(field) + this.str[j];
            ++j;
        }
        if ((field = this.decode(field)).equals("")) {
            throw new IRException(2, "Protocol Error: Distance ID is not defined in @distance.");
        }
        if (field.indexOf(32) != -1) {
            throw new IRException(2, "Protocol Error: Distance ID cannot contains empty chractor(space) in @distance.");
        }
        int[] arguments = this.parseRoundBracketWithSemicolon(this.sPartIndex[1], this.ePartIndex[1]);
        if (arguments.length < 1) {
            throw new IRException(2, "Protocol Error: Distance ID is not defined in @distance.");
        }
        int pos = 0;
        int count = 0;
        String[] coodinates = new String[arguments.length];
        int j2 = 0;
        while (j2 < arguments.length) {
            String coodinate = "";
            int k = this.sPartIndex[pos + j2];
            while (k <= this.ePartIndex[pos + j2]) {
                coodinate = String.valueOf(coodinate) + this.str[k];
                ++k;
            }
            if (coodinate != "") {
                coodinates[count++] = coodinate.trim();
            }
            ++j2;
        }
        if (coodinates == null || coodinates.toString() == "") {
            throw new IRException(2, "Protocol Error: Coodinates is not defined in @distance.");
        }
        DistanceSet distanceSet = new DistanceSet(field, coodinates);
        this.query.setDistance(distanceSet);
    }

    private int[] parseRoundBracketWithSemicolon(int startPos, int endPos) {
        int max = 1;
        int i = startPos;
        while (i <= endPos) {
            if (this.str[i] == ';') {
                ++max;
            }
            ++i;
        }
        int[] result = new int[max];
        int start = startPos;
        boolean quotUse = false;
        int aPos = 0;
        int vPos = 0;
        int sCount = 1;
        int i2 = startPos;
        while (i2 <= endPos) {
            switch (this.str[i2]) {
                case ';': {
                    if (quotUse) break;
                    if (aPos > this.sPartIndex.length) {
                        this.ensureCapacity();
                    }
                    this.sPartIndex[aPos] = start + 1;
                    this.ePartIndex[aPos] = i2 - 2;
                    result[vPos] = sCount;
                    ++aPos;
                    ++vPos;
                    sCount = 1;
                    start = i2 + 1;
                    break;
                }
                case '\'': {
                    boolean bl = quotUse = !quotUse;
                }
            }
            if (i2 == endPos) {
                if (aPos > this.sPartIndex.length) {
                    this.ensureCapacity();
                }
                this.sPartIndex[aPos] = start + 1;
                this.ePartIndex[aPos] = i2 - 1;
                result[vPos] = sCount;
            }
            ++i2;
        }
        if (result.length == vPos + 1) {
            return result;
        }
        int[] new_result = new int[vPos + 1];
        System.arraycopy(result, 0, new_result, 0, new_result.length);
        return new_result;
    }

    public String parseQuery2Html(Query query) {
        int resultCutOffSize;
        GroupBySet[] groupBySet;
        OrderBySet[] orderBySet;
        FilterSet[] filterSet;
        WhereSet[] whereSet;
        SelectSet[] selectSet;
        StringBuffer buffer = new StringBuffer();
        char[] from = query.getFromField();
        int searchOption = query.getSearchOption();
        int thesaurusOption = query.getThesaurusOption();
        int rankingOption = query.getRankingOption();
        int categoryRankingOption = query.getCategoryRankingOption();
        char[] redirect = query.getRedirect();
        char[] recommend = query.getRecommend();
        String queryModifier = query.getQueryModifier();
        String resultModifier = query.getResultModifier();
        char[] stag = query.getHighLightStartTag();
        char[] etag = query.getHighLightEndTag();
        if (stag != null && stag.length != 0) {
            buffer.append("char[] startTag = \"").append(stag).append("\".toCharArray();").append(NEW_LINE);
        }
        if (etag != null && etag.length != 0) {
            buffer.append("char[] endTag = \"").append(etag).append("\".toCharArray();").append(NEW_LINE);
        }
        if (from != null && from.length != 0) {
            buffer.append("QuerySet querySet = new QuerySet(1);").append(NEW_LINE);
            buffer.append("Query query = new Query(startTag, endTag);").append(NEW_LINE);
        }
        buffer.append(this.searchOptionString(searchOption));
        buffer.append(this.thesaurusOptionString(thesaurusOption));
        buffer.append(this.rankingOptionString(rankingOption));
        buffer.append(this.categoryRankingString(categoryRankingOption));
        if (from != null && from.length != 0) {
            buffer.append("query.setFrom(\"").append(from).append("\");").append(NEW_LINE);
        }
        if (redirect != null && redirect.length != 0) {
            buffer.append("query.setRedirect(searchTerm);").append(NEW_LINE);
        }
        if (recommend != null && recommend.length != 0) {
            buffer.append("query.setRecommend(searchTerm);").append(NEW_LINE);
        }
        if ((selectSet = query.getSelectFields()) != null && selectSet.length > 0) {
            buffer.append("SelectSet[] selectSet = new SelectSet[] {").append(NEW_LINE);
            int i = 0;
            while (i < selectSet.length) {
                SelectSet s = selectSet[i];
                buffer.append(this.getSelectStr(s.getField(), s.getOption(), s.getSummarySize()));
                ++i;
            }
            buffer.append("};").append(NEW_LINE);
        }
        if ((whereSet = query.getWhereFields()) != null && whereSet.length > 0) {
            buffer.append("WhereSet[] whereSet = new WhereSet[] {").append(NEW_LINE);
            int i = 0;
            while (i < whereSet.length) {
                WhereSet w = whereSet[i];
                buffer.append(this.getWhereStr(w.getField(), w.getOperation(), w.getKeywords(), w.getWeight()));
                ++i;
            }
            buffer.append("};").append(NEW_LINE);
        }
        if ((filterSet = query.getFilterFields()) != null && filterSet.length > 0) {
            buffer.append("FilterSet[] filterSet = new FilterSet[] {").append(NEW_LINE);
            int i = 0;
            while (i < filterSet.length) {
                FilterSet f = filterSet[i];
                buffer.append(this.getFilterStr(f.getOperation(), f.getField(), f.getKeyword(), f.getWeight()));
                ++i;
            }
            buffer.append("};").append(NEW_LINE);
        }
        if ((orderBySet = query.getOrderbyFields()) != null && orderBySet.length > 0) {
            buffer.append("OrderBySet[] orderBySet = new OrderBySet[] {").append(NEW_LINE);
            int i = 0;
            while (i < orderBySet.length) {
                OrderBySet o = orderBySet[i];
                buffer.append(this.getOrderByStr(o.getOrder(), o.getField(), o.getOperation()));
                ++i;
            }
            buffer.append("};").append(NEW_LINE);
        }
        if ((groupBySet = query.getGroupSelectFields()) != null && groupBySet.length > 0) {
            buffer.append("GroupBySet[] groupBySet = new GroupBySet[] {").append(NEW_LINE);
            int i = 0;
            while (i < groupBySet.length) {
                GroupBySet g = groupBySet[i];
                buffer.append(this.getGroupByStr(g.getField(), g.getOperation(), g.getArgument(), g.getGroupFilter()));
                ++i;
            }
            buffer.append("};").append(NEW_LINE);
        }
        int resultStart = query.getResultStart();
        int resultEnd = query.getResultEnd();
        if (Integer.MAX_VALUE > resultStart && Integer.MIN_VALUE < resultStart && Integer.MAX_VALUE > resultEnd && Integer.MIN_VALUE < resultEnd) {
            buffer.append("query.setResult(").append(resultStart).append(", ").append(resultEnd).append(");").append(NEW_LINE);
        }
        if (Integer.MAX_VALUE > (resultCutOffSize = query.getResultCutOffSize()) && Integer.MIN_VALUE < resultCutOffSize) {
            buffer.append("query.setResultCutOffSize(").append(resultStart).append(");").append(NEW_LINE);
        }
        if (queryModifier != null && !queryModifier.equals("")) {
            buffer.append("query.setQueryModifier(\"").append(queryModifier).append("\");").append(NEW_LINE);
        }
        if (resultModifier != null && !resultModifier.equals("")) {
            buffer.append("query.setResultModifier(\"").append(resultModifier).append("\");").append(NEW_LINE);
        }
        if (from != null && from.length != 0) {
            buffer.append("querySet.addQuery(query);").append(NEW_LINE);
        }
        return buffer.toString();
    }

    private String categoryRankingString(int categoryRankingOption) {
        StringBuffer buffer = new StringBuffer();
        if (categoryRankingOption > 0) {
            buffer.append("query.setCategoryRankingOption((byte)(");
            boolean founded = false;
            if ((categoryRankingOption & 1) > 0) {
                buffer.append("Protocol.CategoryRankingOption.MULTI_TERM_WHITESPACE");
                founded = true;
            }
            if ((categoryRankingOption & 2) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.CategoryRankingOption.MULTI_TERM_KOREAN");
                founded = true;
            }
            if ((categoryRankingOption & 4) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.CategoryRankingOption.EQUIV_SYNONYM");
                founded = true;
            }
            buffer.append("));").append(NEW_LINE);
        }
        return buffer.toString();
    }

    private String rankingOptionString(int rankingOption) {
        StringBuffer buffer = new StringBuffer();
        if (rankingOption > 0) {
            buffer.append("query.setRankingOption((byte)(");
            boolean founded = false;
            if ((rankingOption & 1) > 0) {
                buffer.append("Protocol.RankingOption.CATEGORY_RANKING");
                founded = true;
            }
            if ((rankingOption & 2) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.RankingOption.DOCUMENT_RANKING");
                founded = true;
            }
            if ((rankingOption & 4) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.RankingOption.RANKING_MODEL");
                founded = true;
            }
            buffer.append("));").append(NEW_LINE);
        }
        return buffer.toString();
    }

    private String searchOptionString(int searchOption) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("query.setSearchOption((byte)(");
        if (searchOption > 0) {
            boolean founded = false;
            if ((searchOption & 1) > 0) {
                buffer.append("Protocol.SearchOption.CACHE");
                founded = true;
            }
            if ((searchOption & 2) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.SearchOption.STOPWORD");
                founded = true;
            }
            if ((searchOption & 4) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.SearchOption.PERCENT");
                founded = true;
            }
            if ((searchOption & 8) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.SearchOption.BANNED");
                founded = true;
            }
            if ((searchOption & 0x10) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.SearchOption.PHRASEEXACT");
                boolean bl = true;
            }
        } else {
            buffer.append("0");
        }
        buffer.append("));").append(NEW_LINE);
        return buffer.toString();
    }

    private String thesaurusOptionString(int searchOption) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("query.setThesaurusOption((byte)(");
        if (searchOption > 0) {
            boolean founded = false;
            if ((searchOption & 1) > 0) {
                buffer.append("Protocol.ThesaurusOption.EQUIV_SYNONYM");
                founded = true;
            }
            if ((searchOption & 2) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.ThesaurusOption.QUASI_SYNONYM");
                founded = true;
            }
            if ((searchOption & 4) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.ThesaurusOption.SUPERORDINATE");
                founded = true;
            }
            if ((searchOption & 8) > 0) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.ThesaurusOption.HYPONYM");
                boolean bl = true;
            }
        } else {
            buffer.append("0");
        }
        buffer.append("));").append(NEW_LINE);
        return buffer.toString();
    }

    private String getGroupByStr(char[] field, byte operation, char[] argument, char[][] groupFilter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WHITESPACE_HTML).append(WHITESPACE_HTML).append(WHITESPACE_HTML);
        buffer.append("new GroupBySet(");
        if (field != null) {
            buffer.append("\"").append(field);
            buffer.append("\", ");
        }
        if ((operation & 0x21) == 33) {
            buffer.append("Protocol.GroupBySet.OP_COUNT");
        } else if ((operation & 0x22) == 34) {
            buffer.append("Protocol.GroupBySet.OP_RANGE_COUNT");
        } else if ((operation & 0x24) == 36) {
            buffer.append("Protocol.GroupBySet.ORDER_NAME");
        } else if ((operation & 0x28) == 40) {
            buffer.append("Protocol.GroupBySet.ORDER_COUNT");
        } else if ((operation & 0x20) == 32) {
            buffer.append("Protocol.GroupBySet.ORDER_NONE");
        }
        buffer.append("\", ");
        if (argument != null) {
            buffer.append("\"").append(argument);
            buffer.append("\", ");
        }
        if (groupFilter != null) {
            buffer.append("new String[]{");
            int i = 0;
            while (i < groupFilter.length) {
                buffer.append("\"").append(groupFilter[i]).append("\"");
                if (i != groupFilter.length - 1) {
                    buffer.append(",");
                }
                ++i;
            }
            buffer.append("}");
        }
        buffer.append("),").append(NEW_LINE);
        return buffer.toString();
    }

    private String getOrderByStr(boolean order, char[] field, byte operation) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WHITESPACE_HTML).append(WHITESPACE_HTML).append(WHITESPACE_HTML);
        buffer.append("new OrderBySet(");
        buffer.append(order ? "true" : "false");
        buffer.append(", ");
        if (field != null) {
            buffer.append("\"").append(field);
            buffer.append("\", ");
        }
        if ((operation & 0x61) == 97) {
            buffer.append("Protocol.OrderBySet.OP_PREWEIGHT");
        } else if ((operation & 0x62) == 98) {
            buffer.append("Protocol.OrderBySet.OP_POSTWEIGHT");
        } else if ((operation & 0x63) == 99) {
            buffer.append("Protocol.OrderBySet.OP_NONE");
        } else if ((operation & 0x64) == 100) {
            buffer.append("Protocol.OrderBySet.OP_MERGEWEIGHT");
        } else if ((operation & 0x65) == 101) {
            buffer.append("Protocol.OrderBySet.OP_ADDWEIGHT");
        } else if ((operation & 0x66) == 102) {
            buffer.append("Protocol.OrderBySet.OP_DISTANCE");
        } else if ((operation & 0x67) == 103) {
            buffer.append("Protocol.OrderBySet.OP_DISTANCE_PREWEIGHT");
        } else if ((operation & 0x68) == 104) {
            buffer.append("Protocol.OrderBySet.OP_DISTANCE_POSTWEIGHT");
        }
        buffer.append("),").append(NEW_LINE);
        return buffer.toString();
    }

    private String getFilterStr(byte operation, char[] field, char[][] keyword, int weight) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WHITESPACE_HTML).append(WHITESPACE_HTML).append(WHITESPACE_HTML);
        buffer.append("new FilterSet(");
        buffer.append("(byte)(");
        boolean founded = false;
        if ((operation & 0xFF) == 1) {
            buffer.append("Protocol.FilterSet.OP_MATCH");
            founded = true;
        } else if ((operation & 0xFF) == 2) {
            buffer.append("Protocol.FilterSet.OP_NOT");
            founded = true;
        } else if ((operation & 0xFF) == 3) {
            buffer.append("Protocol.FilterSet.OP_RANGE");
            founded = true;
        } else if ((operation & 0xFF) == 4) {
            buffer.append("Protocol.FilterSet.OP_PARTIAL");
            founded = true;
        } else if ((operation & 0xFF) == 5) {
            buffer.append("Protocol.FilterSet.OP_PREFIX_MATCH");
            founded = true;
        } else if ((operation & 0xFF) == 6) {
            buffer.append("Protocol.FilterSet.OP_SUFFIX_MATCH");
            founded = true;
        } else if ((operation & 0xFF) == 7) {
            buffer.append("Protocol.FilterSet.OP_PARTIAL_NOT");
            founded = true;
        } else if ((operation & 0xFF) == 8) {
            buffer.append("Protocol.FilterSet.OP_PREFIX_NOT");
            founded = true;
        } else if ((operation & 0xFF) == 9) {
            buffer.append("Protocol.FilterSet.OP_SUFFIX_NOT");
            founded = true;
        } else if ((operation & 0xFF) == 10) {
            buffer.append("Protocol.FilterSet.OP_SECURE");
            founded = true;
        } else if ((operation & 0xFF) == 14) {
            buffer.append("Protocol.FilterSet.OP_SECURE_ECM");
            founded = true;
        } else if ((operation & 0xFF) == 11) {
            buffer.append("Protocol.FilterSet.OP_DISTANCE_NEAR");
            founded = true;
        } else if ((operation & 0xFF) == 12) {
            buffer.append("Protocol.FilterSet.OP_DISTANCE_FAR");
            founded = true;
        } else if ((operation & 0xFF) == 13) {
            buffer.append("Protocol.FilterSet.OP_DISTANCE_RANGE");
            founded = true;
        } else if ((operation & 0xFF) == 65) {
            buffer.append("Protocol.FilterSet.OP_ADDWEIGHT");
            founded = true;
        } else if ((operation & 0xFF) == 66) {
            buffer.append("Protocol.FilterSet.OP_MERGEWEIGHT");
            founded = true;
        }
        if ((operation & 0xFF) == 16) {
            if (founded) {
                buffer.append(" | ");
            }
            buffer.append("Protocol.FilterSet.OP_WEIGHT_ADJUST");
            founded = true;
        }
        if ((operation & 0xFF) == 32) {
            if (founded) {
                buffer.append(" | ");
            }
            buffer.append("Protocol.FilterSet.OP_CONDITION_ALL");
        }
        buffer.append("), \"");
        int i = 0;
        while (i < keyword.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(keyword[i]);
            ++i;
        }
        buffer.append("\", ");
        buffer.append(", ").append(weight);
        buffer.append(")").append(NEW_LINE);
        return buffer.toString();
    }

    private String getWhereStr(char[] field, byte option, char[][] keywords, int[] weight) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WHITESPACE_HTML).append(WHITESPACE_HTML).append(WHITESPACE_HTML);
        buffer.append("new WhereSet(");
        if (field != null) {
            buffer.append("\"").append(field);
            buffer.append("\", ");
        }
        if ((option & 0xFF) == 1) {
            buffer.append("Protocol.WhereSet.OP_HASALL");
        } else if ((option & 0xFF) == 2) {
            buffer.append("Protocol.WhereSet.OP_HASANY");
        } else if ((option & 0xFF) == 5) {
            buffer.append("Protocol.WhereSet.OP_AND");
        } else if ((option & 0xFF) == 6) {
            buffer.append("Protocol.WhereSet.OP_OR");
        } else if ((option & 0xFF) == 7) {
            buffer.append("Protocol.WhereSet.OP_NOT");
        } else if ((option & 0xFF) == 9) {
            buffer.append("Protocol.WhereSet.OP_BRACE_OPEN");
        } else if ((option & 0xFF) == 10) {
            buffer.append("Protocol.WhereSet.OP_BRACE_CLOSE");
        } else if ((option & 0xFF) == 4) {
            buffer.append("Protocol.WhereSet.OP_SEMIHASANY");
        } else if ((option & 0xFF) == 16) {
            buffer.append("Protocol.WhereSet.EQUIV_SYNONYM");
        } else if ((option & 0xFF) == 32) {
            buffer.append("Protocol.WhereSet.QUASI_SYNONYM");
        } else if ((option & 0xFF) == 8) {
            buffer.append("Protocol.WhereSet.OP_WEIGHTAND");
        } else if ((option & 0xFF) == 3) {
            buffer.append("Protocol.WhereSet.OP_HASANYONE");
        }
        if (keywords != null && weight != null) {
            buffer.append(", ").append("searchTerm").append(", ");
            buffer.append(weight[0]);
        }
        buffer.append("),").append(NEW_LINE);
        return buffer.toString();
    }

    private String getSelectStr(char[] field, byte option, int summarySize) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WHITESPACE_HTML).append(WHITESPACE_HTML).append(WHITESPACE_HTML);
        buffer.append("new SelectSet(\"");
        buffer.append(field);
        buffer.append("\", ");
        buffer.append("(byte)(");
        boolean founded = false;
        if ((option & 0xFFFFFFEF) == 0) {
            buffer.append("Protocol.SelectSet.NONE");
        } else {
            if ((option & 0x11) == 17) {
                buffer.append("Protocol.SelectSet.SUMMARIZE");
                founded = true;
            }
            if ((option & 0x12) == 18) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.SelectSet.HIGHLIGHT");
                founded = true;
            }
            if ((option & 0x14) == 20) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.SelectSet.SYNONYM_HIGHLIGHT");
                founded = true;
            }
            if ((option & 0x18) == 24) {
                if (founded) {
                    buffer.append(" | ");
                }
                buffer.append("Protocol.SelectSet.DISTANCE");
                founded = true;
            }
        }
        buffer.append(")");
        if (summarySize >= 0) {
            buffer.append(", ").append(summarySize).append("),");
        } else {
            buffer.append("),");
        }
        buffer.append(NEW_LINE);
        return buffer.toString();
    }

    public static void main(String[] args) throws IRException {
        Query query = null;
        SelectSet[] selectSet = null;
        String collectionName = "GSSHOP";
        String profile = "profile1";
        String[] sNames = new String[]{"ID", "NAME", "PRICE", "CATID", "NEWCATID", "WEIGHT"};
        selectSet = new SelectSet[]{new SelectSet(sNames[0], 16), new SelectSet(sNames[1], 22), new SelectSet(sNames[2], 16), new SelectSet(sNames[3], 16), new SelectSet(sNames[4], 16), new SelectSet(sNames[5], 16)};
        String[] wNames = new String[]{"NAME"};
        WhereSet[] whereSet = new WhereSet[]{new WhereSet(wNames[0], 1, "\uce68\uad6c", 100)};
        OrderBySet[] order = new OrderBySet[]{new OrderBySet(false, "WEIGHT", 99)};
        GroupBySet[] groupBys = new GroupBySet[]{new GroupBySet("BRAND", 41, "ASC", "")};
        FilterSet[] filters = new FilterSet[]{new FilterSet(65, "FLT_INT", ""), new FilterSet(66, "FLT_INT2", ""), new FilterSet(17, "FLT_INT", "11", 1000)};
        char[] startTag = "<b>".toCharArray();
        char[] endTag = "</b>".toCharArray();
        query = new Query(startTag, endTag);
        query.setSearchOption(0);
        query.setSelect(selectSet);
        query.setWhere(whereSet);
        query.setOrderby(order);
        query.setFilter(filters);
        query.setGroupBy(groupBys);
        query.setFrom(collectionName);
        query.setProfile(profile);
        query.setThesaurusOption(3);
        query.setValue("synonymWeight", "0.1");
        query.setValue("quasiSynonymWeight", "0.1");
        query.setRankingOption(1);
        query.setCategoryRankingOption(2);
        query.setKeywordProfile(true);
        query.setResult(0, 20);
        query.setDebug(true);
        query.setLoggable(true);
        query.setPrintQuery(true);
        query.setRecommend("\ucd94\ucc9c\uc5b4");
        query.setRedirect("\ubc14\ub85c\uac00\uae30");
        QueryParser parser = new QueryParser();
        String parsed = parser.queryToString(query);
        System.out.println(parsed);
        Query parsedQuery = parser.parseQuery(parsed);
        System.out.println(parsedQuery);
    }
}

