/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.protocol.query.WhereSet;

public class QuerySetVerifier {
    static final int START = 0;
    static final int BRACE_OPEN = 1;
    static final int BRACE_CLOSE = 2;
    static final int OPERATOR = 3;
    static final int OPERAND = 4;
    static final int END = 5;
    static final boolean[][] AUTOMATA = new boolean[5][6];

    static {
        QuerySetVerifier.AUTOMATA[0][1] = true;
        QuerySetVerifier.AUTOMATA[0][4] = true;
        QuerySetVerifier.AUTOMATA[1][1] = true;
        QuerySetVerifier.AUTOMATA[1][4] = true;
        QuerySetVerifier.AUTOMATA[2][3] = true;
        QuerySetVerifier.AUTOMATA[2][2] = true;
        QuerySetVerifier.AUTOMATA[2][5] = true;
        QuerySetVerifier.AUTOMATA[3][1] = true;
        QuerySetVerifier.AUTOMATA[3][4] = true;
        QuerySetVerifier.AUTOMATA[4][3] = true;
        QuerySetVerifier.AUTOMATA[4][2] = true;
        QuerySetVerifier.AUTOMATA[4][5] = true;
    }

    public static final boolean verifyWhereSet(WhereSet[] wheres) throws IRException {
        if (wheres == null || wheres.length == 0) {
            throw new IRException(1, "WhereSet is NULL.");
        }
        int w = 0;
        while (w < wheres.length) {
            if (wheres[w] == null) {
                throw new IRException(1, String.valueOf(w) + "th WhereSet is NULL.");
            }
            if (!wheres[w].isOperation()) {
                char[] whereField = wheres[w].getField();
                if (whereField == null || whereField.length == 0) {
                    throw new IRException(1, "Field name of " + w + "th WhereSet is NULL.");
                }
                char[][] keywords = wheres[w].getKeywords();
                if (keywords == null) {
                    throw new IRException(1, "Keyword of " + w + "th WhereSet is NULL.");
                }
                int k = 0;
                while (k < keywords.length) {
                    if (keywords[k] == null) {
                        throw new IRException(1, String.valueOf(k) + "th keyword of " + w + "th WhereSet is NULL.");
                    }
                    ++k;
                }
            }
            ++w;
        }
        int braceLevel = 0;
        int status = 0;
        int nextStatus = -1;
        int w2 = 0;
        while (w2 < wheres.length) {
            if (wheres[w2].isOperation()) {
                switch (wheres[w2].getOperation()) {
                    case 9: {
                        nextStatus = 1;
                        ++braceLevel;
                        break;
                    }
                    case 10: {
                        nextStatus = 2;
                        --braceLevel;
                        break;
                    }
                    default: {
                        nextStatus = 3;
                        break;
                    }
                }
            } else {
                nextStatus = 4;
            }
            if (braceLevel < 0) {
                throw new IRException(1, "Illegal braces.");
            }
            if (!AUTOMATA[status][nextStatus]) {
                throw new IRException(1, String.valueOf(w2) + "th WhereSet contains ERROR.");
            }
            status = nextStatus;
            ++w2;
        }
        if (braceLevel > 0) {
            throw new IRException(1, "Unclosed brace exists.");
        }
        if (!AUTOMATA[status][5]) {
            throw new IRException(1, "5th WhereSet contains ERROR.");
        }
        return true;
    }
}

