/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class SelectSet
implements Measurable,
Serializable {
    private static final long serialVersionUID = -2897455023123289567L;
    public static final int DEFAULT_SUMMARY_SIZE = 220;
    private char[] field;
    private byte option;
    private int summarySize;

    public SelectSet(char[] field, byte option, int summarySize) {
        this.field = field;
        this.option = option;
        this.summarySize = summarySize;
    }

    public SelectSet(char[] field, byte option) {
        this(field, option, 220);
    }

    public SelectSet(char[] field) {
        this(field, 16, 220);
    }

    public SelectSet(String field, byte option) {
        this(field.toCharArray(), option, 220);
    }

    public SelectSet(String field, byte option, int summarySize) {
        this(field.toCharArray(), option, summarySize);
    }

    public SelectSet(String field) {
        this(field.toCharArray(), 16, 220);
    }

    public char[] getField() {
        return this.field;
    }

    public byte getOption() {
        return this.option;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SelectSet castedObj = (SelectSet)o;
        return this.option == castedObj.option && Arrays.equals(this.field, castedObj.field) && this.summarySize == castedObj.summarySize;
    }

    public String toString() {
        return "[SelectSet [field = " + new String(this.field) + "][option = " + this.option + "]";
    }

    public int size() {
        return SizeUtil.sizeOf((char[])this.field) + 7 + SizeUtil.OBJECT_OVERHEAD;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeChars((OutputStream)out, (char[])this.field);
        ByteUtil.writeByte((OutputStream)out, (byte)this.option);
        ByteUtil.writeInt((OutputStream)out, (int)this.summarySize);
    }

    public static SelectSet deserialize(InputStream in) throws IOException {
        char[] field = ByteUtil.readChars((InputStream)in);
        byte operation = ByteUtil.readByte((InputStream)in);
        int summarySize = ByteUtil.readInt((InputStream)in);
        return new SelectSet(field, operation, summarySize);
    }

    public int getSummarySize() {
        return this.summarySize;
    }
}

