/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.query;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class WhereSet
implements Measurable,
Serializable {
    private static final long serialVersionUID = 5747525158579457916L;
    private boolean isOperation;
    private char[] field;
    private byte operation;
    private char[][] keywords;
    private int[] weight;

    public WhereSet(char[] field, byte operation, char[][] keywords, int[] weight) {
        this.field = field;
        this.operation = operation;
        this.keywords = keywords;
        this.weight = weight;
        this.isOperation = false;
    }

    public WhereSet(char[] field, byte operation, char[][] keywords) {
        this(field, operation, keywords, new int[keywords.length]);
        Arrays.fill(this.weight, -1);
    }

    public WhereSet(String field, byte operation, String[] keywords, int[] weight) {
        this(field.toCharArray(), operation, new char[keywords.length][], weight);
        int i = 0;
        while (i < keywords.length) {
            this.keywords[i] = keywords[i].toCharArray();
            ++i;
        }
    }

    public WhereSet(String field, byte operation, String[] keywords) {
        this(field, operation, keywords, new int[keywords.length]);
        Arrays.fill(this.weight, -1);
    }

    public WhereSet(String field, byte operation, String keyword, int weight) {
        this(field.toCharArray(), operation, new char[1][], new int[1]);
        this.keywords[0] = keyword.toCharArray();
        this.weight[0] = weight;
    }

    public WhereSet(String field, byte operation, String keyword) {
        this(field.toCharArray(), operation, new char[1][], new int[1]);
        this.keywords[0] = keyword.toCharArray();
        this.weight[0] = -1;
    }

    public WhereSet(byte operation) {
        this.operation = operation;
        this.isOperation = true;
    }

    public void setKeyword(String[] keywords) {
        this.keywords = new char[keywords.length][];
        int i = 0;
        while (i < keywords.length) {
            this.keywords[i] = keywords[i].toCharArray();
            ++i;
        }
        if (this.weight.length < keywords.length) {
            int[] newWeights = new int[keywords.length];
            Arrays.fill(newWeights, -1);
            System.arraycopy(this.weight, 0, newWeights, 0, this.weight.length);
            this.weight = newWeights;
        } else if (this.weight.length > keywords.length) {
            int[] newWeights = new int[keywords.length];
            System.arraycopy(this.weight, 0, newWeights, 0, keywords.length);
            this.weight = newWeights;
        }
    }

    public void setKeyword(String[] keywords, int[] weights) {
        this.keywords = new char[keywords.length][];
        int i = 0;
        while (i < keywords.length) {
            this.keywords[i] = keywords[i].toCharArray();
            ++i;
        }
        this.weight = weights;
    }

    public void setKeyword(char[][] keywords) {
        this.keywords = keywords;
        if (this.weight.length < keywords.length) {
            int[] newWeights = new int[keywords.length];
            Arrays.fill(newWeights, -1);
            System.arraycopy(this.weight, 0, newWeights, 0, this.weight.length);
            this.weight = newWeights;
        } else if (this.weight.length > keywords.length) {
            int[] newWeights = new int[keywords.length];
            System.arraycopy(this.weight, 0, newWeights, 0, keywords.length);
            this.weight = newWeights;
        }
    }

    public void setKeyword(char[][] keywords, int[] weights) {
        this.keywords = keywords;
        this.weight = weights;
    }

    public void setKeyword(String keyword) {
        this.keywords = new char[][]{keyword.toCharArray()};
        int[] newWeights = new int[]{this.weight.length > 0 ? this.weight[0] : -1};
        this.weight = newWeights;
    }

    public void setKeyword(String keyword, int weight) {
        this.keywords = new char[][]{keyword.toCharArray()};
        this.weight = new int[]{weight};
    }

    public void setKeyword(char[] keyword) {
        this.keywords = new char[][]{keyword};
        int[] newWeights = new int[]{this.weight.length > 0 ? this.weight[0] : -1};
        this.weight = newWeights;
    }

    public void setKeyword(char[] keyword, int weight) {
        this.keywords = new char[][]{keyword};
        this.weight = new int[]{weight};
    }

    public int size() {
        int size = 6 + SizeUtil.OBJECT_OVERHEAD;
        if (!this.isOperation) {
            size += SizeUtil.sizeOf((char[])this.field);
            int i = 0;
            while (i < this.keywords.length) {
                size += SizeUtil.sizeOf((char[])this.keywords[i]);
                ++i;
            }
            return size += this.weight.length * 4;
        }
        return size;
    }

    public char[] getField() {
        if (this.isOperation) {
            return null;
        }
        return this.field;
    }

    public char[][] getKeywords() {
        if (this.isOperation) {
            return null;
        }
        return this.keywords;
    }

    public int[] getWeight() {
        if (this.isOperation) {
            return null;
        }
        return this.weight;
    }

    public byte getOperation() {
        return this.operation;
    }

    public boolean isOperation() {
        return this.isOperation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        WhereSet castedObj = (WhereSet)o;
        if (this.isOperation != castedObj.isOperation) {
            return false;
        }
        if (!this.isOperation) {
            if (this.keywords.length != castedObj.keywords.length) {
                return false;
            }
            int i = 0;
            while (i < this.keywords.length) {
                if (!Arrays.equals(this.keywords[i], castedObj.keywords[i])) {
                    return false;
                }
                ++i;
            }
            if (!Arrays.equals(this.field, castedObj.field)) {
                return false;
            }
            if (!Arrays.equals(this.weight, castedObj.weight)) {
                return false;
            }
        }
        return this.operation == castedObj.operation;
    }

    public String toString() {
        String string;
        if (!this.isOperation) {
            string = "[index : " + new String(this.field) + "][isOpeartion = " + this.isOperation + "[operation : " + this.operation + "][ keywords :";
            int i = 0;
            while (i < this.keywords.length) {
                String keyword = this.keywords[i] == null ? "null" : new String(this.keywords[i]);
                string = String.valueOf(string) + "(" + i + " : " + keyword + "[" + this.weight[i] + "]) ";
                ++i;
            }
        } else {
            string = "[operation : " + this.operation + "]";
        }
        return string;
    }

    public void serialize(OutputStream out) throws IOException {
        if (this.isOperation) {
            ByteUtil.writeByte((OutputStream)out, (byte)0);
            ByteUtil.writeByte((OutputStream)out, (byte)this.getOperation());
        } else {
            ByteUtil.writeByte((OutputStream)out, (byte)1);
            ByteUtil.writeChars((OutputStream)out, (char[])this.field);
            ByteUtil.writeByte((OutputStream)out, (byte)this.operation);
            ByteUtil.writeInt((OutputStream)out, (int)this.keywords.length);
            int k = 0;
            while (k < this.keywords.length) {
                ByteUtil.writeChars((OutputStream)out, (char[])this.keywords[k]);
                ++k;
            }
            ByteUtil.writeInt((OutputStream)out, (int)this.weight.length);
            k = 0;
            while (k < this.weight.length) {
                ByteUtil.writeInt((OutputStream)out, (int)this.weight[k]);
                ++k;
            }
        }
    }

    public static WhereSet deserialize(InputStream in) throws IOException {
        WhereSet whereSet;
        if (ByteUtil.readByte((InputStream)in) == 1) {
            char[] field = ByteUtil.readChars((InputStream)in);
            byte operation = ByteUtil.readByte((InputStream)in);
            int keywordSize = ByteUtil.readInt((InputStream)in);
            char[][] keywordLists = new char[keywordSize][];
            int k = 0;
            while (k < keywordSize) {
                keywordLists[k] = ByteUtil.readChars((InputStream)in);
                ++k;
            }
            int weightSize = ByteUtil.readInt((InputStream)in);
            int[] weightLists = new int[weightSize];
            int k2 = 0;
            while (k2 < weightSize) {
                weightLists[k2] = ByteUtil.readInt((InputStream)in);
                ++k2;
            }
            whereSet = new WhereSet(field, operation, keywordLists, weightLists);
        } else {
            byte operation = ByteUtil.readByte((InputStream)in);
            whereSet = new WhereSet(operation);
        }
        return whereSet;
    }

    public boolean isHasAny() {
        return !this.isOperation && WhereSet.isHasAny(this.operation);
    }

    public boolean isHasAnyOne() {
        return !this.isOperation && WhereSet.isHasAnyOne(this.operation);
    }

    public boolean isHasAll() {
        return !this.isOperation && WhereSet.isHasAll(this.operation);
    }

    public boolean isHasAllOne() {
        return !this.isOperation && WhereSet.isHasAllOne(this.operation);
    }

    public boolean isSemiHasAny() {
        return !this.isOperation && WhereSet.isSemiHasAny(this.operation);
    }

    public boolean isThesaurusExtend(byte thesaurusID) {
        return !this.isOperation && WhereSet.isThesaurusExtend(thesaurusID, this.operation);
    }

    public static boolean isHasAny(byte operation) {
        return (operation & 0xF) == 2;
    }

    public static boolean isHasAnyOne(byte operation) {
        return (operation & 0xF) == 3;
    }

    public static boolean isHasAll(byte operation) {
        return (operation & 0xF) == 1 || (operation & 0x40) == 64;
    }

    public static boolean isHasAllOne(byte operation) {
        return (operation & 0xF) == 11;
    }

    public static boolean isSemiHasAny(byte operation) {
        return (operation & 0xF) == 4;
    }

    public static boolean isThesaurusExtend(byte thesaurusID, byte operation) {
        switch (thesaurusID) {
            case 1: {
                return (operation & 0x10) == 16;
            }
            case 2: {
                return (operation & 0x10) == 16;
            }
            case 4: {
                return (operation & 0x20) == 32;
            }
            case 8: {
                return (operation & 0x20) == 32;
            }
        }
        return false;
    }

    public void setOperation(byte op) {
        this.operation = op;
    }

    public void setField(char[] charArray) {
        this.field = charArray;
    }

    public boolean isRightTruncation() {
        return !this.isOperation && WhereSet.isRightTruncation(this.operation);
    }

    public static boolean isRightTruncation(byte operation) {
        return (operation & 0x41) == 65;
    }

    public boolean isLeftTruncation() {
        return !this.isOperation && WhereSet.isLeftTruncation(this.operation);
    }

    public static boolean isLeftTruncation(byte operation) {
        return (operation & 0x42) == 66;
    }

    public boolean isCenterTruncation() {
        return !this.isOperation && WhereSet.isCenterTruncation(this.operation);
    }

    public static boolean isCenterTruncation(byte operation) {
        return (operation & 0x44) == 68;
    }
}

