/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.repository;

import com.diquest.ir.common.msg.protocol.query.SelectSet;
import com.diquest.ir.util.common.vector.CharVector;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class DocumentReq {
    public static final int DEFAULT_HIGHLIGHT_THRESHOLD = 10;
    private SelectSet[] selectSet;
    private int[] docIDs;
    private char[][][] keywords;
    private char[][][] extKeywords;
    private LinkedHashSet[] keywordsAux;
    private LinkedHashSet[] extKeywordsAux;
    private boolean[] thesaurusExtend;
    private boolean stopwordExtend;
    private boolean usePercentage;
    private boolean bannedWordExtend;
    private boolean phraseExact;
    private char[] profile;
    private boolean categoryRanking;
    private boolean documentRanking;
    private boolean rankingModel;
    private int maxWeight;
    private int highlightThreshold = 10;
    private boolean[][] symbolMapOptions;
    private double[] thesaurusWeights;
    private boolean fullyHighlight;
    private boolean[] useThesaurusAnyoneWeight;

    public DocumentReq() {
    }

    public DocumentReq(SelectSet[] selectSet, int[] docIDs, char[][][] keywords, char[][][] extKeywords, boolean[] thesaurusExtend, boolean stopwordExtend, boolean usePercentage, boolean bannedWordExtend, boolean[][] symbolMapOptions, int highlightThreshold, double[] thesaurusWeights, boolean fullyHighlight) {
        this.selectSet = selectSet;
        this.docIDs = docIDs;
        this.setKeywords(keywords);
        this.setExtKeywords(extKeywords);
        this.thesaurusExtend = thesaurusExtend;
        this.thesaurusWeights = thesaurusWeights;
        this.stopwordExtend = stopwordExtend;
        this.usePercentage = usePercentage;
        this.bannedWordExtend = bannedWordExtend;
        this.maxWeight = 1;
        this.symbolMapOptions = symbolMapOptions;
        this.highlightThreshold = highlightThreshold;
        this.fullyHighlight = fullyHighlight;
    }

    public DocumentReq(SelectSet[] selectSet, int[] docIDs, char[][][] keywords, char[][][] extKeywords, boolean[] thesaurusExtend, boolean stopwordExtend, boolean usePercentage, boolean bannedWordExtend, boolean[][] symbolMapOptions, double[] thesaurusWeights) {
        this(selectSet, docIDs, keywords, extKeywords, thesaurusExtend, stopwordExtend, usePercentage, bannedWordExtend, symbolMapOptions, 10, thesaurusWeights, false);
    }

    public void setMaxWeight(int maxWeight) {
        this.maxWeight = maxWeight;
    }

    public int[] getDocIDs() {
        return this.docIDs;
    }

    public char[][][] getKeywords() {
        DocumentReq.drainTo(this.keywordsAux, this.keywords);
        return this.keywords;
    }

    public char[][] getAllKeywords() {
        return DocumentReq.mergeKeywordSet(this.keywordsAux);
    }

    public SelectSet[] getSelectSet() {
        return this.selectSet;
    }

    public void setDocIDs(int[] docIDs) {
        this.docIDs = docIDs;
    }

    public void setKeywords(char[][][] keywords) {
        this.keywordsAux = new LinkedHashSet[keywords.length];
        this.keywords = keywords;
    }

    private boolean addKeywords(int selectIndex, CharArrayWrapper keyword) {
        if (this.keywordsAux[selectIndex] == null) {
            this.keywordsAux[selectIndex] = new LinkedHashSet();
            int i = 0;
            while (i < this.keywords[selectIndex].length) {
                this.keywordsAux[selectIndex].add(new CharArrayWrapper(this.keywords[selectIndex][i]));
                ++i;
            }
            this.keywords[selectIndex] = null;
        }
        return this.keywordsAux[selectIndex].add(keyword);
    }

    private boolean addExtKeywords(int selectIndex, CharArrayWrapper keyword) {
        if (this.extKeywordsAux[selectIndex] == null) {
            this.extKeywordsAux[selectIndex] = new LinkedHashSet();
            int i = 0;
            while (i < this.extKeywords[selectIndex].length) {
                this.extKeywordsAux[selectIndex].add(new CharArrayWrapper(this.extKeywords[selectIndex][i]));
                ++i;
            }
            this.extKeywords[selectIndex] = null;
        }
        return this.extKeywordsAux[selectIndex].add(keyword);
    }

    private boolean checkKeywordsAddable(int index) {
        if (this.highlightThreshold == -1) {
            return true;
        }
        int size = this.keywords[index] == null ? this.keywordsAux[index].size() : this.keywords[index].length;
        return size < this.highlightThreshold;
    }

    private boolean checkExtKeywordsAddable(int index) {
        if (this.highlightThreshold == -1) {
            return true;
        }
        int size = this.extKeywords[index] == null ? this.extKeywordsAux[index].size() : this.extKeywords[index].length;
        return size < this.highlightThreshold;
    }

    public boolean addKeywords(int selectIndex, char[] keyword) {
        if (this.checkKeywordsAddable(selectIndex)) {
            return this.addKeywords(selectIndex, new CharArrayWrapper(keyword, true));
        }
        return false;
    }

    public boolean addKeywords(int selectIndex, CharVector keyword) {
        if (this.checkKeywordsAddable(selectIndex)) {
            return this.addKeywords(selectIndex, new CharArrayWrapper(keyword.toCharArray(), false));
        }
        return false;
    }

    public boolean addExtKeywords(int selectIndex, char[] keyword) {
        if (this.checkExtKeywordsAddable(selectIndex)) {
            return this.addExtKeywords(selectIndex, new CharArrayWrapper(keyword, true));
        }
        return false;
    }

    public boolean addExtKeywords(int selectIndex, CharVector keyword) {
        if (this.checkExtKeywordsAddable(selectIndex)) {
            return this.addExtKeywords(selectIndex, new CharArrayWrapper(keyword.toCharArray(), false));
        }
        return false;
    }

    public void setSelectSet(SelectSet[] selectSet) {
        this.selectSet = selectSet;
        char[][][] _keywords = new char[selectSet.length][][];
        char[][][] _extKeywords = new char[selectSet.length][][];
        int i = 0;
        while (i < _keywords.length) {
            _keywords[i] = new char[0][];
            _extKeywords[i] = new char[0][];
            ++i;
        }
        this.setKeywords(_keywords);
        this.setExtKeywords(_extKeywords);
    }

    public char[][][] getExtKeywords() {
        DocumentReq.drainTo(this.extKeywordsAux, this.extKeywords);
        return this.extKeywords;
    }

    public char[][] getAllExtKeywords() {
        return DocumentReq.mergeKeywordSet(this.extKeywordsAux);
    }

    public void setExtKeywords(char[][][] extKeywords) {
        this.extKeywordsAux = new LinkedHashSet[extKeywords.length];
        this.extKeywords = extKeywords;
    }

    public boolean isStopwordExtend() {
        return this.stopwordExtend;
    }

    public void setStopwordExtend(boolean stopwordExtend) {
        this.stopwordExtend = stopwordExtend;
    }

    public int getMaxWeight() {
        return this.maxWeight;
    }

    public void setUsePercentage(boolean usePercentage) {
        this.usePercentage = usePercentage;
    }

    public boolean isUsePercentage() {
        return this.usePercentage;
    }

    public boolean isBannedWordExtend() {
        return this.bannedWordExtend;
    }

    public void setBannedWordExtend(boolean bannedWordExtend) {
        this.bannedWordExtend = bannedWordExtend;
    }

    public boolean[][] getSymbolMapOptions() {
        return this.symbolMapOptions;
    }

    public void setSymbolMapOptions(boolean[][] symbolMapOptions) {
        this.symbolMapOptions = symbolMapOptions;
    }

    public void orSymbolMapOptions(int select, int option, boolean usage) {
        boolean[] blArray = this.symbolMapOptions[select];
        int n = option;
        blArray[n] = blArray[n] | usage;
    }

    private static void drainTo(LinkedHashSet[] sets, char[][][] keyword) {
        int i = 0;
        while (i < sets.length) {
            if (sets[i] != null) {
                keyword[i] = new char[sets[i].size()][];
                int j = 0;
                Iterator it = sets[i].iterator();
                while (it.hasNext()) {
                    CharArrayWrapper wrap = (CharArrayWrapper)it.next();
                    keyword[i][j++] = wrap.getArray();
                }
            }
            sets[i] = null;
            ++i;
        }
    }

    private static char[][] mergeKeywordSet(LinkedHashSet[] sets) {
        Iterator it;
        char[][] keywords = null;
        HashSet<CharArrayWrapper> allKeyword = new HashSet<CharArrayWrapper>();
        int i = 0;
        while (i < sets.length) {
            if (sets[i] != null) {
                it = sets[i].iterator();
                while (it.hasNext()) {
                    allKeyword.add((CharArrayWrapper)it.next());
                }
            }
            ++i;
        }
        if (allKeyword.size() > 0) {
            keywords = new char[allKeyword.size()][];
            i = 0;
            it = allKeyword.iterator();
            while (it.hasNext()) {
                CharArrayWrapper wrap = (CharArrayWrapper)it.next();
                keywords[i++] = wrap.getArray();
            }
        }
        return keywords;
    }

    public void setHighlightThreshold(int highlightThreshold) {
        this.highlightThreshold = highlightThreshold;
    }

    public int getHighlightThreshold() {
        return this.highlightThreshold;
    }

    public boolean isCategoryRanking() {
        return this.categoryRanking;
    }

    public void setCategoryRanking(boolean categoryRanking) {
        this.categoryRanking = categoryRanking;
    }

    public boolean isDocumentRanking() {
        return this.documentRanking;
    }

    public void setDocumentRanking(boolean documentRanking) {
        this.documentRanking = documentRanking;
    }

    public boolean isRankingModel() {
        return this.rankingModel;
    }

    public void setRankingModel(boolean rankingModel) {
        this.rankingModel = rankingModel;
    }

    public char[] getProfile() {
        return this.profile;
    }

    public void setProfile(char[] profile) {
        this.profile = profile;
    }

    public boolean isPhraseExact() {
        return this.phraseExact;
    }

    public void setPhraseExact(boolean phraseExact) {
        this.phraseExact = phraseExact;
    }

    public boolean[] isThesaurusExtend() {
        return this.thesaurusExtend;
    }

    public double[] thesaurusWeights() {
        return this.thesaurusWeights;
    }

    public boolean isThesaurusExtend(byte thesaurusID) {
        return this.thesaurusExtend[this.log2(thesaurusID)];
    }

    public void setThesaurusExtend(boolean[] thesaurusExtend) {
        this.thesaurusExtend = thesaurusExtend;
    }

    public void setThesaurusExtend(byte thesaurusID, boolean thesaurusExtend) {
        this.thesaurusExtend[this.log2((byte)thesaurusID)] = thesaurusExtend;
    }

    public void setThesaurusWeights(double[] thesaurusWeights) {
        this.thesaurusWeights = thesaurusWeights;
    }

    public boolean isFullyHighlight() {
        return this.fullyHighlight;
    }

    public void setFullyHighlight(boolean fullyHighlight) {
        this.fullyHighlight = fullyHighlight;
    }

    public int log2(byte num) {
        return (int)(Math.log(num) / Math.log(2.0));
    }

    public boolean[] isThesaurusUseAnyoneWeight() {
        return this.useThesaurusAnyoneWeight;
    }

    public void setUseThesaurusAnyoneWeight(boolean[] thesaurusesUseAnyoneWeight) {
        this.useThesaurusAnyoneWeight = thesaurusesUseAnyoneWeight;
    }

    private class CharArrayWrapper {
        private int hash;
        private char[] array;

        CharArrayWrapper(char[] array) {
            this.array = array;
        }

        CharArrayWrapper(char[] array, boolean copy) {
            if (copy) {
                this.array = new char[array.length];
                System.arraycopy(array, 0, this.array, 0, array.length);
            } else {
                this.array = array;
            }
        }

        public char[] getArray() {
            return this.array;
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.array, ((CharArrayWrapper)obj).array);
        }

        public int hashCode() {
            if (this.hash == 0) {
                int i = 0;
                while (i < this.array.length) {
                    this.hash <<= 5 - this.hash + this.array[i];
                    i += i + 1;
                }
                if (this.hash == 0) {
                    this.hash = 1;
                }
            }
            return this.hash;
        }
    }
}

