/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.repository;

import com.diquest.ir.common.msg.protocol.query.Query;
import com.diquest.ir.common.msg.protocol.query.SelectSet;
import com.diquest.ir.common.msg.protocol.repository.DocumentReq;
import com.diquest.ir.common.msg.protocol.result.GroupResult;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RepositoryReqT
extends Transmitable {
    private char[] collectionID;
    private char[] startTag;
    private char[] endTag;
    private int totalResultCount;
    private byte resultCountMethod;
    private DocumentReq documentReq;
    private GroupResult[] groupResults;
    private int[] weights;
    private double[] distances;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.protocol.repository.RepositoryReqT");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RepositoryReqT(Query query, int totalResultCount, byte resultCountMethod, DocumentReq documentReq, GroupResult[] groupResults, int[] precisions, double[] distances) {
        this.collectionID = query.getFromField();
        this.startTag = query.getHighLightStartTag();
        this.endTag = query.getHighLightEndTag();
        this.totalResultCount = totalResultCount;
        this.resultCountMethod = resultCountMethod;
        this.documentReq = documentReq;
        this.groupResults = groupResults;
        this.weights = precisions;
        this.distances = distances;
    }

    public RepositoryReqT() {
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeChars((OutputStream)out, (char[])this.collectionID);
        ByteUtil.writeChars((OutputStream)out, (char[])this.startTag);
        ByteUtil.writeChars((OutputStream)out, (char[])this.endTag);
        ByteUtil.writeInt((OutputStream)out, (int)this.totalResultCount);
        ByteUtil.writeByte((OutputStream)out, (byte)this.resultCountMethod);
        ByteUtil.writeInt((OutputStream)out, (int)this.groupResults.length);
        int j = 0;
        while (j < this.groupResults.length) {
            int k;
            Object[] values;
            byte type = this.groupResults[j].getType();
            if (!$assertionsDisabled && type != 65 && type != 66) {
                throw new AssertionError();
            }
            ByteUtil.writeByte((OutputStream)out, (byte)type);
            ByteUtil.writeInt((OutputStream)out, (int)this.groupResults[j].groupResultSize());
            char[][] ids = this.groupResults[j].getIds();
            if (type == 65) {
                values = this.groupResults[j].getIntValues();
                k = 0;
                while (k < this.groupResults[j].groupResultSize()) {
                    ByteUtil.writeChars((OutputStream)out, (char[])ids[k]);
                    ByteUtil.writeInt((OutputStream)out, (int)values[k]);
                    ++k;
                }
            } else if (type == 66) {
                values = this.groupResults[j].getFloatValues();
                k = 0;
                while (k < this.groupResults[j].groupResultSize()) {
                    ByteUtil.writeChars((OutputStream)out, (char[])ids[k]);
                    ByteUtil.writeFloat((OutputStream)out, (float)values[k]);
                    ++k;
                }
            }
            ++j;
        }
        SelectSet[] selectSet = this.documentReq.getSelectSet();
        ByteUtil.writeInt((OutputStream)out, (int)selectSet.length);
        int i = 0;
        while (i < selectSet.length) {
            ByteUtil.writeChars((OutputStream)out, (char[])selectSet[i].getField());
            ByteUtil.writeByte((OutputStream)out, (byte)selectSet[i].getOption());
            ++i;
        }
        int[] docIDs = this.documentReq.getDocIDs();
        ByteUtil.writeInt((OutputStream)out, (int)docIDs.length);
        int i2 = 0;
        while (i2 < docIDs.length) {
            ByteUtil.writeInt((OutputStream)out, (int)docIDs[i2]);
            ++i2;
        }
        char[][][] keywords = this.documentReq.getKeywords();
        ByteUtil.writeInt((OutputStream)out, (int)keywords.length);
        int i3 = 0;
        while (i3 < keywords.length) {
            ByteUtil.writeInt((OutputStream)out, (int)keywords[i3].length);
            int j2 = 0;
            while (j2 < keywords[i3].length) {
                ByteUtil.writeInt((OutputStream)out, (int)keywords[i3][j2].length);
                int k = 0;
                while (k < keywords[i3][j2].length) {
                    ByteUtil.writeChar((OutputStream)out, (char)keywords[i3][j2][k]);
                    ++k;
                }
                ++j2;
            }
            ++i3;
        }
        char[][][] extKeywords = this.documentReq.getExtKeywords();
        ByteUtil.writeInt((OutputStream)out, (int)extKeywords.length);
        int i4 = 0;
        while (i4 < extKeywords.length) {
            ByteUtil.writeInt((OutputStream)out, (int)extKeywords[i4].length);
            int j3 = 0;
            while (j3 < extKeywords[i4].length) {
                ByteUtil.writeInt((OutputStream)out, (int)extKeywords[i4][j3].length);
                int k = 0;
                while (k < extKeywords[i4][j3].length) {
                    ByteUtil.writeChar((OutputStream)out, (char)extKeywords[i4][j3][k]);
                    ++k;
                }
                ++j3;
            }
            ++i4;
        }
        boolean[] isThesaurusExtend = this.documentReq.isThesaurusExtend();
        double[] thesaurusWeight = this.documentReq.thesaurusWeights();
        ByteUtil.writeInt((OutputStream)out, (int)isThesaurusExtend.length);
        int i5 = 0;
        while (i5 < isThesaurusExtend.length) {
            ByteUtil.writeBoolean((OutputStream)out, (boolean)isThesaurusExtend[i5]);
            ByteUtil.writeDouble((OutputStream)out, (double)thesaurusWeight[i5]);
            ++i5;
        }
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.documentReq.isStopwordExtend());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.documentReq.isUsePercentage());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.documentReq.isBannedWordExtend());
        ByteUtil.writeChars((OutputStream)out, (char[])this.documentReq.getProfile());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.documentReq.isCategoryRanking());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.documentReq.isDocumentRanking());
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.documentReq.isRankingModel());
        ByteUtil.writeInt((OutputStream)out, (int)this.documentReq.getMaxWeight());
        boolean[][] symbolMapOptions = this.documentReq.getSymbolMapOptions();
        ByteUtil.writeInt((OutputStream)out, (int)symbolMapOptions.length);
        int i6 = 0;
        while (i6 < symbolMapOptions.length) {
            ByteUtil.writeInt((OutputStream)out, (int)symbolMapOptions[i6].length);
            int j4 = 0;
            while (j4 < symbolMapOptions[i6].length) {
                ByteUtil.writeBoolean((OutputStream)out, (boolean)symbolMapOptions[i6][j4]);
                ++j4;
            }
            ++i6;
        }
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.documentReq.isFullyHighlight());
        ByteUtil.writeInt((OutputStream)out, (int)this.documentReq.getHighlightThreshold());
        if (this.weights == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)this.weights.length);
            i6 = 0;
            while (i6 < this.weights.length) {
                ByteUtil.writeInt((OutputStream)out, (int)this.weights[i6]);
                ++i6;
            }
        }
        if (this.distances == null) {
            ByteUtil.writeInt((OutputStream)out, (int)0);
        } else {
            ByteUtil.writeInt((OutputStream)out, (int)this.distances.length);
            i6 = 0;
            while (i6 < this.distances.length) {
                ByteUtil.writeDouble((OutputStream)out, (double)this.distances[i6]);
                ++i6;
            }
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.collectionID = ByteUtil.readChars((InputStream)in);
        this.startTag = ByteUtil.readChars((InputStream)in);
        this.endTag = ByteUtil.readChars((InputStream)in);
        this.totalResultCount = ByteUtil.readInt((InputStream)in);
        this.resultCountMethod = ByteUtil.readByte((InputStream)in);
        int opResultsSize = ByteUtil.readInt((InputStream)in);
        this.groupResults = new GroupResult[opResultsSize];
        int j = 0;
        while (j < opResultsSize) {
            int k;
            byte type = ByteUtil.readByte((InputStream)in);
            this.groupResults[j] = new GroupResult(type, ByteUtil.readInt((InputStream)in));
            int opResultSize = this.groupResults[j].groupResultSize();
            if (this.groupResults[j].getType() == 65) {
                k = 0;
                while (k < opResultSize) {
                    this.groupResults[j].addResult(ByteUtil.readChars((InputStream)in), ByteUtil.readInt((InputStream)in));
                    ++k;
                }
            } else if (this.groupResults[j].getType() == 66) {
                k = 0;
                while (k < opResultSize) {
                    this.groupResults[j].addResult(ByteUtil.readChars((InputStream)in), ByteUtil.readFloat((InputStream)in));
                    ++k;
                }
            } else {
                throw new IOException("Illegal result type : " + this.groupResults[j].getType());
            }
            ++j;
        }
        SelectSet[] selectSet = new SelectSet[ByteUtil.readInt((InputStream)in)];
        int i = 0;
        while (i < selectSet.length) {
            selectSet[i] = new SelectSet(ByteUtil.readChars((InputStream)in), ByteUtil.readByte((InputStream)in));
            ++i;
        }
        int[] docIDs = new int[ByteUtil.readInt((InputStream)in)];
        int i2 = 0;
        while (i2 < docIDs.length) {
            docIDs[i2] = ByteUtil.readInt((InputStream)in);
            ++i2;
        }
        char[][][] keywords = new char[ByteUtil.readInt((InputStream)in)][][];
        int i3 = 0;
        while (i3 < keywords.length) {
            keywords[i3] = new char[ByteUtil.readInt((InputStream)in)][];
            int j2 = 0;
            while (j2 < keywords[i3].length) {
                keywords[i3][j2] = new char[ByteUtil.readInt((InputStream)in)];
                int k = 0;
                while (k < keywords[i3][j2].length) {
                    keywords[i3][j2][k] = ByteUtil.readChar((InputStream)in);
                    ++k;
                }
                ++j2;
            }
            ++i3;
        }
        char[][][] extKeywords = new char[ByteUtil.readInt((InputStream)in)][][];
        int i4 = 0;
        while (i4 < extKeywords.length) {
            extKeywords[i4] = new char[ByteUtil.readInt((InputStream)in)][];
            int j3 = 0;
            while (j3 < extKeywords[i4].length) {
                extKeywords[i4][j3] = new char[ByteUtil.readInt((InputStream)in)];
                int k = 0;
                while (k < extKeywords[i4][j3].length) {
                    extKeywords[i4][j3][k] = ByteUtil.readChar((InputStream)in);
                    ++k;
                }
                ++j3;
            }
            ++i4;
        }
        int thesaurusExtendSize = ByteUtil.readInt((InputStream)in);
        boolean[] thesaurusExtend = new boolean[thesaurusExtendSize];
        double[] thesaurusWeights = new double[thesaurusExtendSize];
        int i5 = 0;
        while (i5 < thesaurusExtendSize) {
            thesaurusExtend[i5] = ByteUtil.readBoolean((InputStream)in);
            thesaurusWeights[i5] = ByteUtil.readDouble((InputStream)in);
            ++i5;
        }
        boolean stopwordExtend = ByteUtil.readBoolean((InputStream)in);
        boolean usePercentage = ByteUtil.readBoolean((InputStream)in);
        boolean bannedWordExtend = ByteUtil.readBoolean((InputStream)in);
        char[] profile = ByteUtil.readChars((InputStream)in);
        boolean categoryRanking = ByteUtil.readBoolean((InputStream)in);
        boolean documentRanking = ByteUtil.readBoolean((InputStream)in);
        boolean rankingModel = ByteUtil.readBoolean((InputStream)in);
        int maxWeight = ByteUtil.readInt((InputStream)in);
        boolean[][] symbolMapOptions = new boolean[ByteUtil.readInt((InputStream)in)][];
        int i6 = 0;
        while (i6 < symbolMapOptions.length) {
            symbolMapOptions[i6] = new boolean[ByteUtil.readInt((InputStream)in)];
            int j4 = 0;
            while (j4 < symbolMapOptions[i6].length) {
                symbolMapOptions[i6][j4] = ByteUtil.readBoolean((InputStream)in);
                ++j4;
            }
            ++i6;
        }
        boolean fullyHighlight = ByteUtil.readBoolean((InputStream)in);
        this.documentReq = new DocumentReq(selectSet, docIDs, keywords, extKeywords, thesaurusExtend, stopwordExtend, usePercentage, bannedWordExtend, symbolMapOptions, thesaurusWeights);
        this.documentReq.setMaxWeight(maxWeight);
        this.documentReq.setHighlightThreshold(ByteUtil.readInt((InputStream)in));
        this.documentReq.setProfile(profile);
        this.documentReq.setCategoryRanking(categoryRanking);
        this.documentReq.setDocumentRanking(documentRanking);
        this.documentReq.setRankingModel(rankingModel);
        this.documentReq.setFullyHighlight(fullyHighlight);
        int precisionLength = ByteUtil.readInt((InputStream)in);
        this.weights = new int[precisionLength];
        int i7 = 0;
        while (i7 < precisionLength) {
            this.weights[i7] = ByteUtil.readInt((InputStream)in);
            ++i7;
        }
        int distanceLength = ByteUtil.readInt((InputStream)in);
        this.distances = new double[distanceLength];
        int i8 = 0;
        while (i8 < distanceLength) {
            this.distances[i8] = ByteUtil.readDouble((InputStream)in);
            ++i8;
        }
    }

    public Transmitable getInstance() {
        return new RepositoryReqT();
    }

    public char[] getCollectionID() {
        return this.collectionID;
    }

    public DocumentReq getDocumentReq() {
        return this.documentReq;
    }

    public char[] getEndTag() {
        return this.endTag;
    }

    public byte getResultCountMethod() {
        return this.resultCountMethod;
    }

    public char[] getStartTag() {
        return this.startTag;
    }

    public int getTotalResultCount() {
        return this.totalResultCount;
    }

    public GroupResult[] getGroupResults() {
        return this.groupResults;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public void setTotalResultCount(int totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public void setDocumentReq(DocumentReq documentReq) {
        this.documentReq = documentReq;
    }

    public void setWeights(int[] weights) {
        this.weights = weights;
    }

    public void setDistances(double[] distances) {
        this.distances = distances;
    }

    public double[] getDistances() {
        return this.distances;
    }
}

