/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.protocol.result;

import com.diquest.ir.common.msg.protocol.Measurable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.SizeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class GroupResult
implements Measurable {
    private byte type;
    private int groupResultSize;
    private char[][] ids;
    private int[] intValues;
    private float[] floatValues;
    private int resultCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.protocol.result.GroupResult");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GroupResult(byte type, int size) {
        this.type = type;
        this.groupResultSize = size;
        this.resultCount = 0;
        this.ids = new char[size][];
        if (type == 65) {
            this.intValues = new int[size];
        } else if (type == 66) {
            this.floatValues = new float[size];
        } else {
            return;
        }
    }

    public int size() {
        int size = 15 + SizeUtil.OBJECT_OVERHEAD;
        if (this.type == 65 && this.intValues != null) {
            size += SizeUtil.sizeOf((int[])this.intValues);
        } else if (this.type == 66 && this.floatValues != null) {
            size += SizeUtil.sizeOf((float[])this.floatValues);
        }
        if (this.ids != null) {
            size += this.ids.length * 2;
            int i = 0;
            while (i < this.ids.length) {
                if (this.ids[i] != null) {
                    size += SizeUtil.sizeOf((char[])this.ids[i]);
                }
                ++i;
            }
        }
        return size;
    }

    public void trimSize(int newsize) {
        this.groupResultSize = newsize;
        if (this.type == 65) {
            int[] newIntValues = new int[newsize];
            System.arraycopy(this.intValues, 0, newIntValues, 0, newsize);
            this.intValues = newIntValues;
        } else if (this.type == 66) {
            float[] newFloatValues = new float[newsize];
            System.arraycopy(this.floatValues, 0, newFloatValues, 0, newsize);
            this.floatValues = newFloatValues;
        }
    }

    public void setIds(char[][] ids) {
        this.ids = ids;
    }

    public void setValues(int[] intValues) {
        if (this.type != 65) {
            return;
        }
        this.intValues = intValues;
    }

    public void setValues(float[] floatValues) {
        if (this.type != 66) {
            return;
        }
        this.floatValues = floatValues;
    }

    public void addResult(char[] id, int value) {
        if (this.type != 65) {
            return;
        }
        this.ids[this.resultCount] = id;
        this.intValues[this.resultCount++] = value;
    }

    public void addResult(char[] id, float value) {
        if (this.type != 66) {
            return;
        }
        this.ids[this.resultCount] = id;
        this.floatValues[this.resultCount++] = value;
    }

    public int groupResultSize() {
        return this.groupResultSize;
    }

    public char[][] getIds() {
        return this.ids;
    }

    public int[] getIntValues() {
        if (this.type != 65) {
            return null;
        }
        return this.intValues;
    }

    public float[] getFloatValues() {
        if (this.type != 66) {
            return null;
        }
        return this.floatValues;
    }

    public char[] getId(int index) {
        return this.ids[index];
    }

    public int getIntValue(int index) {
        if (this.type != 65) {
            return 0;
        }
        return this.intValues[index];
    }

    public float getFloatValues(int index) {
        if (this.type != 66) {
            return 0.0f;
        }
        return this.floatValues[index];
    }

    public byte getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        GroupResult castedObj = (GroupResult)o;
        if (this.type == castedObj.type && this.groupResultSize == castedObj.groupResultSize) {
            int i = 0;
            while (i < this.ids.length) {
                if (!Arrays.equals(this.ids[i], castedObj.ids[i])) {
                    return false;
                }
                ++i;
            }
            return Arrays.equals(this.intValues, castedObj.intValues) && Arrays.equals(this.floatValues, castedObj.floatValues) && this.resultCount == castedObj.resultCount;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[GroupResults : " + this.groupResultSize + "]\n");
        int i = 0;
        while (i < this.groupResultSize && this.ids[i] != null) {
            buffer.append('[');
            buffer.append(this.ids[i]);
            buffer.append(" : ");
            if (this.type == 65) {
                buffer.append(this.intValues[i]);
            } else if (this.type == 66) {
                buffer.append(this.floatValues[i]);
            }
            buffer.append("]\n");
            ++i;
        }
        return buffer.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        block4: {
            block3: {
                if (!$assertionsDisabled && this.type != 65 && this.type != 66) {
                    throw new AssertionError();
                }
                ByteUtil.writeByte((OutputStream)out, (byte)this.type);
                ByteUtil.writeInt((OutputStream)out, (int)this.groupResultSize);
                if (this.type != 65) break block3;
                int k = 0;
                while (k < this.groupResultSize()) {
                    ByteUtil.writeChars((OutputStream)out, (char[])this.ids[k]);
                    ByteUtil.writeInt((OutputStream)out, (int)this.intValues[k]);
                    ++k;
                }
                break block4;
            }
            if (this.type != 66) break block4;
            int k = 0;
            while (k < this.groupResultSize()) {
                ByteUtil.writeChars((OutputStream)out, (char[])this.ids[k]);
                ByteUtil.writeFloat((OutputStream)out, (float)this.floatValues[k]);
                ++k;
            }
        }
    }

    public static GroupResult deserialize(InputStream in) throws IOException {
        byte type = ByteUtil.readByte((InputStream)in);
        GroupResult groupResult = new GroupResult(type, ByteUtil.readInt((InputStream)in));
        int opResultSize = groupResult.groupResultSize();
        if (groupResult.getType() == 65) {
            int k = 0;
            while (k < opResultSize) {
                groupResult.addResult(ByteUtil.readChars((InputStream)in), ByteUtil.readInt((InputStream)in));
                ++k;
            }
        } else if (groupResult.getType() == 66) {
            int k = 0;
            while (k < opResultSize) {
                groupResult.addResult(ByteUtil.readChars((InputStream)in), ByteUtil.readFloat((InputStream)in));
                ++k;
            }
        } else {
            throw new IOException("Unknown result type : " + groupResult.getType());
        }
        return groupResult;
    }
}

