/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.rankingmodel;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RankingModel
extends Transmitable {
    private final float WIDEN_FACTOR = 1.5f;
    private char[][] fields;
    private byte[] types;
    private int[] weights;
    private boolean[] use;
    private int currentSize;
    private int capacity;

    public RankingModel(int initialSize) {
        this.capacity = initialSize;
        this.fields = new char[this.capacity][];
        this.types = new byte[this.capacity];
        this.weights = new int[this.capacity];
        this.use = new boolean[this.capacity];
        this.currentSize = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.currentSize) {
            buf.append("[FIELD:" + new String(this.fields[i]) + "]");
            buf.append("[TYPE:" + this.types[i] + "]");
            buf.append("[WEIGHT:" + this.weights[i] + "]");
            buf.append("[USE:" + this.use[i] + "]");
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    public RankingModel() {
    }

    public RankingModel getSortTypeRankingModel() {
        int sortCount = 0;
        int i = 0;
        while (i < this.types.length) {
            if ((this.types[i] == 2 || this.types[i] == 3) && this.use[i]) {
                ++sortCount;
            }
            ++i;
        }
        char[][] rfields = new char[sortCount][];
        byte[] rtypes = new byte[sortCount];
        int[] rweights = new int[sortCount];
        boolean[] ruse = new boolean[sortCount];
        int offset = 0;
        int i2 = 0;
        while (i2 < this.types.length) {
            if ((this.types[i2] == 2 || this.types[i2] == 3) && this.use[i2]) {
                rfields[offset] = this.fields[i2];
                rtypes[offset] = this.types[i2];
                rweights[offset] = this.weights[i2];
                ruse[offset] = this.use[i2];
                ++offset;
            }
            ++i2;
        }
        RankingModel model = new RankingModel(sortCount);
        model.fields = rfields;
        model.types = rtypes;
        model.weights = rweights;
        model.use = ruse;
        model.currentSize = sortCount;
        return model;
    }

    public synchronized void addField(char[] fieldID, byte type, int weight, boolean use) {
        this.ensureCapacity();
        this.fields[this.currentSize] = fieldID;
        this.types[this.currentSize] = type;
        this.weights[this.currentSize] = weight;
        this.use[this.currentSize] = use;
        ++this.currentSize;
    }

    private synchronized void ensureCapacity() {
        if (this.capacity == this.currentSize) {
            int newCapacity = (int)((float)this.capacity * 1.5f);
            char[][] nfields = new char[newCapacity][];
            byte[] ntypes = new byte[newCapacity];
            int[] nweights = new int[newCapacity];
            boolean[] nuse = new boolean[newCapacity];
            System.arraycopy(this.fields, 0, nfields, 0, this.capacity);
            System.arraycopy(this.types, 0, ntypes, 0, this.capacity);
            System.arraycopy(this.weights, 0, nweights, 0, this.capacity);
            System.arraycopy(this.use, 0, nuse, 0, this.capacity);
            this.fields = nfields;
            this.types = ntypes;
            this.weights = nweights;
            this.use = nuse;
            this.capacity = newCapacity;
        }
    }

    private synchronized void trim() {
        char[][] nfields = new char[this.currentSize][];
        byte[] ntypes = new byte[this.currentSize];
        int[] nweights = new int[this.currentSize];
        boolean[] nuse = new boolean[this.currentSize];
        System.arraycopy(this.fields, 0, nfields, 0, this.currentSize);
        System.arraycopy(this.types, 0, ntypes, 0, this.currentSize);
        System.arraycopy(this.weights, 0, nweights, 0, this.currentSize);
        System.arraycopy(this.use, 0, nuse, 0, this.currentSize);
        this.fields = nfields;
        this.types = ntypes;
        this.weights = nweights;
        this.use = nuse;
        this.capacity = this.currentSize;
    }

    public void serialize(OutputStream out) throws IOException {
        this.trim();
        ByteUtil.writeInt((OutputStream)out, (int)this.capacity);
        ByteUtil.writeInt((OutputStream)out, (int)this.currentSize);
        int i = 0;
        while (i < this.currentSize) {
            ByteUtil.writeChars((OutputStream)out, (char[])this.fields[i]);
            ByteUtil.writeByte((OutputStream)out, (byte)this.types[i]);
            ByteUtil.writeInt((OutputStream)out, (int)this.weights[i]);
            ByteUtil.writeBoolean((OutputStream)out, (boolean)this.use[i]);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.capacity = ByteUtil.readInt((InputStream)in);
        this.currentSize = ByteUtil.readInt((InputStream)in);
        this.fields = new char[this.capacity][];
        this.types = new byte[this.capacity];
        this.weights = new int[this.capacity];
        this.use = new boolean[this.capacity];
        int i = 0;
        while (i < this.currentSize) {
            this.fields[i] = ByteUtil.readChars((InputStream)in);
            this.types[i] = ByteUtil.readByte((InputStream)in);
            this.weights[i] = ByteUtil.readInt((InputStream)in);
            this.use[i] = ByteUtil.readBoolean((InputStream)in);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new RankingModel();
    }

    public boolean isNull() {
        return false;
    }

    public char[][] getFields() {
        return this.fields;
    }

    public byte[] getTypes() {
        return this.types;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public boolean[] getUse() {
        return this.use;
    }
}

