/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.simulation;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.msg.dictionary.CategoryRankingElement;
import com.diquest.ir.common.msg.dictionary.CategoryRankingElementSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CategoryRankingInfo {
    private char[] category;
    private char[] field;
    private byte type;
    private int weight;

    public CategoryRankingInfo(char[] category, char[] field, byte type, int weight) {
        this.category = category;
        this.field = field;
        this.type = type;
        this.weight = weight;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[FIELD=" + new String(this.field) + "]");
        buf.append("[CATEGORY=" + new String(this.category) + "]");
        buf.append("[TYPE=" + this.type + "]");
        buf.append("[WEIGHT=" + this.weight + "]");
        return buf.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeChars((OutputStream)out, (char[])this.category);
        ByteUtil.writeChars((OutputStream)out, (char[])this.field);
        ByteUtil.writeByte((OutputStream)out, (byte)this.type);
        ByteUtil.writeInt((OutputStream)out, (int)this.weight);
    }

    public static CategoryRankingInfo deserialize(InputStream in) throws IOException {
        char[] category = ByteUtil.readChars((InputStream)in);
        char[] field = ByteUtil.readChars((InputStream)in);
        byte type = ByteUtil.readByte((InputStream)in);
        int weight = ByteUtil.readInt((InputStream)in);
        return new CategoryRankingInfo(category, field, type, weight);
    }

    public char[] getCategory() {
        return this.category;
    }

    public char[] getField() {
        return this.field;
    }

    public byte getType() {
        return this.type;
    }

    public int getWeight() {
        return this.weight;
    }

    public static CategoryRankingInfo[] trimAndRemoveNull(CategoryRankingInfo[] infos) {
        if (infos == null) {
            return new CategoryRankingInfo[0];
        }
        int actualSize = 0;
        CategoryRankingInfo[] ret = new CategoryRankingInfo[infos.length];
        int i = 0;
        while (i < infos.length) {
            if (infos[i] != null && infos[i].category != null && infos[i].field != null) {
                ret[actualSize] = infos[i];
                ++actualSize;
            }
            ++i;
        }
        CategoryRankingInfo[] actual = new CategoryRankingInfo[actualSize];
        System.arraycopy(ret, 0, actual, 0, actualSize);
        return actual;
    }

    public static CategoryRankingInfo[] makeInfoFromElementSet(CategoryRankingElementSet elementSet) {
        if (elementSet == null) {
            return new CategoryRankingInfo[0];
        }
        CategoryRankingElement[] elements = elementSet.getCategoryElements();
        int numCategory = 0;
        if (elements != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] != null) {
                    numCategory += elements[i].getCategories();
                }
                ++i;
            }
        }
        if (numCategory == 0) {
            return new CategoryRankingInfo[0];
        }
        CategoryRankingInfo[] rankingInfos = new CategoryRankingInfo[numCategory];
        int index = 0;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] != null) {
                int categories = elements[i].getCategories();
                int j = 0;
                while (j < categories) {
                    rankingInfos[index++] = new CategoryRankingInfo(elements[i].getCategory(j), elements[i].getField(j), elements[i].getType(j), elements[i].getWeight(j));
                    ++j;
                }
            }
            ++i;
        }
        return rankingInfos;
    }
}

