/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.simulation;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.msg.simulation.CategoryRankingInfo;
import com.diquest.ir.common.msg.simulation.DocumentRankingInfo;
import com.diquest.ir.common.msg.simulation.FieldResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DocumentResult {
    private String docID;
    private FieldResult[] fields;
    private DocumentRankingInfo documentRankingInfo;
    private CategoryRankingInfo[] categoryRankingInfo;
    private int weightSum;

    public DocumentResult(FieldResult[] fields, DocumentRankingInfo documentRankingInfo, CategoryRankingInfo[] categoryRankingInfo, int weightSum) {
        this.docID = null;
        this.fields = fields;
        this.documentRankingInfo = documentRankingInfo;
        this.categoryRankingInfo = categoryRankingInfo;
        this.weightSum = weightSum;
    }

    public DocumentResult(String docID, FieldResult[] fields, DocumentRankingInfo documentRankingInfo, CategoryRankingInfo[] categoryRankingInfo, int weightSum) {
        this.docID = docID;
        this.fields = fields;
        this.documentRankingInfo = documentRankingInfo;
        this.categoryRankingInfo = categoryRankingInfo;
        this.weightSum = weightSum;
    }

    public boolean hasDocumentRanking() {
        return this.documentRankingInfo != null;
    }

    public boolean hasCategoryRanking() {
        return this.categoryRankingInfo != null && this.categoryRankingInfo.length != 0;
    }

    public boolean isDeleted() {
        if (this.documentRankingInfo != null && this.documentRankingInfo.getType() == 3) {
            return true;
        }
        if (this.categoryRankingInfo == null || this.categoryRankingInfo.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.categoryRankingInfo.length) {
            if (this.categoryRankingInfo[i].getType() == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.docID);
        ByteUtil.writeInt((OutputStream)out, (int)this.fields.length);
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i].serialize(out);
            ++i;
        }
        if (this.documentRankingInfo == null) {
            ByteUtil.writeByte((OutputStream)out, (byte)0);
        } else {
            ByteUtil.writeByte((OutputStream)out, (byte)1);
            this.documentRankingInfo.serialize(out);
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.categoryRankingInfo.length);
        i = 0;
        while (i < this.categoryRankingInfo.length) {
            this.categoryRankingInfo[i].serialize(out);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.weightSum);
    }

    public static DocumentResult deserialize(InputStream in) throws IOException {
        String docID = ByteUtil.readString((InputStream)in);
        int fieldLength = ByteUtil.readInt((InputStream)in);
        FieldResult[] fields = new FieldResult[fieldLength];
        int i = 0;
        while (i < fieldLength) {
            fields[i] = FieldResult.deserialize(in);
            ++i;
        }
        DocumentRankingInfo documentRankingInfo = null;
        if (ByteUtil.readByte((InputStream)in) == 1) {
            documentRankingInfo = DocumentRankingInfo.deserialize(in);
        }
        int categoryRankingInfoLength = ByteUtil.readInt((InputStream)in);
        CategoryRankingInfo[] categoryRankingInfo = new CategoryRankingInfo[categoryRankingInfoLength];
        int i2 = 0;
        while (i2 < categoryRankingInfoLength) {
            categoryRankingInfo[i2] = CategoryRankingInfo.deserialize(in);
            ++i2;
        }
        int weightSum = ByteUtil.readInt((InputStream)in);
        return new DocumentResult(docID, fields, documentRankingInfo, categoryRankingInfo, weightSum);
    }

    public FieldResult[] getFields() {
        return this.fields;
    }

    public void setFields(FieldResult[] fields) {
        this.fields = fields;
    }

    public int getWeightSum() {
        return this.weightSum;
    }

    public void setWeightSum(int weightSum) {
        this.weightSum = weightSum;
    }

    public DocumentRankingInfo getDocumentRankingInfo() {
        return this.documentRankingInfo;
    }

    public CategoryRankingInfo[] getCategoryRankingInfo() {
        return this.categoryRankingInfo;
    }

    public String getDocID() {
        return this.docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }
}

