/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.simulation;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.msg.simulation.SearchExpression;
import com.diquest.ir.common.msg.simulation.TermInfo;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExtractedResult
extends Transmitable {
    private TermInfo[] inputTerms;
    private int extractorSize;
    private String[][] extractorTypes;
    private TermInfo[][] extractedTerms;
    private TermInfo[][][] extendedResults;
    private SearchExpression[] expressions;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.msg.simulation.ExtractedResult");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ExtractedResult() {
    }

    public ExtractedResult(TermInfo[] inputTerms, String[][] extractorTypes, TermInfo[][] extractedTerms, TermInfo[][][] extendedResults, SearchExpression[] expressions) {
        this.inputTerms = inputTerms;
        this.extractorSize = extractorTypes.length;
        this.extractorTypes = extractorTypes;
        this.extractedTerms = extractedTerms;
        this.extendedResults = extendedResults;
        this.expressions = expressions;
        if (!$assertionsDisabled && this.extractorSize != extractorTypes.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.extractorSize != extractedTerms.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.extractorSize != extendedResults.length) {
            throw new AssertionError();
        }
    }

    public String toString() {
        int j;
        StringBuffer buf = new StringBuffer();
        buf.append("Search Terms :\n");
        int i = 0;
        while (i < this.inputTerms.length) {
            buf.append(this.inputTerms[i].getTerm());
            buf.append(this.inputTerms[i].isBannedWord() ? "(Banned)" : "");
            buf.append(this.inputTerms[i].isStopword() ? "(Stopword)" : "");
            buf.append(this.inputTerms[i].isWeightFeature() ? "(Weight)" : "");
            buf.append(' ');
            ++i;
        }
        buf.append('\n');
        buf.append("Extracted Terms :\n");
        i = 0;
        while (i < this.extractorSize) {
            j = 0;
            while (j < this.extractorTypes[i].length) {
                buf.append(this.extractorTypes[i][j]).append(' ');
                ++j;
            }
            buf.append(": ");
            j = 0;
            while (j < this.extractedTerms[i].length) {
                buf.append(this.extractedTerms[i][j].getTerm());
                buf.append(this.extractedTerms[i][j].isBannedWord() ? "(Banned)" : "");
                buf.append(this.extractedTerms[i][j].isStopword() ? "(Stopword)" : "");
                buf.append(this.extractedTerms[i][j].isWeightFeature() ? "(Weight)" : "");
                buf.append(' ');
                ++j;
            }
            buf.append('\n');
            ++i;
        }
        buf.append("Extended Terms :\n");
        i = 0;
        while (i < this.extractorSize) {
            j = 0;
            while (j < this.extractorTypes[i].length) {
                buf.append(this.extractorTypes[i][j]).append(' ');
                ++j;
            }
            buf.append('\n');
            j = 0;
            while (j < this.extendedResults[i].length) {
                buf.append("(" + (j + 1) + ") ");
                buf.append(this.extendedResults[i][j][0].getTerm());
                buf.append(this.extendedResults[i][j][0].isBannedWord() ? "(Banned)" : "");
                buf.append(this.extendedResults[i][j][0].isStopword() ? "(Stopword)" : "");
                buf.append(this.extendedResults[i][j][0].isWeightFeature() ? "(Weight)" : "");
                buf.append("->");
                int k = 1;
                while (k < this.extendedResults[i][j].length) {
                    buf.append(' ');
                    buf.append(this.extendedResults[i][j][k].getTerm());
                    buf.append(this.extendedResults[i][j][k].isBannedWord() ? "(Banned)" : "");
                    buf.append(this.extendedResults[i][j][k].isStopword() ? "(Stopword)" : "");
                    buf.append(this.extendedResults[i][j][k].isWeightFeature() ? "(Weight)" : "");
                    ++k;
                }
                buf.append('\n');
                ++j;
            }
            ++i;
        }
        buf.append("Expressions : \n");
        i = 0;
        while (i < this.expressions.length) {
            String[] extractor = this.expressions[i].getExtractorType();
            int j2 = 0;
            while (j2 < extractor.length) {
                buf.append(extractor[j2]).append(' ');
                ++j2;
            }
            buf.append(": ");
            j2 = 0;
            while (j2 < this.expressions[i].getFields().length) {
                buf.append(this.expressions[i].getFields()[j2]).append(' ');
                ++j2;
            }
            buf.append('\n');
            buf.append(this.expressions[i].getExpression());
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeVbInt((OutputStream)out, (int)this.inputTerms.length);
        int i = 0;
        while (i < this.inputTerms.length) {
            this.inputTerms[i].serialize(out);
            ++i;
        }
        ByteUtil.writeVbInt((OutputStream)out, (int)this.extractorSize);
        i = 0;
        while (i < this.extractorSize) {
            ByteUtil.writeVbInt((OutputStream)out, (int)this.extractorTypes[i].length);
            int j = 0;
            while (j < this.extractorTypes[i].length) {
                ByteUtil.writeString((OutputStream)out, (String)this.extractorTypes[i][j]);
                ++j;
            }
            ByteUtil.writeVbInt((OutputStream)out, (int)this.extractedTerms[i].length);
            j = 0;
            while (j < this.extractedTerms[i].length) {
                this.extractedTerms[i][j].serialize(out);
                ++j;
            }
            ByteUtil.writeVbInt((OutputStream)out, (int)this.extendedResults[i].length);
            j = 0;
            while (j < this.extendedResults[i].length) {
                ByteUtil.writeVbInt((OutputStream)out, (int)this.extendedResults[i][j].length);
                int k = 0;
                while (k < this.extendedResults[i][j].length) {
                    this.extendedResults[i][j][k].serialize(out);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        ByteUtil.writeVbInt((OutputStream)out, (int)this.expressions.length);
        i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].serialize(out);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        int inputTermsLength = ByteUtil.readVbInt((InputStream)in);
        this.inputTerms = new TermInfo[inputTermsLength];
        int i = 0;
        while (i < inputTermsLength) {
            this.inputTerms[i] = TermInfo.deserialize(in);
            ++i;
        }
        this.extractorSize = ByteUtil.readVbInt((InputStream)in);
        this.extractorTypes = new String[this.extractorSize][];
        this.extractedTerms = new TermInfo[this.extractorSize][];
        this.extendedResults = new TermInfo[this.extractorSize][][];
        i = 0;
        while (i < this.extractorSize) {
            int extractorLength = ByteUtil.readVbInt((InputStream)in);
            this.extractorTypes[i] = new String[extractorLength];
            int j = 0;
            while (j < extractorLength) {
                this.extractorTypes[i][j] = ByteUtil.readString((InputStream)in);
                ++j;
            }
            int extractedTermsLength = ByteUtil.readVbInt((InputStream)in);
            this.extractedTerms[i] = new TermInfo[extractedTermsLength];
            int j2 = 0;
            while (j2 < extractedTermsLength) {
                this.extractedTerms[i][j2] = TermInfo.deserialize(in);
                ++j2;
            }
            int extendedResultLength = ByteUtil.readVbInt((InputStream)in);
            this.extendedResults[i] = new TermInfo[extendedResultLength][];
            int j3 = 0;
            while (j3 < extendedResultLength) {
                int extendedResultLengthSub = ByteUtil.readVbInt((InputStream)in);
                this.extendedResults[i][j3] = new TermInfo[extendedResultLengthSub];
                int k = 0;
                while (k < extendedResultLengthSub) {
                    this.extendedResults[i][j3][k] = TermInfo.deserialize(in);
                    ++k;
                }
                ++j3;
            }
            ++i;
        }
        int expressionSize = ByteUtil.readVbInt((InputStream)in);
        this.expressions = new SearchExpression[expressionSize];
        int i2 = 0;
        while (i2 < expressionSize) {
            this.expressions[i2] = SearchExpression.deserialize(in);
            ++i2;
        }
    }

    public TermInfo[] getInputTerms() {
        return this.inputTerms;
    }

    public void setInputTerms(TermInfo[] inputTerms) {
        this.inputTerms = inputTerms;
    }

    public TermInfo[][] getExtractedTerms() {
        return this.extractedTerms;
    }

    public void setExtractedTerms(TermInfo[][] extractedTerms) {
        this.extractedTerms = extractedTerms;
    }

    public TermInfo[][][] getExtendedResults() {
        return this.extendedResults;
    }

    public void setExtendedResults(TermInfo[][][] extendedResults) {
        this.extendedResults = extendedResults;
    }

    public Transmitable getInstance() {
        return new ExtractedResult();
    }

    public boolean isNull() {
        return false;
    }

    public int getExtractorSize() {
        return this.extractorSize;
    }

    public void setExtractorSize(int extractorSize) {
        this.extractorSize = extractorSize;
    }

    public SearchExpression[] getExpressions() {
        return this.expressions;
    }

    public void setExpressions(SearchExpression[] expressions) {
        this.expressions = expressions;
    }

    public String[][] getExtractorTypes() {
        return this.extractorTypes;
    }

    public void setExtractorTypes(String[][] extractorTypes) {
        this.extractorTypes = extractorTypes;
    }
}

