/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.simulation;

import com.diquest.commons.type.ByteUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FieldResult {
    private byte fieldType;
    private String fieldName;
    private String[] fieldKeywords;
    private int[] typeWeights;
    private int weightSum;

    public FieldResult(byte fieldType, String fieldName, String[] fieldKeywords, int[] typeWeights, int weightSum) {
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.fieldKeywords = fieldKeywords;
        this.typeWeights = typeWeights;
        this.weightSum = weightSum;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[TYPE=" + this.fieldType + "]");
        buf.append("[FIELDNAME=" + this.fieldName + "]");
        buf.append(' ');
        int i = 0;
        while (i < this.fieldKeywords.length) {
            buf.append(this.fieldKeywords[i]);
            if (this.typeWeights.length == this.fieldKeywords.length) {
                buf.append("(" + this.typeWeights[i] + ")");
            }
            buf.append(' ');
            ++i;
        }
        buf.append("WEIGHTSUM=" + this.weightSum);
        return buf.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        int i;
        ByteUtil.writeByte((OutputStream)out, (byte)this.fieldType);
        ByteUtil.writeString((OutputStream)out, (String)this.fieldName);
        if (this.fieldKeywords == null) {
            ByteUtil.writeBoolean((OutputStream)out, (boolean)false);
        } else {
            ByteUtil.writeBoolean((OutputStream)out, (boolean)true);
            ByteUtil.writeVbInt((OutputStream)out, (int)this.fieldKeywords.length);
            i = 0;
            while (i < this.fieldKeywords.length) {
                ByteUtil.writeString((OutputStream)out, (String)this.fieldKeywords[i]);
                ++i;
            }
        }
        if (this.typeWeights == null) {
            ByteUtil.writeBoolean((OutputStream)out, (boolean)false);
        } else {
            ByteUtil.writeBoolean((OutputStream)out, (boolean)true);
            ByteUtil.writeVbInt((OutputStream)out, (int)this.typeWeights.length);
            i = 0;
            while (i < this.typeWeights.length) {
                ByteUtil.writeInt((OutputStream)out, (int)this.typeWeights[i]);
                ++i;
            }
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.weightSum);
    }

    public static FieldResult deserialize(InputStream in) throws IOException {
        byte fieldType = ByteUtil.readByte((InputStream)in);
        String fieldName = ByteUtil.readString((InputStream)in);
        String[] fieldKeywords = null;
        boolean fieldKeywordsExists = ByteUtil.readBoolean((InputStream)in);
        if (fieldKeywordsExists) {
            int fieldKeywordsLength = ByteUtil.readVbInt((InputStream)in);
            fieldKeywords = new String[fieldKeywordsLength];
            int i = 0;
            while (i < fieldKeywordsLength) {
                fieldKeywords[i] = ByteUtil.readString((InputStream)in);
                ++i;
            }
        }
        int[] typeWeights = null;
        boolean typeWeightsExists = ByteUtil.readBoolean((InputStream)in);
        if (typeWeightsExists) {
            int typeWeightsLength = ByteUtil.readVbInt((InputStream)in);
            typeWeights = new int[typeWeightsLength];
            int i = 0;
            while (i < typeWeightsLength) {
                typeWeights[i] = ByteUtil.readInt((InputStream)in);
                ++i;
            }
        }
        int weightSum = ByteUtil.readInt((InputStream)in);
        return new FieldResult(fieldType, fieldName, fieldKeywords, typeWeights, weightSum);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldKeywords() {
        return this.fieldKeywords;
    }

    public void setFieldKeywords(String[] fieldKeywords) {
        this.fieldKeywords = fieldKeywords;
    }

    public int[] getTypeWeights() {
        return this.typeWeights;
    }

    public void setTypeWeights(int[] typeWeights) {
        this.typeWeights = typeWeights;
    }

    public int getWeightSum() {
        return this.weightSum;
    }

    public void setWeightSum(int weightSum) {
        this.weightSum = weightSum;
    }

    public byte getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(byte fieldType) {
        this.fieldType = fieldType;
    }
}

