/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.simulation;

import com.diquest.commons.type.ByteUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SearchExpression {
    private String[] extractorType;
    private String[] fields;
    private String expression;

    public SearchExpression(String[] extractorType, String[] fields, String expression) {
        this.extractorType = extractorType;
        this.fields = fields;
        this.expression = expression;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SearchExpression) {
            SearchExpression destObj = (SearchExpression)obj;
            if (this.extractorType.length != destObj.extractorType.length || this.fields.length != destObj.fields.length || !this.expression.equals(destObj.expression)) {
                return false;
            }
            int i = 0;
            while (i < this.extractorType.length) {
                if (!this.extractorType[i].equals(destObj.extractorType[i])) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.fields.length) {
                if (!this.fields[i].equals(destObj.fields[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.extractorType[0]);
        ByteUtil.writeString((OutputStream)out, (String)this.extractorType[1]);
        ByteUtil.writeString((OutputStream)out, (String)this.extractorType[2]);
        ByteUtil.writeString((OutputStream)out, (String)this.extractorType[3]);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.fields.length);
        int i = 0;
        while (i < this.fields.length) {
            ByteUtil.writeString((OutputStream)out, (String)this.fields[i]);
            ++i;
        }
        ByteUtil.writeString((OutputStream)out, (String)this.expression);
    }

    public static SearchExpression deserialize(InputStream in) throws IOException {
        String[] extractorType = new String[]{ByteUtil.readString((InputStream)in), ByteUtil.readString((InputStream)in), ByteUtil.readString((InputStream)in), ByteUtil.readString((InputStream)in)};
        int fieldSize = ByteUtil.readVbInt((InputStream)in);
        String[] fields = new String[fieldSize];
        int i = 0;
        while (i < fieldSize) {
            fields[i] = ByteUtil.readString((InputStream)in);
            ++i;
        }
        String expression = ByteUtil.readString((InputStream)in);
        return new SearchExpression(extractorType, fields, expression);
    }

    public String[] getExtractorType() {
        return this.extractorType;
    }

    public void setExtractorType(String[] extractorType) {
        this.extractorType = extractorType;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

