/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.simulation;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.msg.simulation.CategoryRankingInfo;
import com.diquest.ir.common.msg.simulation.DocumentResult;
import com.diquest.ir.common.msg.simulation.FieldResult;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SimulationDocuments
extends Transmitable {
    private DocumentResult[] documents;

    public SimulationDocuments() {
    }

    public SimulationDocuments(DocumentResult[] documents) {
        this.documents = documents;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeVbInt((OutputStream)out, (int)this.documents.length);
        int i = 0;
        while (i < this.documents.length) {
            this.documents[i].serialize(out);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        int documentsLength = ByteUtil.readVbInt((InputStream)in);
        this.documents = new DocumentResult[documentsLength];
        int i = 0;
        while (i < documentsLength) {
            this.documents[i] = DocumentResult.deserialize(in);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new SimulationDocuments();
    }

    public boolean isNull() {
        return false;
    }

    public DocumentResult[] getDocuments() {
        return this.documents;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RESULT SIZE = " + this.documents.length).append('\n');
        int i = 0;
        while (i < this.documents.length) {
            buf.append("[" + i + "]th document ID=" + this.documents[i].getDocID() + "removed=" + this.documents[i].isDeleted() + "\n[FIELD RESULT]\n");
            FieldResult[] fields = this.documents[i].getFields();
            int f = 0;
            while (f < fields.length) {
                buf.append(fields[f].toString()).append('\n');
                ++f;
            }
            buf.append("[DOCUMENT RANKING]\n");
            if (this.documents[i].getDocumentRankingInfo() != null) {
                buf.append(this.documents[i].getDocumentRankingInfo().toString()).append('\n');
            }
            buf.append("[CATEGORY RANKING]\n");
            CategoryRankingInfo[] cats = this.documents[i].getCategoryRankingInfo();
            int c = 0;
            while (c < cats.length) {
                buf.append(cats[c].toString()).append('\n');
                ++c;
            }
            buf.append("[WEIGHT=" + this.documents[i].getWeightSum() + "]");
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }
}

