/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.simulation;

import com.diquest.commons.type.ByteUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TermInfo {
    private String term;
    private boolean stopword;
    private boolean bannedWord;
    private boolean weightFeature;

    public TermInfo(String term, boolean stopword, boolean bannedWord, boolean weightFeature) {
        this.term = term;
        this.stopword = stopword;
        this.bannedWord = bannedWord;
        this.weightFeature = weightFeature;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.term);
        buf.append(this.stopword ? "(stopword)" : "");
        buf.append(this.bannedWord ? "(bannedword)" : "");
        buf.append(this.weightFeature ? "(weight)" : "");
        return buf.toString();
    }

    public String getTerm() {
        return this.term;
    }

    public boolean isStopword() {
        return this.stopword;
    }

    public boolean isBannedWord() {
        return this.bannedWord;
    }

    public boolean isWeightFeature() {
        return this.weightFeature;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.term);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.stopword);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.bannedWord);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.weightFeature);
    }

    public static TermInfo deserialize(InputStream in) throws IOException {
        String term = ByteUtil.readString((InputStream)in);
        boolean stopword = ByteUtil.readBoolean((InputStream)in);
        boolean bannedWord = ByteUtil.readBoolean((InputStream)in);
        boolean weightFeature = ByteUtil.readBoolean((InputStream)in);
        return new TermInfo(term, stopword, bannedWord, weightFeature);
    }

    public boolean equals(Object obj) {
        TermInfo destObj = (TermInfo)obj;
        return this.term.equals(destObj.term) && this.stopword == destObj.stopword && this.bannedWord == destObj.bannedWord && this.weightFeature == destObj.weightFeature;
    }

    public void setStopword(boolean stopword) {
        this.stopword = stopword;
    }

    public void setBannedWord(boolean bannedWord) {
        this.bannedWord = bannedWord;
    }

    public void setWeightFeature(boolean weightFeature) {
        this.weightFeature = weightFeature;
    }
}

