/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.status;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class IndexingStatus
extends Transmitable
implements Comparable,
CollectionObservable {
    public static final IndexingStatus instance = new IndexingStatus();
    private static final String RECENT_STATUS_KEY = "";
    public static final Map instances = new HashMap();
    public static final int NOTHING = 0;
    public static final int INITIALIZE = 1;
    public static final int COLLECT = 2;
    public static final int REPOSITORY = 3;
    public static final int INDEX = 4;
    public static final int MIRRORING = 5;
    public static final int CHANGE = 6;
    public static final int FINISHED = 7;
    public static final int FAIL = 8;
    public static final String[] STATUS = new String[]{"NOTHING", "INITIALIZE", "COLLECT", "REPOSITORY", "INDEX", "MIRRORING", "CHANGE", "FINISHED", "FAIL"};
    private char indexType;
    private String currentCollection;
    private int currentStatus = 0;
    private int collectedDocuments;
    private int repositoryDocuments;
    private int indexDocuments;
    private int currentDocuments;
    private long lastUpdateTime;
    private long collectStartTime;
    private long collectEndTime;
    private long repositoryStartTime;
    private long repositoryEndTime;
    private long indexStartTime;
    private long indexEndTime;
    private int excuteType;
    public static final int AUTO = 1;
    public static final int MANUAL = 2;
    private boolean indexCancel = false;

    public static synchronized IndexingStatus getInstance(String collectionId) {
        Object instance = instances.get(collectionId);
        if (instance == null) {
            instance = new IndexingStatus(collectionId, 0, 0, System.currentTimeMillis());
            instances.put(collectionId, instance);
        }
        return (IndexingStatus)instance;
    }

    public IndexingStatus() {
    }

    public IndexingStatus(String currentCollection, int currentStatus, int currentDocuments, long lastUpdateTime) {
        this.currentCollection = currentCollection;
        this.currentStatus = currentStatus;
        this.currentDocuments = currentDocuments;
        this.lastUpdateTime = lastUpdateTime;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Type = " + this.indexType + "]\n");
        buf.append("[collectionID = " + this.currentCollection + "]\n");
        buf.append("[currentStatus= " + STATUS[this.currentStatus] + "]\n");
        buf.append("[collectedDocuments= " + this.collectedDocuments + "]\n");
        buf.append("[repositoryDocuments= " + this.repositoryDocuments + "]\n");
        buf.append("[indexDocuments= " + this.indexDocuments + "]\n");
        buf.append("[currentDocuments= " + this.currentDocuments + "]\n");
        buf.append("[lastUpdateTime= " + new Date(this.lastUpdateTime) + "]\n");
        return buf.toString();
    }

    public synchronized void set(int currentStatus, int currentDocuments, long lastUpdateTime) {
        this.checkUndoIndexCancel(currentStatus);
        if (currentStatus == 1) {
            this.collectedDocuments = 0;
            this.repositoryDocuments = 0;
            this.indexDocuments = 0;
            this.collectStartTime = 0L;
            this.collectEndTime = 0L;
            this.repositoryStartTime = 0L;
            this.repositoryEndTime = 0L;
            this.indexStartTime = 0L;
            this.indexEndTime = 0L;
        }
        if (currentStatus == 2) {
            this.collectedDocuments = currentDocuments;
            this.repositoryDocuments = 0;
            this.indexDocuments = 0;
        } else if (currentStatus == 3 && this.repositoryDocuments < currentDocuments) {
            this.repositoryDocuments = currentDocuments;
        } else if (currentStatus == 4 && this.indexDocuments < currentDocuments) {
            this.indexDocuments = currentDocuments;
        }
        this.currentStatus = currentStatus;
        this.currentDocuments = currentDocuments;
        this.lastUpdateTime = lastUpdateTime;
        this.updateRecentStatus(this);
    }

    public synchronized void updateResentStatus() {
        this.updateRecentStatus(this);
    }

    public synchronized void setCollectStartTime(long collectStartTime) {
        this.collectStartTime = collectStartTime;
    }

    public void setCurrentStatus(int currentStatus) {
        this.currentStatus = currentStatus;
    }

    public synchronized void setCollectEndTime(long collectEndTime) {
        this.collectEndTime = collectEndTime;
    }

    public synchronized void setRepositoryStartTime(long repositoryStartTime) {
        this.repositoryStartTime = repositoryStartTime;
    }

    public synchronized void setRepositoryEndTime(long repositoryEndTime) {
        this.repositoryEndTime = repositoryEndTime;
    }

    public synchronized void setIndexStartTime(long indexStartTime) {
        this.indexStartTime = indexStartTime;
    }

    public synchronized void setIndexEndTime(long indexEndTime) {
        this.indexEndTime = indexEndTime;
    }

    public synchronized void setExcuteType(int excuteType) {
        this.excuteType = excuteType;
    }

    private synchronized void checkUndoIndexCancel(int currentStatus) {
        if ((currentStatus == 7 || currentStatus == 8 || currentStatus == 1 || currentStatus == 0) && this.indexCancel) {
            System.out.println("[CANCEL] Previous index cancel command was ignored.");
            this.indexCancel = false;
        }
    }

    public synchronized void add(int currentStatus, int plusDocuments, long lastUpdateTime) {
        this.checkUndoIndexCancel(currentStatus);
        if (currentStatus == 2 && plusDocuments != 0) {
            this.collectedDocuments = this.collectedDocuments <= 0 ? plusDocuments : (this.collectedDocuments += plusDocuments);
            this.repositoryDocuments = 0;
            this.indexDocuments = 0;
            this.currentDocuments = this.collectedDocuments;
        }
        this.lastUpdateTime = lastUpdateTime;
        this.updateRecentStatus(this);
    }

    private synchronized void updateRecentStatus(IndexingStatus indexingStatus) {
        instances.put(RECENT_STATUS_KEY, indexingStatus);
    }

    public synchronized void set(String currentCollection, int currentStatus, int currentDocuments, long lastUpdateTime) {
        if (currentStatus == 1) {
            this.collectedDocuments = 0;
            this.repositoryDocuments = 0;
            this.indexDocuments = 0;
        }
        if (currentStatus == 2 && (this.collectedDocuments < currentDocuments || currentDocuments != 0)) {
            this.collectedDocuments = currentDocuments;
            this.repositoryDocuments = 0;
            this.indexDocuments = 0;
        } else if (currentStatus == 3 && this.repositoryDocuments < currentDocuments) {
            this.repositoryDocuments = currentDocuments;
        } else if (currentStatus == 4 && this.indexDocuments < currentDocuments) {
            this.indexDocuments = currentDocuments;
        }
        this.currentCollection = currentCollection;
        this.currentStatus = currentStatus;
        this.currentDocuments = currentDocuments;
        this.lastUpdateTime = lastUpdateTime;
    }

    public Transmitable getInstance() {
        return new IndexingStatus();
    }

    public synchronized boolean isNull() {
        return false;
    }

    public synchronized void serialize(OutputStream out) throws IOException {
        ByteUtil.writeChar((OutputStream)out, (char)this.indexType);
        ByteUtil.writeString((OutputStream)out, (String)this.currentCollection);
        ByteUtil.writeInt((OutputStream)out, (int)this.currentStatus);
        ByteUtil.writeInt((OutputStream)out, (int)this.collectedDocuments);
        ByteUtil.writeInt((OutputStream)out, (int)this.repositoryDocuments);
        ByteUtil.writeInt((OutputStream)out, (int)this.indexDocuments);
        ByteUtil.writeInt((OutputStream)out, (int)this.currentDocuments);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.lastUpdateTime);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.collectStartTime);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.collectEndTime);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.repositoryStartTime);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.repositoryEndTime);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.indexStartTime);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.indexEndTime);
        ByteUtil.writeInt((OutputStream)out, (int)this.excuteType);
    }

    public synchronized void deserialize(InputStream in) throws IOException {
        this.indexType = ByteUtil.readChar((InputStream)in);
        this.currentCollection = ByteUtil.readString((InputStream)in);
        this.currentStatus = ByteUtil.readInt((InputStream)in);
        this.collectedDocuments = ByteUtil.readInt((InputStream)in);
        this.repositoryDocuments = ByteUtil.readInt((InputStream)in);
        this.indexDocuments = ByteUtil.readInt((InputStream)in);
        this.currentDocuments = ByteUtil.readInt((InputStream)in);
        this.lastUpdateTime = ByteUtil.readVbLong((InputStream)in);
        this.collectStartTime = ByteUtil.readVbLong((InputStream)in);
        this.collectEndTime = ByteUtil.readVbLong((InputStream)in);
        this.repositoryStartTime = ByteUtil.readVbLong((InputStream)in);
        this.repositoryEndTime = ByteUtil.readVbLong((InputStream)in);
        this.indexStartTime = ByteUtil.readVbLong((InputStream)in);
        this.indexEndTime = ByteUtil.readVbLong((InputStream)in);
        this.excuteType = ByteUtil.readInt((InputStream)in);
    }

    public synchronized long getCollectStartTime() {
        return this.collectStartTime;
    }

    public synchronized long getCollectEndTime() {
        return this.collectEndTime;
    }

    public synchronized long getRepositoryStartTime() {
        return this.repositoryStartTime;
    }

    public synchronized long getRepositoryEndTime() {
        return this.repositoryEndTime;
    }

    public synchronized long getIndexStartTime() {
        return this.indexStartTime;
    }

    public synchronized long getIndexEndTime() {
        return this.indexEndTime;
    }

    public synchronized int getExcuteType() {
        return this.excuteType;
    }

    public synchronized String getCurrentCollection() {
        return this.currentCollection;
    }

    public synchronized int getCurrentDocuments() {
        return this.currentDocuments;
    }

    public synchronized int getCurrentStatus() {
        return this.currentStatus;
    }

    public synchronized long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public synchronized int compareTo(Object o) {
        long tp = this.lastUpdateTime - ((IndexingStatus)o).lastUpdateTime;
        if (tp > 0L) {
            return -1;
        }
        return 1;
    }

    public synchronized char getIndexType() {
        return this.indexType;
    }

    public synchronized void setIndexType(char indexType) {
        this.indexType = indexType;
    }

    public synchronized int getCollectedDocuments() {
        return this.collectedDocuments;
    }

    public synchronized int getIndexDocuments() {
        return this.indexDocuments;
    }

    public synchronized int getRepositoryDocuments() {
        return this.repositoryDocuments;
    }

    public synchronized void setCollectedDocuments(int collectedDocuments) {
        this.collectedDocuments = collectedDocuments;
    }

    public synchronized void setIndexDocuments(int indexDocuments) {
        this.indexDocuments = indexDocuments;
    }

    public synchronized void setRepositoryDocuments(int repositoryDocuments) {
        this.repositoryDocuments = repositoryDocuments;
    }

    public IndexingStatus getCopy() {
        IndexingStatus indexingStatus = new IndexingStatus();
        indexingStatus.collectedDocuments = this.collectedDocuments;
        indexingStatus.currentCollection = this.currentCollection;
        indexingStatus.currentDocuments = this.currentDocuments;
        indexingStatus.currentStatus = this.currentStatus;
        indexingStatus.indexDocuments = this.indexDocuments;
        indexingStatus.indexType = this.indexType;
        indexingStatus.lastUpdateTime = this.lastUpdateTime;
        indexingStatus.repositoryDocuments = this.repositoryDocuments;
        indexingStatus.collectStartTime = this.collectStartTime;
        indexingStatus.collectEndTime = this.collectEndTime;
        indexingStatus.repositoryStartTime = this.repositoryStartTime;
        indexingStatus.repositoryEndTime = this.repositoryEndTime;
        indexingStatus.indexStartTime = this.indexStartTime;
        indexingStatus.indexEndTime = this.indexEndTime;
        indexingStatus.excuteType = this.excuteType;
        return indexingStatus;
    }

    public static synchronized IndexingStatus getCopyOf(String collectionId) {
        IndexingStatus instance = IndexingStatus.getInstance(collectionId);
        return instance.getCopy();
    }

    public static synchronized IndexingStatus getRecentStatusCopy() {
        IndexingStatus instance = IndexingStatus.getInstance(RECENT_STATUS_KEY);
        return instance.getCopy();
    }

    public synchronized void setIndexCancel(boolean isCancel) {
        this.indexCancel = isCancel;
    }

    public synchronized void setAndCheckCancel(int currentStatus, int currentDocuments, long lastUpdateTime) throws IRException {
        this.set(currentStatus, currentDocuments, lastUpdateTime);
        if (this.indexCancel) {
            this.indexCancel = false;
            throw new IRException(2, "Cannot cancel Indexing");
        }
    }

    public synchronized void addAndCheckCancel(int currentStatus, int plusDocuments, long lastUpdateTime) throws IRException {
        this.add(currentStatus, plusDocuments, lastUpdateTime);
        if (this.indexCancel) {
            this.indexCancel = false;
            throw new IRException(2, "Cannot Cancel Indexing");
        }
    }

    public static synchronized void reload(Collection collections) {
        HashSet<String> all = new HashSet<String>(collections.size() << 1);
        all.addAll(collections);
        all.add(RECENT_STATUS_KEY);
        instances.keySet().retainAll(all);
    }

    public synchronized void onAdd(String collection) throws IRException, InterruptedException {
    }

    public synchronized void onAddBefore(String collection) {
    }

    public synchronized void onModify(String collection) throws IRException, InterruptedException {
    }

    public synchronized void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public synchronized void onRemove(String collection) throws IRException {
        instances.remove(collection);
    }

    public synchronized void onRemoveBefore(String collection) throws IRException {
    }
}

