/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.status;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryStatus
extends Transmitable {
    private long M = 0x100000L;
    private long[][] sec;
    private long[][] min;
    private long[][] hour;
    private long maxUsed;

    public MemoryStatus(long[][] sec, long[][] min, long[][] hour, long maxUsed) {
        this.sec = sec;
        this.min = min;
        this.hour = hour;
    }

    public MemoryStatus() {
        this.sec = new long[3][60];
        this.min = new long[4][60];
        this.hour = new long[4][24];
        this.maxUsed = 0L;
    }

    public void setStatus(long[][] sec, long[][] min, long[][] hour, long maxUsed) {
        this.sec = sec;
        this.min = min;
        this.hour = hour;
        this.maxUsed = maxUsed;
    }

    public Transmitable getInstance() {
        return new MemoryStatus();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SEC MAX : \n");
        int i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.sec[0][i] / this.M) + " ");
            ++i;
        }
        buf.append("\nSEC CUR : \n");
        i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.sec[1][i] / this.M) + " ");
            ++i;
        }
        buf.append("\nSEC USED : \n");
        i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.sec[2][i] / this.M) + " ");
            ++i;
        }
        buf.append("------------------------------------------------------------\n");
        buf.append("MIN MAX : \n");
        i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.min[0][i] / this.M) + " ");
            ++i;
        }
        buf.append("\nMIN CUR : \n");
        i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.min[1][i] / this.M) + " ");
            ++i;
        }
        buf.append("\nMIN USED : \n");
        i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.min[2][i] / this.M) + " ");
            ++i;
        }
        buf.append("\nMIN MAX USED : \n");
        i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.min[3][i] / this.M) + " ");
            ++i;
        }
        buf.append("------------------------------------------------------------\n");
        buf.append("HOUR MAX : \n");
        i = 0;
        while (i < 24) {
            buf.append(String.valueOf(this.hour[0][i] / this.M) + " ");
            ++i;
        }
        buf.append("\nHOUR CUR : \n");
        i = 0;
        while (i < 24) {
            buf.append(String.valueOf(this.hour[1][i] / this.M) + " ");
            ++i;
        }
        buf.append("\nHOUR USED : \n");
        i = 0;
        while (i < 24) {
            buf.append(String.valueOf(this.hour[2][i] / this.M) + " ");
            ++i;
        }
        buf.append("\nHOUR MAX USED : \n");
        i = 0;
        while (i < 24) {
            buf.append(String.valueOf(this.hour[3][i] / this.M) + " ");
            ++i;
        }
        buf.append("------------------------------------------------------------\n");
        buf.append("MAX USED MEMORY in this process : " + this.maxUsed / this.M + "\n");
        return buf.toString();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        int j;
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 60) {
                ByteUtil.writeVbLong((OutputStream)out, (long)this.sec[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 60) {
                ByteUtil.writeVbLong((OutputStream)out, (long)this.min[i][j]);
                ++j;
            }
            j = 0;
            while (j < 24) {
                ByteUtil.writeVbLong((OutputStream)out, (long)this.hour[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        int j;
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 60) {
                this.sec[i][j] = ByteUtil.readVbLong((InputStream)in);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 60) {
                this.min[i][j] = ByteUtil.readVbLong((InputStream)in);
                ++j;
            }
            j = 0;
            while (j < 24) {
                this.hour[i][j] = ByteUtil.readVbLong((InputStream)in);
                ++j;
            }
            ++i;
        }
    }

    public long[][] getHour() {
        return this.hour;
    }

    public long[][] getMin() {
        return this.min;
    }

    public long[][] getSec() {
        return this.sec;
    }

    public static int getMaxIndex() {
        return 0;
    }

    public static int getCurrIndex() {
        return 1;
    }

    public static int getUsedIndex() {
        return 2;
    }

    public static int getMaxUsedIndex() {
        return 3;
    }

    public long getMaxUsed() {
        return this.maxUsed;
    }
}

