/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.status;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class QueryStatus
extends Transmitable {
    private int[] sec;
    private int[] min;
    private int[] hour;
    private int[] maxMin;
    private int[] maxHour;
    private int maxQuery;

    public QueryStatus(int[] sec, int[] min, int[] maxMin, int[] hour, int[] maxHour, int maxQuery) {
        this.sec = sec;
        int i = 0;
        while (i < min.length) {
            int n = i++;
            min[n] = min[n] / 60;
        }
        this.min = min;
        i = 0;
        while (i < hour.length) {
            int n = i++;
            hour[n] = hour[n] / 3600;
        }
        this.hour = hour;
        this.maxMin = maxMin;
        this.maxHour = maxHour;
        this.maxQuery = maxQuery;
    }

    public QueryStatus() {
        this.sec = new int[60];
        this.min = new int[60];
        this.hour = new int[24];
        this.maxMin = new int[60];
        this.maxHour = new int[24];
        this.maxQuery = 0;
    }

    public void setStatus(int[] sec, int[] min, int[] maxMin, int[] hour, int[] maxHour, int maxQuery) {
        this.sec = sec;
        this.min = min;
        this.hour = hour;
        this.maxMin = maxMin;
        this.maxHour = maxHour;
        this.maxQuery = maxQuery;
    }

    public Transmitable getInstance() {
        return new QueryStatus();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SEC : \n");
        int i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.sec[i]) + " ");
            ++i;
        }
        buf.append("\n------------------------------------------------------------\n");
        buf.append("MIN : \n");
        i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.min[i]) + " ");
            ++i;
        }
        buf.append("MAX MIN : \n");
        i = 0;
        while (i < 60) {
            buf.append(String.valueOf(this.maxMin[i]) + " ");
            ++i;
        }
        buf.append("\n------------------------------------------------------------\n");
        buf.append("HOUR : \n");
        i = 0;
        while (i < 24) {
            buf.append(String.valueOf(this.hour[i]) + " ");
            ++i;
        }
        buf.append("MAX HOUR : \n");
        i = 0;
        while (i < 24) {
            buf.append(String.valueOf(this.maxHour[i]) + " ");
            ++i;
        }
        return buf.toString();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        int i = 0;
        while (i < 60) {
            ByteUtil.writeVbInt((OutputStream)out, (int)this.sec[i]);
            ++i;
        }
        i = 0;
        while (i < 60) {
            ByteUtil.writeVbInt((OutputStream)out, (int)this.min[i]);
            ByteUtil.writeVbInt((OutputStream)out, (int)this.maxMin[i]);
            ++i;
        }
        i = 0;
        while (i < 24) {
            ByteUtil.writeVbInt((OutputStream)out, (int)this.hour[i]);
            ByteUtil.writeVbInt((OutputStream)out, (int)this.maxHour[i]);
            ++i;
        }
        ByteUtil.writeVbInt((OutputStream)out, (int)this.maxQuery);
    }

    public void deserialize(InputStream in) throws IOException {
        int j = 0;
        while (j < 60) {
            this.sec[j] = ByteUtil.readVbInt((InputStream)in);
            ++j;
        }
        j = 0;
        while (j < 60) {
            this.min[j] = ByteUtil.readVbInt((InputStream)in);
            this.maxMin[j] = ByteUtil.readVbInt((InputStream)in);
            ++j;
        }
        j = 0;
        while (j < 24) {
            this.hour[j] = ByteUtil.readVbInt((InputStream)in);
            this.maxHour[j] = ByteUtil.readVbInt((InputStream)in);
            ++j;
        }
        this.maxQuery = ByteUtil.readVbInt((InputStream)in);
    }

    public int[] getHour() {
        return this.hour;
    }

    public int[] getMin() {
        return this.min;
    }

    public int[] getSec() {
        return this.sec;
    }

    public int[] getMaxMin() {
        return this.maxMin;
    }

    public int[] getMaxHour() {
        return this.maxHour;
    }

    public int getMaxQuery() {
        return this.maxQuery;
    }
}

