/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.msg.status;

import com.diquest.ir.common.msg.status.MemoryStatus;
import com.diquest.ir.common.msg.status.QueryStatus;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SystemStatus
extends Transmitable {
    private String serverName;
    private int serverGroup;
    private int serverID;
    private String serverIP;
    private int cpus;
    private int activeThreads;
    private MemoryStatus memoryStatus;
    private QueryStatus queryStatus;
    private String[] externalIPs;
    private int[] externalConnections;
    private int externalConnectionSize;
    private int incomingQueueSize;
    private long startTime;
    private long upTime;

    public SystemStatus(String serverName, int serverGroup, int serverID, String serverIP, MemoryStatus memoryStatus, QueryStatus queryStatus, long startTime, long uptime) {
        this.serverName = serverName;
        this.serverGroup = serverGroup;
        this.serverID = serverID;
        this.serverIP = serverIP;
        this.memoryStatus = memoryStatus;
        this.queryStatus = queryStatus;
        this.startTime = startTime;
        this.upTime = uptime;
    }

    public SystemStatus() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[" + this.serverName + "][" + (char)this.serverGroup + ":" + this.serverID + "][" + this.serverIP + "]\n");
        buf.append("[cpus = " + this.cpus + "][active threads = " + this.activeThreads + "]\n");
        buf.append("[Memory Status]\n");
        buf.append(this.memoryStatus.toString());
        buf.append("[ExternalConnectionSize = " + this.externalConnectionSize + "]\n");
        int i = 0;
        while (i < this.externalIPs.length) {
            buf.append("[" + this.externalIPs[i] + " " + this.externalConnections[i] + "]\n");
            ++i;
        }
        buf.append("[IncomingQueueSize = " + this.incomingQueueSize + "]\n");
        buf.append("[Query Status]\n");
        buf.append(this.queryStatus.toString());
        return buf.toString();
    }

    public void setExternalNetworkStatus(String[] ips, int[] cons, int totalCons) {
        this.externalIPs = ips;
        this.externalConnections = cons;
        this.externalConnectionSize = totalCons;
    }

    public void checkSystemStatus() {
        Runtime runtime = Runtime.getRuntime();
        this.cpus = runtime.availableProcessors();
        this.activeThreads = Thread.activeCount();
    }

    public Transmitable getInstance() {
        return new SystemStatus();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.serverName);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.serverGroup);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.serverID);
        ByteUtil.writeString((OutputStream)out, (String)this.serverIP);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.cpus);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.activeThreads);
        this.memoryStatus.serialize(out);
        this.queryStatus.serialize(out);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.externalIPs.length);
        int i = 0;
        while (i < this.externalIPs.length) {
            ByteUtil.writeString((OutputStream)out, (String)this.externalIPs[i]);
            ByteUtil.writeVbInt((OutputStream)out, (int)this.externalConnections[i]);
            ++i;
        }
        ByteUtil.writeVbInt((OutputStream)out, (int)this.externalConnectionSize);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.incomingQueueSize);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.startTime);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.upTime);
    }

    public void deserialize(InputStream in) throws IOException {
        this.serverName = ByteUtil.readString((InputStream)in);
        this.serverGroup = ByteUtil.readVbInt((InputStream)in);
        this.serverID = ByteUtil.readVbInt((InputStream)in);
        this.serverIP = ByteUtil.readString((InputStream)in);
        this.cpus = ByteUtil.readVbInt((InputStream)in);
        this.activeThreads = ByteUtil.readVbInt((InputStream)in);
        this.memoryStatus = new MemoryStatus();
        this.memoryStatus.deserialize(in);
        this.queryStatus = new QueryStatus();
        this.queryStatus.deserialize(in);
        int externalIPLength = ByteUtil.readVbInt((InputStream)in);
        this.externalIPs = new String[externalIPLength];
        this.externalConnections = new int[externalIPLength];
        int i = 0;
        while (i < externalIPLength) {
            this.externalIPs[i] = ByteUtil.readString((InputStream)in);
            this.externalConnections[i] = ByteUtil.readVbInt((InputStream)in);
            ++i;
        }
        this.externalConnectionSize = ByteUtil.readVbInt((InputStream)in);
        this.incomingQueueSize = ByteUtil.readVbInt((InputStream)in);
        this.startTime = ByteUtil.readVbLong((InputStream)in);
        this.upTime = ByteUtil.readVbLong((InputStream)in);
    }

    public int getActiveThreads() {
        return this.activeThreads;
    }

    public int getCpus() {
        return this.cpus;
    }

    public int[] getExternalConnections() {
        return this.externalConnections;
    }

    public String[] getExternalIPs() {
        return this.externalIPs;
    }

    public int getServerGroup() {
        return this.serverGroup;
    }

    public int getServerID() {
        return this.serverID;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getIncomingQueueSize() {
        return this.incomingQueueSize;
    }

    public void setIncomingQueueSize(int incomingQueueSize) {
        this.incomingQueueSize = incomingQueueSize;
    }

    public int getExternalConnectionSize() {
        return this.externalConnectionSize;
    }

    public MemoryStatus getMemoryStatus() {
        return this.memoryStatus;
    }

    public QueryStatus getQueryStatus() {
        return this.queryStatus;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getUptime() {
        return this.upTime;
    }
}

