/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.report;

import com.diquest.commons.type.ArrayUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.database.handler.FailQueryLogDB;
import com.diquest.ir.common.report.KeywordCountQueryReportUtil;
import com.diquest.ir.common.report.KeywordCountQueryReportable;
import com.diquest.ir.common.report.ReportUtil;
import com.diquest.ir.util.common.TimeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public final class FailQueryReport
extends FailQueryLogDB
implements KeywordCountQueryReportable {
    private long from;
    private long to;
    private long unit;
    private int numKeywords;
    private double[] slotsRequested;
    private int previousTotalRequested;
    private int totalRequested;
    private String[] keywords;

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.from = ByteUtil.readLong((InputStream)in);
        this.to = ByteUtil.readLong((InputStream)in);
        this.unit = ByteUtil.readLong((InputStream)in);
        this.numKeywords = ByteUtil.readInt((InputStream)in);
        int loop = ByteUtil.readInt((InputStream)in);
        this.slotsRequested = new double[loop];
        int i = 0;
        while (i < loop) {
            this.slotsRequested[i] = ByteUtil.readDouble((InputStream)in);
            ++i;
        }
        this.previousTotalRequested = ByteUtil.readInt((InputStream)in);
        this.totalRequested = ByteUtil.readInt((InputStream)in);
        loop = ByteUtil.readInt((InputStream)in);
        this.keywords = new String[loop];
        i = 0;
        while (i < loop) {
            this.keywords[i] = ByteUtil.readString((InputStream)in);
            ++i;
        }
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeLong((OutputStream)out, (long)this.from);
        ByteUtil.writeLong((OutputStream)out, (long)this.to);
        ByteUtil.writeLong((OutputStream)out, (long)this.unit);
        ByteUtil.writeInt((OutputStream)out, (int)this.numKeywords);
        ByteUtil.writeInt((OutputStream)out, (int)this.slotsRequested.length);
        int i = 0;
        while (i < this.slotsRequested.length) {
            ByteUtil.writeDouble((OutputStream)out, (double)this.slotsRequested[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.previousTotalRequested);
        ByteUtil.writeInt((OutputStream)out, (int)this.totalRequested);
        ByteUtil.writeInt((OutputStream)out, (int)this.keywords.length);
        i = 0;
        while (i < this.keywords.length) {
            ByteUtil.writeString((OutputStream)out, (String)this.keywords[i]);
            ++i;
        }
    }

    public FailQueryReport(Connection conn, String[] collections, String[][] profiles, long from, long to, long unit, int numKeywords) throws SQLException {
        ReportUtil.check(from, to, unit);
        boolean month = ReportUtil.isMonth(from, to);
        long previousMonthStart = ReportUtil.getPreviousMonthStart(from);
        this.from = from;
        this.to = to;
        this.unit = unit;
        this.numKeywords = numKeywords;
        this.setLimit(numKeywords);
        this.setOffset(1);
        List selected = this.select(conn, null, collections, profiles, from, to);
        List previousSelected = this.select(conn, null, collections, profiles, month ? previousMonthStart : from - (to - from), from);
        this.slotsRequested = ArrayUtil.toDoubleArray((int[])KeywordCountQueryReportUtil.getRequestedInSlots(this, conn, collections, profiles, from, to, unit));
        this.totalRequested = KeywordCountQueryReportUtil.sumRequested(selected);
        this.keywords = KeywordCountQueryReportUtil.getKeywords(selected);
        this.previousTotalRequested = KeywordCountQueryReportUtil.sumRequested(previousSelected);
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public double getPreviousTotalRequested() {
        return this.previousTotalRequested;
    }

    public double[] getRequested() {
        return this.slotsRequested;
    }

    public double getTotalRequested() {
        return this.totalRequested;
    }

    public String toString() {
        String TAB = ", ";
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(super.toString());
        sb.append(", ");
        sb.append("from=");
        sb.append(new Date(this.from));
        sb.append(", ");
        sb.append("to=");
        sb.append(new Date(this.to));
        sb.append(", ");
        sb.append("unit=");
        sb.append(TimeUtil.getTimeString((long)this.unit));
        sb.append(", ");
        sb.append("numKeywords=");
        sb.append(this.numKeywords);
        sb.append(", ");
        sb.append("slotsRequested=");
        sb.append(ArrayUtil.toString((double[])this.slotsRequested));
        sb.append(", ");
        sb.append("previousTotalRequested=");
        sb.append(this.previousTotalRequested);
        sb.append(", ");
        sb.append("totalRequested=");
        sb.append(this.totalRequested);
        sb.append(", ");
        sb.append("keywords=");
        sb.append(ArrayUtil.toString((Object[])this.keywords));
        sb.append(", ");
        sb.append("]");
        return sb.toString();
    }
}

