/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.report;

import com.diquest.commons.math.DescriptiveStatistics;
import com.diquest.commons.type.ArrayUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.IntegerUtil;
import com.diquest.commons.type.PrimitiveCache;
import com.diquest.commons.type.StringArrayUtil;
import com.diquest.commons.type.TimeUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.IndexLog;
import com.diquest.ir.common.database.handler.IndexLogDB;
import com.diquest.ir.common.report.ReportUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class IndexReport
extends IndexLogDB {
    private long[] times;
    private int[] inserted;
    private int[] deleted;
    private int[] inserteds;
    private int[] deleteds;
    private long previousTotalInserted;
    private long totalInserted;
    private long totalDeleted;
    private int fullIndexCount;
    private int fullIndexSucceeded;
    private int fullIndexFailed;
    private int incrementalIndexCount;
    private int incrementalIndexSucceeded;
    private int incrementalIndexFailed;
    private int fieldUpdateCount;
    private int fieldUpdateSucceeded;
    private int fieldUpdateFailed;
    private double[] collectPerSecond;
    private double averageCollectPerSecond;
    private double maxCollectPerSecond;
    private double minCollectPerSecond;
    private double[] fullIndexPerSecond;
    private double averageFullIndexPerSecond;
    private double maxFullIndexPerSecond;
    private double minFullIndexPerSecond;
    private double[] incrementalIndexPerSecond;
    private double averageIncrementalIndexPerSecond;
    private double maxIncrementalIndexPerSecond;
    private double minIncrementalIndexPerSecond;
    private double[] fieldUpdatePerSecond;
    private double averageFieldUpdatePerSecond;
    private double maxFieldUpdatePerSecond;
    private double minFieldUpdatePerSecond;
    private long unit;
    private long to;
    private long from;
    private String[] collections;

    private static int countTypeOf(List logs, char indexType, char status) {
        int count = 0;
        Iterator iter = logs.iterator();
        while (iter.hasNext()) {
            IndexLog log = (IndexLog)((Object)iter.next());
            if (indexType != 'N' && indexType != log.getIndexingType() || status != 'N' && status != log.getStatus()) continue;
            ++count;
        }
        return count;
    }

    private static double overlapPercentile(long rangeFrom, long rangeTo, long baseFrom, long baseTo) {
        long overlapEnd;
        long overlapStart = rangeFrom > baseFrom ? rangeFrom : baseFrom;
        long l = overlapEnd = rangeTo < baseTo ? rangeTo : baseTo;
        if (overlapStart >= overlapEnd) {
            return 0.0;
        }
        return (double)(overlapEnd - overlapStart) / (double)(rangeTo - rangeFrom);
    }

    private static String padding(String x, int size) {
        if (x.length() < size) {
            char[] cp = new char[size];
            int at = size - x.length();
            x.getChars(0, x.length(), cp, at);
            int i = 0;
            while (i < at) {
                cp[i] = 32;
                ++i;
            }
            return new String(cp);
        }
        return x;
    }

    private static List refineSuccess(List logs) {
        ArrayList<IndexLog> refined = new ArrayList<IndexLog>();
        Iterator iter = logs.iterator();
        while (iter.hasNext()) {
            IndexLog log = (IndexLog)((Object)iter.next());
            if (log.getStatus() != 'S') continue;
            refined.add(log);
        }
        return refined;
    }

    public IndexReport(Connection conn, long from, long to, long unit) throws SQLException {
        this(conn, from, to, unit, null);
    }

    public IndexReport(Connection conn, long from, long to, long unit, String[] collections) throws SQLException {
        ReportUtil.check(from, to, unit);
        boolean month = ReportUtil.isMonth(from, to);
        long previousMonthStart = ReportUtil.getPreviousMonthStart(from);
        this.from = from;
        this.to = to;
        this.unit = unit;
        this.collections = collections;
        IndexLogDB db = new IndexLogDB();
        db.setOrderColumn("ENDED");
        db.setOrderDirection(true);
        List logs = db.select(conn, collections, 'N', 'N', 'N', from, to, 'e');
        List successLogs = IndexReport.refineSuccess(logs);
        List latests = Collections.EMPTY_LIST;
        Set needLastestLog = this.collectionNotInFirstSlot(successLogs, collections, from, from + unit);
        String[] neededCollections = null;
        if (needLastestLog != null) {
            neededCollections = needLastestLog.toArray(new String[needLastestLog.size()]);
        }
        latests = db.selectLatest(conn, neededCollections, 'N', 'N', 'S', from, 'e');
        this.fullIndexCount = IndexReport.countTypeOf(logs, 'F', 'N');
        this.fullIndexSucceeded = IndexReport.countTypeOf(logs, 'F', 'S');
        this.fullIndexFailed = IndexReport.countTypeOf(logs, 'F', 'F');
        this.incrementalIndexCount = IndexReport.countTypeOf(logs, 'I', 'N');
        this.incrementalIndexSucceeded = IndexReport.countTypeOf(logs, 'I', 'S');
        this.incrementalIndexFailed = IndexReport.countTypeOf(logs, 'I', 'F');
        this.fieldUpdateCount = IndexReport.countTypeOf(logs, 'U', 'N');
        this.fieldUpdateSucceeded = IndexReport.countTypeOf(logs, 'U', 'S');
        this.fieldUpdateFailed = IndexReport.countTypeOf(logs, 'U', 'F');
        this.previousTotalInserted = db.count(conn, collections, 'N', 'N', 'N', month ? previousMonthStart : from - (to - from), from, 's');
        this.times = new long[successLogs.size()];
        this.inserted = new int[successLogs.size()];
        this.deleted = new int[successLogs.size()];
        int numSlots = (int)((to - from) / unit);
        this.inserteds = new int[numSlots];
        this.deleteds = new int[numSlots];
        this.extrapolate(latests, successLogs, from, to, unit, this.inserteds, this.deleteds);
        int index = 0;
        Iterator iter = successLogs.iterator();
        while (iter.hasNext()) {
            IndexLog log = (IndexLog)((Object)iter.next());
            long ended = log.getEnded().getTime();
            int inserted = log.getInserted();
            int deleted = log.getDeleted();
            this.times[index] = ended;
            this.inserted[index] = inserted;
            this.deleted[index] = deleted;
            ++index;
        }
        this.totalInserted = DescriptiveStatistics.sum((int[])this.inserted);
        this.totalDeleted = DescriptiveStatistics.sum((int[])this.deleted);
        int slots = (int)((to - from) / unit);
        this.collectPerSecond = new double[slots];
        this.fullIndexPerSecond = new double[slots];
        this.incrementalIndexPerSecond = new double[slots];
        this.fieldUpdatePerSecond = new double[slots];
        double[] collected = new double[slots];
        double[] cDurations = new double[slots];
        double[] fullIndexed = new double[slots];
        double[] fDurations = new double[slots];
        double[] incrementalIndexed = new double[slots];
        double[] iDurations = new double[slots];
        double[] fieldUpdated = new double[slots];
        double[] fuDurations = new double[slots];
        double maxCollectPerMs = 0.0;
        double minCollectPerMs = Double.POSITIVE_INFINITY;
        double maxFullIndexPerMs = 0.0;
        double minFullIndexPerMs = Double.POSITIVE_INFINITY;
        double maxIncrementalIndexPerMs = 0.0;
        double minIncrementalIndexPerMs = Double.POSITIVE_INFINITY;
        double maxFieldUpdatePerMs = 0.0;
        double minFieldUpdatePerMs = Double.POSITIVE_INFINITY;
        Iterator iter2 = successLogs.iterator();
        while (iter2.hasNext()) {
            double p;
            int at;
            int end;
            int start;
            int inserted;
            IndexLog log = (IndexLog)((Object)iter2.next());
            long started = log.getCollectionStarted().getTime();
            long ended = Math.max(log.getCollectionEnded().getTime(), started);
            long duration = ended - started;
            int insertCollected = log.getInsertCollected();
            int updateCollected = log.getUpdateCollected();
            if (duration > 0L) {
                int start2 = IntegerUtil.getBounded((int)0, (int)(slots - 1), (int)((int)((started - from) / unit)));
                int end2 = IntegerUtil.getBounded((int)0, (int)(slots - 1), (int)((int)((ended - from) / unit)));
                int at2 = start2;
                while (at2 <= end2) {
                    double p2 = IndexReport.overlapPercentile(started, ended, from + (long)at2 * unit, from + (long)at2 * unit + unit);
                    int n = at2;
                    collected[n] = collected[n] + p2 * (double)(insertCollected + updateCollected);
                    int n2 = at2++;
                    cDurations[n2] = cDurations[n2] + p2 * (double)duration;
                }
                double speed = (double)(insertCollected + updateCollected) / (double)duration;
                if (maxCollectPerMs < speed) {
                    maxCollectPerMs = speed;
                } else if (minCollectPerMs > speed) {
                    minCollectPerMs = speed;
                }
            }
            if ('F' == log.getIndexingType()) {
                started = log.getIndexingStarted().getTime();
                ended = Math.max(log.getIndexingEnded().getTime(), started);
                duration = ended - started;
                inserted = log.getInserted();
                if (duration <= 0L) continue;
                start = IntegerUtil.getBounded((int)0, (int)(slots - 1), (int)((int)((started - from) / unit)));
                end = IntegerUtil.getBounded((int)0, (int)(slots - 1), (int)((int)((ended - from) / unit)));
                at = start;
                while (at <= end) {
                    p = IndexReport.overlapPercentile(started, ended, from + (long)at * unit, from + (long)at * unit + unit);
                    int n = at;
                    fullIndexed[n] = fullIndexed[n] + p * (double)inserted;
                    int n3 = at++;
                    fDurations[n3] = fDurations[n3] + p * (double)duration;
                }
                double speed = (double)inserted / (double)duration;
                if (maxFullIndexPerMs < speed) {
                    maxFullIndexPerMs = speed;
                    continue;
                }
                if (!(minFullIndexPerMs > speed)) continue;
                minFullIndexPerMs = speed;
                continue;
            }
            if ('I' == log.getIndexingType()) {
                started = log.getIndexingStarted().getTime();
                ended = Math.max(log.getIndexingEnded().getTime(), started);
                duration = ended - started;
                inserted = log.getInserted();
                if (duration <= 0L) continue;
                start = IntegerUtil.getBounded((int)0, (int)(slots - 1), (int)((int)((started - from) / unit)));
                end = IntegerUtil.getBounded((int)0, (int)(slots - 1), (int)((int)((ended - from) / unit)));
                at = start;
                while (at <= end) {
                    p = IndexReport.overlapPercentile(started, ended, from + (long)at * unit, from + (long)at * unit + unit);
                    int n = at;
                    incrementalIndexed[n] = incrementalIndexed[n] + p * (double)inserted;
                    int n4 = at++;
                    iDurations[n4] = iDurations[n4] + p * (double)duration;
                }
                double speed = (double)inserted / (double)duration;
                if (maxIncrementalIndexPerMs < speed) {
                    maxIncrementalIndexPerMs = speed;
                    continue;
                }
                if (!(minIncrementalIndexPerMs > speed)) continue;
                minIncrementalIndexPerMs = speed;
                continue;
            }
            if ('U' != log.getIndexingType()) continue;
            started = log.getRepositoryStarted().getTime();
            ended = Math.max(log.getRepositoryEnded().getTime(), started);
            duration = ended - started;
            int updated = log.getUpdated();
            if (duration <= 0L) continue;
            start = IntegerUtil.getBounded((int)0, (int)(slots - 1), (int)((int)((started - from) / unit)));
            end = IntegerUtil.getBounded((int)0, (int)(slots - 1), (int)((int)((ended - from) / unit)));
            at = start;
            while (at <= end) {
                p = IndexReport.overlapPercentile(started, ended, from + (long)at * unit, from + (long)at * unit + unit);
                int n = at;
                fieldUpdated[n] = fieldUpdated[n] + p * (double)updated;
                int n5 = at++;
                fuDurations[n5] = fuDurations[n5] + p * (double)duration;
            }
            double speed = (double)updated / (double)duration;
            if (maxFieldUpdatePerMs < speed) {
                maxFieldUpdatePerMs = speed;
                continue;
            }
            if (!(minFieldUpdatePerMs > speed)) continue;
            minFieldUpdatePerMs = speed;
        }
        int i = 0;
        while (i < slots) {
            this.collectPerSecond[i] = cDurations[i] == 0.0 ? 0.0 : 1000.0 * (collected[i] / cDurations[i]);
            this.fullIndexPerSecond[i] = fDurations[i] == 0.0 ? 0.0 : 1000.0 * (fullIndexed[i] / fDurations[i]);
            this.incrementalIndexPerSecond[i] = iDurations[i] == 0.0 ? 0.0 : 1000.0 * (incrementalIndexed[i] / iDurations[i]);
            this.fieldUpdatePerSecond[i] = fuDurations[i] == 0.0 ? 0.0 : 1000.0 * (fieldUpdated[i] / fuDurations[i]);
            ++i;
        }
        double sumC = DescriptiveStatistics.sum((double[])cDurations);
        double sumF = DescriptiveStatistics.sum((double[])fDurations);
        double sumI = DescriptiveStatistics.sum((double[])iDurations);
        double sumFu = DescriptiveStatistics.sum((double[])fuDurations);
        this.averageCollectPerSecond = 1000.0 * (sumC == 0.0 ? 0.0 : DescriptiveStatistics.sum((double[])collected) / sumC);
        this.averageFullIndexPerSecond = 1000.0 * (sumF == 0.0 ? 0.0 : DescriptiveStatistics.sum((double[])fullIndexed) / sumF);
        this.averageIncrementalIndexPerSecond = 1000.0 * (sumI == 0.0 ? 0.0 : DescriptiveStatistics.sum((double[])incrementalIndexed) / sumI);
        this.averageFieldUpdatePerSecond = 1000.0 * (sumFu == 0.0 ? 0.0 : DescriptiveStatistics.sum((double[])fieldUpdated) / sumFu);
        this.maxCollectPerSecond = 1000.0 * maxCollectPerMs;
        this.minCollectPerSecond = 1000.0 * (minCollectPerMs == Double.POSITIVE_INFINITY ? 0.0 : minCollectPerMs);
        this.maxFullIndexPerSecond = 1000.0 * maxFullIndexPerMs;
        this.minFullIndexPerSecond = 1000.0 * (minFullIndexPerMs == Double.POSITIVE_INFINITY ? 0.0 : minFullIndexPerMs);
        this.maxIncrementalIndexPerSecond = 1000.0 * maxIncrementalIndexPerMs;
        this.minIncrementalIndexPerSecond = 1000.0 * (minIncrementalIndexPerMs == Double.POSITIVE_INFINITY ? 0.0 : minIncrementalIndexPerMs);
        this.maxFieldUpdatePerSecond = 1000.0 * maxFieldUpdatePerMs;
        this.minFieldUpdatePerSecond = 1000.0 * (minFieldUpdatePerMs == Double.POSITIVE_INFINITY ? 0.0 : minFieldUpdatePerMs);
    }

    private Set collectionNotInFirstSlot(List successLogs, String[] collections, long firstStart, long firstEnd) {
        if (collections == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(1 + collections.length << 1);
        int i = 0;
        while (i < collections.length) {
            map.put(collections[i], PrimitiveCache.valueOf((int)i));
            ++i;
        }
        Iterator iter = successLogs.iterator();
        while (iter.hasNext()) {
            IndexLog log = (IndexLog)((Object)iter.next());
            if (firstStart > log.getEnded().getTime() || log.getEnded().getTime() >= firstEnd) continue;
            map.remove(log.getCollection());
        }
        return map.keySet();
    }

    private void extrapolate(List latests, List logs, long from, long to, long unit, int[] indexed, int[] delMarked) {
        IndexLog log;
        int numSlots = (int)((to - from) / unit);
        int slot = 0;
        SlotSummer curIndexed = new SlotSummer();
        SlotSummer curDelMarked = new SlotSummer();
        Iterator iter = latests.iterator();
        while (iter.hasNext()) {
            log = (IndexLog)((Object)iter.next());
            curIndexed.set(log.getCollection(), log.getTotalIndexed());
            curDelMarked.set(log.getCollection(), log.getTotalIndexed() - log.getServiceable());
        }
        iter = logs.iterator();
        while (iter.hasNext()) {
            log = (IndexLog)((Object)iter.next());
            long ended = log.getEnded().getTime();
            if (ended < from || ended >= to) continue;
            int newSlot = ReportUtil.getSlot(ended, from, to, unit);
            if (newSlot < 0) {
                throw new IllegalArgumentException("What the");
            }
            if (slot < newSlot) {
                indexed[slot] = curIndexed.sum();
                delMarked[slot] = curDelMarked.sum();
                ++slot;
                while (slot < newSlot) {
                    indexed[slot] = indexed[slot - 1];
                    delMarked[slot] = delMarked[slot - 1];
                    ++slot;
                }
            }
            String collection = log.getCollection();
            curIndexed.set(collection, log.getTotalIndexed());
            curDelMarked.set(collection, log.getTotalIndexed() - log.getServiceable());
        }
        if (slot < numSlots) {
            indexed[slot] = curIndexed.sum();
            delMarked[slot] = curDelMarked.sum();
            ++slot;
            while (slot < numSlots) {
                indexed[slot] = indexed[slot - 1];
                delMarked[slot] = delMarked[slot - 1];
                ++slot;
            }
        }
    }

    protected String naming(String[] collections) {
        String serverName = collections == null || collections.length == 0 ? "all collections" : (collections.length == 1 ? collections[0] : StringArrayUtil.format((String[])collections, (String)", "));
        return serverName;
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        int loop = 0;
        loop = ByteUtil.readInt((InputStream)in);
        this.times = new long[loop];
        int i = 0;
        while (i < loop) {
            this.times[i] = ByteUtil.readLong((InputStream)in);
            ++i;
        }
        loop = ByteUtil.readInt((InputStream)in);
        this.inserted = new int[loop];
        i = 0;
        while (i < loop) {
            this.inserted[i] = ByteUtil.readInt((InputStream)in);
            ++i;
        }
        loop = ByteUtil.readInt((InputStream)in);
        this.deleted = new int[loop];
        i = 0;
        while (i < loop) {
            this.deleted[i] = ByteUtil.readInt((InputStream)in);
            ++i;
        }
        loop = ByteUtil.readInt((InputStream)in);
        this.inserteds = new int[loop];
        i = 0;
        while (i < loop) {
            this.inserteds[i] = ByteUtil.readInt((InputStream)in);
            ++i;
        }
        loop = ByteUtil.readInt((InputStream)in);
        this.deleteds = new int[loop];
        i = 0;
        while (i < loop) {
            this.deleteds[i] = ByteUtil.readInt((InputStream)in);
            ++i;
        }
        this.previousTotalInserted = ByteUtil.readLong((InputStream)in);
        this.totalInserted = ByteUtil.readLong((InputStream)in);
        this.totalDeleted = ByteUtil.readLong((InputStream)in);
        this.fullIndexCount = ByteUtil.readInt((InputStream)in);
        this.fullIndexSucceeded = ByteUtil.readInt((InputStream)in);
        this.fullIndexFailed = ByteUtil.readInt((InputStream)in);
        this.incrementalIndexCount = ByteUtil.readInt((InputStream)in);
        this.incrementalIndexSucceeded = ByteUtil.readInt((InputStream)in);
        this.incrementalIndexFailed = ByteUtil.readInt((InputStream)in);
        this.fieldUpdateCount = ByteUtil.readInt((InputStream)in);
        this.fieldUpdateSucceeded = ByteUtil.readInt((InputStream)in);
        this.fieldUpdateFailed = ByteUtil.readInt((InputStream)in);
        loop = ByteUtil.readInt((InputStream)in);
        this.collectPerSecond = new double[loop];
        i = 0;
        while (i < loop) {
            this.collectPerSecond[i] = ByteUtil.readDouble((InputStream)in);
            ++i;
        }
        this.averageCollectPerSecond = ByteUtil.readDouble((InputStream)in);
        this.maxCollectPerSecond = ByteUtil.readDouble((InputStream)in);
        this.minCollectPerSecond = ByteUtil.readDouble((InputStream)in);
        loop = ByteUtil.readInt((InputStream)in);
        this.fullIndexPerSecond = new double[loop];
        i = 0;
        while (i < loop) {
            this.fullIndexPerSecond[i] = ByteUtil.readDouble((InputStream)in);
            ++i;
        }
        this.averageFullIndexPerSecond = ByteUtil.readDouble((InputStream)in);
        this.maxFullIndexPerSecond = ByteUtil.readDouble((InputStream)in);
        this.minFullIndexPerSecond = ByteUtil.readDouble((InputStream)in);
        loop = ByteUtil.readInt((InputStream)in);
        this.incrementalIndexPerSecond = new double[loop];
        i = 0;
        while (i < loop) {
            this.incrementalIndexPerSecond[i] = ByteUtil.readDouble((InputStream)in);
            ++i;
        }
        this.averageIncrementalIndexPerSecond = ByteUtil.readDouble((InputStream)in);
        this.maxIncrementalIndexPerSecond = ByteUtil.readDouble((InputStream)in);
        this.minIncrementalIndexPerSecond = ByteUtil.readDouble((InputStream)in);
        loop = ByteUtil.readInt((InputStream)in);
        this.fieldUpdatePerSecond = new double[loop];
        i = 0;
        while (i < loop) {
            this.fieldUpdatePerSecond[i] = ByteUtil.readDouble((InputStream)in);
            ++i;
        }
        this.averageFieldUpdatePerSecond = ByteUtil.readDouble((InputStream)in);
        this.maxFieldUpdatePerSecond = ByteUtil.readDouble((InputStream)in);
        this.minFieldUpdatePerSecond = ByteUtil.readDouble((InputStream)in);
        this.unit = ByteUtil.readLong((InputStream)in);
        this.to = ByteUtil.readLong((InputStream)in);
        this.from = ByteUtil.readLong((InputStream)in);
        loop = ByteUtil.readInt((InputStream)in);
        this.collections = new String[loop];
        i = 0;
        while (i < loop) {
            this.collections[i] = ByteUtil.readString((InputStream)in);
            ++i;
        }
    }

    public final double getAverageCollectPerSecond() {
        return this.averageCollectPerSecond;
    }

    public final double getAverageFieldUpdatePerSecond() {
        return this.averageFieldUpdatePerSecond;
    }

    public final double getAverageFullIndexPerSecond() {
        return this.averageFullIndexPerSecond;
    }

    public final double getAverageIncrementalIndexPerSecond() {
        return this.averageIncrementalIndexPerSecond;
    }

    public final String[] getCollections() {
        return (String[])this.collections.clone();
    }

    public final double[] getCollectPerSecond() {
        return this.collectPerSecond;
    }

    public final int getFieldUpdateCount() {
        return this.fieldUpdateCount;
    }

    public final int getFieldUpdateFailed() {
        return this.fieldUpdateFailed;
    }

    public final double[] getFieldUpdatePerSecond() {
        return this.fieldUpdatePerSecond;
    }

    public final int getFieldUpdateSucceeded() {
        return this.fieldUpdateSucceeded;
    }

    public final long getFrom() {
        return this.from;
    }

    public final int getFullIndexCount() {
        return this.fullIndexCount;
    }

    public final int getFullIndexFailed() {
        return this.fullIndexFailed;
    }

    public final double[] getFullIndexPerSecond() {
        return this.fullIndexPerSecond;
    }

    public final int getFullIndexSucceeded() {
        return this.fullIndexSucceeded;
    }

    public final int getIncrementalIndexCount() {
        return this.incrementalIndexCount;
    }

    public final int getIncrementalIndexFailed() {
        return this.incrementalIndexFailed;
    }

    public final double[] getIncrementalIndexPerSecond() {
        return this.incrementalIndexPerSecond;
    }

    public final int getIncrementalIndexSucceeded() {
        return this.incrementalIndexSucceeded;
    }

    public final InsertedAndDeleted getInsertedAndDeleted() {
        return new InsertedAndDeleted(this.inserteds, this.deleteds);
    }

    public final double getMaxCollectPerSecond() {
        return this.maxCollectPerSecond;
    }

    public final double getMaxFieldUpdatePerSecond() {
        return this.maxFieldUpdatePerSecond;
    }

    public final double getMaxFullIndexPerSecond() {
        return this.maxFullIndexPerSecond;
    }

    public final double getMaxIncrementalIndexPerSecond() {
        return this.maxIncrementalIndexPerSecond;
    }

    public final double getMinCollectPerSecond() {
        return this.minCollectPerSecond;
    }

    public final double getMinFieldUpdatePerSecond() {
        return this.minFieldUpdatePerSecond;
    }

    public final double getMinFullIndexPerSecond() {
        return this.minFullIndexPerSecond;
    }

    public final double getMinIncrementalIndexPerSecond() {
        return this.minIncrementalIndexPerSecond;
    }

    public final long getPreviousTotalInserted() {
        return this.previousTotalInserted;
    }

    public final long getTo() {
        return this.to;
    }

    public final long getTotalDeleted() {
        return this.totalDeleted;
    }

    public final long getTotalInserted() {
        return this.totalInserted;
    }

    public final long getUnit() {
        return this.unit;
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeInt((OutputStream)out, (int)this.times.length);
        int i = 0;
        while (i < this.times.length) {
            ByteUtil.writeLong((OutputStream)out, (long)this.times[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.inserted.length);
        i = 0;
        while (i < this.inserted.length) {
            ByteUtil.writeInt((OutputStream)out, (int)this.inserted[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.deleted.length);
        i = 0;
        while (i < this.deleted.length) {
            ByteUtil.writeInt((OutputStream)out, (int)this.deleted[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.inserteds.length);
        i = 0;
        while (i < this.inserteds.length) {
            ByteUtil.writeInt((OutputStream)out, (int)this.inserteds[i]);
            ++i;
        }
        ByteUtil.writeInt((OutputStream)out, (int)this.deleteds.length);
        i = 0;
        while (i < this.deleteds.length) {
            ByteUtil.writeInt((OutputStream)out, (int)this.deleteds[i]);
            ++i;
        }
        ByteUtil.writeLong((OutputStream)out, (long)this.previousTotalInserted);
        ByteUtil.writeLong((OutputStream)out, (long)this.totalInserted);
        ByteUtil.writeLong((OutputStream)out, (long)this.totalDeleted);
        ByteUtil.writeInt((OutputStream)out, (int)this.fullIndexCount);
        ByteUtil.writeInt((OutputStream)out, (int)this.fullIndexSucceeded);
        ByteUtil.writeInt((OutputStream)out, (int)this.fullIndexFailed);
        ByteUtil.writeInt((OutputStream)out, (int)this.incrementalIndexCount);
        ByteUtil.writeInt((OutputStream)out, (int)this.incrementalIndexSucceeded);
        ByteUtil.writeInt((OutputStream)out, (int)this.incrementalIndexFailed);
        ByteUtil.writeInt((OutputStream)out, (int)this.fieldUpdateCount);
        ByteUtil.writeInt((OutputStream)out, (int)this.fieldUpdateSucceeded);
        ByteUtil.writeInt((OutputStream)out, (int)this.fieldUpdateFailed);
        ByteUtil.writeInt((OutputStream)out, (int)this.collectPerSecond.length);
        i = 0;
        while (i < this.collectPerSecond.length) {
            ByteUtil.writeDouble((OutputStream)out, (double)this.collectPerSecond[i]);
            ++i;
        }
        ByteUtil.writeDouble((OutputStream)out, (double)this.averageCollectPerSecond);
        ByteUtil.writeDouble((OutputStream)out, (double)this.maxCollectPerSecond);
        ByteUtil.writeDouble((OutputStream)out, (double)this.minCollectPerSecond);
        ByteUtil.writeInt((OutputStream)out, (int)this.fullIndexPerSecond.length);
        i = 0;
        while (i < this.fullIndexPerSecond.length) {
            ByteUtil.writeDouble((OutputStream)out, (double)this.fullIndexPerSecond[i]);
            ++i;
        }
        ByteUtil.writeDouble((OutputStream)out, (double)this.averageFullIndexPerSecond);
        ByteUtil.writeDouble((OutputStream)out, (double)this.maxFullIndexPerSecond);
        ByteUtil.writeDouble((OutputStream)out, (double)this.minFullIndexPerSecond);
        ByteUtil.writeInt((OutputStream)out, (int)this.incrementalIndexPerSecond.length);
        i = 0;
        while (i < this.incrementalIndexPerSecond.length) {
            ByteUtil.writeDouble((OutputStream)out, (double)this.incrementalIndexPerSecond[i]);
            ++i;
        }
        ByteUtil.writeDouble((OutputStream)out, (double)this.averageIncrementalIndexPerSecond);
        ByteUtil.writeDouble((OutputStream)out, (double)this.maxIncrementalIndexPerSecond);
        ByteUtil.writeDouble((OutputStream)out, (double)this.minIncrementalIndexPerSecond);
        ByteUtil.writeInt((OutputStream)out, (int)this.fieldUpdatePerSecond.length);
        i = 0;
        while (i < this.fieldUpdatePerSecond.length) {
            ByteUtil.writeDouble((OutputStream)out, (double)this.fieldUpdatePerSecond[i]);
            ++i;
        }
        ByteUtil.writeDouble((OutputStream)out, (double)this.averageFieldUpdatePerSecond);
        ByteUtil.writeDouble((OutputStream)out, (double)this.maxFieldUpdatePerSecond);
        ByteUtil.writeDouble((OutputStream)out, (double)this.minFieldUpdatePerSecond);
        ByteUtil.writeLong((OutputStream)out, (long)this.unit);
        ByteUtil.writeLong((OutputStream)out, (long)this.to);
        ByteUtil.writeLong((OutputStream)out, (long)this.from);
        ByteUtil.writeInt((OutputStream)out, (int)this.collections.length);
        i = 0;
        while (i < this.collections.length) {
            ByteUtil.writeString((OutputStream)out, (String)this.collections[i]);
            ++i;
        }
    }

    public String toString() {
        String TAB = ", ";
        StringBuilder buf = new StringBuilder();
        buf.append("IndexReport ( ");
        buf.append(super.toString());
        buf.append(", ");
        buf.append("times=");
        buf.append(ArrayUtil.toString((long[])this.times));
        buf.append(", ");
        buf.append("inserted=");
        buf.append(ArrayUtil.toString((int[])this.inserted));
        buf.append(", ");
        buf.append("deleted=");
        buf.append(ArrayUtil.toString((int[])this.deleted));
        buf.append(", ");
        buf.append("inserteds=");
        buf.append(ArrayUtil.toString((int[])this.inserteds));
        buf.append(", ");
        buf.append("deleteds=");
        buf.append(ArrayUtil.toString((int[])this.deleteds));
        buf.append(", ");
        buf.append("previousTotalInserted=");
        buf.append(this.previousTotalInserted);
        buf.append(", ");
        buf.append("totalInserted=");
        buf.append(this.totalInserted);
        buf.append(", ");
        buf.append("totalDeleted=");
        buf.append(this.totalDeleted);
        buf.append(", ");
        buf.append("fullIndexCount=");
        buf.append(this.fullIndexCount);
        buf.append(", ");
        buf.append("fullIndexSucceeded=");
        buf.append(this.fullIndexSucceeded);
        buf.append(", ");
        buf.append("fullIndexFailed=");
        buf.append(this.fullIndexFailed);
        buf.append(", ");
        buf.append("incrementalIndexCount=");
        buf.append(this.incrementalIndexCount);
        buf.append(", ");
        buf.append("incrementalIndexSucceeded=");
        buf.append(this.incrementalIndexSucceeded);
        buf.append(", ");
        buf.append("incrementalIndexFailed=");
        buf.append(this.incrementalIndexFailed);
        buf.append(", ");
        buf.append("fieldUpdateCount=");
        buf.append(this.fieldUpdateCount);
        buf.append(", ");
        buf.append("fieldUpdateSucceeded=");
        buf.append(this.fieldUpdateSucceeded);
        buf.append(", ");
        buf.append("fieldUpdateFailed=");
        buf.append(this.fieldUpdateFailed);
        buf.append(", ");
        buf.append("collectPerSecond=");
        buf.append(ArrayUtil.toString((double[])this.collectPerSecond));
        buf.append(", ");
        buf.append("averageCollectPerSecond=");
        buf.append(this.averageCollectPerSecond);
        buf.append(", ");
        buf.append("maxCollectPerSecond=");
        buf.append(this.maxCollectPerSecond);
        buf.append(", ");
        buf.append("minCollectPerSecond=");
        buf.append(this.minCollectPerSecond);
        buf.append(", ");
        buf.append("fullIndexPerSecond=");
        buf.append(ArrayUtil.toString((double[])this.fullIndexPerSecond));
        buf.append(", ");
        buf.append("averageFullIndexPerSecond=");
        buf.append(this.averageFullIndexPerSecond);
        buf.append(", ");
        buf.append("maxFullIndexPerSecond=");
        buf.append(this.maxFullIndexPerSecond);
        buf.append(", ");
        buf.append("minFullIndexPerSecond=");
        buf.append(this.minFullIndexPerSecond);
        buf.append(", ");
        buf.append("incrementalIndexPerSecond=");
        buf.append(ArrayUtil.toString((double[])this.incrementalIndexPerSecond));
        buf.append(", ");
        buf.append("averageIncrementalIndexPerSecond=");
        buf.append(this.averageIncrementalIndexPerSecond);
        buf.append(", ");
        buf.append("maxIncrementalIndexPerSecond=");
        buf.append(this.maxIncrementalIndexPerSecond);
        buf.append(", ");
        buf.append("minIncrementalIndexPerSecond=");
        buf.append(this.minIncrementalIndexPerSecond);
        buf.append(", ");
        buf.append("fieldUpdatePerSecond=");
        buf.append(ArrayUtil.toString((double[])this.fieldUpdatePerSecond));
        buf.append(", ");
        buf.append("averageFieldUpdatePerSecond=");
        buf.append(this.averageFieldUpdatePerSecond);
        buf.append(", ");
        buf.append("maxFieldUpdatePerSecond=");
        buf.append(this.maxFieldUpdatePerSecond);
        buf.append(", ");
        buf.append("minFieldUpdatePerSecond=");
        buf.append(this.minFieldUpdatePerSecond);
        buf.append(", ");
        buf.append("unit=");
        buf.append(this.unit);
        buf.append(", ");
        buf.append("to=");
        buf.append(this.to);
        buf.append(", ");
        buf.append("from=");
        buf.append(this.from);
        buf.append(", ");
        buf.append(" )");
        return buf.toString();
    }

    public String toString2() {
        DecimalFormat dot2 = new DecimalFormat("#0.00");
        DecimalFormat dot0 = new DecimalFormat("#0");
        StringBuilder builder = new StringBuilder();
        builder.append("======================================================").append("\n");
        builder.append(" Index Report").append("\n");
        if (this.collections == null) {
            builder.append(" for all collections").append("\n");
        } else {
            builder.append(" for " + this.naming(this.collections)).append("\n");
        }
        builder.append(" " + new Date(this.from) + " ~ " + new Date(this.to) + " (" + TimeUtil.getTimeString((long)this.unit) + ")").append("\n");
        builder.append("\n");
        InsertedAndDeleted insertedAndDeleted = this.getInsertedAndDeleted();
        builder.append("==STATISTICS==\n");
        builder.append("      inserted: ").append(ArrayUtil.toString((int[])insertedAndDeleted.getInserted(), (NumberFormat)dot0)).append("\n");
        builder.append("       deleted: ").append(ArrayUtil.toString((int[])insertedAndDeleted.getDeleted(), (NumberFormat)dot0)).append("\n");
        builder.append("total inserted: ").append(IndexReport.padding(dot0.format(this.getTotalInserted()), 13)).append("\n");
        builder.append(" total deleted: ").append(IndexReport.padding(dot0.format(this.getTotalDeleted()), 13)).append("\n");
        builder.append("\n");
        builder.append("==full index (" + dot0.format(this.getFullIndexCount()) + ")==\n");
        builder.append("     succeeded: ").append(IndexReport.padding(dot0.format(this.getFullIndexSucceeded()), 10)).append("\n");
        builder.append("        failed: ").append(IndexReport.padding(dot0.format(this.getFullIndexFailed()), 10)).append("\n");
        builder.append("==incremental index (" + dot0.format(this.getIncrementalIndexCount()) + ")==\n");
        builder.append("     succeeded: ").append(IndexReport.padding(dot0.format(this.getIncrementalIndexSucceeded()), 10)).append("\n");
        builder.append("        failed: ").append(IndexReport.padding(dot0.format(this.getIncrementalIndexFailed()), 10)).append("\n");
        builder.append("==field update (" + dot0.format(this.getFieldUpdateCount()) + ")==\n");
        builder.append("     succeeded: ").append(IndexReport.padding(dot0.format(this.getFieldUpdateSucceeded()), 10)).append("\n");
        builder.append("        failed: ").append(IndexReport.padding(dot0.format(this.getFieldUpdateFailed()), 10)).append("\n");
        builder.append("\n");
        builder.append("==PERFORMANCE (per second)==\n");
        builder.append("          collect: ").append(ArrayUtil.toString((double[])this.getCollectPerSecond(), (NumberFormat)dot2)).append("\n");
        builder.append("       full index: ").append(ArrayUtil.toString((double[])this.getFullIndexPerSecond(), (NumberFormat)dot2)).append("\n");
        builder.append("incremental index: ").append(ArrayUtil.toString((double[])this.getIncrementalIndexPerSecond(), (NumberFormat)dot2)).append("\n");
        builder.append("     field update: ").append(ArrayUtil.toString((double[])this.getFieldUpdatePerSecond(), (NumberFormat)dot2)).append("\n");
        builder.append("\n");
        builder.append("  ==collect==\n");
        String u = " document(s)/sec";
        builder.append("      MAX: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getMaxCollectPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("  Average: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getAverageCollectPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("      min: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getMinCollectPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("  ==full index==\n");
        builder.append("      MAX: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getMaxFullIndexPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("  Average: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getAverageFullIndexPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("      min: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getMinFullIndexPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("  ==incremental index==\n");
        builder.append("      MAX: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getMaxIncrementalIndexPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("  Average: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getAverageIncrementalIndexPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("      min: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getMinIncrementalIndexPerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("  ==field update==\n");
        builder.append("      MAX: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getMaxFieldUpdatePerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("  Average: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getAverageFieldUpdatePerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("      min: ").append(String.valueOf(IndexReport.padding(dot2.format(this.getMinFieldUpdatePerSecond()), 13)) + " document(s)/sec").append("\n");
        builder.append("\n");
        builder.append(super.toString());
        builder.append("\n");
        builder.append("======================================================").append('\n');
        return builder.toString();
    }

    public class InsertedAndDeleted {
        private int[] inserted;
        private int[] deleted;

        private InsertedAndDeleted(int[] i, int[] d) {
            this.inserted = (int[])i.clone();
            this.deleted = (int[])d.clone();
        }

        public void destroy() {
            this.inserted = null;
            this.deleted = null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof InsertedAndDeleted) {
                return Arrays.equals(((InsertedAndDeleted)obj).getInserted(), this.inserted) && Arrays.equals(((InsertedAndDeleted)obj).getDeleted(), this.deleted);
            }
            return false;
        }

        public final int[] getDeleted() {
            return this.deleted;
        }

        public final int[] getInserted() {
            return this.inserted;
        }
    }

    private class SlotSummer {
        HashMap map = new HashMap();

        private SlotSummer() {
        }

        public synchronized void set(String collection, int value) {
            this.map.put(collection, new Integer(value));
        }

        public synchronized int sum() {
            Collection values = this.map.values();
            Iterator iterator = values.iterator();
            int sum = 0;
            while (iterator.hasNext()) {
                sum += ((Integer)iterator.next()).intValue();
            }
            return sum;
        }
    }
}

