/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.report;

import com.diquest.ir.common.database.entity.AbstractKeywordCountQueryLog;
import com.diquest.ir.common.database.handler.AbstractKeywordCountQueryLogDB;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

class KeywordCountQueryReportUtil {
    KeywordCountQueryReportUtil() {
    }

    static int[] getRequestedInSlots(AbstractKeywordCountQueryLogDB db, Connection conn, String[] collections, String[][] profiles, long from, long to, long unit) throws SQLException {
        int nSlots = (int)((to - from) / unit);
        int[] requested = new int[nSlots];
        int i = nSlots - 1;
        while (i >= 0) {
            long slotFrom = from + (long)i * unit;
            long t1 = System.currentTimeMillis();
            List select = db.select(conn, null, collections, profiles, slotFrom, slotFrom + unit);
            Iterator iter = select.iterator();
            while (iter.hasNext()) {
                AbstractKeywordCountQueryLog log = (AbstractKeywordCountQueryLog)iter.next();
                int n = i;
                requested[n] = requested[n] + log.getRequested();
            }
            long t2 = System.currentTimeMillis();
            System.out.println(">>" + (t2 - t1) + "ms");
            --i;
        }
        return requested;
    }

    static int sumRequested(List logs) {
        int c = 0;
        Iterator iter = logs.iterator();
        while (iter.hasNext()) {
            AbstractKeywordCountQueryLog log = (AbstractKeywordCountQueryLog)iter.next();
            c += log.getRequested();
        }
        return c;
    }

    static String[] getKeywords(List logs) {
        String[] ks = new String[logs.size()];
        int i = 0;
        Iterator iter = logs.iterator();
        while (iter.hasNext()) {
            ks[i++] = ((AbstractKeywordCountQueryLog)iter.next()).getKeywords();
        }
        return ks;
    }
}

