/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.report;

import com.diquest.commons.develop.NamingConvention;
import com.diquest.commons.type.DateUtil;
import com.diquest.commons.type.TimeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

final class ReportUtil {
    ReportUtil() {
    }

    static boolean isMonth(long from, long to) {
        try {
            return DateUtil.isMonthBased((long)from) && DateUtil.isMonthBased((long)to) && ReportUtil.getPreviousMonthStart(to) == from;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    static long getPreviousMonthStart(long from) {
        return DateUtil.getStartOf((int)5, (long)(DateUtil.getStartOf((int)5, (long)from) - 1L));
    }

    static int getSlot(long current, long from, long to, long unit) {
        if (current < from || current >= to) {
            return -1;
        }
        long l = (current - from) / unit;
        if (l > Integer.MAX_VALUE) {
            throw new ClassCastException("Cannot convert long to int");
        }
        return (int)l;
    }

    static void check(long from, long to, long unit) {
        boolean dividable;
        if (from < 0L || to < 0L || unit < 0L) {
            throw new IllegalArgumentException("Only positive value is available");
        }
        if (!(TimeUtil.isDayBased((long)unit) && DateUtil.isDayBased((long)from) && DateUtil.isDayBased((long)to) || TimeUtil.isHourBased((long)unit) && DateUtil.isHourBased((long)from) && DateUtil.isHourBased((long)to) || TimeUtil.isMinuteBased((long)unit) && DateUtil.isMinuteBased((long)from) && DateUtil.isMinuteBased((long)to))) {
            throw new IllegalArgumentException("The range of date is illegal.");
        }
        long range = to - from;
        boolean bl = dividable = range % unit == 0L;
        if (range <= 0L || !dividable) {
            throw new IllegalArgumentException("Illegal range and unit: " + from + "~" + to + " with unit " + unit);
        }
    }

    static double[] get(String column, List list, Class clazz) {
        try {
            String field = NamingConvention.db2Java((String)column);
            Method method = clazz.getDeclaredMethod(NamingConvention.getGetMethodName((String)field), null);
            double[] ds = new double[list.size()];
            int index = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object ret = method.invoke(iter.next(), null);
                ds[index++] = (Double)ret;
            }
            return ds;
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    static String consoleLineChart(double[] x, double[][] values, String[] labels) {
        return null;
    }
}

