/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.report;

import com.diquest.commons.math.DescriptiveStatistics;
import com.diquest.commons.math.VectorOperation;
import com.diquest.commons.type.ArrayUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringArrayUtil;
import com.diquest.commons.type.TimeUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.ServerLog;
import com.diquest.ir.common.database.handler.ServerLogDB;
import com.diquest.ir.common.report.ReportUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ServerReport
extends ServerLogDB {
    private Date from;
    private Date to;
    private long unit;
    private String[] servers;
    private List stats;
    private List maxs;
    private List mins;
    private int spaceTotal;
    private int spaceUsedByEtc;
    private int spaceUsedByIr;
    private int spaceUsed;
    private int spaceRemain;
    private List serversForSpace = new ArrayList();
    private transient double getAverageConnection = Double.NaN;
    private transient double getAverageCpuUsageByIr = Double.NaN;
    private transient double getAverageDenial = Double.NaN;
    private transient double getAverageError = Double.NaN;
    private transient double getAverageMemoryUsedByIr = Double.NaN;
    private transient double[] getConnections = null;
    private transient double[] getCpuUsageByIr = null;
    private transient double[] getDenials = null;
    private transient double[] getErrors = null;
    private transient double getMaxConnection = Double.NaN;
    private transient double[] getMaxConnections = null;
    private transient double getMaxCpuUsageByIr = Double.NaN;
    private transient double getMaxDenial = Double.NaN;
    private transient double getMaxError = Double.NaN;
    private transient double getMaxMemoryUsedByIr = Double.NaN;
    private transient double[] getMemoryUsedByIr = null;
    private transient double getMinConnection = Double.NaN;
    private transient double getMinCpuUsageByIr = Double.NaN;
    private transient double getMinDenial = Double.NaN;
    private transient double getMinError = Double.NaN;
    private transient double getMinMemoryUsedByIr = Double.NaN;
    private transient double getTotalDenial = Double.NaN;
    static /* synthetic */ Class class$0;

    private static String padding(String x, int size) {
        if (x.length() < size) {
            char[] cp = new char[size];
            int at = size - x.length();
            x.getChars(0, x.length(), cp, at);
            int i = 0;
            while (i < at) {
                cp[i] = 32;
                ++i;
            }
            return new String(cp);
        }
        return x;
    }

    public ServerReport() {
    }

    public ServerReport(Connection conn, long from, long to, long unit) throws SQLException {
        this(conn, from, to, unit, (String[])null);
    }

    public ServerReport(Connection conn, long from, long to, long unit, String server) throws SQLException {
        this(conn, from, to, unit, ServerReport.arrayrize(server));
    }

    public ServerReport(Connection conn, long from, long to, long unit, String[] servers) throws SQLException {
        if (servers != null) {
            this.servers = new String[servers.length];
            System.arraycopy(servers, 0, this.servers, 0, servers.length);
            Arrays.sort(this.servers);
        } else {
            this.servers = null;
        }
        ReportUtil.check(from, to, unit);
        this.from = new Date(from);
        this.to = new Date(to);
        this.unit = unit;
        ServerLogDB db = new ServerLogDB();
        this.mins = db.selectMin(conn, servers, from, to, unit);
        this.maxs = db.selectMax(conn, servers, from, to, unit);
        this.stats = db.select(conn, servers, from, to, unit);
        List latests = null;
        latests = servers != null ? db.selectLatest(conn, servers, from, to + 1L) : db.selectLatest(conn, from, to + 1L);
        int spaceUsed = 0;
        int spaceUsedByIr = 0;
        int spaceRemain = 0;
        Iterator iter = latests.iterator();
        while (iter.hasNext()) {
            ServerLog log = (ServerLog)((Object)iter.next());
            if (log == null) continue;
            spaceUsed = (int)((double)spaceUsed + log.getSpaceUsed());
            spaceUsedByIr = (int)((double)spaceUsedByIr + log.getSpaceUsedByIr());
            spaceRemain = (int)((double)spaceRemain + log.getSpaceRemain());
            this.serversForSpace.add(log.getServer());
        }
        this.spaceUsed = Math.max(0, Math.max(spaceUsed, spaceUsedByIr));
        this.spaceUsedByIr = Math.max(0, Math.min(spaceUsed, spaceUsedByIr));
        this.spaceRemain = Math.max(0, spaceRemain);
        this.spaceTotal = this.spaceRemain + this.spaceUsed;
        this.spaceUsedByEtc = this.spaceUsed - this.spaceUsedByIr;
    }

    private double[] get(String column) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.ServerLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ReportUtil.get(column, this.stats, clazz);
    }

    private double get(String column, int type) {
        switch (type) {
            case 1: {
                return this.get(column, type, this.maxs);
            }
            case 0: {
                return this.get(column, type, this.mins);
            }
        }
        return this.get(column, type, this.stats);
    }

    private double get(String column, int type, List list) {
        switch (type) {
            case 1: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.ServerLog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return DescriptiveStatistics.max((double[])ReportUtil.get(column, list, clazz));
            }
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.ServerLog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return DescriptiveStatistics.min((double[])ReportUtil.get(column, list, clazz));
            }
            case 3: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.ServerLog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return DescriptiveStatistics.sum((double[])ReportUtil.get(column, list, clazz));
            }
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.ServerLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return DescriptiveStatistics.averageNoneZero((double[])ReportUtil.get(column, list, clazz));
    }

    private int maxLength(String[][] x) {
        int m = 0;
        int i = 0;
        while (i < x.length) {
            int j = 0;
            while (j < x[i].length) {
                if (m < x[i][j].length()) {
                    m = x[i][j].length();
                }
                ++j;
            }
            ++i;
        }
        return m;
    }

    public void deserialize(InputStream in) throws IOException {
        ServerLog log;
        super.deserialize(in);
        this.from = new Date(ByteUtil.readVbLong((InputStream)in));
        this.to = new Date(ByteUtil.readVbLong((InputStream)in));
        this.unit = ByteUtil.readVbLong((InputStream)in);
        boolean isNullServer = ByteUtil.readBoolean((InputStream)in);
        if (!isNullServer) {
            this.servers = new String[ByteUtil.readVbInt((InputStream)in)];
            int i = 0;
            while (i < this.servers.length) {
                this.servers[i] = ByteUtil.readString((InputStream)in);
                ++i;
            }
        } else {
            this.servers = null;
        }
        int size = ByteUtil.readVbInt((InputStream)in);
        this.stats = new ArrayList(size);
        int i = 0;
        while (i < size) {
            log = new ServerLog();
            log.deserialize(in);
            this.stats.add(log);
            ++i;
        }
        size = ByteUtil.readVbInt((InputStream)in);
        this.maxs = new ArrayList(size);
        i = 0;
        while (i < size) {
            log = new ServerLog();
            log.deserialize(in);
            this.maxs.add(log);
            ++i;
        }
        size = ByteUtil.readVbInt((InputStream)in);
        this.mins = new ArrayList(size);
        i = 0;
        while (i < size) {
            log = new ServerLog();
            log.deserialize(in);
            this.mins.add(log);
            ++i;
        }
        this.spaceTotal = ByteUtil.readVbInt((InputStream)in);
        this.spaceUsedByEtc = ByteUtil.readVbInt((InputStream)in);
        this.spaceUsedByIr = ByteUtil.readVbInt((InputStream)in);
        this.spaceUsed = ByteUtil.readVbInt((InputStream)in);
        this.spaceRemain = ByteUtil.readVbInt((InputStream)in);
        size = ByteUtil.readVbInt((InputStream)in);
        i = 0;
        while (i < size) {
            this.serversForSpace.add(ByteUtil.readString((InputStream)in));
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof ServerReport) {
            ServerReport r = (ServerReport)obj;
            return this.from.getTime() == r.from.getTime() && this.to.getTime() == r.to.getTime() && this.unit == r.unit && Arrays.equals(this.servers, r.servers) && this.stats.equals(r.stats) && this.maxs.equals(r.maxs) && this.mins.equals(r.mins) && this.spaceTotal == this.spaceTotal && this.spaceUsedByEtc == this.spaceUsedByEtc && this.spaceUsedByIr == this.spaceUsedByIr && this.spaceUsed == this.spaceUsed && this.spaceRemain == this.spaceRemain;
        }
        return false;
    }

    public double getAverageConnection() {
        this.getAverageConnection = Double.isNaN(this.getAverageConnection) ? this.get("CONNECTIONS", 4) : this.getAverageConnection;
        return this.getAverageConnection;
    }

    public double getAverageCpuUsageByIr() {
        this.getAverageCpuUsageByIr = Double.isNaN(this.getAverageCpuUsageByIr) ? this.get("CPU_USAGE_BY_IR", 4) : this.getAverageCpuUsageByIr;
        return this.getAverageCpuUsageByIr;
    }

    public double getAverageDenial() {
        this.getAverageDenial = Double.isNaN(this.getAverageDenial) ? this.get("DENIAL", 4) : this.getAverageDenial;
        return this.getAverageDenial;
    }

    public double getAverageError() {
        this.getAverageError = Double.isNaN(this.getAverageError) ? this.get("ERRORS", 4) : this.getAverageError;
        return this.getAverageError;
    }

    public double getAverageMemoryUsedByIr() {
        this.getAverageMemoryUsedByIr = Double.isNaN(this.getAverageMemoryUsedByIr) ? this.get("MEMORY_USED_BY_IR", 4) : this.getAverageMemoryUsedByIr;
        return this.getAverageMemoryUsedByIr;
    }

    public double[] getConnections() {
        this.getConnections = this.getConnections == null ? this.get("CONNECTIONS") : this.getConnections;
        return this.getConnections;
    }

    public double[] getCpuUsageByIr() {
        this.getCpuUsageByIr = this.getCpuUsageByIr == null ? this.get("CPU_USAGE_BY_IR") : this.getCpuUsageByIr;
        return this.getCpuUsageByIr;
    }

    public double[] getDenials() {
        this.getDenials = this.getDenials == null ? this.get("DENIAL") : this.getDenials;
        return this.getDenials;
    }

    public double[] getErrors() {
        this.getErrors = this.getErrors == null ? this.get("ERRORS") : this.getErrors;
        return this.getErrors;
    }

    public Transmitable getInstance() {
        return new ServerReport();
    }

    public double getMaxConnection() {
        return this.getMaxConnection(false);
    }

    public double getMaxConnection(boolean inList) {
        this.getMaxConnection = Double.isNaN(this.getMaxConnection) ? this.get("CONNECTIONS", 1, inList ? this.stats : this.maxs) : this.getMaxConnection;
        return this.getMaxConnection;
    }

    public double[] getMaxConnections() {
        double[] dArray;
        if (this.getMaxConnections == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.ServerLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dArray = ReportUtil.get("CONNECTIONS", this.maxs, clazz);
        } else {
            dArray = this.getMaxConnections;
        }
        this.getMaxConnections = dArray;
        return dArray;
    }

    public double getMaxCpuUsageByIr() {
        this.getMaxCpuUsageByIr = Double.isNaN(this.getMaxCpuUsageByIr) ? this.getMaxCpuUsageByIr(false) : this.getMaxCpuUsageByIr;
        return this.getMaxCpuUsageByIr;
    }

    public double getMaxCpuUsageByIr(boolean inList) {
        return this.get("CPU_USAGE_BY_IR", 1, inList ? this.stats : this.maxs);
    }

    public double getMaxDenial() {
        this.getMaxDenial = Double.isNaN(this.getMaxDenial) ? this.getMaxDenial(false) : this.getMaxDenial;
        return this.getMaxDenial;
    }

    public double getMaxDenial(boolean inList) {
        return this.get("DENIAL", 1, inList ? this.stats : this.maxs);
    }

    public double getMaxError() {
        this.getMaxError = Double.isNaN(this.getMaxError) ? this.getMaxError(true) : this.getMaxError;
        return this.getMaxError;
    }

    public double getMaxError(boolean inList) {
        return this.get("ERRORS", 1, inList ? this.stats : this.maxs);
    }

    public double getMaxMemoryUsedByIr() {
        this.getMaxMemoryUsedByIr = Double.isNaN(this.getMaxMemoryUsedByIr) ? this.getMaxMemoryUsedByIr(false) : this.getMaxMemoryUsedByIr;
        return this.getMaxMemoryUsedByIr;
    }

    public double getMaxMemoryUsedByIr(boolean inList) {
        return this.get("MEMORY_USED_BY_IR", 1, inList ? this.stats : this.maxs);
    }

    public double[] getMemoryUsedByIr() {
        this.getMemoryUsedByIr = this.getMemoryUsedByIr == null ? this.get("MEMORY_USED_BY_IR") : this.getMemoryUsedByIr;
        return this.getMemoryUsedByIr;
    }

    public double getMinConnection() {
        this.getMinConnection = Double.isNaN(this.getMinConnection) ? this.getMinConnection(false) : this.getMinConnection;
        return this.getMinConnection;
    }

    public double getMinConnection(boolean inList) {
        return this.get("CONNECTIONS", 0, inList ? this.stats : this.mins);
    }

    public double getMinCpuUsageByIr() {
        this.getMinCpuUsageByIr = Double.isNaN(this.getMinCpuUsageByIr) ? this.getMinCpuUsageByIr(false) : this.getMinCpuUsageByIr;
        return this.getMinCpuUsageByIr;
    }

    public double getMinCpuUsageByIr(boolean inList) {
        return this.get("CPU_USAGE_BY_IR", 0, inList ? this.stats : this.mins);
    }

    public double getMinDenial() {
        this.getMinDenial = Double.isNaN(this.getMinDenial) ? this.getMinDenial(false) : this.getMinDenial;
        return this.getMinDenial;
    }

    public double getMinDenial(boolean inList) {
        return this.get("DENIAL", 0, inList ? this.stats : this.mins);
    }

    public double getMinError() {
        this.getMinError = Double.isNaN(this.getMinError) ? this.getMinError(true) : this.getMinError;
        return this.getMinError;
    }

    public double getMinError(boolean inList) {
        return this.get("ERRORS", 0, inList ? this.stats : this.mins);
    }

    public double getMinMemoryUsedByIr() {
        this.getMinMemoryUsedByIr = Double.isNaN(this.getMinMemoryUsedByIr) ? this.getMinMemoryUsedByIr(false) : this.getMinMemoryUsedByIr;
        return this.getMinMemoryUsedByIr;
    }

    public double getMinMemoryUsedByIr(boolean inList) {
        return this.get("MEMORY_USED_BY_IR", 0, inList ? this.stats : this.mins);
    }

    public final List getServersForSpace() {
        return this.serversForSpace;
    }

    public final int getSpaceRemain() {
        return this.spaceRemain;
    }

    public final int getSpaceTotal() {
        return this.spaceTotal;
    }

    public final int getSpaceUsed() {
        return this.spaceUsed;
    }

    public final int getSpaceUsedByEtc() {
        return this.spaceUsedByEtc;
    }

    public final int getSpaceUsedByIr() {
        return this.spaceUsedByIr;
    }

    public double getSumDenial() {
        return this.get("DENIAL", 3, this.stats);
    }

    public double getTotalDenial() {
        this.getTotalDenial = Double.isNaN(this.getTotalDenial) ? this.get("DENIAL", 3, this.stats) : this.getTotalDenial;
        return this.getTotalDenial;
    }

    public int hashCode() {
        return super.hashCode() ^ (int)this.from.getTime() ^ (int)this.to.getTime() ^ (int)this.unit ^ StringArrayUtil.hashCode((String[])this.servers);
    }

    public void serialize(OutputStream out) throws IOException {
        ServerLog log;
        super.serialize(out);
        ByteUtil.writeVbLong((OutputStream)out, (long)this.from.getTime());
        ByteUtil.writeVbLong((OutputStream)out, (long)this.to.getTime());
        ByteUtil.writeVbLong((OutputStream)out, (long)this.unit);
        ByteUtil.writeBoolean((OutputStream)out, (this.servers == null ? 1 : 0) != 0);
        if (this.servers != null) {
            ByteUtil.writeVbInt((OutputStream)out, (int)this.servers.length);
            int i = 0;
            while (i < this.servers.length) {
                ByteUtil.writeString((OutputStream)out, (String)this.servers[i]);
                ++i;
            }
        }
        ByteUtil.writeVbInt((OutputStream)out, (int)this.stats.size());
        Iterator iter = this.stats.iterator();
        while (iter.hasNext()) {
            log = (ServerLog)((Object)iter.next());
            log.serialize(out);
        }
        ByteUtil.writeVbInt((OutputStream)out, (int)this.maxs.size());
        iter = this.maxs.iterator();
        while (iter.hasNext()) {
            log = (ServerLog)((Object)iter.next());
            log.serialize(out);
        }
        ByteUtil.writeVbInt((OutputStream)out, (int)this.mins.size());
        iter = this.mins.iterator();
        while (iter.hasNext()) {
            log = (ServerLog)((Object)iter.next());
            log.serialize(out);
        }
        ByteUtil.writeVbInt((OutputStream)out, (int)this.spaceTotal);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.spaceUsedByEtc);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.spaceUsedByIr);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.spaceUsed);
        ByteUtil.writeVbInt((OutputStream)out, (int)this.spaceRemain);
        int size = this.serversForSpace.size();
        ByteUtil.writeVbInt((OutputStream)out, (int)size);
        Iterator iter2 = this.serversForSpace.iterator();
        while (iter2.hasNext()) {
            ByteUtil.writeString((String)((String)iter2.next()));
        }
    }

    public String toString() {
        DecimalFormat dot2 = new DecimalFormat("#0.00");
        DecimalFormat dot0 = new DecimalFormat("#0");
        StringBuilder builder = new StringBuilder();
        builder.append("======================================================").append("\n");
        builder.append(" Server Report").append("\n");
        if (this.servers == null) {
            builder.append("               for all servers").append("\n");
        } else {
            builder.append("               for " + this.naming(this.servers) + " server").append("\n");
        }
        builder.append("               " + this.from + " ~ " + this.to + " (" + TimeUtil.getTimeString((long)this.unit) + ")").append("\n");
        builder.append("\n");
        builder.append("==CPU==\n");
        builder.append("      cpu %/unit: ").append(ArrayUtil.toString((double[])VectorOperation.multiply((double[])this.getCpuUsageByIr(), (double)0.01), (NumberFormat)dot2)).append("%\n");
        builder.append("    max in units: ").append(ServerReport.padding(dot2.format(this.getMaxCpuUsageByIr(true) / 100.0), 13)).append("%\n");
        builder.append("average in units: ").append(ServerReport.padding(dot2.format(this.getAverageCpuUsageByIr() / 100.0), 13)).append("%\n");
        builder.append("    min in units: ").append(ServerReport.padding(dot2.format(this.getMinCpuUsageByIr(true) / 100.0), 13)).append("%\n");
        builder.append("             max: ").append(ServerReport.padding(dot2.format(this.getMaxCpuUsageByIr(false) / 100.0), 13)).append("%\n");
        builder.append("             min: ").append(ServerReport.padding(dot2.format(this.getMinCpuUsageByIr(false) / 100.0), 13)).append("%\n");
        builder.append("\n");
        builder.append("==MEMORY==\n");
        builder.append("         MB/unit: ").append(ArrayUtil.toString((double[])this.getMemoryUsedByIr(), (NumberFormat)dot0)).append(" MB\n");
        builder.append("    max in units: ").append(ServerReport.padding(dot0.format(this.getMaxMemoryUsedByIr(true)), 10)).append(" MB\n");
        builder.append("average in units: ").append(ServerReport.padding(dot2.format(this.getAverageMemoryUsedByIr()), 13)).append(" MB\n");
        builder.append("    min in units: ").append(ServerReport.padding(dot0.format(this.getMinMemoryUsedByIr(true)), 10)).append(" MB\n");
        builder.append("             max: ").append(ServerReport.padding(dot0.format(this.getMaxMemoryUsedByIr(false)), 10)).append(" MB\n");
        builder.append("             min: ").append(ServerReport.padding(dot0.format(this.getMinMemoryUsedByIr(false)), 10)).append(" MB\n");
        builder.append('\n');
        builder.append("==SPACE==").append("\n");
        builder.append("considered: " + this.serversForSpace).append('\n');
        int used = this.getSpaceUsed();
        int ir = this.getSpaceUsedByIr();
        int remain = this.getSpaceRemain();
        int total = this.getSpaceTotal();
        String[][] map = new String[2][6];
        map[0] = new String[]{"Size", "Ir", "Used", "Avail", "Ir%", "Use%"};
        map[1] = new String[]{String.valueOf((int)Math.round((double)total / 1024.0)) + "G", String.valueOf((int)Math.round((double)ir / 1024.0)) + "G", String.valueOf((int)Math.round((double)used / 1024.0)) + "G", String.valueOf((int)Math.round((double)remain / 1024.0)) + "G", String.valueOf(total == 0 ? 0 : (int)Math.round(100.0 * (double)ir / (double)total)) + "%", String.valueOf(total == 0 ? 0 : (int)Math.round(100.0 * (double)used / (double)total)) + "%"};
        int limit = this.maxLength(map) + 2;
        int i = 0;
        while (i < map.length) {
            int j = 0;
            while (j < map[i].length) {
                builder.append(ServerReport.padding(map[i][j], limit));
                ++j;
            }
            builder.append("\n");
            ++i;
        }
        builder.append("\n");
        builder.append("==CONNECTIONS==\n");
        builder.append("connections/unit: ").append(ArrayUtil.toString((double[])this.getConnections(), (NumberFormat)dot0)).append(" connections\n");
        builder.append("   max conn/unit: ").append(ArrayUtil.toString((double[])this.getMaxConnections(), (NumberFormat)dot0)).append(" connections\n");
        builder.append("    max in units: ").append(ServerReport.padding(dot0.format(this.getMaxConnection(true)), 10)).append(" connections\n");
        builder.append("average in units: ").append(ServerReport.padding(dot2.format(this.getAverageConnection()), 13)).append(" connections\n");
        builder.append("    min in units: ").append(ServerReport.padding(dot0.format(this.getMinConnection(true)), 10)).append(" connections\n");
        builder.append("             max: ").append(ServerReport.padding(dot0.format(this.getMaxConnection(false)), 10)).append(" connections\n");
        builder.append("             min: ").append(ServerReport.padding(dot0.format(this.getMinConnection(false)), 10)).append(" connections\n");
        builder.append('\n');
        builder.append("==DENIALS==\n");
        builder.append("    denials/unit: ").append(ArrayUtil.toString((double[])this.getDenials(), (NumberFormat)dot0)).append(" denials\n");
        builder.append("    max in units: ").append(ServerReport.padding(dot0.format(this.getMaxDenial(true)), 10)).append(" denials\n");
        builder.append("average in units: ").append(ServerReport.padding(dot2.format(this.getAverageDenial()), 13)).append(" denials\n");
        builder.append("    min in units: ").append(ServerReport.padding(dot0.format(this.getMinDenial(true)), 10)).append(" denials\n");
        builder.append("             max: ").append(ServerReport.padding(dot0.format(this.getMaxDenial(false)), 10)).append(" denials\n");
        builder.append("             min: ").append(ServerReport.padding(dot0.format(this.getMinDenial(false)), 10)).append(" denials\n");
        builder.append('\n');
        builder.append("==ERRORS==\n");
        builder.append("     errors/unit: ").append(ArrayUtil.toString((double[])this.getErrors(), (NumberFormat)dot0)).append(" errors\n");
        builder.append("    max in units: ").append(ServerReport.padding(dot0.format(this.getMaxError(true)), 10)).append(" errors\n");
        builder.append("average in units: ").append(ServerReport.padding(dot2.format(this.getAverageError()), 13)).append(" errors\n");
        builder.append("    min in units: ").append(ServerReport.padding(dot0.format(this.getMinError(true)), 10)).append(" errors\n");
        builder.append("             max: ").append(ServerReport.padding(dot0.format(this.getMaxError(false)), 10)).append(" errors\n");
        builder.append("             min: ").append(ServerReport.padding(dot0.format(this.getMinError(false)), 10)).append(" errors\n");
        builder.append('\n');
        builder.append(super.toString());
        builder.append("======================================================").append('\n');
        return builder.toString();
    }

    private static final class TYPE {
        public static final int MIN = 0;
        public static final int MAX = 1;
        public static final int SUM = 3;
        public static final int AVG = 4;

        private TYPE() {
        }
    }
}

