/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.report;

import com.diquest.commons.math.DescriptiveStatistics;
import com.diquest.commons.type.ArrayUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.IntegerUtil;
import com.diquest.commons.type.StringArrayUtil;
import com.diquest.commons.type.TimeUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.StatisticalQueryLog;
import com.diquest.ir.common.database.entity.factory.StatisticalQueryLogFactory;
import com.diquest.ir.common.database.handler.StatisticalQueryLogDB;
import com.diquest.ir.common.report.ReportUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StatisticalQueryReport
extends StatisticalQueryLogDB {
    private List stats;
    private double averageRequestedPerSecond;
    private double maxRequestedPerSecond;
    private double maxResponseTimePerSecond;
    private double minRequestedPerSecond;
    private double minResponseTimePerSecond;
    private double[] timeout;
    private double totalTimeOut;
    private int timeoutUsed;
    private long totalRequested;
    private long previousTotalRequested;
    private Date from;
    private Date to;
    private long unit;
    private String[] servers;
    private String[] collections;
    private String[][] profiles;
    private double previousAverageResponseTime;
    private double averageResponseTime;
    private transient double getAverageRequested = Double.NaN;
    private transient double getAverageRequestedPerSecond = Double.NaN;
    private transient double getMaxRequested = Double.NaN;
    private transient double getMaxRequestedPerSecond = Double.NaN;
    private transient double getMaxResponseTime = Double.NaN;
    private transient double getMinRequested = Double.NaN;
    private transient double getMinResponseTime = Double.NaN;
    private transient double[] getRequested = null;
    private transient double[] getResponseTime = null;
    private transient long getTotalRequested = 0L;
    static /* synthetic */ Class class$0;

    private static String padding(String x, int size) {
        if (x.length() < size) {
            char[] cp = new char[size];
            int at = size - x.length();
            x.getChars(0, x.length(), cp, at);
            int i = 0;
            while (i < at) {
                cp[i] = 32;
                ++i;
            }
            return new String(cp);
        }
        return x;
    }

    public StatisticalQueryReport() {
    }

    public StatisticalQueryReport(Connection conn, long from, long to, long unit, String[] servers, String[] collections, String[][] profiles) throws SQLException {
        ReportUtil.check(from, to, unit);
        boolean month = ReportUtil.isMonth(from, to);
        long previousMonthStart = ReportUtil.getPreviousMonthStart(from);
        if (ArrayUtil.isNullExist((Object[])servers) || ArrayUtil.isNullExist((Object[])collections) || ArrayUtil.isNullExist((Object[])profiles)) {
            throw new IllegalArgumentException("Null object(s) are detected in the array.");
        }
        if (profiles != null) {
            int i = 0;
            while (i < profiles.length) {
                if (ArrayUtil.isNullExist((Object[])profiles[i])) {
                    throw new IllegalArgumentException("Null object(s) are detected in the array.");
                }
                ++i;
            }
        }
        this.from = new Date(from);
        this.to = new Date(to);
        this.unit = unit;
        this.servers = servers;
        this.collections = collections;
        this.profiles = profiles;
        Iterator naive = this.selectApprox(conn, collections, profiles, servers, from, to, unit);
        this.initialize(naive, from, to, unit);
        this.previousTotalRequested = this.getRequested(conn, collections, profiles, servers, month ? previousMonthStart : from - (to - from), from);
        this.previousAverageResponseTime = this.getAverageResponseTime(conn, collections, profiles, servers, month ? previousMonthStart : from - (to - from), from);
        this.averageResponseTime = this.getAverageResponseTime(conn, collections, profiles, servers, from, to);
        double[] minMaxReq = this.getMinMaxRequested(conn, collections, profiles, servers, from, to);
        double[] minMaxRes = this.getMinMaxResponseTime(conn, collections, profiles, servers, from, to);
        this.minRequestedPerSecond = minMaxReq[0];
        this.maxRequestedPerSecond = minMaxReq[1];
        this.minResponseTimePerSecond = minMaxRes[0];
        this.maxResponseTimePerSecond = minMaxRes[1];
    }

    public StatisticalQueryReport(InputStream is) throws IOException {
        int size = ByteUtil.readVbInt((InputStream)is);
        this.stats = new ArrayList(size);
        int i = 0;
        while (i < size) {
            StatisticalQueryLog log = new StatisticalQueryLog();
            log.deserialize(is);
            this.stats.add(log);
            ++i;
        }
        this.averageRequestedPerSecond = ByteUtil.readDouble((InputStream)is);
        this.maxRequestedPerSecond = ByteUtil.readDouble((InputStream)is);
        this.maxResponseTimePerSecond = ByteUtil.readDouble((InputStream)is);
        this.minRequestedPerSecond = ByteUtil.readDouble((InputStream)is);
        this.minResponseTimePerSecond = ByteUtil.readDouble((InputStream)is);
        if (!ByteUtil.readBoolean((InputStream)is)) {
            this.timeout = new double[ByteUtil.readVbInt((InputStream)is)];
            i = 0;
            while (i < this.timeout.length) {
                this.timeout[i] = ByteUtil.readDouble((InputStream)is);
                ++i;
            }
        }
        this.totalTimeOut = ByteUtil.readDouble((InputStream)is);
        this.timeoutUsed = ByteUtil.readVbInt((InputStream)is);
        this.totalRequested = ByteUtil.readVbLong((InputStream)is);
        this.previousTotalRequested = ByteUtil.readLong((InputStream)is);
        this.from = new Date(ByteUtil.readVbLong((InputStream)is));
        this.to = new Date(ByteUtil.readVbLong((InputStream)is));
        this.unit = ByteUtil.readVbLong((InputStream)is);
        if (!ByteUtil.readBoolean((InputStream)is)) {
            this.servers = new String[ByteUtil.readVbInt((InputStream)is)];
            i = 0;
            while (i < this.servers.length) {
                this.servers[i] = ByteUtil.readString((InputStream)is);
                ++i;
            }
        }
        if (!ByteUtil.readBoolean((InputStream)is)) {
            this.collections = new String[ByteUtil.readVbInt((InputStream)is)];
            i = 0;
            while (i < this.collections.length) {
                this.collections[i] = ByteUtil.readString((InputStream)is);
                ++i;
            }
        }
        if (!ByteUtil.readBoolean((InputStream)is)) {
            this.profiles = new String[ByteUtil.readVbInt((InputStream)is)][];
            i = 0;
            while (i < this.profiles.length) {
                if (!ByteUtil.readBoolean((InputStream)is)) {
                    this.profiles[i] = new String[ByteUtil.readVbInt((InputStream)is)];
                    int j = 0;
                    while (j < this.profiles[i].length) {
                        this.profiles[i][j] = ByteUtil.readString((InputStream)is);
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.previousAverageResponseTime = ByteUtil.readDouble((InputStream)is);
        this.averageResponseTime = ByteUtil.readDouble((InputStream)is);
    }

    public StatisticalQueryReport(StatisticalQueryReport statisticalQueryReport) {
        this.stats = statisticalQueryReport.stats;
        this.averageRequestedPerSecond = statisticalQueryReport.averageRequestedPerSecond;
        this.maxRequestedPerSecond = statisticalQueryReport.maxRequestedPerSecond;
        this.maxResponseTimePerSecond = statisticalQueryReport.maxResponseTimePerSecond;
        this.minRequestedPerSecond = statisticalQueryReport.minRequestedPerSecond;
        this.minResponseTimePerSecond = statisticalQueryReport.minResponseTimePerSecond;
        this.timeout = statisticalQueryReport.timeout;
        this.totalTimeOut = statisticalQueryReport.totalTimeOut;
        this.timeoutUsed = statisticalQueryReport.timeoutUsed;
        this.totalRequested = statisticalQueryReport.totalRequested;
        this.previousTotalRequested = statisticalQueryReport.previousTotalRequested;
        this.from = statisticalQueryReport.from;
        this.to = statisticalQueryReport.to;
        this.unit = statisticalQueryReport.unit;
        this.servers = statisticalQueryReport.servers;
        this.collections = statisticalQueryReport.collections;
        this.profiles = statisticalQueryReport.profiles;
        this.previousAverageResponseTime = statisticalQueryReport.previousAverageResponseTime;
        this.averageResponseTime = statisticalQueryReport.averageResponseTime;
    }

    private void caching(int t) {
        double[] v = new double[this.stats.size()];
        int i = 0;
        Iterator iter = this.stats.iterator();
        while (iter.hasNext()) {
            StatisticalQueryLog log = (StatisticalQueryLog)iter.next();
            v[i++] = log.getResponseTimeOver(t);
        }
        this.timeout = v;
        this.timeoutUsed = t;
        this.totalTimeOut = DescriptiveStatistics.sum((double[])this.timeout);
    }

    private double[] get(String column) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.StatisticalQueryLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ReportUtil.get(column, this.stats, clazz);
    }

    private double get(String column, int type) {
        switch (type) {
            default: 
        }
        return this.get(column, type, this.stats);
    }

    private double get(String column, int type, List list) {
        switch (type) {
            case 1: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.StatisticalQueryLog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return DescriptiveStatistics.max((double[])ReportUtil.get(column, list, clazz));
            }
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.StatisticalQueryLog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return DescriptiveStatistics.min((double[])ReportUtil.get(column, list, clazz));
            }
            case 5: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.StatisticalQueryLog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return DescriptiveStatistics.minNot((double[])ReportUtil.get(column, list, clazz), (double)0.0);
            }
            case 3: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.StatisticalQueryLog");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return DescriptiveStatistics.sum((double[])ReportUtil.get(column, list, clazz));
            }
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.database.entity.StatisticalQueryLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return DescriptiveStatistics.averageNoneZero((double[])ReportUtil.get(column, list, clazz));
    }

    private void initialize(Iterator logs, long start, long end, long units) {
        if (units > Integer.MAX_VALUE || (end - start) % units != 0L) {
            throw new IllegalArgumentException();
        }
        int size = (int)((end - start) / units);
        StatisticalQueryLog[] merged = new StatisticalQueryLog[(int)((end - start) / units)];
        int i = 0;
        while (i < size) {
            StatisticalQueryLog log = new StatisticalQueryLog();
            log.setDuration((int)units);
            log.setRegistered(start + units * (long)i);
            merged[i] = log;
            ++i;
        }
        this.totalRequested = 0L;
        while (logs.hasNext()) {
            StatisticalQueryLog log = (StatisticalQueryLog)logs.next();
            long logRegistered = log.getRegistered();
            this.totalRequested = (long)((double)this.totalRequested + log.getRequested());
            try {
                long slot = start + units * ((logRegistered - start) / units);
                long duration = log.getDuration();
                double portion = StatisticalQueryLogFactory.portion(logRegistered, duration, slot, units);
                merged[(int)((slot - start) / units)].merge(log, portion);
                while (logRegistered + duration > slot + units) {
                    portion = StatisticalQueryLogFactory.portion(logRegistered, duration, slot += units, units);
                    merged[(int)((slot - start) / units)].merge(log, portion);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.stats = Arrays.asList(merged);
        this.averageRequestedPerSecond = (double)this.totalRequested / ((double)(end - start) / 1000.0);
    }

    private Set selectedCollectionsAndProfiles() {
        HashSet colls = this.collections == null ? new HashSet() : new HashSet<String>(Arrays.asList(this.collections));
        HashSet<String> profs = new HashSet<String>();
        if (this.profiles != null) {
            int i = 0;
            while (i < this.profiles.length) {
                if (!colls.contains(this.profiles[i][0])) {
                    profs.add(String.valueOf(this.profiles[i][1]) + " of " + this.profiles[i][0]);
                }
                ++i;
            }
        }
        colls.addAll(profs);
        return colls;
    }

    public double getAverageRequested() {
        if (Double.isNaN(this.getAverageRequested)) {
            this.getAverageRequested = this.get("REQUESTED", 4);
            return this.getAverageRequested;
        }
        return this.getAverageRequested;
    }

    public final double getAverageRequestedPerSecond() {
        if (Double.isNaN(this.getAverageRequestedPerSecond)) {
            this.getAverageRequestedPerSecond = this.get("REQUESTED", 4) / ((double)this.unit / 1000.0);
            return this.getAverageRequestedPerSecond;
        }
        return this.getAverageRequestedPerSecond;
    }

    public double getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public final double getAverageResponseTimePerSecond() {
        return this.averageResponseTime;
    }

    public double getMaxRequested() {
        if (Double.isNaN(this.getMaxRequested)) {
            this.getMaxRequested = this.get("REQUESTED", 1);
            return this.getMaxRequested;
        }
        return this.getMaxRequested;
    }

    public final double getMaxRequestedPerSecond() {
        if (Double.isNaN(this.getMaxRequestedPerSecond)) {
            this.getMaxRequestedPerSecond = this.maxRequestedPerSecond;
            return this.getMaxRequestedPerSecond;
        }
        return this.getMaxRequestedPerSecond;
    }

    public double getMaxResponseTime() {
        if (Double.isNaN(this.getMaxResponseTime)) {
            this.getMaxResponseTime = this.get("RESPONSE_TIME", 1);
            return this.getMaxResponseTime;
        }
        return this.getMaxResponseTime;
    }

    public final double getMaxResponseTimePerSecond() {
        return this.maxResponseTimePerSecond;
    }

    public double getMinRequested() {
        if (Double.isNaN(this.getMinRequested)) {
            this.getMinRequested = this.get("REQUESTED", 5);
            return this.getMinRequested;
        }
        return this.getMinRequested;
    }

    public final double getMinRequestedPerSecond() {
        return this.minRequestedPerSecond;
    }

    public double getMinResponseTime() {
        if (Double.isNaN(this.getMinResponseTime)) {
            this.getMinResponseTime = this.get("RESPONSE_TIME", 0);
            return this.getMinResponseTime;
        }
        return this.getMinResponseTime;
    }

    public final double getMinResponseTimePerSecond() {
        return this.minResponseTimePerSecond;
    }

    public final double getPreviousAverageResponseTime() {
        return this.previousAverageResponseTime;
    }

    public final long getPreviousTotalRequested() {
        return this.previousTotalRequested;
    }

    public double[] getRequested() {
        this.getRequested = this.getRequested != null ? this.getRequested : this.get("REQUESTED");
        return this.getRequested;
    }

    public double[] getResponseTime() {
        this.getResponseTime = this.getResponseTime != null ? this.getResponseTime : this.get("RESPONSE_TIME");
        return this.getResponseTime;
    }

    public synchronized double[] getTimeout(int t) {
        t = IntegerUtil.getBounded((int)0, (int)10, (int)t);
        if (this.timeout == null || this.timeoutUsed != t) {
            this.caching(t);
        }
        return this.timeout;
    }

    public long getTotalRequested() {
        return this.getTotalRequested == 0L ? (long)this.get("REQUESTED", 3) : this.getTotalRequested;
    }

    public synchronized double getTotalTimeout(int t) {
        t = IntegerUtil.getBounded((int)0, (int)10, (int)t);
        if (this.totalTimeOut != 0.0 && this.timeoutUsed == t) {
            return this.totalTimeOut;
        }
        this.caching(t);
        return this.totalTimeOut;
    }

    public void serialize(OutputStream os) throws IOException {
        ByteUtil.writeVbInt((OutputStream)os, (int)this.stats.size());
        Iterator iter = this.stats.iterator();
        while (iter.hasNext()) {
            StatisticalQueryLog log = (StatisticalQueryLog)iter.next();
            log.serialize(os);
        }
        ByteUtil.writeDouble((OutputStream)os, (double)this.averageRequestedPerSecond);
        ByteUtil.writeDouble((OutputStream)os, (double)this.maxRequestedPerSecond);
        ByteUtil.writeDouble((OutputStream)os, (double)this.maxResponseTimePerSecond);
        ByteUtil.writeDouble((OutputStream)os, (double)this.minRequestedPerSecond);
        ByteUtil.writeDouble((OutputStream)os, (double)this.minResponseTimePerSecond);
        ByteUtil.writeBoolean((OutputStream)os, (this.timeout == null ? 1 : 0) != 0);
        if (this.timeout != null) {
            ByteUtil.writeVbInt((int)this.timeout.length);
            int i = 0;
            while (i < this.timeout.length) {
                ByteUtil.writeDouble((OutputStream)os, (double)this.timeout[i]);
                ++i;
            }
        }
        ByteUtil.writeDouble((OutputStream)os, (double)this.totalTimeOut);
        ByteUtil.writeVbInt((OutputStream)os, (int)this.timeoutUsed);
        ByteUtil.writeVbLong((OutputStream)os, (long)this.totalRequested);
        ByteUtil.writeLong((OutputStream)os, (long)this.previousTotalRequested);
        ByteUtil.writeVbLong((OutputStream)os, (long)this.from.getTime());
        ByteUtil.writeVbLong((OutputStream)os, (long)this.to.getTime());
        ByteUtil.writeVbLong((OutputStream)os, (long)this.unit);
        ByteUtil.writeBoolean((OutputStream)os, (this.servers == null ? 1 : 0) != 0);
        if (this.servers != null) {
            ByteUtil.writeVbInt((OutputStream)os, (int)this.servers.length);
            int i = 0;
            while (i < this.servers.length) {
                ByteUtil.writeString((OutputStream)os, (String)this.servers[i]);
                ++i;
            }
        }
        ByteUtil.writeBoolean((OutputStream)os, (this.collections == null ? 1 : 0) != 0);
        if (this.collections != null) {
            ByteUtil.writeVbInt((OutputStream)os, (int)this.collections.length);
            int i = 0;
            while (i < this.collections.length) {
                ByteUtil.writeString((OutputStream)os, (String)this.collections[i]);
                ++i;
            }
        }
        ByteUtil.writeBoolean((OutputStream)os, (this.profiles == null ? 1 : 0) != 0);
        if (this.profiles != null) {
            ByteUtil.writeVbInt((OutputStream)os, (int)this.profiles.length);
            int i = 0;
            while (i < this.profiles.length) {
                ByteUtil.writeBoolean((OutputStream)os, (this.profiles[i] == null ? 1 : 0) != 0);
                if (this.profiles[i] != null) {
                    ByteUtil.writeVbInt((OutputStream)os, (int)this.profiles[i].length);
                    int j = 0;
                    while (j < this.profiles[i].length) {
                        ByteUtil.writeString((OutputStream)os, (String)this.profiles[i][j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        ByteUtil.writeDouble((OutputStream)os, (double)this.previousAverageResponseTime);
        ByteUtil.writeDouble((OutputStream)os, (double)this.averageResponseTime);
    }

    public String toString() {
        Set selectedCollectionsAndProfiles = this.selectedCollectionsAndProfiles();
        DecimalFormat dot2 = new DecimalFormat("#0.00");
        StringBuilder builder = new StringBuilder();
        builder.append("======================================================").append("\n");
        builder.append(" Statistical Query Report").append("\n");
        if (this.servers == null || this.servers.length == 0) {
            builder.append("               for all servers").append("\n");
        } else {
            builder.append("               for " + StringArrayUtil.format((String[])this.servers, (String)", ") + " servers").append("\n");
        }
        if (selectedCollectionsAndProfiles.isEmpty()) {
            builder.append("               for all collections").append("\n");
        } else {
            builder.append("               for " + selectedCollectionsAndProfiles.toString()).append("\n");
        }
        builder.append("               " + this.from + " ~ " + this.to + " (" + TimeUtil.getTimeString((long)this.unit) + ")").append("\n");
        builder.append("\n");
        builder.append("     requested/unit: ").append(ArrayUtil.toString((double[])this.getRequested(), (NumberFormat)dot2)).append(" queries\n");
        builder.append("      total queries: ").append(StatisticalQueryReport.padding(dot2.format(this.getTotalRequested()), 10)).append(" queries\n");
        builder.append("   current/previous: ").append(StatisticalQueryReport.padding(dot2.format(100.0 * (double)this.getTotalRequested() / (double)this.getPreviousTotalRequested()), 10)).append("%\n");
        builder.append("                max: ").append(StatisticalQueryReport.padding(dot2.format(this.getMaxRequested()), 10)).append(" queries/unit\n");
        builder.append("            average: ").append(StatisticalQueryReport.padding(dot2.format(this.getAverageRequested()), 10)).append(" queries/unit\n");
        builder.append("                min: ").append(StatisticalQueryReport.padding(dot2.format(this.getMinRequested()), 10)).append(" queries/unit\n");
        builder.append("    max queries/sec: ").append(StatisticalQueryReport.padding(dot2.format(this.getMaxRequestedPerSecond()), 10)).append(" queries/sec\n");
        builder.append("average queries/sec: ").append(StatisticalQueryReport.padding(dot2.format(this.getMaxRequestedPerSecond()), 10)).append(" queries/sec\n");
        builder.append("            min/sec: ").append(StatisticalQueryReport.padding(dot2.format(this.getMinRequestedPerSecond()), 10)).append(" queries/sec\n");
        builder.append("\n");
        builder.append("       millis/unit: ").append(ArrayUtil.toString((double[])this.getResponseTime(), (NumberFormat)dot2)).append(" millis\n");
        builder.append("  current/previous: ").append(StatisticalQueryReport.padding(dot2.format(100.0 * this.getAverageResponseTime() / this.getPreviousAverageResponseTime()), 10)).append("%\n");
        builder.append("               max: ").append(StatisticalQueryReport.padding(dot2.format(this.getMaxResponseTime()), 10)).append(" millis\n");
        builder.append("           average: ").append(StatisticalQueryReport.padding(dot2.format(this.getAverageResponseTime()), 10)).append(" millis\n");
        builder.append("               min: ").append(StatisticalQueryReport.padding(dot2.format(this.getMinResponseTime()), 10)).append(" millis\n");
        builder.append("      max(in 1min): ").append(StatisticalQueryReport.padding(dot2.format(this.getMaxResponseTimePerSecond()), 10)).append(" millis\n");
        builder.append("  average(in 1min): ").append(StatisticalQueryReport.padding(dot2.format(this.getAverageResponseTimePerSecond()), 10)).append(" millis\n");
        builder.append("      min(in 1min): ").append(StatisticalQueryReport.padding(dot2.format(this.getMinResponseTimePerSecond()), 10)).append(" millis\n");
        builder.append("\n");
        builder.append("      timeout/unit: ").append(ArrayUtil.toString((double[])this.getTimeout(3), (NumberFormat)dot2)).append(" queries\n");
        builder.append("    total timeouts: ").append(StatisticalQueryReport.padding(dot2.format(this.getTotalTimeout(3)), 10)).append(" queries\n");
        builder.append("\n");
        builder.append("======================================================").append('\n');
        return builder.toString();
    }

    private static final class TYPE {
        public static final int AVG = 4;
        public static final int MAX = 1;
        public static final int MIN = 0;
        public static final int SUM = 3;
        public static final int MIN_NONE_ZERO = 5;

        private TYPE() {
        }
    }
}

