/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Element;

public final class SettingComparatorUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.setting.SettingComparatorUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static final boolean equals(Object x, Object y, Set exception, boolean attributeOnly) {
        return SettingComparatorUtil.equals(x, y, Collections.EMPTY_MAP, exception, attributeOnly, "");
    }

    public static final boolean equals(Object source, Object target, Map identifiers, Set exceptions, boolean attributeOnly, String prefix) {
        try {
            return SettingComparatorUtil.equals0(source, target, identifiers, exceptions, attributeOnly, prefix);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static final boolean equals0(Object source, Object target, Map identifiers, Set exceptions, boolean attributeOnly, String prefix) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, ClassNotFoundException {
        if (!$assertionsDisabled && !SettingComparatorUtil.debug(prefix)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !SettingComparatorUtil.debug("\t" + source + "\t" + target)) {
            throw new AssertionError();
        }
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (source.equals(target)) {
            return true;
        }
        if (source instanceof List && target instanceof List) {
            if (attributeOnly) {
                return true;
            }
            List xl = (List)source;
            List yl = (List)target;
            if (xl.size() != yl.size()) {
                return false;
            }
            if (xl.isEmpty() && yl.isEmpty()) {
                return true;
            }
            String idMethodName = (String)identifiers.get(prefix);
            Method idMethod = SettingComparatorUtil.getMethodOf(SettingComparatorUtil.extractMethods(SettingComparatorUtil.getSample(xl, yl)), idMethodName);
            Object[] xs = null;
            Object[] ys = null;
            if (idMethod == null) {
                xs = xl.toArray();
                ys = yl.toArray();
            } else {
                xs = SettingComparatorUtil.sortBy(xl.toArray(), idMethod);
                ys = SettingComparatorUtil.sortBy(yl.toArray(), idMethod);
            }
            int i = 0;
            while (i < xs.length) {
                Object xelem = xs[i];
                Object yelem = ys[i];
                boolean subEquals = SettingComparatorUtil.equals0(xelem, yelem, identifiers, exceptions, attributeOnly, prefix);
                if (!subEquals) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(source instanceof Element) && !(target instanceof Element)) {
            return source.equals(target);
        }
        Method[] declaredMethods = SettingComparatorUtil.extractMethods(source);
        int m = 0;
        while (m < declaredMethods.length) {
            Object yelem;
            Object xelem;
            boolean subEquals;
            Method method = declaredMethods[m];
            String name = method.getName();
            String newPrefix = SettingComparatorUtil.append(prefix, name);
            if ((name.startsWith("is") || name.startsWith("get")) && !exceptions.contains(newPrefix) && !(subEquals = SettingComparatorUtil.equals0(xelem = method.invoke(source, null), yelem = method.invoke(target, null), identifiers, exceptions, attributeOnly, newPrefix))) {
                return false;
            }
            ++m;
        }
        return true;
    }

    private static final Object getSample(List xl, List yl) {
        Iterator xs = xl.iterator();
        while (xs.hasNext()) {
            Object x = xs.next();
            if (x == null) continue;
            return x;
        }
        Iterator ys = yl.iterator();
        while (ys.hasNext()) {
            Object y = ys.next();
            if (y == null) continue;
            return y;
        }
        return null;
    }

    private static final boolean debug(Object object) {
        System.out.println(object);
        return true;
    }

    private static final String append(String prefix, String name) {
        return prefix.length() > 0 ? String.valueOf(prefix) + "." + name : name;
    }

    private static final Method getMethodOf(Method[] declaredMethods, String name) {
        Method idMethod = null;
        if (name != null) {
            int m = 0;
            while (m < declaredMethods.length) {
                if (declaredMethods[m].getName().equals(name)) {
                    idMethod = declaredMethods[m];
                    break;
                }
                ++m;
            }
        }
        return idMethod;
    }

    private static final Method[] extractMethods(Object sample) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (sample == null) {
            return new Method[0];
        }
        Method method = sample.getClass().getMethod("getPrimaryInterface", null);
        Class primary = (Class)method.invoke(sample, null);
        Method[] declaredMethods = Class.forName(String.valueOf(primary.getName()) + "Type").getDeclaredMethods();
        return declaredMethods;
    }

    protected static final Object[] sortBy(Object[] objs, final Method m) {
        Arrays.sort(objs, new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    Comparable s1 = (Comparable)m.invoke(o1, null);
                    Comparable s2 = (Comparable)m.invoke(o2, null);
                    if (s1 != null) {
                        return s1.compareTo(s2);
                    }
                    if (s2 != null) {
                        return -s2.compareTo(s1);
                    }
                    return 0;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return objs;
    }
}

