/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting;

import com.diquest.ir.common.exception.IRException;
import java.io.File;

public class SettingKey {
    private String prefix;
    private String fileName;
    private static File SETTING_REPOSITORY = null;

    public static void init(String settingRepository) {
        SETTING_REPOSITORY = new File(settingRepository);
    }

    public static File getSettingRepository() {
        return SETTING_REPOSITORY;
    }

    public static String getCollectionRepository(String collectionID) {
        return new File(SETTING_REPOSITORY, collectionID).getAbsolutePath();
    }

    public static String getDBWatcherSettingRepository(String collectionID) {
        return new File(SettingKey.getCollectionRepository(collectionID), "dbwatcher").getAbsolutePath();
    }

    public SettingKey(String prefix, String fileName) throws IRException {
        Assert.ready();
        prefix = prefix == null ? "" : prefix;
        this.init(prefix, fileName);
    }

    public SettingKey(String fileName) throws IRException {
        Assert.ready();
        this.init("", fileName);
    }

    public static SettingKey createServerListKey() throws IRException {
        return new ServerListSettingKey();
    }

    public static SettingKey createServerSettingKey(String serverName) throws IRException {
        return new ServerSettingKey(serverName);
    }

    public static SettingKey createLogSettingKey() throws IRException {
        return new LogSettingKey();
    }

    public static SettingKey createCollectionListKey() throws IRException {
        return new CollectionListSettingKey();
    }

    public static SettingKey createDBWatcherListKey(String collectionID) throws IRException {
        return new DBWatcherListSettingKey(collectionID);
    }

    public static SettingKey createDBWatcherKey(String collectionID, String dbWatcherID) throws IRException {
        return new DBWatcherSettingKey(collectionID, dbWatcherID);
    }

    public static SettingKey createCollectionKey(String collectionID) throws IRException {
        return new CollectionSettingKey(collectionID);
    }

    public static SettingKey createProfileKey(String collectionID) throws IRException {
        return new ProfileSettingKey(collectionID);
    }

    public static SettingKey createDataSourceKey() throws IRException {
        return new DataSourceSettingKey();
    }

    public static SettingKey createMailReporterSettingKey() throws IRException {
        return new MailReporterSettingKey();
    }

    public static SettingKey createBrokerSettingKey() throws IRException {
        return new BrokerSettingKey();
    }

    public static SettingKey createDBWatcherFilterKey() throws IRException {
        return new FilterSettingKey();
    }

    public void init(String prefix, String fileName) throws IRException {
        Assert.ready();
        File settingFile = new File(SETTING_REPOSITORY, String.valueOf(prefix) + "/" + fileName);
        File fullPrefix = settingFile.getParentFile();
        this.prefix = fullPrefix.getAbsolutePath().substring(SETTING_REPOSITORY.getAbsolutePath().length());
        this.fileName = settingFile.getName();
    }

    public File toFile() throws IRException {
        Assert.ready();
        return new File(SETTING_REPOSITORY, String.valueOf(this.prefix) + "/" + this.fileName);
    }

    public String getUri() throws IRException {
        return this.toFile().getAbsolutePath();
    }

    public String getAbsolutePrefix() {
        return this.getParentFile().getAbsolutePath();
    }

    public File getParentFile() {
        return new File(SETTING_REPOSITORY, this.prefix);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return String.valueOf(this.prefix.replace('\\', '/')) + "/" + this.fileName;
    }

    public boolean equals(Object o) {
        SettingKey castedObj = (SettingKey)o;
        return this.toString().equals(castedObj.toString());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.prefix == null ? 0 : this.prefix.hashCode());
        hashCode = 31 * hashCode + (this.fileName == null ? 0 : this.fileName.hashCode());
        return hashCode;
    }

    public static SettingKey createExtensionListKey() throws IRException {
        return new ExtensionListKey();
    }

    static class Assert {
        Assert() {
        }

        public static void ready() throws IRException {
            if (SETTING_REPOSITORY == null) {
                throw new IRException("SettingKey is not initialized.");
            }
        }
    }

    static class BrokerSettingKey
    extends SettingKey {
        public BrokerSettingKey() throws IRException {
            super("brokerSetting.xml");
        }
    }

    static class CollectionListSettingKey
    extends SettingKey {
        public CollectionListSettingKey() throws IRException {
            super("collectionList.xml");
        }
    }

    static class CollectionSettingKey
    extends SettingKey {
        public CollectionSettingKey(String collectionID) throws IRException {
            super(collectionID, "collectionSetting.xml");
        }
    }

    static class DBWatcherListSettingKey
    extends SettingKey {
        public DBWatcherListSettingKey(String collectionID) throws IRException {
            super(String.valueOf(collectionID) + "/dbwatcher", "list.xml");
        }
    }

    static class DBWatcherSettingKey
    extends SettingKey {
        public DBWatcherSettingKey(String collectionID, String dbWatcherID) throws IRException {
            super(String.valueOf(collectionID) + "/dbwatcher", String.valueOf(dbWatcherID) + ".xml");
        }
    }

    static class DataSourceSettingKey
    extends SettingKey {
        public DataSourceSettingKey() throws IRException {
            super("dataSourceSetting.xml");
        }
    }

    static class ExtensionListKey
    extends SettingKey {
        public ExtensionListKey() throws IRException {
            super("extensionList.xml");
        }
    }

    static class FilterSettingKey
    extends SettingKey {
        public FilterSettingKey() throws IRException {
            super("dbWatcherFilterSetting.xml");
        }
    }

    static class LogSettingKey
    extends SettingKey {
        public LogSettingKey() throws IRException {
            super("logSetting.xml");
        }
    }

    static class MailReporterSettingKey
    extends SettingKey {
        public MailReporterSettingKey() throws IRException {
            super("mailReporter.xml");
        }
    }

    static class ProfileSettingKey
    extends SettingKey {
        public ProfileSettingKey(String collectionID) throws IRException {
            super(collectionID, "profileSetting.xml");
        }
    }

    static class ServerListSettingKey
    extends SettingKey {
        public ServerListSettingKey() throws IRException {
            super("serverList.xml");
        }
    }

    static class ServerSettingKey
    extends SettingKey {
        public ServerSettingKey(String serverName) throws IRException {
            super(String.valueOf(serverName) + ".xml");
        }
    }
}

