/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.exporter.impl.runtime;

import com.diquest.ir.common.setting.exporter.impl.runtime.XMLSerializer;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ContentHandlerAdaptor
implements ContentHandler {
    private final ArrayList prefixMap = new ArrayList();
    private final XMLSerializer serializer;
    private final StringBuffer text = new StringBuffer();

    public ContentHandlerAdaptor(XMLSerializer _serializer) {
        this.serializer = _serializer;
    }

    public void startDocument() throws SAXException {
        this.prefixMap.clear();
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMap.add(prefix);
        this.prefixMap.add(uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.flushText();
        int len = atts.getLength();
        this.serializer.startElement(namespaceURI, localName);
        int i = 0;
        while (i < len) {
            String qname = atts.getQName(i);
            int idx = qname.indexOf(58);
            String prefix = idx == -1 ? qname : qname.substring(0, idx);
            this.serializer.getNamespaceContext().declareNamespace(atts.getURI(i), prefix, true);
            ++i;
        }
        i = 0;
        while (i < this.prefixMap.size()) {
            String prefix = (String)this.prefixMap.get(i);
            this.serializer.getNamespaceContext().declareNamespace((String)this.prefixMap.get(i + 1), prefix, prefix.length() != 0);
            i += 2;
        }
        this.serializer.endNamespaceDecls();
        i = 0;
        while (i < len) {
            this.serializer.startAttribute(atts.getURI(i), atts.getLocalName(i));
            this.serializer.text(atts.getValue(i), null);
            this.serializer.endAttribute();
            ++i;
        }
        this.prefixMap.clear();
        this.serializer.endAttributes();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.flushText();
        this.serializer.endElement();
    }

    private void flushText() throws SAXException {
        if (this.text.length() != 0) {
            this.serializer.text(this.text.toString(), null);
            this.text.setLength(0);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

