/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.affilter.DbWatcherFilterSetting;
import com.diquest.ir.common.setting.affilter.DbWatcherFilterSettingList;
import com.diquest.ir.common.setting.affilter.Extension;
import com.diquest.ir.common.setting.affilter.ObjectFactory;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.util.msg.Transmitable;
import java.util.List;
import javax.xml.bind.JAXBException;

public class AttachFileFilterSettingManager
extends SettingHandler {
    private static ObjectFactory FACTORY = new ObjectFactory();

    public AttachFileFilterSettingManager() {
    }

    public AttachFileFilterSettingManager(String prefix, String fileName, Object settingObject) {
        super(prefix, fileName, settingObject);
    }

    public AttachFileFilterSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    public static AttachFileFilterSettingManager create(String prefix, String fileName) throws IRException {
        try {
            return new AttachFileFilterSettingManager(prefix, fileName, FACTORY.createDbWatcherFilterSettingList());
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create AttachFileFilterSettingManager", (Throwable)e);
        }
    }

    public static AttachFileFilterSettingManager create() throws IRException {
        try {
            return new AttachFileFilterSettingManager(null, null, FACTORY.createDbWatcherFilterSettingList());
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create AttachFileFilterSettingManager", (Throwable)e);
        }
    }

    public static AttachFileFilterSettingManager readFromObject(Object filterSetting) {
        return new AttachFileFilterSettingManager(null, null, filterSetting);
    }

    public static AttachFileFilterSettingManager readFromFile(String prefix, String fileName) throws IRException {
        try {
            return new AttachFileFilterSettingManager(prefix, fileName);
        }
        catch (IRException e) {
            AttachFileFilterSettingManager settingMgr = AttachFileFilterSettingManager.create(prefix, fileName);
            settingMgr.save();
            return settingMgr;
        }
    }

    public List getFilterSettingList() {
        return ((DbWatcherFilterSettingList)this.getSettingObject()).getDbWatcherFilterSetting();
    }

    public DbWatcherFilterSetting addFilterSetting(String id, String internalFileFilterDefaultEncoding) throws IRException {
        try {
            DbWatcherFilterSetting filterSetting = FACTORY.createDbWatcherFilterSetting();
            filterSetting.setId(id);
            filterSetting.setInternalFileFilterDefaultEncoding(internalFileFilterDefaultEncoding);
            this.getFilterSettingList().add(filterSetting);
            return filterSetting;
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add filter setting", (Throwable)e);
        }
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.affilter";
    }

    public Transmitable getInstance() {
        return new AttachFileFilterSettingManager();
    }

    public DbWatcherFilterSetting getFilterSetting(String id) {
        int i = 0;
        while (i < this.getFilterSettingList().size()) {
            DbWatcherFilterSetting filterSetting = (DbWatcherFilterSetting)this.getFilterSettingList().get(i);
            if (id.equals(filterSetting.getId())) {
                return filterSetting;
            }
            ++i;
        }
        return null;
    }

    public boolean removeFilterSetting(String id) {
        List settings = this.getFilterSettingList();
        int i = 0;
        while (i < settings.size()) {
            DbWatcherFilterSetting filterSetting = (DbWatcherFilterSetting)settings.get(i);
            if (id.equals(filterSetting.getId())) {
                settings.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean createExtension(String parentId, String name, boolean removeHtmlTag, boolean useFileFilter, boolean useTextFilter, boolean autoDetect, String encoding) throws IRException {
        try {
            List extensionList = this.retrieveExtensionList(parentId);
            Extension extension = FACTORY.createExtension();
            extension.setName(name);
            extension.setUseFileFilter(useFileFilter);
            extension.setUseTextFilter(useTextFilter);
            extension.setRemoveHtmlTag(removeHtmlTag);
            extension.setAutoDetect(autoDetect);
            extension.setEncoding(encoding);
            extensionList.add(extension);
            return true;
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create attached file extension", (Throwable)e);
        }
    }

    public Extension retrieveExtension(String parentId, String name) {
        List extensionList = this.retrieveExtensionList(parentId);
        int i = 0;
        while (i < extensionList.size()) {
            Extension extension = (Extension)extensionList.get(i);
            if (name.equals(extension.getName())) {
                return extension;
            }
            ++i;
        }
        return null;
    }

    public List retrieveExtensionList(String parentId) {
        return this.getFilterSetting(parentId).getExtension();
    }

    public Extension updateExtension(String parentId, String name, boolean removeHtmlTag, boolean useFileFilter, boolean useTextFilter) {
        return this.updateExtension(parentId, name, removeHtmlTag, useFileFilter, useTextFilter, false, null);
    }

    public Extension updateExtension(String parentId, String name, boolean removeHtmlTag, boolean useFileFilter, boolean useTextFilter, boolean autoDetect, String encoding) {
        Extension extension = this.retrieveExtension(parentId, name);
        extension.setRemoveHtmlTag(removeHtmlTag);
        extension.setUseFileFilter(useFileFilter);
        extension.setUseTextFilter(useTextFilter);
        extension.setAutoDetect(autoDetect);
        extension.setEncoding(encoding);
        return extension;
    }

    public boolean deleteExtension(String parentId, String name) {
        List extensionList = this.retrieveExtensionList(parentId);
        int i = 0;
        while (i < extensionList.size()) {
            Extension extension = (Extension)extensionList.get(i);
            if (name.equals(extension.getName())) {
                extensionList.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updateAttributes(String id, String internalFileFilterDefaultEncoding) {
        this.getFilterSetting(id).setInternalFileFilterDefaultEncoding(internalFileFilterDefaultEncoding);
    }
}

