/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.collectionlist.CollectionList;
import com.diquest.ir.common.setting.collectionlist.Element;
import com.diquest.ir.common.setting.collectionlist.ObjectFactory;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.util.msg.Transmitable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;

public class CollectionListSettingManager
extends SettingHandler {
    private static ObjectFactory OF = new ObjectFactory();

    public CollectionListSettingManager() {
    }

    private CollectionListSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    private CollectionListSettingManager(String prefix, String fileName, Object settingObj) throws IRException {
        super(prefix, fileName, settingObj);
    }

    public static CollectionListSettingManager readFromFile(String prefix, String fileName) throws IRException {
        try {
            return new CollectionListSettingManager(prefix, fileName);
        }
        catch (IRException e) {
            CollectionListSettingManager setting = CollectionListSettingManager.create(prefix, fileName);
            setting.save();
            return setting;
        }
    }

    public static CollectionListSettingManager create(String prefix, String fileName) throws IRException {
        try {
            CollectionList settingObj = OF.createCollectionList();
            return new CollectionListSettingManager(prefix, fileName, settingObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create CollectionListSettingManager", (Throwable)e);
        }
    }

    public static CollectionListSettingManager readFromObject(String prefix, Object settingObj, String fileName) throws IRException {
        return new CollectionListSettingManager(prefix, fileName, settingObj);
    }

    public static CollectionListSettingManager readFromObject(Object settingObj) throws IRException {
        return CollectionListSettingManager.readFromObject(null, settingObj, null);
    }

    public void add(String collectionID) throws IRException {
        try {
            if (this.isNotNull(collectionID)) {
                throw new IRException(2, "CollectionID(" + collectionID + ") already exists.");
            }
            Element element = OF.createElement();
            element.setId(collectionID);
            this.getCollectionListSetting().getElement().add(element);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add collection(" + collectionID + ".", (Throwable)e);
        }
    }

    public boolean isNotNull(String collectionID) {
        int i = 0;
        while (i < this.getCollectionListSetting().getElement().size()) {
            Element element = (Element)this.getCollectionListSetting().getElement().get(i);
            if (element.getId().equals(collectionID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isNull(String collectionID) {
        return !this.isNotNull(collectionID);
    }

    public boolean remove(String collectionID) {
        List collections = this.getCollectionListSetting().getElement();
        int i = 0;
        while (i < collections.size()) {
            Element element = (Element)collections.get(i);
            if (element.getId().equals(collectionID)) {
                collections.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public CollectionList getCollectionListSetting() {
        return (CollectionList)this.getSettingObject();
    }

    public List getCollectionIDList() {
        ArrayList<String> collectionlist = new ArrayList<String>();
        int i = 0;
        while (i < this.getCollectionListSetting().getElement().size()) {
            collectionlist.add(((Element)this.getCollectionListSetting().getElement().get(i)).getId());
            ++i;
        }
        return collectionlist;
    }

    public Transmitable getInstance() {
        return new CollectionListSettingManager();
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.collectionlist";
    }
}

