/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.setting.dbwatcherlist.DbWatcherList;
import com.diquest.ir.common.setting.dbwatcherlist.Element;
import com.diquest.ir.common.setting.dbwatcherlist.ObjectFactory;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.util.msg.Transmitable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;

public class DBWatcherListSettingManager
extends SettingHandler {
    private static final ObjectFactory OF = new ObjectFactory();

    public DBWatcherListSettingManager() {
    }

    private DBWatcherListSettingManager(String prefix, String fileName, Object settingObj) {
        super(prefix, fileName, settingObj);
    }

    private DBWatcherListSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    public static DBWatcherListSettingManager create(String prefix, String fileName, String collectionID) throws IRException {
        DbWatcherList setting = null;
        try {
            setting = OF.createDbWatcherList();
            setting.setCollectionID(collectionID);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create DBWatcherListSettingManager", ProfileKey.getKey(collectionID), (Throwable)e);
        }
        return new DBWatcherListSettingManager(prefix, fileName, setting);
    }

    public static DBWatcherListSettingManager create(String collectionID) throws IRException {
        return DBWatcherListSettingManager.create(null, null, collectionID);
    }

    public static DBWatcherListSettingManager readFromFile(String prefix, String collectionID, String fileName) throws IRException {
        try {
            return new DBWatcherListSettingManager(prefix, fileName);
        }
        catch (IRException e) {
            DBWatcherListSettingManager settingMgr = DBWatcherListSettingManager.create(prefix, fileName, collectionID);
            settingMgr.save();
            return settingMgr;
        }
    }

    public static DBWatcherListSettingManager readFromObject(String prefix, String fileName, Object settingObj) throws IRException {
        return new DBWatcherListSettingManager(prefix, fileName, settingObj);
    }

    public static DBWatcherListSettingManager readFromObject(Object settingObj) throws IRException {
        return DBWatcherListSettingManager.readFromObject(null, null, settingObj);
    }

    public DbWatcherList getDbWatcherListSetting() {
        DbWatcherList setting = (DbWatcherList)super.getSettingObject();
        return setting;
    }

    public List getDBWatcherIDList() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.getDbWatcherListSetting().getElement().size()) {
            result.add(((Element)this.getDbWatcherListSetting().getElement().get(i)).getId());
            ++i;
        }
        return result;
    }

    private boolean isDuplicate(String dbWatcherID) {
        int i = 0;
        while (i < this.getDbWatcherListSetting().getElement().size()) {
            Element element = (Element)this.getDbWatcherListSetting().getElement().get(i);
            if (dbWatcherID.equals(element.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void add(String dbWatcherID) throws IRException {
        try {
            if (this.isDuplicate(dbWatcherID)) {
                throw new IRException(2, "dbwatcher setting(" + dbWatcherID + ") already exists.", ProfileKey.getKey(this.getDbWatcherListSetting().getCollectionID()));
            }
            Element element = OF.createElement();
            element.setId(dbWatcherID);
            this.getDbWatcherListSetting().getElement().add(element);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add dbwatcher setting", ProfileKey.getKey(this.getDbWatcherListSetting().getCollectionID()), (Throwable)e);
        }
    }

    public boolean isNull(String dbWatcherID) {
        int i = 0;
        while (i < this.getDbWatcherListSetting().getElement().size()) {
            Element element = (Element)this.getDbWatcherListSetting().getElement().get(i);
            if (dbWatcherID.equals(element.getId())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void remove(String dbWatcherID) {
        List elements = this.getDbWatcherListSetting().getElement();
        int i = 0;
        while (i < elements.size()) {
            Element element = (Element)elements.get(i);
            if (dbWatcherID.equals(element.getId())) {
                elements.remove(i);
                return;
            }
            ++i;
        }
    }

    public List list() {
        return this.getDbWatcherListSetting().getElement();
    }

    public Element get(String dbWatcherID) {
        int i = 0;
        while (i < this.getDbWatcherListSetting().getElement().size()) {
            Element element = (Element)this.getDbWatcherListSetting().getElement().get(i);
            if (element.getId().equals(dbWatcherID)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Transmitable getInstance() {
        return new DBWatcherListSettingManager();
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.dbwatcherlist";
    }

    public void setThread(int value) {
        this.getDbWatcherListSetting().setThread(value);
    }

    public int getThread() {
        return this.getDbWatcherListSetting().getThread();
    }
}

