/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.datasource.DataSourceSetting;
import com.diquest.ir.common.setting.datasource.DataSourceSettingList;
import com.diquest.ir.common.setting.datasource.ObjectFactory;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.util.encode.SimpleEncoder;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import java.util.List;
import javax.xml.bind.JAXBException;

public class DataSourceSettingManager
extends SettingHandler {
    static ObjectFactory FACTORY = new ObjectFactory();
    static final RdbmsProperties properties = RdbmsPropertiesFactory.load();

    public DataSourceSettingManager() {
    }

    private DataSourceSettingManager(String prefix, String fileName, Object settingObject) {
        super(prefix, fileName, settingObject);
    }

    private DataSourceSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    private DataSourceSettingManager(Object setting) throws JAXBException {
        super(null, null, setting);
    }

    public static DataSourceSettingManager create(String prefix, String fileName) throws IRException {
        try {
            return new DataSourceSettingManager(prefix, fileName, FACTORY.createDataSourceSettingList());
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create DataSourceSettingManager : " + prefix + "/" + fileName, (Throwable)e);
        }
    }

    public static DataSourceSettingManager create() throws IRException {
        try {
            return new DataSourceSettingManager(null, null, FACTORY.createDataSourceSettingList());
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create DataSourceSettingManager", (Throwable)e);
        }
    }

    public static DataSourceSettingManager readFromObject(Object dataSourceSetting) throws IRException {
        try {
            return new DataSourceSettingManager(dataSourceSetting);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create DataSourceSettingManager(read from object)", (Throwable)e);
        }
    }

    public static DataSourceSettingManager readFromFile(String settingRepository, String fileName) throws IRException {
        try {
            return new DataSourceSettingManager(settingRepository, fileName);
        }
        catch (IRException e) {
            DataSourceSettingManager settingMgr = DataSourceSettingManager.create(settingRepository, fileName);
            settingMgr.save();
            return settingMgr;
        }
    }

    public void add(String id, String description, String driver, String url, String userid, String password) throws IRException {
        try {
            DataSourceSetting setting = this.get(id);
            if (setting != null) {
                throw new IRException(2, "Datasource(" + id + ") already exists.");
            }
            DataSourceSetting addend = FACTORY.createDataSourceSetting();
            addend.setId(id);
            addend.setDesc(description);
            addend.setDriver(driver);
            addend.setUrl(url);
            addend.setUserid(userid);
            addend.setPassword(properties.getUseEncryption() ? SimpleEncoder.encrypt((String)password) : password);
            this.getRootSettingObject().getDataSourceSetting().add(addend);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public DataSourceSettingList getRootSettingObject() {
        return (DataSourceSettingList)this.settingObj;
    }

    public DataSourceSetting get(String id) {
        List settings = this.getRootSettingObject().getDataSourceSetting();
        int i = 0;
        while (i < settings.size()) {
            DataSourceSetting setting = (DataSourceSetting)settings.get(i);
            String sid = setting.getId();
            if (sid.equals(id)) {
                return setting;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        List settings = this.getRootSettingObject().getDataSourceSetting();
        int i = 0;
        while (i < settings.size()) {
            DataSourceSetting setting = (DataSourceSetting)settings.get(i);
            sbuf.append(String.valueOf(setting.getId()) + ",");
            ++i;
        }
        return sbuf.toString();
    }

    public void modify(String id, String desc, String driver, String url, String userid, String password) throws IRException {
        DataSourceSetting setting = this.get(id);
        if (setting == null) {
            throw new IRException(2, "Datasource(" + id + ") does not exists.");
        }
        setting.setId(id);
        setting.setDesc(desc);
        setting.setDriver(driver);
        setting.setUrl(url);
        setting.setUserid(userid);
        setting.setPassword(properties.getUseEncryption() ? SimpleEncoder.encrypt((String)password) : password);
    }

    public void delete(String id) throws IRException {
        DataSourceSetting setting = this.get(id);
        if (setting == null) {
            throw new IRException(2, "Datasource(" + id + ") does not exists.");
        }
        List sources = this.getRootSettingObject().getDataSourceSetting();
        int i = 0;
        while (i < sources.size()) {
            DataSourceSetting target = (DataSourceSetting)sources.get(i);
            if (target.getId().equals(id)) {
                sources.remove(i);
                return;
            }
            ++i;
        }
    }

    public List getDataSourceSettingList() {
        return this.getRootSettingObject().getDataSourceSetting();
    }

    public Transmitable getInstance() {
        return new DataSourceSettingManager();
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.datasource";
    }
}

