/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.database.migrate.document.DocumentSyntax;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.exporter.DocumentExporterType;
import com.diquest.ir.common.setting.exporter.Mapping;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.util.msg.Transmitable;
import java.io.File;
import java.util.List;

public class DocumentExporterSettingManager
extends SettingHandler {
    public DocumentExporterSettingManager() {
    }

    private DocumentExporterSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    private DocumentExporterSettingManager(String fileUri) throws IRException {
        super(new File(fileUri));
    }

    public static DocumentExporterSettingManager readFromFile(String prefix, String fileName) throws IRException {
        return new DocumentExporterSettingManager(prefix, fileName);
    }

    public static DocumentExporterSettingManager readFromFile(String fileUri) throws IRException {
        return new DocumentExporterSettingManager(fileUri);
    }

    public List getMappingList() {
        DocumentExporterType exporter = (DocumentExporterType)this.getSettingObject();
        List mappings = exporter.getMapping();
        return mappings;
    }

    public DocumentSyntax toSyntax() {
        List mappings = this.getMappingList();
        String[] idSet = new String[mappings.size()];
        String[][] tuples = new String[mappings.size()][2];
        int i = 0;
        while (i < mappings.size()) {
            Mapping mapping = (Mapping)mappings.get(i);
            idSet[i] = mapping.getDocID();
            tuples[i][0] = mapping.getDbField();
            tuples[i][1] = mapping.getDbType();
            ++i;
        }
        return new DocumentSyntax(idSet, tuples);
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.exporter";
    }

    public Transmitable getInstance() {
        return new DocumentExporterSettingManager();
    }

    public static void main(String[] args) throws IRException {
        DocumentExporterSettingManager exporterSetting = DocumentExporterSettingManager.readFromFile("testdata/documentExporter.xml");
        List mappings = exporterSetting.getMappingList();
        String[] idSet = new String[mappings.size()];
        String[][] tuples = new String[mappings.size()][2];
        int i = 0;
        while (i < mappings.size()) {
            Mapping mapping = (Mapping)mappings.get(i);
            idSet[i] = mapping.getDocID();
            tuples[i][0] = mapping.getDbField();
            tuples[i][1] = mapping.getDbType();
            ++i;
        }
        i = 0;
        while (i < idSet.length) {
            System.out.println(idSet[i]);
            System.out.println(tuples[i][0]);
            System.out.println(tuples[i][1]);
            ++i;
        }
        DocumentSyntax syntax = new DocumentSyntax(idSet, tuples);
    }
}

