/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentFactory {
    static final DOMParser parser = new DOMParser();
    static final InputSource is = new InputSource();

    public static Document create(File file) throws IRException {
        try {
            is.setByteStream(new FileInputStream(file));
            parser.parse(is);
        }
        catch (SAXException e) {
            throw new IRException("A SAXException is occurred.(parsing:" + file.getAbsolutePath() + ")", e);
        }
        catch (IOException e) {
            throw new IRException("An IOException is occurred.(reading:" + file.getAbsolutePath() + ")", e);
        }
        return parser.getDocument();
    }

    public static Document create(String uri) throws IRException {
        return DocumentFactory.create(new File(uri));
    }
}

