/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.log.ErrorLogSetting;
import com.diquest.ir.common.setting.log.ErrorLogSettingType;
import com.diquest.ir.common.setting.log.IndexLogSetting;
import com.diquest.ir.common.setting.log.IndexLogSettingType;
import com.diquest.ir.common.setting.log.JobLogSetting;
import com.diquest.ir.common.setting.log.JobLogSettingType;
import com.diquest.ir.common.setting.log.LogSetting;
import com.diquest.ir.common.setting.log.LogSettingType;
import com.diquest.ir.common.setting.log.ObjectFactory;
import com.diquest.ir.common.setting.log.QueryLogFailSetting;
import com.diquest.ir.common.setting.log.QueryLogFailSettingType;
import com.diquest.ir.common.setting.log.QueryLogFullSetting;
import com.diquest.ir.common.setting.log.QueryLogFullSettingType;
import com.diquest.ir.common.setting.log.QueryLogKeywordSetting;
import com.diquest.ir.common.setting.log.QueryLogPopularSetting;
import com.diquest.ir.common.setting.log.QueryLogPopularSettingType;
import com.diquest.ir.common.setting.log.QueryLogSetting;
import com.diquest.ir.common.setting.log.QueryLogSettingType;
import com.diquest.ir.common.setting.log.QueryLogStatsSetting;
import com.diquest.ir.common.setting.log.QueryLogStatsSettingType;
import com.diquest.ir.common.setting.log.ServerLogSetting;
import com.diquest.ir.common.setting.log.ServerLogSettingType;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.util.msg.Transmitable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import javax.xml.bind.JAXBException;

public class LogSettingManager
extends SettingHandler {
    public static final String PACKAGE_NAME = "com.diquest.ir.common.setting.log";
    private static ObjectFactory OF = new ObjectFactory();

    public static LogSettingManager create(String prefix, String fileName) throws IRException {
        try {
            LogSetting settingObj = OF.createLogSetting();
            return new LogSettingManager(prefix, fileName, settingObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create LogSettingManager", (Throwable)e);
        }
    }

    public static int getErrorLogDataRetentionPeriod(LogSettingType setting) {
        ErrorLogSettingType errorLogSetting = setting.getErrorLogSetting();
        return LogSettingManager.getLevelOneDataRetentionPeriod(setting, errorLogSetting);
    }

    public static int getFailQueryLogDataRetentionPeriod(LogSettingType setting) {
        QueryLogSettingType queryLogSetting = setting.getQueryLogSetting();
        QueryLogFailSettingType detailSetting = null;
        if (queryLogSetting != null) {
            detailSetting = queryLogSetting.getQueryLogFailSetting();
        }
        return LogSettingManager.getQueryLogDataRetentionPeriod(setting, detailSetting);
    }

    public static int getFullQueryLogDataRetentionPeriod(LogSettingType setting) {
        QueryLogSettingType queryLogSetting = setting.getQueryLogSetting();
        QueryLogFullSettingType detailSetting = null;
        if (queryLogSetting != null) {
            detailSetting = queryLogSetting.getQueryLogFullSetting();
        }
        return LogSettingManager.getQueryLogDataRetentionPeriod(setting, detailSetting);
    }

    public static int getIndexLogDataRetentionPeriod(LogSettingType setting) {
        IndexLogSettingType indexLogSetting = setting.getIndexLogSetting();
        return LogSettingManager.getLevelOneDataRetentionPeriod(setting, indexLogSetting);
    }

    public static int getJobLogDataRetentionPeriod(LogSettingType setting) {
        JobLogSettingType jobLogSetting = setting.getJobLogSetting();
        return LogSettingManager.getLevelOneDataRetentionPeriod(setting, jobLogSetting);
    }

    public static int getPopularQueryLogDataRetentionPeriod(LogSettingType setting) {
        QueryLogSettingType queryLogSetting = setting.getQueryLogSetting();
        QueryLogPopularSettingType detailSetting = null;
        if (queryLogSetting != null) {
            detailSetting = queryLogSetting.getQueryLogPopularSetting();
        }
        return LogSettingManager.getQueryLogDataRetentionPeriod(setting, detailSetting);
    }

    public static int getServerLogDataRetentionPeriod(LogSettingType setting) {
        ServerLogSettingType serverLogSetting = setting.getServerLogSetting();
        return LogSettingManager.getLevelOneDataRetentionPeriod(setting, serverLogSetting);
    }

    public static int getStatsQueryLogDataRetentionPeriod(LogSettingType setting) {
        QueryLogSettingType queryLogSetting = setting.getQueryLogSetting();
        QueryLogStatsSettingType detailSetting = null;
        if (queryLogSetting != null) {
            detailSetting = queryLogSetting.getQueryLogStatsSetting();
        }
        return LogSettingManager.getQueryLogDataRetentionPeriod(setting, detailSetting);
    }

    public static LogSettingManager readFromFile(String prefix, String fileName) throws IRException {
        try {
            return new LogSettingManager(prefix, fileName);
        }
        catch (IRException e) {
            LogSettingManager setting = LogSettingManager.create(prefix, fileName);
            setting.save();
            return setting;
        }
    }

    public static LogSettingManager readFromObject(Object settingObj) {
        return LogSettingManager.readFromObject(null, settingObj, null);
    }

    public static LogSettingManager readFromObject(String prefix, Object settingObj, String fileName) {
        return new LogSettingManager(prefix, fileName, settingObj);
    }

    private static int getLevelOneDataRetentionPeriod(LogSettingType setting, Object innerSetting) {
        int candidate = 0;
        try {
            Method method;
            if (innerSetting != null && (candidate = ((Integer)(method = innerSetting.getClass().getMethod("getDataRetentionPeriod", null)).invoke(innerSetting, null)).intValue()) > 0) {
                return candidate;
            }
            if (setting.getDataRetentionPeriod() > 0) {
                candidate = setting.getDataRetentionPeriod();
                return candidate;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return -candidate;
    }

    private static int getQueryLogDataRetentionPeriod(LogSettingType setting, Object innerSetting) {
        int candidate = 0;
        try {
            Method method;
            if (innerSetting != null && (candidate = ((Integer)(method = innerSetting.getClass().getMethod("getDataRetentionPeriod", null)).invoke(innerSetting, null)).intValue()) > 0) {
                return candidate;
            }
            QueryLogSettingType queryLogSetting = setting.getQueryLogSetting();
            if (queryLogSetting != null && queryLogSetting.getDataRetentionPeriod() > 0) {
                candidate = setting.getDataRetentionPeriod();
                return candidate;
            }
            if (setting.getDataRetentionPeriod() > 0) {
                candidate = setting.getDataRetentionPeriod();
                return candidate;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return -candidate;
    }

    public LogSettingManager() {
    }

    private LogSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    private LogSettingManager(String prefix, String fileName, Object settingObj) {
        super(prefix, fileName, settingObj);
    }

    public int getErrorLogDataRetentionPeriod() {
        LogSetting setting = (LogSetting)this.getSettingObject();
        return LogSettingManager.getErrorLogDataRetentionPeriod(setting);
    }

    public ErrorLogSetting getErrorLogSetting() {
        return (ErrorLogSetting)this.getLogSetting().getErrorLogSetting();
    }

    public int getFailQueryLogDataRetentionPeriod() {
        LogSetting setting = (LogSetting)this.getSettingObject();
        return LogSettingManager.getFailQueryLogDataRetentionPeriod(setting);
    }

    public int getFullQueryLogDataRetentionPeriod() {
        LogSetting setting = (LogSetting)this.getSettingObject();
        return LogSettingManager.getFullQueryLogDataRetentionPeriod(setting);
    }

    public int getIndexLogDataRetentionPeriod() {
        LogSetting setting = (LogSetting)this.getSettingObject();
        return LogSettingManager.getIndexLogDataRetentionPeriod(setting);
    }

    public IndexLogSetting getIndexLogSetting() {
        return (IndexLogSetting)this.getLogSetting().getIndexLogSetting();
    }

    public Transmitable getInstance() {
        return new LogSettingManager();
    }

    public int getJobLogDataRetentionPeriod() {
        LogSetting setting = (LogSetting)this.getSettingObject();
        return LogSettingManager.getJobLogDataRetentionPeriod(setting);
    }

    public JobLogSetting getJobLogSetting() {
        return (JobLogSetting)this.getLogSetting().getJobLogSetting();
    }

    public LogSetting getLogSetting() {
        return (LogSetting)this.getSettingObject();
    }

    public String getPackageName() {
        return PACKAGE_NAME;
    }

    public int getPopularQueryLogDataRetentionPeriod() {
        LogSetting setting = (LogSetting)this.getSettingObject();
        return LogSettingManager.getPopularQueryLogDataRetentionPeriod(setting);
    }

    public QueryLogFailSetting getQueryLogFailSetting() {
        return (QueryLogFailSetting)this.getQueryLogSetting().getQueryLogFailSetting();
    }

    public QueryLogFullSetting getQueryLogFullSetting() {
        return (QueryLogFullSetting)this.getQueryLogSetting().getQueryLogFullSetting();
    }

    public QueryLogKeywordSetting getQueryLogKeywordSetting() {
        return (QueryLogKeywordSetting)this.getQueryLogSetting().getQueryLogKeywordSetting();
    }

    public QueryLogPopularSetting getQueryLogPopularSetting() {
        return (QueryLogPopularSetting)this.getQueryLogSetting().getQueryLogPopularSetting();
    }

    public QueryLogSetting getQueryLogSetting() {
        return (QueryLogSetting)this.getLogSetting().getQueryLogSetting();
    }

    public QueryLogStatsSetting getQueryLogStatsSetting() {
        return (QueryLogStatsSetting)this.getQueryLogSetting().getQueryLogStatsSetting();
    }

    public int getServerLogDataRetentionPeriod() {
        LogSetting setting = (LogSetting)this.getSettingObject();
        return LogSettingManager.getServerLogDataRetentionPeriod(setting);
    }

    public ServerLogSetting getServerLogSetting() {
        return (ServerLogSetting)this.getLogSetting().getServerLogSetting();
    }

    public int getStatsQueryLogDataRetentionPeriod() {
        LogSetting setting = (LogSetting)this.getSettingObject();
        return LogSettingManager.getStatsQueryLogDataRetentionPeriod(setting);
    }

    public int getUploadPeriod(Object object) {
        try {
            Method method = object.getClass().getMethod("getUploadPeriod", null);
            Integer period = (Integer)method.invoke(object, null);
            return period;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDataRetentionPeriod(Object object, int period) {
        if (period < 0) {
            throw new IllegalArgumentException("The period should not be negative.");
        }
        try {
            Method method = object.getClass().getMethod("setDataRetentionPeriod", Integer.TYPE);
            method.invoke(object, new Integer(period));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void setErrorLogDataRetentionPeriod(int period) {
        this.setDataRetentionPeriod(this.getErrorLogSetting(), period);
    }

    public void setIndexLogDataRetentionPeriod(int period) {
        this.setDataRetentionPeriod(this.getIndexLogSetting(), period);
    }

    public void setJobLogDataRetentionPeriod(int period) {
        this.setDataRetentionPeriod(this.getJobLogSetting(), period);
    }

    public void setQueryLogKeywordSetting(boolean trim, String whitespace, boolean engMap, boolean hanjaMap, boolean spCharMap) {
        if (!this.isValidWhitespace(whitespace)) {
            throw new IllegalArgumentException("Not a valid whitespace value: keep, condense(default), and remove");
        }
        QueryLogKeywordSetting queryLogKeywordSetting = this.getQueryLogKeywordSetting();
        queryLogKeywordSetting.setTrim(trim);
        queryLogKeywordSetting.setWhitespace(whitespace);
        queryLogKeywordSetting.setEngMap(engMap);
        queryLogKeywordSetting.setHanjaMap(hanjaMap);
        queryLogKeywordSetting.setSpCharMap(spCharMap);
    }

    public void setServerLogDataRetentionPeriod(int period) {
        this.setDataRetentionPeriod(this.getServerLogSetting(), period);
    }

    public void setQueryLogFullUploadPeriod(int period) {
        this.setUploadPeriod(this.getQueryLogFullSetting(), period);
    }

    public void setServerLogUploadPeriod(int period) {
        this.setUploadPeriod(this.getServerLogSetting(), period);
    }

    public void setUploadPeriod(Object object, int period) {
        if (period < 0) {
            throw new IllegalArgumentException("The period should not be negative.");
        }
        if (!(period >= 60 && period % 60 == 0 || period < 60 && 60 % period == 0)) {
            throw new IllegalArgumentException("The greatest common divisor between the period and 60 should be a minimum value between the period and 60.");
        }
        try {
            Method method = object.getClass().getMethod("setUploadPeriod", Integer.TYPE);
            method.invoke(object, new Integer(period));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isValidWhitespace(String ws) {
        return ws == null || "keep".equals(ws) || "condense".equals(ws) || "remove".equals(ws);
    }

    public static class Use {
        public static final int FORCE = 0;
        public static final int TRUE = 1;
        public static final int FALSE = 2;
        static final String FORCE_EXP = "force";
        static final String TRUE_EXP = "true";
        static final String FALSE_EXP = "false";

        public static int parse(String use) throws ParseException {
            if (FORCE_EXP.equalsIgnoreCase(use)) {
                return 0;
            }
            if (TRUE_EXP.equalsIgnoreCase(use)) {
                return 1;
            }
            if (FALSE_EXP.equalsIgnoreCase(use)) {
                return 2;
            }
            throw new ParseException(use, 0);
        }

        public static boolean isUse(String value) throws ParseException {
            return Use.isUse(Use.parse(value));
        }

        public static boolean isUse(int value) {
            return value == 0 || 1 == value;
        }
    }

    public static final class Whitespace {
        public static final int CONDENSE = 0;
        public static final int REMOVE = 1;
        public static final int KEEP = 2;
        public static final String CONDENSE_EXP = "condense";
        public static final String REMOVE_EXP = "remove";
        public static final String KEEP_EXP = "keep";
        public static final int DEFAULT = 0;

        public static int parse(String whitespace) {
            if (CONDENSE_EXP.equalsIgnoreCase(whitespace)) {
                return 0;
            }
            if (REMOVE_EXP.equalsIgnoreCase(whitespace)) {
                return 1;
            }
            if (KEEP_EXP.equalsIgnoreCase(whitespace)) {
                return 2;
            }
            return 0;
        }
    }
}

