/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.mailreporter.MailReporterSetting;
import com.diquest.ir.common.setting.mailreporter.ObjectFactory;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.util.msg.Transmitable;
import javax.xml.bind.JAXBException;

public class MailReporterSettingManager
extends SettingHandler {
    private static ObjectFactory OF = new ObjectFactory();

    public MailReporterSettingManager() {
    }

    public MailReporterSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    public MailReporterSettingManager(String prefix, String fileName, Object settingObj) throws IRException {
        super(prefix, fileName, settingObj);
    }

    public static MailReporterSettingManager readFromObject(String prefix, String fileName, Object settingObject) throws IRException {
        try {
            return new MailReporterSettingManager(prefix, fileName, settingObject);
        }
        catch (IRException e) {
            return MailReporterSettingManager.create(prefix, fileName);
        }
    }

    public static MailReporterSettingManager readFromObject(Object settingObject) throws IRException {
        return MailReporterSettingManager.readFromObject(null, null, settingObject);
    }

    public static MailReporterSettingManager create(String prefix, String fileName) throws IRException {
        try {
            MailReporterSetting settingObj = OF.createMailReporterSetting();
            return new MailReporterSettingManager(prefix, fileName, settingObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during createing setting object : " + prefix + "/" + fileName + ".", (Throwable)e);
        }
    }

    public static MailReporterSettingManager create() throws IRException {
        return MailReporterSettingManager.create(null, null);
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.mailreporter";
    }

    public Transmitable getInstance() {
        return new MailReporterSettingManager();
    }

    public MailReporterSetting getSetting() {
        return (MailReporterSetting)this.getSettingObject();
    }

    public void modifySetting(boolean auth, String hostname, String username, String password, String from, String personal, String to, boolean useMailReport) throws IRException {
        MailReporterSetting setting = this.getSetting();
        if (setting == null) {
            throw new IRException(2, "Cannot modify MailReporterSetting : setting does not exists.");
        }
        setting.setAuth(auth);
        setting.setHostname(hostname);
        setting.setUsername(username);
        setting.setPassword(password);
        setting.setFrom(from);
        setting.setPersonal(personal);
        setting.setTo(to);
        setting.setUseMailReport(useMailReport);
    }

    public void modifySetting(boolean auth, int errorLevel, String hostname, String username, String password, String from, String personal, String to, boolean useMailReport) throws IRException {
        MailReporterSetting setting = this.getSetting();
        if (setting == null) {
            throw new IRException(2, "Cannot modify MailReporterSetting : setting does not exists.");
        }
        setting.setAuth(auth);
        setting.setErrorLevel(errorLevel);
        setting.setHostname(hostname);
        setting.setUsername(username);
        setting.setPassword(password);
        setting.setFrom(from);
        setting.setPersonal(personal);
        setting.setTo(to);
        setting.setUseMailReport(useMailReport);
    }
}

