/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.common.setting.profile.BannedWord;
import com.diquest.ir.common.setting.profile.CategoryRanking;
import com.diquest.ir.common.setting.profile.DefaultProfile;
import com.diquest.ir.common.setting.profile.DocumentRanking;
import com.diquest.ir.common.setting.profile.InheritThesaurus;
import com.diquest.ir.common.setting.profile.ObjectFactory;
import com.diquest.ir.common.setting.profile.Profile;
import com.diquest.ir.common.setting.profile.ProfileSetting;
import com.diquest.ir.common.setting.profile.RankingModel;
import com.diquest.ir.common.setting.profile.Recommend;
import com.diquest.ir.common.setting.profile.Redirect;
import com.diquest.ir.common.setting.profile.Stopword;
import com.diquest.ir.common.setting.profile.Thesaurus;
import com.diquest.ir.common.setting.profile.ThesaurusList;
import com.diquest.ir.util.msg.Transmitable;
import java.util.List;
import javax.xml.bind.JAXBException;

public class ProfileSettingManager
extends SettingHandler {
    public static final String PROFILE_SETTING_XML = "profileSetting.xml";
    public static final String PACKAGE_NAME = "com.diquest.ir.common.setting.profile";
    private static ObjectFactory OF = new ObjectFactory();

    public ProfileSettingManager() {
    }

    public ProfileSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    public ProfileSettingManager(String prefix, String fileName, Object settingObj) throws IRException {
        super(prefix, fileName, settingObj);
    }

    public ProfileSetting getProfileSetting() {
        return (ProfileSetting)this.getSettingObject();
    }

    public void setCollectionID(String collectionID) {
        ((ProfileSetting)this.settingObj).setCollectionID(collectionID);
    }

    public static ProfileSettingManager readFromFile(String prefix, String fileName) throws IRException {
        return new ProfileSettingManager(prefix, fileName);
    }

    public static ProfileSettingManager readFromObject(String prefix, String fileName, Object settingObject) throws IRException {
        try {
            return new ProfileSettingManager(prefix, fileName, settingObject);
        }
        catch (IRException e) {
            return ProfileSettingManager.create(prefix, fileName);
        }
    }

    public static ProfileSettingManager readFromObject(Object settingObject) throws IRException {
        return ProfileSettingManager.readFromObject(null, null, settingObject);
    }

    public static ProfileSettingManager create(String prefix, String fileName) throws IRException {
        try {
            ProfileSetting settingObj = OF.createProfileSetting();
            return new ProfileSettingManager(prefix, fileName, settingObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during createing setting object : " + prefix + "/" + fileName + ".", (Throwable)e);
        }
    }

    public static ProfileSettingManager create(String prefix, String collectionID, String fileName) throws IRException {
        try {
            ProfileSetting settingObj = OF.createProfileSetting();
            settingObj.setCollectionID(collectionID);
            DefaultProfile dp = OF.createDefaultProfile();
            dp.setInheritBannedWord(true);
            dp.setInheritRecommend(true);
            dp.setInheritRedirect(true);
            dp.setInheritStopword(true);
            InheritThesaurus equiSynonym = OF.createInheritThesaurus();
            equiSynonym.setInherit(true);
            equiSynonym.setName("EQUIV_SYNONYM");
            dp.getInheritThesaurus().add(equiSynonym);
            InheritThesaurus sysEquiSynonym = OF.createInheritThesaurus();
            sysEquiSynonym.setInherit(true);
            sysEquiSynonym.setName("SYS_EQUIV_SYNONYM");
            dp.getInheritThesaurus().add(sysEquiSynonym);
            InheritThesaurus quasiSynonym = OF.createInheritThesaurus();
            quasiSynonym.setInherit(true);
            quasiSynonym.setName("QUASI_SYNONYM");
            dp.getInheritThesaurus().add(quasiSynonym);
            InheritThesaurus sysQuasiSynonym = OF.createInheritThesaurus();
            sysQuasiSynonym.setInherit(true);
            sysQuasiSynonym.setName("SYS_QUASI_SYNONYM");
            dp.getInheritThesaurus().add(sysQuasiSynonym);
            settingObj.setDefaultProfile(dp);
            return new ProfileSettingManager(prefix, fileName, settingObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during createing setting object : " + prefix + "/" + fileName + ".", ProfileKey.getKey(collectionID), (Throwable)e);
        }
    }

    public static Profile createProfile(String profileID) throws IRException {
        ObjectFactory of = new ObjectFactory();
        try {
            Profile profile = of.createProfile();
            RankingModel rankingModel = of.createRankingModel();
            CategoryRanking categoryRanking = of.createCategoryRanking();
            DocumentRanking documentRanking = of.createDocumentRanking();
            Stopword stopword = of.createStopword();
            BannedWord bannedWord = of.createBannedWord();
            Recommend recommend = of.createRecommend();
            Redirect redirect = of.createRedirect();
            ThesaurusList thesaurusList = of.createThesaurusList();
            thesaurusList.getThesaurus().clear();
            Thesaurus equiSynonym = of.createThesaurus();
            equiSynonym.setName("EQUIV_SYNONYM");
            thesaurusList.getThesaurus().add(equiSynonym);
            Thesaurus sysEquiSynonym = of.createThesaurus();
            sysEquiSynonym.setName("SYS_EQUIV_SYNONYM");
            thesaurusList.getThesaurus().add(sysEquiSynonym);
            Thesaurus quasiSynonym = of.createThesaurus();
            quasiSynonym.setName("QUASI_SYNONYM");
            thesaurusList.getThesaurus().add(quasiSynonym);
            Thesaurus sysQuasiSynonym = of.createThesaurus();
            sysQuasiSynonym.setName("SYS_QUASI_SYNONYM");
            thesaurusList.getThesaurus().add(sysQuasiSynonym);
            profile.setId(profileID);
            profile.setRankingModel(rankingModel);
            profile.setCategoryRanking(categoryRanking);
            profile.setDocumentRanking(documentRanking);
            profile.setStopword(stopword);
            profile.setBannedWord(bannedWord);
            profile.setRecommend(recommend);
            profile.setRedirect(redirect);
            profile.setThesaurusList(thesaurusList);
            return profile;
        }
        catch (JAXBException e) {
            throw new IRException(2, "Cannot create Profile Setting Object : profileID=" + profileID, (Throwable)e);
        }
    }

    public static DefaultProfile createDefaultProfile(List inheritThesaurusList, boolean inheritStopword, boolean inheritBannedWord, boolean inheritRecommend, boolean inheritRedirct) throws IRException {
        ObjectFactory of = new ObjectFactory();
        try {
            DefaultProfile profile = of.createDefaultProfile();
            int i = 0;
            while (i < inheritThesaurusList.size()) {
                profile.getInheritThesaurus().add(inheritThesaurusList.get(i));
                ++i;
            }
            profile.setInheritBannedWord(inheritBannedWord);
            profile.setInheritRecommend(inheritRecommend);
            profile.setInheritRedirect(inheritRedirct);
            profile.setInheritStopword(inheritStopword);
            return profile;
        }
        catch (JAXBException e) {
            throw new IRException(2, "Cannot create DefaultProfile Setting Object", (Throwable)e);
        }
    }

    public static ProfileSettingManager create() throws IRException {
        return ProfileSettingManager.create(null, null);
    }

    public Transmitable getInstance() {
        return new ProfileSettingManager();
    }

    public String getPackageName() {
        return PACKAGE_NAME;
    }
}

