/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.common.ServerKey;
import com.diquest.ir.common.msg.ext.body.setting.ReqAddServerT;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.common.setting.serverlist.Group;
import com.diquest.ir.common.setting.serverlist.ObjectFactory;
import com.diquest.ir.common.setting.serverlist.Server;
import com.diquest.ir.common.setting.serverlist.ServerList;
import com.diquest.ir.util.msg.Transmitable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;

public class ServerListSettingManager
extends SettingHandler {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.common.setting.manager.ServerListSettingManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ServerListSettingManager() {
    }

    public static ServerListSettingManager readFromFile(String prefix, String fileName) throws IRException {
        return new ServerListSettingManager(prefix, fileName);
    }

    public static ServerListSettingManager readFromObject(Object setting) {
        return new ServerListSettingManager(setting);
    }

    private ServerListSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    private ServerListSettingManager(Object setting) {
        super(null, null, setting);
    }

    public String getPrefix(ServerKey serverInfo) {
        Server server = this.getServer(this.getGroup(serverInfo.getGroup()), serverInfo.getId());
        return server.getPrefix();
    }

    public int addServer(ReqAddServerT serverSetting) throws IRException {
        return this.addServer(serverSetting.getServerGroup(), serverSetting.getServerIP(), serverSetting.getServerName(), serverSetting.getServerPort(), serverSetting.getServerPrefix());
    }

    public List getServerNameList() {
        ArrayList<String> result = new ArrayList<String>();
        List groupList = this.getServerList().getGroup();
        int i = 0;
        while (i < groupList.size()) {
            Group group = (Group)groupList.get(i);
            List servers = group.getServer();
            int j = 0;
            while (j < servers.size()) {
                Server server = (Server)servers.get(j);
                result.add(server.getName());
                ++j;
            }
            ++i;
        }
        return result;
    }

    public int addServer(int serverGroup, String serverIP, String serverName, int serverPort, String serverPrefix) throws IRException {
        Group group = this.getGroup(serverGroup);
        if (serverGroup != 83 && serverGroup != 66) {
            throw new IRException(2, "Unknown server group(" + serverGroup + "). serverName=" + serverName);
        }
        if (group == null) {
            group = this.addGroup(serverGroup);
        }
        int serverID = this.getNextServerID(serverGroup);
        ObjectFactory objectFactory = new ObjectFactory();
        Server server = null;
        try {
            server = objectFactory.createServer();
        }
        catch (JAXBException e) {
            throw new IRException(2, "A JAXBException is occurred. serverName=" + serverName, (Throwable)e);
        }
        server.setId(serverID);
        server.setIp(serverIP);
        server.setName(serverName);
        server.setPort(serverPort);
        server.setPrefix(serverPrefix);
        group.getServer().add(server);
        return serverID;
    }

    public void addServer(int serverGroup, int serverId, String serverName, String serverIP, int serverPort, String serverPrefix) throws IRException {
        if (this.getServer(serverGroup, serverId) != null) {
            throw new IRException(2, "Server(" + serverGroup + ":" + serverId + ") already exists. serverName=" + serverName);
        }
        Group group = this.getGroup(serverGroup);
        if (serverGroup != 83 && serverGroup != 66) {
            throw new IRException(2, "Unknown server group(" + serverGroup + "). serverName=" + serverName);
        }
        if (group == null) {
            group = this.addGroup(serverGroup);
        }
        ObjectFactory objectFactory = new ObjectFactory();
        Server server = null;
        try {
            server = objectFactory.createServer();
        }
        catch (JAXBException e) {
            throw new IRException(2, "A JAXBException is occurred. serverName=" + serverName, (Throwable)e);
        }
        server.setId(serverId);
        server.setIp(serverIP);
        server.setName(serverName);
        server.setPort(serverPort);
        server.setPrefix(serverPrefix);
        group.getServer().add(server);
    }

    public void modifyServer(int serverGroup, int serverID, String serverIP, int serverPort) {
        Group group = this.getGroup(serverGroup);
        if (!$assertionsDisabled && group == null) {
            throw new AssertionError((Object)("group : " + group));
        }
        Server server = this.findServer(group.getServer(), serverID);
        server.setIp(serverIP);
        server.setPort(serverPort);
    }

    public Server findServer(List servers, int serverID) {
        int i = 0;
        while (i < servers.size()) {
            Server server = (Server)servers.get(i);
            if (server.getId() == serverID) {
                return server;
            }
            ++i;
        }
        return null;
    }

    public Group getGroup(int groupID) {
        int i = 0;
        while (i < this.getServerList().getGroup().size()) {
            Group group = (Group)this.getServerList().getGroup().get(i);
            if (groupID == group.getId()) {
                return group;
            }
            ++i;
        }
        return null;
    }

    public int getNextServerID(int groupID) {
        Group group = this.getGroup(groupID);
        return this.getNextServerID(group);
    }

    public int getMaxServerID(int groupID) {
        Group group = this.getGroup(groupID);
        return this.getMaxServerID(group);
    }

    public int getMaxServerID(Group group) {
        int max = -1;
        List serverlist = group.getServer();
        int i = 0;
        while (i < serverlist.size()) {
            Server server = (Server)serverlist.get(i);
            if (max < server.getId()) {
                max = server.getId();
            }
            ++i;
        }
        return max;
    }

    public int getNextServerID(Group group) {
        int max = this.getMaxServerID(group);
        return max + 1;
    }

    public Server getServer(int groupID, int serverID) {
        Group group = this.getGroup(groupID);
        return this.getServer(group, serverID);
    }

    public Server getServer(Group group, int serverID) {
        List serverlist = group.getServer();
        int i = 0;
        while (i < serverlist.size()) {
            Server server = (Server)serverlist.get(i);
            if (serverID == server.getId()) {
                return server;
            }
            ++i;
        }
        return null;
    }

    public boolean removeServer(int serverGroup, int serverID) {
        Group group = this.getGroup(serverGroup);
        if (group != null) {
            List servers = group.getServer();
            int i = 0;
            while (i < servers.size()) {
                Server server = (Server)servers.get(i);
                if (server.getId() == serverID) {
                    servers.remove(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Group addGroup(int groupID) throws IRException {
        ObjectFactory objectFactory = new ObjectFactory();
        Group group = null;
        if (groupID != 83 && groupID != 66) {
            throw new IRException(2, "Unknown server group(" + groupID + ").");
        }
        try {
            group = objectFactory.createGroup();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        group.setId(groupID);
        group.setName("service");
        this.getServerList().getGroup().add(group);
        return group;
    }

    public int removeGroup(int groupID) {
        List groups = this.getServerList().getGroup();
        int i = 0;
        while (i < groups.size()) {
            Group group = (Group)groups.get(i);
            if (group.getId() == groupID) {
                groups.remove(i);
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEmptyGroup(int id) {
        Group group = this.getGroup(id);
        return group.getServer().size() == 0;
    }

    public Transmitable getInstance() {
        return new ServerListSettingManager();
    }

    public ServerList getServerList() {
        return (ServerList)this.getSettingObject();
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.serverlist";
    }
}

