/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.IrProperties;
import com.diquest.ir.util.common.TraverseException;
import com.diquest.ir.util.msg.Transmitable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class SettingHandler
extends Transmitable {
    protected Object settingObj;
    protected String prefix;
    protected String fileName;

    protected SettingHandler() {
    }

    protected SettingHandler(String prefix, String fileName, Object settingObj) {
        this.setUri(prefix, fileName);
        this.settingObj = settingObj;
    }

    protected SettingHandler(String prefix, String fileName) throws IRException {
        this.setUri(prefix, fileName);
        try {
            Object setting;
            JAXBContext jc = JAXBContext.newInstance((String)this.getPackageName());
            Unmarshaller u = jc.createUnmarshaller();
            File file = new File(prefix, fileName);
            this.settingObj = setting = u.unmarshal((InputStream)new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new IRException("Cannot find xml file : [" + new File(prefix, fileName).getAbsolutePath() + "]", e);
        }
        catch (JAXBException e) {
            throw new IRException("JAXBException is occurred during processing [" + fileName + "]", e);
        }
    }

    protected SettingHandler(File file) throws IRException {
        try {
            Object setting;
            JAXBContext jc = JAXBContext.newInstance((String)this.getPackageName());
            Unmarshaller u = jc.createUnmarshaller();
            this.settingObj = setting = u.unmarshal((InputStream)new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new IRException("Cannot find xml file : [" + file.getAbsolutePath() + "]", e);
        }
        catch (JAXBException e) {
            throw new IRException("JAXBException is occurred during processing [" + file.getAbsolutePath() + "]", e);
        }
    }

    public synchronized void save() throws IRException {
        File dir = new File(this.prefix);
        dir.mkdirs();
        File file = new File(dir, this.fileName);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getPackageName());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)IrProperties.IANA_ENCODING);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
            try {
                marshaller.marshal(this.settingObj, (OutputStream)fos);
            }
            finally {
                ((OutputStream)fos).close();
            }
        }
        catch (JAXBException e) {
            throw new IRException("JAXBException is occurred during processing settingObject", e);
        }
        catch (IOException e) {
            throw new IRException("IOException is occurred during write a file : [" + file.getAbsolutePath() + "]", e);
        }
    }

    public String getAbsolutePath() {
        File dir = new File(this.prefix);
        File file = new File(dir, this.fileName);
        return file.getAbsolutePath();
    }

    public boolean isFile() {
        File dir = new File(this.prefix);
        File file = new File(dir, this.fileName);
        return file.isFile();
    }

    public void modifySetting(Object setting) {
        this.settingObj = setting;
    }

    public Object getSettingObject() {
        return this.settingObj;
    }

    public boolean isNull() {
        return this.settingObj == null;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.prefix);
        ByteUtil.writeString((OutputStream)out, (String)this.fileName);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getPackageName());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)IrProperties.IANA_ENCODING);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(this.settingObj, out);
        }
        catch (JAXBException e) {
            TraverseException tr = new TraverseException((Throwable)e);
            throw new IOException(tr.chainMessage());
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.prefix = ByteUtil.readString((InputStream)in);
        this.fileName = ByteUtil.readString((InputStream)in);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getPackageName());
            Unmarshaller u = jc.createUnmarshaller();
            this.settingObj = u.unmarshal(in);
        }
        catch (JAXBException e) {
            TraverseException tr = new TraverseException((Throwable)e);
            throw new IOException(tr.chainMessage());
        }
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)this.getPackageName());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)IrProperties.IANA_ENCODING);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(this.settingObj, (OutputStream)baos);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        byte[] stream = baos.toByteArray();
        String data = null;
        try {
            data = new String(stream, IrProperties.IANA_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            data = new String(stream);
        }
        return data;
    }

    public void setUri(String prefix, String fileName) {
        this.prefix = prefix;
        this.fileName = fileName;
    }

    public String getUri() {
        return String.valueOf(this.prefix) + "/" + this.fileName;
    }

    public abstract String getPackageName();

    public String getPrefix() {
        return this.prefix;
    }

    public String getFileName() {
        return this.fileName;
    }
}

