/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.setting.collection.CollectionSetting;
import com.diquest.ir.common.setting.manager.CollectionListSettingManager;
import com.diquest.ir.common.setting.manager.DBWatcherListSettingManager;
import com.diquest.ir.common.setting.manager.ICollectionSettingManager;
import com.diquest.ir.common.setting.manager.SingleCollectionSettingManager;
import com.diquest.ir.common.setting.manager.SingleDBWatcherSettingManager;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingTree
extends Transmitable
implements ICollectionSettingManager {
    private CollectionListSettingManager collectionList = null;
    private Map collectionMap = new HashMap();
    private Map dbWatcherListMap = new HashMap();
    private Map dbWatcherCollectionMap = new HashMap();
    private String prefix;

    public SettingTree(String prefix, String initFileName) throws IRException {
        this.prefix = prefix;
        this.collectionList = CollectionListSettingManager.readFromFile(prefix, initFileName);
        List collectionlist = this.collectionList.getCollectionIDList();
        int i = 0;
        while (i < collectionlist.size()) {
            String collectionID = (String)collectionlist.get(i);
            SingleCollectionSettingManager collectionSettingManager = SingleCollectionSettingManager.readFromFile(String.valueOf(prefix) + "/" + collectionID, "collectionSetting.xml");
            this.collectionMap.put(collectionID, collectionSettingManager);
            String dbwatcherPrefix = String.valueOf(prefix) + "/" + collectionID + "/dbwatcher";
            DBWatcherListSettingManager dbWatcherListSettingMgr = DBWatcherListSettingManager.readFromFile(dbwatcherPrefix, collectionID, "list.xml");
            this.dbWatcherListMap.put(collectionID, dbWatcherListSettingMgr);
            HashMap<String, SingleDBWatcherSettingManager> dbWatcherSettings = new HashMap<String, SingleDBWatcherSettingManager>();
            int j = 0;
            while (j < dbWatcherListSettingMgr.getDBWatcherIDList().size()) {
                String dbWatcherID = (String)dbWatcherListSettingMgr.getDBWatcherIDList().get(j);
                SingleDBWatcherSettingManager dbWatcherSettingMgr = SingleDBWatcherSettingManager.readFromFile(dbwatcherPrefix, String.valueOf(dbWatcherID) + ".xml");
                dbWatcherSettings.put(dbWatcherID, dbWatcherSettingMgr);
                ++j;
            }
            this.dbWatcherCollectionMap.put(collectionID, dbWatcherSettings);
            ++i;
        }
    }

    public SettingTree() {
    }

    public boolean isNull() {
        return this.collectionList == null;
    }

    public void serialize(OutputStream out) throws IOException {
    }

    public void deserialize(InputStream in) throws IOException {
    }

    public Transmitable getInstance() {
        return new SettingTree();
    }

    public static SettingTree initialize(String prefix, String colListFileName) throws IRException {
        return new SettingTree(prefix, colListFileName);
    }

    public CollectionSetting addCollectionSetting(String collectionID, String description, String largeFileChunksize, String bTreePageSize, String server, int documentPerSegment, String compressType, boolean useDBWatcher) throws IRException {
        this.collectionList.add(collectionID);
        SingleCollectionSettingManager collectionSetting = SingleCollectionSettingManager.create(String.valueOf(this.prefix) + "/" + collectionID, "collectionSetting.xml");
        collectionSetting.frame(collectionID, description, largeFileChunksize, bTreePageSize, server, documentPerSegment, compressType, useDBWatcher);
        this.collectionMap.put(collectionID, collectionSetting);
        DBWatcherListSettingManager dbWatcherListSetting = DBWatcherListSettingManager.create(String.valueOf(this.prefix) + "/" + collectionID + "/dbwatcher", "list.xml", collectionID);
        this.dbWatcherListMap.put(collectionID, dbWatcherListSetting);
        this.dbWatcherCollectionMap.put(collectionID, new HashMap());
        return collectionSetting.getCollectionSetting();
    }

    public CollectionSetting modifyCollection(String collectionID, String description, String largeFileChunksize, String bTreePageSize, String server, int documentPerSegment, String compressType) throws IRException {
        if (this.collectionList.isNotNull(collectionID)) {
            CollectionSetting collectionSetting = this.getCollectionSetting(collectionID);
            collectionSetting.setDescription(description);
            collectionSetting.setLargeFileChunksize(largeFileChunksize);
            collectionSetting.setBTreePageSize(bTreePageSize);
            collectionSetting.getRepositorySetting().setDocumentPerSegment(documentPerSegment);
            collectionSetting.getRepositorySetting().setCompressType(compressType);
            return collectionSetting;
        }
        return null;
    }

    public boolean removeCollection(String collectionID) throws IRException {
        if (this.collectionList.isNotNull(collectionID)) {
            this.collectionList.remove(collectionID);
            this.dbWatcherListMap.remove(collectionID);
            this.dbWatcherCollectionMap.remove(collectionID);
            return true;
        }
        return false;
    }

    public List getAllCollectionSetting() {
        ArrayList collectionSettings = new ArrayList();
        int i = 0;
        while (i < this.collectionList.getCollectionIDList().size()) {
            String collectionID = (String)this.collectionList.getCollectionIDList().get(i);
            collectionSettings.add(this.collectionMap.get(collectionID));
            ++i;
        }
        return collectionSettings;
    }

    public CollectionSetting getCollectionSetting(String collectionID) {
        if (this.collectionList.isNotNull(collectionID)) {
            SingleCollectionSettingManager collectionSetting = (SingleCollectionSettingManager)((Object)this.collectionMap.get(collectionID));
            return collectionSetting.getCollectionSetting();
        }
        return null;
    }

    public void addDBWatcherSetting(String collectionID, String id, String description, String dataSourceID, String logLevel, String filterSettingID) throws IRException {
        this.addDBWatcherSetting(collectionID, id, description, dataSourceID, filterSettingID);
    }

    public void addDBWatcherSetting(String collectionID, String id, String description, String dataSourceID, String filterSettingID) throws IRException {
        if (!this.collectionList.isNotNull(collectionID)) {
            throw new IRException(2, "Cannot add dbwatcher setting : Collection does not exists.", ProfileKey.getKey(collectionID));
        }
        DBWatcherListSettingManager dbWatcherListSettingMgr = (DBWatcherListSettingManager)((Object)this.dbWatcherListMap.get(collectionID));
        dbWatcherListSettingMgr.add(id);
        SingleDBWatcherSettingManager dbWatcherSetting = SingleDBWatcherSettingManager.create(String.valueOf(this.prefix) + "/" + collectionID + "/dbwatcher", String.valueOf(id) + ".xml");
        dbWatcherSetting.frame(collectionID, id, description, dataSourceID, filterSettingID);
        Map dbWatcherMap = (Map)this.dbWatcherCollectionMap.get(collectionID);
        dbWatcherMap.put(id, dbWatcherSetting);
    }

    public SingleDBWatcherSettingManager getDBWatcherSetting(String collectionID, String dbWatcherID) throws IRException {
        if (this.collectionList.isNotNull(collectionID)) {
            DBWatcherListSettingManager dbWatcherListSettingMgr = (DBWatcherListSettingManager)((Object)this.dbWatcherListMap.get(collectionID));
            if (!dbWatcherListSettingMgr.isNull(dbWatcherID)) {
                Map dbWatcherMap = (Map)this.dbWatcherCollectionMap.get(collectionID);
                return (SingleDBWatcherSettingManager)((Object)dbWatcherMap.get(dbWatcherID));
            }
            throw new IRException(2, "Cannot retrieve dbwatcher setting : (" + dbWatcherID + ") does not exists.", ProfileKey.getKey(collectionID));
        }
        throw new IRException(2, "Cannot retrieve dbwatcher setting : collection does not exists.", ProfileKey.getKey(collectionID));
    }

    public Map getDBWatcherSettingList(String collectionID) throws IRException {
        if (this.collectionList.isNotNull(collectionID)) {
            DBWatcherListSettingManager dbWatcherListSettingMgr = (DBWatcherListSettingManager)((Object)this.dbWatcherListMap.get(collectionID));
            return (Map)this.dbWatcherCollectionMap.get(collectionID);
        }
        throw new IRException(2, "Cannot retrieve dbwatcher setting list : collection does not exists.", ProfileKey.getKey(collectionID));
    }

    public void removeDBWatcherSetting(String collectionID, String dbWatcherID) throws IRException {
        if (this.collectionList.isNotNull(collectionID)) {
            if (this.dbWatcherListMap.get(collectionID) == null) {
                throw new IRException(2, "Cannot remove dbwatcher setting : (" + dbWatcherID + ") does not exists.", ProfileKey.getKey(collectionID));
            }
        } else {
            throw new IRException(2, "Cannot remove dbwatcher setting list : collection does not exists.", ProfileKey.getKey(collectionID));
        }
        this.dbWatcherListMap.remove(collectionID);
        Map dbWatcherCollection = (Map)this.dbWatcherCollectionMap.get(collectionID);
        dbWatcherCollection.remove(dbWatcherID);
    }
}

