/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.common.setting.collection.CollectionSetting;
import com.diquest.ir.common.setting.collection.FilterField;
import com.diquest.ir.common.setting.collection.FilterSetting;
import com.diquest.ir.common.setting.collection.GroupField;
import com.diquest.ir.common.setting.collection.GroupSetting;
import com.diquest.ir.common.setting.collection.IndexField;
import com.diquest.ir.common.setting.collection.IndexSetting;
import com.diquest.ir.common.setting.collection.MirrorSettingType;
import com.diquest.ir.common.setting.collection.MirrorType;
import com.diquest.ir.common.setting.collection.ObjectFactory;
import com.diquest.ir.common.setting.collection.RepositorySetting;
import com.diquest.ir.common.setting.collection.RepositorySettingType;
import com.diquest.ir.common.setting.collection.SchemaSetting;
import com.diquest.ir.common.setting.collection.SortField;
import com.diquest.ir.common.setting.collection.SortSetting;
import com.diquest.ir.common.setting.collection.UserExtractor;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.common.setting.manager.filter.MacroSchemaFilter;
import com.diquest.ir.util.msg.Transmitable;
import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBException;

public class SingleCollectionSettingManager
extends SettingHandler {
    static MacroSchemaFilter FILTER = new MacroSchemaFilter();
    private static ObjectFactory OF = new ObjectFactory();

    public SingleCollectionSettingManager() {
    }

    public SingleCollectionSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    public SingleCollectionSettingManager(String prefix, String fileName, Object settingObj) throws IRException {
        super(prefix, fileName, settingObj);
    }

    public CollectionSetting frame(String id, String description, String server, boolean useDBWatcher) throws IRException {
        return this.frame(id, description, 1000, "1G", "8K", server, 0, "DEFAULT", useDBWatcher);
    }

    public CollectionSetting frame(String id, String description, String largeFileChunksize, String bTreePageSize, String server, int documentPerSegment, String compressType, boolean useDBWatcher) throws IRException {
        try {
            this.getCollectionSetting().setId(id);
            this.getCollectionSetting().setDescription(description);
            this.getCollectionSetting().setBaseDirectory(id);
            this.getCollectionSetting().setLargeFileChunksize(largeFileChunksize);
            this.getCollectionSetting().setBTreePageSize(bTreePageSize);
            this.getCollectionSetting().setUseDBWatcher(useDBWatcher);
            this.getCollectionSetting().setServer(server);
            RepositorySetting repositorySetting = OF.createRepositorySetting();
            repositorySetting.setCompressType(compressType);
            repositorySetting.setDocumentPerSegment(documentPerSegment);
            this.getCollectionSetting().setRepositorySetting(repositorySetting);
            return this.getCollectionSetting();
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a collection.", ProfileKey.getKey(id), (Throwable)e);
        }
    }

    public CollectionSetting frame(String id, String description, int indexBulkFactor, String largeFileChunksize, String bTreePageSize, String server, int documentPerSegment, String compressType, boolean useDBWatcher) throws IRException {
        try {
            this.getCollectionSetting().setId(id);
            this.getCollectionSetting().setDescription(description);
            this.getCollectionSetting().setBaseDirectory(id);
            this.getCollectionSetting().setIndexBulkFactor(indexBulkFactor);
            this.getCollectionSetting().setLargeFileChunksize(largeFileChunksize);
            this.getCollectionSetting().setBTreePageSize(bTreePageSize);
            this.getCollectionSetting().setUseDBWatcher(useDBWatcher);
            this.getCollectionSetting().setServer(server);
            RepositorySetting repositorySetting = OF.createRepositorySetting();
            repositorySetting.setCompressType(compressType);
            repositorySetting.setDocumentPerSegment(documentPerSegment);
            this.getCollectionSetting().setRepositorySetting(repositorySetting);
            return this.getCollectionSetting();
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a collection.", ProfileKey.getKey(id), (Throwable)e);
        }
    }

    public CollectionSetting getCollectionSetting() {
        return (CollectionSetting)this.getSettingObject();
    }

    public CollectionSetting modifyCollection(String id, String description, String largeFileChunksize, String bTreePageSize, String server, int documentPerSegment, String compressType) throws IRException {
        this.getCollectionSetting().setId(id);
        this.getCollectionSetting().setDescription(description);
        this.getCollectionSetting().setBaseDirectory(id);
        this.getCollectionSetting().setLargeFileChunksize(largeFileChunksize);
        this.getCollectionSetting().setBTreePageSize(bTreePageSize);
        this.getCollectionSetting().getRepositorySetting().setCompressType(compressType);
        this.getCollectionSetting().getRepositorySetting().setDocumentPerSegment(documentPerSegment);
        return this.getCollectionSetting();
    }

    public CollectionSetting modifyCollection(String id, String description, int indexBulkFactor, String largeFileChunksize, String bTreePageSize, String server, int documentPerSegment, String compressType) throws IRException {
        this.getCollectionSetting().setId(id);
        this.getCollectionSetting().setDescription(description);
        this.getCollectionSetting().setBaseDirectory(id);
        this.getCollectionSetting().setIndexBulkFactor(indexBulkFactor);
        this.getCollectionSetting().setLargeFileChunksize(largeFileChunksize);
        this.getCollectionSetting().setBTreePageSize(bTreePageSize);
        this.getCollectionSetting().getRepositorySetting().setCompressType(compressType);
        this.getCollectionSetting().getRepositorySetting().setDocumentPerSegment(documentPerSegment);
        return this.getCollectionSetting();
    }

    public boolean removeCollection(String collectionID) throws IRException {
        File file = new File(String.valueOf(this.prefix) + "/" + this.fileName);
        return file.delete();
    }

    public static SingleCollectionSettingManager readFromFile(String prefix, String fileName) throws IRException {
        return new SingleCollectionSettingManager(prefix, fileName);
    }

    public static SingleCollectionSettingManager readFromObject(String prefix, String fileName, Object settingObject) throws IRException {
        try {
            return new SingleCollectionSettingManager(prefix, fileName, settingObject);
        }
        catch (IRException e) {
            return SingleCollectionSettingManager.create(prefix, fileName);
        }
    }

    public static SingleCollectionSettingManager readFromObject(Object settingObject) throws IRException {
        return SingleCollectionSettingManager.readFromObject(null, null, settingObject);
    }

    public static SingleCollectionSettingManager create(String prefix, String fileName) throws IRException {
        try {
            CollectionSetting settingObj = OF.createCollectionSetting();
            return new SingleCollectionSettingManager(prefix, fileName, settingObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during createing setting object : " + prefix + "/" + fileName + ".", (Throwable)e);
        }
    }

    public static SingleCollectionSettingManager create() throws IRException {
        return SingleCollectionSettingManager.create(null, null);
    }

    public List getAllSchemaSetting() {
        return this.getCollectionSetting().getSchemaSetting();
    }

    public void clearAllSchemaSetting() {
        this.getCollectionSetting().getSchemaSetting().clear();
    }

    public boolean addSchemaSetting(String schemaID, String description, boolean isAllowNull, boolean isIdField, boolean isMultiple, boolean isMutable, int precision, boolean strictCheck, String type, String defaultValue, String deliminator, int multipleValueSize) throws IRException {
        schemaID = schemaID.toUpperCase();
        ObjectFactory objectFactory = new ObjectFactory();
        try {
            SchemaSetting schemaSetting = objectFactory.createSchemaSetting();
            schemaSetting.setId(schemaID);
            schemaSetting.setDescription(description);
            schemaSetting.setAllowNull(isAllowNull);
            schemaSetting.setIdField(isIdField);
            schemaSetting.setMultiple(isMultiple);
            schemaSetting.setMutable(isMutable);
            schemaSetting.setPrecision(precision);
            schemaSetting.setStrictCheck(strictCheck);
            schemaSetting.setType(type);
            schemaSetting.setDefaultValue(defaultValue);
            schemaSetting.setDeliminator(deliminator);
            schemaSetting.setMultipleValueSize(multipleValueSize);
            FILTER.excute(this.getAllSchemaSetting(), schemaSetting);
            this.getCollectionSetting().getSchemaSetting().add(schemaSetting);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a schema : " + schemaID + ".", (Throwable)e);
        }
        return true;
    }

    public SchemaSetting getSchemaSetting(String schemaID) {
        schemaID = schemaID.toUpperCase();
        int i = 0;
        while (i < this.getCollectionSetting().getSchemaSetting().size()) {
            SchemaSetting ss = (SchemaSetting)this.getCollectionSetting().getSchemaSetting().get(i);
            if (ss.getId().toUpperCase().equals(schemaID)) {
                return ss;
            }
            ++i;
        }
        return null;
    }

    public IndexSetting getIndexSetting(String indexID) {
        indexID = indexID.toUpperCase();
        int i = 0;
        while (i < this.getCollectionSetting().getIndexSetting().size()) {
            IndexSetting indexSetting = (IndexSetting)this.getCollectionSetting().getIndexSetting().get(i);
            if (indexSetting.getId().toUpperCase().equals(indexID)) {
                return indexSetting;
            }
            ++i;
        }
        return null;
    }

    public void addIndexSetting(String indexID, String server, String description, String extractor, int weight, String[] schemaIDList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate) throws IRException {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            IndexSetting indexSetting = null;
            indexSetting = objectFactory.createIndexSetting();
            List indexFields = indexSetting.getIndexField();
            int i = 0;
            while (i < schemaIDList.length) {
                IndexField indexField = objectFactory.createIndexField();
                indexField.setId(schemaIDList[i]);
                indexFields.add(indexField);
                ++i;
            }
            indexSetting.setId(indexID);
            indexSetting.setDescription(description);
            indexSetting.setExtractor(extractor);
            indexSetting.setWeight(weight);
            indexSetting.setUseEngMap(useEngMap);
            indexSetting.setUseHanjaMap(useHanjaMap);
            indexSetting.setUseSpCharMap(useSpCharMap);
            indexSetting.setMaxDFRate(maxDFRate);
            this.getCollectionSetting().getIndexSetting().add(indexSetting);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a index setting: " + indexID + ".", (Throwable)e);
        }
    }

    public void addIndexSetting(String indexID, String description, String extractor, String extractorOption, boolean useExtractorSymbolMap, String bigramSynonymExtractor, int weight, String[] schemaIDList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate) throws IRException {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            IndexSetting indexSetting = null;
            indexSetting = objectFactory.createIndexSetting();
            List indexFields = indexSetting.getIndexField();
            int i = 0;
            while (i < schemaIDList.length) {
                IndexField indexField = objectFactory.createIndexField();
                indexField.setId(schemaIDList[i]);
                indexFields.add(indexField);
                ++i;
            }
            indexSetting.setId(indexID);
            indexSetting.setDescription(description);
            indexSetting.setExtractor(extractor);
            indexSetting.setExtractorOption(extractorOption);
            indexSetting.setUseExtractorSymbolMap(useExtractorSymbolMap);
            indexSetting.setBigramSynonymExtractor(bigramSynonymExtractor);
            indexSetting.setWeight(weight);
            indexSetting.setUseEngMap(useEngMap);
            indexSetting.setUseHanjaMap(useHanjaMap);
            indexSetting.setUseSpCharMap(useSpCharMap);
            indexSetting.setMaxDFRate(maxDFRate);
            this.getCollectionSetting().getIndexSetting().add(indexSetting);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a index setting: " + indexID + ".", (Throwable)e);
        }
    }

    public void addIndexSetting(String indexID, String description, String extractor, String extractorOption, String delimiter, boolean useExtractorSymbolMap, String bigramSynonymExtractor, int weight, String[] schemaIDList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate, boolean isCatIndex) throws IRException {
        this.addIndexSetting(indexID, description, extractor, extractorOption, delimiter, useExtractorSymbolMap, bigramSynonymExtractor, weight, schemaIDList, useEngMap, useHanjaMap, useSpCharMap, maxDFRate, isCatIndex, null, null);
    }

    public void addIndexSetting(String indexID, String description, String extractor, String extractorOption, String delimiter, boolean useExtractorSymbolMap, String bigramSynonymExtractor, int weight, String[] schemaIDList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate, boolean isCatIndex, String indexExtClass, String searchExtClass) throws IRException {
        this.addIndexSetting(indexID, description, extractor, extractorOption, delimiter, useExtractorSymbolMap, bigramSynonymExtractor, weight, schemaIDList, useEngMap, useHanjaMap, useSpCharMap, maxDFRate, isCatIndex, indexExtClass, searchExtClass, null, null, null);
    }

    public void addIndexSetting(String indexID, String description, String extractor, String extractorOption, String delimiter, boolean useExtractorSymbolMap, String bigramSynonymExtractor, int weight, String[] schemaIDList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate, boolean isCatIndex, String indexExtClass, String searchExtClass, String searchExtractor, String searchExtractorOption, String searchExtractorDelim) throws IRException {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            IndexSetting indexSetting = null;
            indexSetting = objectFactory.createIndexSetting();
            List indexFields = indexSetting.getIndexField();
            int i = 0;
            while (i < schemaIDList.length) {
                IndexField indexField = objectFactory.createIndexField();
                indexField.setId(schemaIDList[i]);
                indexFields.add(indexField);
                ++i;
            }
            if (indexExtClass != null && searchExtClass != null) {
                UserExtractor userExtractor = objectFactory.createUserExtractor();
                userExtractor.setIndexClass(indexExtClass);
                userExtractor.setSearchClass(searchExtClass);
                indexSetting.setUserExtractor(userExtractor);
            }
            indexSetting.setId(indexID);
            indexSetting.setDescription(description);
            indexSetting.setExtractor(extractor);
            indexSetting.setExtractorOption(extractorOption);
            indexSetting.setDelim(delimiter);
            indexSetting.setUseExtractorSymbolMap(useExtractorSymbolMap);
            indexSetting.setBigramSynonymExtractor(bigramSynonymExtractor);
            indexSetting.setWeight(weight);
            indexSetting.setUseEngMap(useEngMap);
            indexSetting.setUseHanjaMap(useHanjaMap);
            indexSetting.setUseSpCharMap(useSpCharMap);
            indexSetting.setMaxDFRate(maxDFRate);
            indexSetting.setCatIndex(isCatIndex);
            indexSetting.setSearchExtractor(searchExtractor);
            indexSetting.setSearchExtractorOption(searchExtractorOption);
            indexSetting.setSearchExtractorDelim(searchExtractorDelim);
            this.getCollectionSetting().getIndexSetting().add(indexSetting);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a index setting: " + indexID + ".", (Throwable)e);
        }
    }

    public void modifyIndexSetting(String indexID, String server, String description, String extractor, int weight, String[] schemaIDs, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate) throws IRException {
        IndexSetting indexSetting = this.getIndexSetting(indexID);
        ObjectFactory objectFactory = new ObjectFactory();
        indexSetting.setDescription(description);
        indexSetting.setExtractor(extractor);
        indexSetting.setWeight(weight);
        indexSetting.setUseEngMap(useEngMap);
        indexSetting.setUseHanjaMap(useHanjaMap);
        indexSetting.setUseSpCharMap(useSpCharMap);
        indexSetting.setMaxDFRate(maxDFRate);
        List indexFields = indexSetting.getIndexField();
        indexFields.clear();
        try {
            int i = 0;
            while (i < schemaIDs.length) {
                IndexField field = objectFactory.createIndexField();
                field.setId(schemaIDs[i]);
                indexFields.add(i, field);
                ++i;
            }
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during modifying a index setting: " + indexID + ".", (Throwable)e);
        }
    }

    public void modifyIndexSetting(String indexID, String description, String extractor, String extractorOption, boolean useExtractorSymbolMap, String bigramSynonymExtractor, int weight, String[] schemaIDs, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate) throws IRException {
        IndexSetting indexSetting = this.getIndexSetting(indexID);
        ObjectFactory objectFactory = new ObjectFactory();
        indexSetting.setDescription(description);
        indexSetting.setExtractor(extractor);
        indexSetting.setExtractorOption(extractorOption);
        indexSetting.setBigramSynonymExtractor(bigramSynonymExtractor);
        indexSetting.setUseExtractorSymbolMap(useExtractorSymbolMap);
        indexSetting.setWeight(weight);
        indexSetting.setUseEngMap(useEngMap);
        indexSetting.setUseHanjaMap(useHanjaMap);
        indexSetting.setUseSpCharMap(useSpCharMap);
        indexSetting.setMaxDFRate(maxDFRate);
        List indexFields = indexSetting.getIndexField();
        indexFields.clear();
        try {
            int i = 0;
            while (i < schemaIDs.length) {
                IndexField field = objectFactory.createIndexField();
                field.setId(schemaIDs[i]);
                indexFields.add(i, field);
                ++i;
            }
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during modifying a index setting: " + indexID + ".", (Throwable)e);
        }
    }

    public void modifyIndexSetting(String indexID, String description, String extractor, String extractorOption, String extractorDelimiter, boolean useExtractorSymbolMap, String bigramSynonymExtractor, int weight, String[] schemaIDs, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate, boolean isCatIndex) throws IRException {
        this.modifyIndexSetting(indexID, description, extractor, extractorOption, extractorDelimiter, useExtractorSymbolMap, bigramSynonymExtractor, weight, schemaIDs, useEngMap, useHanjaMap, useSpCharMap, maxDFRate, isCatIndex, null, null);
    }

    public void modifyIndexSetting(String indexID, String description, String extractor, String extractorOption, String extractorDelimiter, boolean useExtractorSymbolMap, String bigramSynonymExtractor, int weight, String[] schemaIDs, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate, boolean isCatIndex, String indexExtClass, String searchExtClass) throws IRException {
        this.modifyIndexSetting(indexID, description, extractor, extractorOption, extractorDelimiter, useExtractorSymbolMap, bigramSynonymExtractor, weight, schemaIDs, useEngMap, useHanjaMap, useSpCharMap, maxDFRate, isCatIndex, indexExtClass, searchExtClass, null, null, null);
    }

    public void modifyIndexSetting(String indexID, String description, String extractor, String extractorOption, String extractorDelimiter, boolean useExtractorSymbolMap, String bigramSynonymExtractor, int weight, String[] schemaIDs, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap, float maxDFRate, boolean isCatIndex, String indexExtClass, String searchExtClass, String searchExtractor, String searchExtractorOption, String searchExtractorDelim) throws IRException {
        IndexSetting indexSetting = this.getIndexSetting(indexID);
        ObjectFactory objectFactory = new ObjectFactory();
        indexSetting.setDescription(description);
        indexSetting.setExtractor(extractor);
        indexSetting.setExtractorOption(extractorOption);
        indexSetting.setDelim(extractorDelimiter);
        indexSetting.setBigramSynonymExtractor(bigramSynonymExtractor);
        indexSetting.setUseExtractorSymbolMap(useExtractorSymbolMap);
        indexSetting.setWeight(weight);
        indexSetting.setUseEngMap(useEngMap);
        indexSetting.setUseHanjaMap(useHanjaMap);
        indexSetting.setUseSpCharMap(useSpCharMap);
        indexSetting.setMaxDFRate(maxDFRate);
        indexSetting.setCatIndex(isCatIndex);
        indexSetting.setSearchExtractor(searchExtractor);
        indexSetting.setSearchExtractorOption(searchExtractorOption);
        indexSetting.setSearchExtractorDelim(searchExtractorDelim);
        List indexFields = indexSetting.getIndexField();
        indexFields.clear();
        try {
            int i = 0;
            while (i < schemaIDs.length) {
                IndexField field = objectFactory.createIndexField();
                field.setId(schemaIDs[i]);
                indexFields.add(i, field);
                ++i;
            }
            if (indexExtClass != null && searchExtClass != null) {
                UserExtractor userExtractor = objectFactory.createUserExtractor();
                userExtractor.setIndexClass(indexExtClass);
                userExtractor.setSearchClass(searchExtClass);
                indexSetting.setUserExtractor(userExtractor);
            } else {
                indexSetting.setUserExtractor(null);
            }
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during modifying a index setting: " + indexID + ".", (Throwable)e);
        }
    }

    public boolean removeSchemaSetting(String schemaID) {
        List schemaSettings = this.getCollectionSetting().getSchemaSetting();
        int i = 0;
        while (i < schemaSettings.size()) {
            SchemaSetting schemaSetting = (SchemaSetting)schemaSettings.get(i);
            if (schemaSetting.getId().toUpperCase().equals(schemaID)) {
                schemaSettings.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeIndexSetting(String indexID) {
        indexID = indexID.toUpperCase();
        List indexSettings = this.getCollectionSetting().getIndexSetting();
        int i = 0;
        while (i < indexSettings.size()) {
            IndexSetting indexSetting = (IndexSetting)indexSettings.get(i);
            if (indexSetting.getId().toUpperCase().equals(indexID)) {
                indexSettings.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public List getAllIndexSetting() {
        return this.getCollectionSetting().getIndexSetting();
    }

    public List getAllFilterSetting() {
        return this.getCollectionSetting().getFilterSetting();
    }

    public FilterSetting getFilterSetting(String filterID) {
        filterID = filterID.toUpperCase();
        int i = 0;
        while (i < this.getCollectionSetting().getFilterSetting().size()) {
            FilterSetting filterSetting = (FilterSetting)this.getCollectionSetting().getFilterSetting().get(i);
            if (filterSetting.getId().toUpperCase().equals(filterID)) {
                return filterSetting;
            }
            ++i;
        }
        return null;
    }

    public boolean addFilterSetting(String filterID, String serverName, String description, String[] filterFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        return this.addFilterSetting(filterID, description, filterFieldList, useEngMap, useHanjaMap, useSpCharMap);
    }

    public boolean addFilterSetting(String filterID, String description, String[] filterFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        ObjectFactory of = new ObjectFactory();
        FilterSetting filterSetting = null;
        try {
            filterSetting = of.createFilterSetting();
            filterSetting.setId(filterID);
            filterSetting.setDescription(description);
            filterSetting.setUseEngMap(useEngMap);
            filterSetting.setUseHanjaMap(useHanjaMap);
            filterSetting.setUseSpCharMap(useSpCharMap);
            List originalFilterField = filterSetting.getFilterField();
            int i = 0;
            while (i < filterFieldList.length) {
                FilterField filterField = of.createFilterField();
                filterField.setId(filterFieldList[i]);
                originalFilterField.add(filterField);
                ++i;
            }
            this.getCollectionSetting().getFilterSetting().add(filterSetting);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a filter setting: " + filterID + ".", (Throwable)e);
        }
        return true;
    }

    public boolean removeFilterSetting(String filterID) {
        FilterSetting filterSetting = null;
        int i = 0;
        while (i < this.getAllFilterSetting().size()) {
            filterSetting = (FilterSetting)this.getAllFilterSetting().get(i);
            if (filterSetting.getId().equals(filterID)) {
                this.getAllFilterSetting().remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean modifyFilterSetting(String filterID, String serverName, String description, String[] filterFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        return this.modifyFilterSetting(filterID, description, filterFieldList, useEngMap, useHanjaMap, useSpCharMap);
    }

    public boolean modifyFilterSetting(String filterID, String description, String[] filterFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        try {
            FilterSetting filterSetting = this.getFilterSetting(filterID);
            filterSetting.setDescription(description);
            filterSetting.setUseEngMap(useEngMap);
            filterSetting.setUseHanjaMap(useHanjaMap);
            filterSetting.setUseSpCharMap(useSpCharMap);
            List ffl = filterSetting.getFilterField();
            ffl.clear();
            ObjectFactory of = new ObjectFactory();
            int i = 0;
            while (i < filterFieldList.length) {
                FilterField filterField = of.createFilterField();
                filterField.setId(filterFieldList[i]);
                ffl.add(filterField);
                ++i;
            }
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during modifying a filter setting: " + filterID + ".", (Throwable)e);
        }
        return true;
    }

    public List getAllGroupSetting() {
        return this.getCollectionSetting().getGroupSetting();
    }

    public GroupSetting getGroupSetting(String groupID) {
        groupID = groupID.toUpperCase();
        int i = 0;
        while (i < this.getCollectionSetting().getGroupSetting().size()) {
            GroupSetting groupSetting = (GroupSetting)this.getCollectionSetting().getGroupSetting().get(i);
            if (groupSetting.getId().toUpperCase().equals(groupID)) {
                return groupSetting;
            }
            ++i;
        }
        return null;
    }

    public boolean addGroupSetting(String groupID, String serverName, String description, String[] groupFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        return this.addGroupSetting(groupID, description, groupFieldList, useEngMap, useHanjaMap, useSpCharMap);
    }

    public boolean addGroupSetting(String groupID, String description, String[] groupFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        ObjectFactory of = new ObjectFactory();
        GroupSetting groupSetting = null;
        try {
            groupSetting = of.createGroupSetting();
            groupSetting.setId(groupID);
            groupSetting.setDescription(description);
            groupSetting.setUseEngMap(useEngMap);
            groupSetting.setUseHanjaMap(useHanjaMap);
            groupSetting.setUseSpCharMap(useSpCharMap);
            List originalGroupField = groupSetting.getGroupField();
            int i = 0;
            while (i < groupFieldList.length) {
                GroupField groupField = of.createGroupField();
                groupField.setId(groupFieldList[i]);
                originalGroupField.add(groupField);
                ++i;
            }
            this.getCollectionSetting().getGroupSetting().add(groupSetting);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a group setting: " + groupID + ".", (Throwable)e);
        }
        return true;
    }

    public boolean modifyGroupSetting(String groupID, String serverName, String description, String[] groupFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        return this.modifyGroupSetting(groupID, description, groupFieldList, useEngMap, useHanjaMap, useSpCharMap);
    }

    public boolean modifyGroupSetting(String groupID, String description, String[] groupFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        ObjectFactory of = new ObjectFactory();
        GroupSetting groupSetting = this.getGroupSetting(groupID);
        try {
            groupSetting.setDescription(description);
            groupSetting.setUseEngMap(useEngMap);
            groupSetting.setUseHanjaMap(useHanjaMap);
            groupSetting.setUseSpCharMap(useSpCharMap);
            groupSetting.getGroupField().clear();
            int i = 0;
            while (i < groupFieldList.length) {
                GroupField groupField = of.createGroupField();
                groupField.setId(groupFieldList[i]);
                groupSetting.getGroupField().add(groupField);
                ++i;
            }
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during modifying a group setting: " + groupID + ".", (Throwable)e);
        }
        return true;
    }

    public boolean removeGroupSetting(String groupID) {
        groupID = groupID.toUpperCase();
        int i = 0;
        while (i < this.getAllGroupSetting().size()) {
            GroupSetting groupSetting = (GroupSetting)this.getAllGroupSetting().get(i);
            if (groupSetting.getId().toUpperCase().equals(groupID)) {
                this.getAllGroupSetting().remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public List getAllSortSetting() {
        return this.getCollectionSetting().getSortSetting();
    }

    public SortSetting getSortSetting(String sortID) {
        sortID = sortID.toUpperCase();
        int i = 0;
        while (i < this.getCollectionSetting().getSortSetting().size()) {
            SortSetting sortSetting = (SortSetting)this.getCollectionSetting().getSortSetting().get(i);
            if (sortSetting.getId().toUpperCase().equals(sortID)) {
                return sortSetting;
            }
            ++i;
        }
        return null;
    }

    public boolean addSortSetting(String sortID, String server, String description, String[][] sortFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        return this.addSortSetting(sortID, description, sortFieldList, useEngMap, useHanjaMap, useSpCharMap);
    }

    public boolean addSortSetting(String sortID, String description, String[][] sortFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            SortSetting sortSetting = objectFactory.createSortSetting();
            sortSetting.setId(sortID);
            sortSetting.setDescription(description);
            sortSetting.setUseEngMap(useEngMap);
            sortSetting.setUseHanjaMap(useHanjaMap);
            sortSetting.setUseSpCharMap(useSpCharMap);
            int i = 0;
            while (i < sortFieldList.length) {
                SortField sortField = objectFactory.createSortField();
                sortField.setId(sortFieldList[i][0]);
                sortField.setOrder(sortFieldList[i][1]);
                sortSetting.getSortField().add(sortField);
                ++i;
            }
            this.getAllSortSetting().add(sortSetting);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding a sort setting: " + sortID + ".", (Throwable)e);
        }
        return true;
    }

    public boolean modifySortSetting(String sortID, String server, String description, String[][] sortFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        return this.modifySortSetting(sortID, description, sortFieldList, useEngMap, useHanjaMap, useSpCharMap);
    }

    public boolean modifySortSetting(String sortID, String description, String[][] sortFieldList, boolean useEngMap, boolean useHanjaMap, boolean useSpCharMap) throws IRException {
        SortSetting sortSetting = this.getSortSetting(sortID);
        ObjectFactory objectFactory = new ObjectFactory();
        sortSetting.setDescription(description);
        sortSetting.setUseEngMap(useEngMap);
        sortSetting.setUseHanjaMap(useHanjaMap);
        sortSetting.setUseSpCharMap(useSpCharMap);
        sortSetting.getSortField().clear();
        try {
            int i = 0;
            while (i < sortFieldList.length) {
                SortField sortField = objectFactory.createSortField();
                sortField.setId(sortFieldList[i][0]);
                sortField.setOrder(sortFieldList[i][1]);
                sortSetting.getSortField().add(sortField);
                ++i;
            }
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during modifying a sort setting: " + sortID + ".", (Throwable)e);
        }
        return true;
    }

    public boolean removeSortSetting(String sortID) {
        sortID = sortID.toUpperCase();
        List sortSettings = this.getCollectionSetting().getSortSetting();
        int i = 0;
        while (i < sortSettings.size()) {
            SortSetting sortSetting = (SortSetting)sortSettings.get(i);
            if (sortSetting.getId().toUpperCase().equals(sortID)) {
                sortSettings.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean setAdvancedSetting(String bTreePageSize, String largeFileChunkSize, int documentPerSegment, String compressType) {
        this.getCollectionSetting().setBTreePageSize(bTreePageSize);
        this.getCollectionSetting().setLargeFileChunksize(largeFileChunkSize);
        RepositorySettingType repositorySetting = this.getCollectionSetting().getRepositorySetting();
        repositorySetting.setDocumentPerSegment(documentPerSegment);
        repositorySetting.setCompressType(compressType);
        return true;
    }

    public SchemaSetting modifySchemaSetting(SchemaSetting target) throws IRException {
        int i = 0;
        while (i < this.getCollectionSetting().getSchemaSetting().size()) {
            SchemaSetting schemaSetting = (SchemaSetting)this.getCollectionSetting().getSchemaSetting().get(i);
            if (schemaSetting.getId().toUpperCase().equals(target.getId().toUpperCase())) {
                schemaSetting.setDefaultValue(target.getDefaultValue());
                schemaSetting.setDeliminator(target.getDeliminator());
                schemaSetting.setDescription(target.getDescription());
                schemaSetting.setAllowNull(target.isAllowNull());
                schemaSetting.setIdField(target.isIdField());
                schemaSetting.setMultiple(target.isMultiple());
                schemaSetting.setMutable(target.isMutable());
                schemaSetting.setPrecision(target.getPrecision());
                schemaSetting.setStrictCheck(target.isStrictCheck());
                schemaSetting.setType(target.getType());
                return schemaSetting;
            }
            ++i;
        }
        return null;
    }

    public SchemaSetting modifySchemaSetting(String schemaID, String description, boolean isAllowNull, boolean isIdField, boolean isMultiple, boolean isMutable, int precision, boolean strictCheck, String type, String defaultValue, String deliminator, int multipleValueSize) throws IRException {
        SchemaSetting schemaSetting = this.getSchemaSetting(schemaID);
        if (schemaSetting == null) {
            return null;
        }
        schemaSetting.setDefaultValue(defaultValue);
        schemaSetting.setDeliminator(deliminator);
        schemaSetting.setDescription(description);
        schemaSetting.setAllowNull(isAllowNull);
        schemaSetting.setIdField(isIdField);
        schemaSetting.setMultiple(isMultiple);
        schemaSetting.setMutable(isMutable);
        schemaSetting.setPrecision(precision);
        schemaSetting.setStrictCheck(strictCheck);
        schemaSetting.setType(type);
        schemaSetting.setMultipleValueSize(multipleValueSize);
        return schemaSetting;
    }

    public void setUseMirror(boolean useMirror) throws JAXBException {
        MirrorSettingType mirrorSetting = this.getCollectionSetting().getMirrorSetting();
        mirrorSetting.setUseMirror(useMirror);
    }

    public boolean addMirror(String name, boolean repository) throws JAXBException {
        MirrorType mirror = this.createMirror(name, repository);
        this.getMirrorSetting().getMirror().add(mirror);
        return true;
    }

    public MirrorType createMirror(String name, boolean repository) throws JAXBException {
        MirrorType mirror = OF.createMirrorType();
        mirror.setName(name);
        mirror.setHasRepository(repository);
        return mirror;
    }

    public boolean hasMirror(String name) {
        CollectionSetting collectionSetting = this.getCollectionSetting();
        MirrorSettingType mirrorSetting = collectionSetting.getMirrorSetting();
        return !MirrorFilter.filterout(mirrorSetting, name);
    }

    public MirrorSettingType getMirrorSetting() {
        CollectionSetting collectionSetting = this.getCollectionSetting();
        return collectionSetting.getMirrorSetting();
    }

    public boolean hasMirrorSetting() {
        return this.getMirrorSetting() != null;
    }

    public void initMirrorSetting() throws JAXBException {
        MirrorSettingType mirrorSetting = OF.createMirrorSettingType();
        this.getCollectionSetting().setMirrorSetting(mirrorSetting);
    }

    public boolean modifyMirror(String name, boolean repository) throws JAXBException {
        return this.removeMirror(name) && this.addMirror(name, repository);
    }

    public boolean removeMirror(String name) {
        List mirrors = this.getMirrorSetting().getMirror();
        int i = 0;
        while (i < mirrors.size()) {
            MirrorType mirror = (MirrorType)mirrors.get(i);
            if (mirror.getName().equals(name)) {
                mirrors.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public MirrorType getMirror(String name) {
        List mirrors = this.getCollectionSetting().getMirrorSetting().getMirror();
        int i = 0;
        while (i < mirrors.size()) {
            MirrorType mt = (MirrorType)mirrors.get(i);
            if (mt.getName().equals(name)) {
                return mt;
            }
            ++i;
        }
        return null;
    }

    public Transmitable getInstance() {
        return new SingleCollectionSettingManager();
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.collection";
    }

    static class MirrorFilter {
        MirrorFilter() {
        }

        public static boolean filterout(MirrorSettingType exists, String servername) {
            if (exists == null) {
                return false;
            }
            int i = 0;
            while (i < exists.getMirror().size()) {
                MirrorType mt = (MirrorType)exists.getMirror().get(i);
                if (mt.getName().equals(servername)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

