/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.collection.SchemaSetting;
import com.diquest.ir.common.setting.dbwatcher.AutoUpdateCheckPost;
import com.diquest.ir.common.setting.dbwatcher.AutoUpdateCheckPre;
import com.diquest.ir.common.setting.dbwatcher.DbWatcherSetting;
import com.diquest.ir.common.setting.dbwatcher.FieldUpdateCollectSqlPost;
import com.diquest.ir.common.setting.dbwatcher.FieldUpdateCollectSqlPre;
import com.diquest.ir.common.setting.dbwatcher.FullCollectSqlPost;
import com.diquest.ir.common.setting.dbwatcher.FullCollectSqlPre;
import com.diquest.ir.common.setting.dbwatcher.ManualUpdateCheckPost;
import com.diquest.ir.common.setting.dbwatcher.Mapping;
import com.diquest.ir.common.setting.dbwatcher.MappingList;
import com.diquest.ir.common.setting.dbwatcher.MappingListType;
import com.diquest.ir.common.setting.dbwatcher.ObjectFactory;
import com.diquest.ir.common.setting.dbwatcher.Query;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.util.msg.Transmitable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;

public class SingleDBWatcherSettingManager
extends SettingHandler {
    private static final ObjectFactory OF = new ObjectFactory();

    public SingleDBWatcherSettingManager() {
    }

    private SingleDBWatcherSettingManager(String prefix, String fileName, Object settingObj) {
        super(prefix, fileName, settingObj);
    }

    public SingleDBWatcherSettingManager(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    public static SingleDBWatcherSettingManager readFromObject(String prefix, String fileName, Object settingObject) {
        return new SingleDBWatcherSettingManager(prefix, fileName, settingObject);
    }

    public static SingleDBWatcherSettingManager readFromObject(Object settingObject) throws IRException {
        return SingleDBWatcherSettingManager.readFromObject(null, null, settingObject);
    }

    public static SingleDBWatcherSettingManager readFromFile(String prefix, String fileName) throws IRException {
        return new SingleDBWatcherSettingManager(prefix, fileName);
    }

    public static SingleDBWatcherSettingManager create() throws IRException {
        try {
            DbWatcherSetting settingObject = OF.createDbWatcherSetting();
            return new SingleDBWatcherSettingManager(null, null, settingObject);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create SingleDBWatcherSettingManager", (Throwable)e);
        }
    }

    public static SingleDBWatcherSettingManager create(String prefix, String fileName) throws IRException {
        try {
            DbWatcherSetting settingObject = OF.createDbWatcherSetting();
            return new SingleDBWatcherSettingManager(prefix, fileName, settingObject);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during create SingleDBWatcherSettingManager", (Throwable)e);
        }
    }

    public DbWatcherSetting getDbWatcherSetting() {
        return (DbWatcherSetting)this.getSettingObject();
    }

    public DbWatcherSetting frame(String collectionID, String id, String description, String dataSourceID, String logLevel, String filterSettingID) throws IRException {
        return this.frame(collectionID, id, description, dataSourceID, filterSettingID);
    }

    public DbWatcherSetting frame(String collectionID, String id, String description, String dataSourceID, String filterSettingID) throws IRException {
        this.getDbWatcherSetting().setCollectionID(collectionID);
        this.getDbWatcherSetting().setId(id);
        this.getDbWatcherSetting().setDescription(description);
        this.getDbWatcherSetting().setDataSourceID(dataSourceID);
        this.getDbWatcherSetting().setDbWatcherFilterSettingID(filterSettingID);
        this.setMappingList(false, "");
        this.initFullCollectPre();
        this.initFullCollectPost();
        this.initAutoUpdateCheckPre();
        this.initAutoUpdateCheckPost();
        this.initManualUpdatePost();
        this.initFieldUpdateCollectPre();
        this.initFieldUpdateCollectPost();
        return this.getDbWatcherSetting();
    }

    public DbWatcherSetting frame(String collectionID, String id, String description, String dataSourceID, String logLevel, String filterSettingID, int fetchSize) throws IRException {
        this.getDbWatcherSetting().setCollectionID(collectionID);
        this.getDbWatcherSetting().setId(id);
        this.getDbWatcherSetting().setDescription(description);
        this.getDbWatcherSetting().setDataSourceID(dataSourceID);
        this.getDbWatcherSetting().setFetchSize(fetchSize);
        this.getDbWatcherSetting().setDbWatcherFilterSettingID(filterSettingID);
        this.setMappingList(false, "");
        this.initFullCollectPre();
        this.initFullCollectPost();
        this.initAutoUpdateCheckPre();
        this.initAutoUpdateCheckPost();
        this.initManualUpdatePost();
        this.initFieldUpdateCollectPre();
        this.initFieldUpdateCollectPost();
        return this.getDbWatcherSetting();
    }

    public void addFullCollectSqlPre(String query) throws IRException {
        try {
            int size = this.getDbWatcherSetting().getFullCollectSqlPre().getQuery().size();
            int index = 1;
            int i = 0;
            while (i < size) {
                Query q = (Query)this.getDbWatcherSetting().getFullCollectSqlPre().getQuery().get(i);
                if (index <= q.getSequence()) {
                    index = q.getSequence() + 1;
                }
                ++i;
            }
            Query queryObj = OF.createQuery();
            queryObj.setSequence(index);
            queryObj.setBody(query);
            this.getDbWatcherSetting().getFullCollectSqlPre().getQuery().add(queryObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add full collect pre-SQL", (Throwable)e);
        }
    }

    public List getFullCollectSqlPre() {
        return this.getDbWatcherSetting().getFullCollectSqlPre().getQuery();
    }

    public Query getFullCollectSqlPre(int sequence) {
        int i = 0;
        while (i < this.getDbWatcherSetting().getFullCollectSqlPre().getQuery().size()) {
            Query q = (Query)this.getDbWatcherSetting().getFullCollectSqlPre().getQuery().get(i);
            if (q.getSequence() == sequence) {
                return q;
            }
            ++i;
        }
        return null;
    }

    public boolean modifyFullCollectSqlPre(int sequence, String query) {
        int size = this.getDbWatcherSetting().getFullCollectSqlPre().getQuery().size();
        int i = 0;
        while (i < size) {
            Query q = (Query)this.getDbWatcherSetting().getFullCollectSqlPre().getQuery().get(i);
            if (q.getSequence() == sequence) {
                q.setBody(query);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeFullCollectSqlPre(int sequence) {
        List queries = this.getDbWatcherSetting().getFullCollectSqlPre().getQuery();
        int i = 0;
        while (i < queries.size()) {
            Query q = (Query)queries.get(i);
            if (q.getSequence() == sequence) {
                queries.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setFullCollectSql(String query) {
        this.getDbWatcherSetting().setFullCollectSql(query);
    }

    public String getFullCollectSql() {
        return this.getDbWatcherSetting().getFullCollectSql();
    }

    public void addFullCollectSqlPost(String query) throws IRException {
        try {
            int size = this.getDbWatcherSetting().getFullCollectSqlPost().getQuery().size();
            int index = 1;
            int i = 0;
            while (i < size) {
                Query q = (Query)this.getDbWatcherSetting().getFullCollectSqlPost().getQuery().get(i);
                if (index <= q.getSequence()) {
                    index = q.getSequence() + 1;
                }
                ++i;
            }
            Query queryObj = OF.createQuery();
            queryObj.setSequence(index);
            queryObj.setBody(query);
            this.getDbWatcherSetting().getFullCollectSqlPost().getQuery().add(queryObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add full collect post-SQL", (Throwable)e);
        }
    }

    public List getFullCollectSqlPost() {
        return this.getDbWatcherSetting().getFullCollectSqlPost().getQuery();
    }

    public Query getFullCollectSqlPost(int sequence) {
        int i = 0;
        while (i < this.getDbWatcherSetting().getFullCollectSqlPost().getQuery().size()) {
            Query q = (Query)this.getDbWatcherSetting().getFullCollectSqlPost().getQuery().get(i);
            if (q.getSequence() == sequence) {
                return q;
            }
            ++i;
        }
        return null;
    }

    public boolean modifyFullCollectSqlPost(int sequence, String query) {
        int size = this.getDbWatcherSetting().getFullCollectSqlPost().getQuery().size();
        int i = 0;
        while (i < size) {
            Query q = (Query)this.getDbWatcherSetting().getFullCollectSqlPost().getQuery().get(i);
            if (q.getSequence() == sequence) {
                q.setBody(query);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeFullCollectSqlPost(int sequence) {
        List queries = this.getDbWatcherSetting().getFullCollectSqlPost().getQuery();
        int i = 0;
        while (i < queries.size()) {
            Query q = (Query)queries.get(i);
            if (q.getSequence() == sequence) {
                queries.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setIncCollectSql(String query) {
        this.getDbWatcherSetting().setIncCollectSql(query);
    }

    public String getIncCollectSql() {
        return this.getDbWatcherSetting().getIncCollectSql();
    }

    public void setIdSeletSql(String query) {
        this.getDbWatcherSetting().setUpdateIdSelectSql(query);
    }

    public String getIdSelectSql() {
        return this.getDbWatcherSetting().getUpdateIdSelectSql();
    }

    public void addAutoUpdateCheckPre(String query) throws IRException {
        try {
            int size = this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery().size();
            int index = 1;
            int i = 0;
            while (i < size) {
                Query q = (Query)this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery().get(i);
                if (index <= q.getSequence()) {
                    index = q.getSequence() + 1;
                }
                ++i;
            }
            Query queryObj = OF.createQuery();
            queryObj.setSequence(index);
            queryObj.setBody(query);
            this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery().add(queryObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add auto update check pre-SQL", (Throwable)e);
        }
    }

    public List getAutoUpdateCheckPre() {
        return this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery();
    }

    public Query getAutoUpdateCheckPre(int sequence) {
        int i = 0;
        while (i < this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery().size()) {
            Query q = (Query)this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery().get(i);
            if (q.getSequence() == sequence) {
                return q;
            }
            ++i;
        }
        return null;
    }

    public boolean modifyAutoUpdateCheckPre(int sequence, String query) {
        int size = this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery().size();
        int i = 0;
        while (i < size) {
            Query q = (Query)this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery().get(i);
            if (q.getSequence() == sequence) {
                q.setBody(query);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeAutoUpdateCheckPre(int sequence) {
        List queries = this.getDbWatcherSetting().getAutoUpdateCheckPre().getQuery();
        int i = 0;
        while (i < queries.size()) {
            Query q = (Query)queries.get(i);
            if (q.getSequence() == sequence) {
                queries.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addAutoUpdateCheckPost(String query) throws IRException {
        try {
            int size = this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery().size();
            int index = 1;
            int i = 0;
            while (i < size) {
                Query q = (Query)this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery().get(i);
                if (index <= q.getSequence()) {
                    index = q.getSequence() + 1;
                }
                ++i;
            }
            Query queryObj = OF.createQuery();
            queryObj.setSequence(index);
            queryObj.setBody(query);
            this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery().add(queryObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add auto update check post-SQL", (Throwable)e);
        }
    }

    public List getAutoUpdateCheckPost() {
        return this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery();
    }

    public Query getAutoUpdateCheckPost(int sequence) {
        int i = 0;
        while (i < this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery().size()) {
            Query q = (Query)this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery().get(i);
            if (q.getSequence() == sequence) {
                return q;
            }
            ++i;
        }
        return null;
    }

    public boolean modifyAutoUpdateCheckPost(int sequence, String query) {
        int size = this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery().size();
        int i = 0;
        while (i < size) {
            Query q = (Query)this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery().get(i);
            if (q.getSequence() == sequence) {
                q.setBody(query);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeAutoUpdateCheckPost(int sequence) {
        List queries = this.getDbWatcherSetting().getAutoUpdateCheckPost().getQuery();
        int i = 0;
        while (i < queries.size()) {
            Query q = (Query)queries.get(i);
            if (q.getSequence() == sequence) {
                queries.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setManualUpdateCheckSql(String query) {
        this.getDbWatcherSetting().setManualUpdateCheckSql(query);
    }

    public String getManualUpdateCheckSql() {
        return this.getDbWatcherSetting().getManualUpdateCheckSql();
    }

    public void addManualUpdateCheckPost(String query) throws IRException {
        try {
            int size = this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery().size();
            int index = 1;
            int i = 0;
            while (i < size) {
                Query q = (Query)this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery().get(i);
                if (index <= q.getSequence()) {
                    index = q.getSequence() + 1;
                }
                ++i;
            }
            Query queryObj = OF.createQuery();
            queryObj.setSequence(index);
            queryObj.setBody(query);
            this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery().add(queryObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add manual update check post-SQL", (Throwable)e);
        }
    }

    public List getManualUpdateCheckPost() {
        return this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery();
    }

    public Query getManualUpdateCheckPost(int sequence) {
        int i = 0;
        while (i < this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery().size()) {
            Query q = (Query)this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery().get(i);
            if (q.getSequence() == sequence) {
                return q;
            }
            ++i;
        }
        return null;
    }

    public boolean modifyManualUpdateCheckPost(int sequence, String query) {
        int size = this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery().size();
        int i = 0;
        while (i < size) {
            Query q = (Query)this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery().get(i);
            if (q.getSequence() == sequence) {
                q.setBody(query);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeManualUpdateCheckPost(int sequence) {
        List queries = this.getDbWatcherSetting().getManualUpdateCheckPost().getQuery();
        int i = 0;
        while (i < queries.size()) {
            Query q = (Query)queries.get(i);
            if (q.getSequence() == sequence) {
                queries.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addFieldUpdateCollectSqlPre(String query) throws IRException {
        try {
            int size = this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery().size();
            int index = 1;
            int i = 0;
            while (i < size) {
                Query q = (Query)this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery().get(i);
                if (index <= q.getSequence()) {
                    index = q.getSequence() + 1;
                }
                ++i;
            }
            Query queryObj = OF.createQuery();
            queryObj.setSequence(index);
            queryObj.setBody(query);
            this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery().add(queryObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add field update collect pre-SQL", (Throwable)e);
        }
    }

    public List getFieldUpdateCollectSqlPre() {
        return this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery();
    }

    public Query getFieldUpdateCollectSqlPre(int sequence) {
        int i = 0;
        while (i < this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery().size()) {
            Query q = (Query)this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery().get(i);
            if (q.getSequence() == sequence) {
                return q;
            }
            ++i;
        }
        return null;
    }

    public boolean modifyFieldUpdateCollectSqlPre(int sequence, String query) {
        int size = this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery().size();
        int i = 0;
        while (i < size) {
            Query q = (Query)this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery().get(i);
            if (q.getSequence() == sequence) {
                q.setBody(query);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeFieldUpdateCollectSqlPre(int sequence) {
        List queries = this.getDbWatcherSetting().getFieldUpdateCollectSqlPre().getQuery();
        int i = 0;
        while (i < queries.size()) {
            Query q = (Query)queries.get(i);
            if (q.getSequence() == sequence) {
                queries.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setFieldUpdateCollectSql(String query) {
        this.getDbWatcherSetting().setFieldUpdateCollectSql(query);
    }

    public String getFieldUpdateCollectSql() {
        return this.getDbWatcherSetting().getFieldUpdateCollectSql();
    }

    public void addFieldUpdateCollectSqlPost(String query) throws IRException {
        try {
            int size = this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery().size();
            int index = 1;
            int i = 0;
            while (i < size) {
                Query q = (Query)this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery().get(i);
                if (index <= q.getSequence()) {
                    index = q.getSequence() + 1;
                }
                ++i;
            }
            Query queryObj = OF.createQuery();
            queryObj.setSequence(index);
            queryObj.setBody(query);
            this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery().add(queryObj);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during add field update collect post-SQL", (Throwable)e);
        }
    }

    public List getFieldUpdateCollectSqlPost() {
        return this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery();
    }

    public Query getFieldUpdateCollectSqlPost(int sequence) {
        int i = 0;
        while (i < this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery().size()) {
            Query q = (Query)this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery().get(i);
            if (q.getSequence() == sequence) {
                return q;
            }
            ++i;
        }
        return null;
    }

    public boolean modifyFieldUpdateCollectSqlPost(int sequence, String query) {
        int size = this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery().size();
        int i = 0;
        while (i < size) {
            Query q = (Query)this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery().get(i);
            if (q.getSequence() == sequence) {
                q.setBody(query);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeFieldUpdateCollectSqlPost(int sequence) {
        List queries = this.getDbWatcherSetting().getFieldUpdateCollectSqlPost().getQuery();
        int i = 0;
        while (i < queries.size()) {
            Query q = (Query)queries.get(i);
            if (q.getSequence() == sequence) {
                queries.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setMappingList(boolean extension, String extensionLabel) throws IRException {
        try {
            MappingList mappingList = (MappingList)this.getDbWatcherSetting().getMappingList();
            if (mappingList == null) {
                mappingList = OF.createMappingList();
            }
            mappingList.setUseExtension(extension);
            mappingList.setExtensionLabel(extensionLabel);
            this.getDbWatcherSetting().setMappingList(mappingList);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during set mapping list", (Throwable)e);
        }
    }

    public void initFullCollectPre() throws IRException {
        try {
            FullCollectSqlPre fullCollectPre = OF.createFullCollectSqlPre();
            this.getDbWatcherSetting().setFullCollectSqlPre(fullCollectPre);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during initialize full collect pre-SQL", (Throwable)e);
        }
    }

    public void initFullCollectPost() throws IRException {
        try {
            FullCollectSqlPost fullCollectPost = OF.createFullCollectSqlPost();
            this.getDbWatcherSetting().setFullCollectSqlPost(fullCollectPost);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during initialize full collect post-SQL", (Throwable)e);
        }
    }

    public void initAutoUpdateCheckPre() throws IRException {
        try {
            AutoUpdateCheckPre autoUpdateCheckPre = OF.createAutoUpdateCheckPre();
            this.getDbWatcherSetting().setAutoUpdateCheckPre(autoUpdateCheckPre);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during initialize auto update check pre-SQL", (Throwable)e);
        }
    }

    public void initAutoUpdateCheckPost() throws IRException {
        try {
            AutoUpdateCheckPost autoUpdateCheckPost = OF.createAutoUpdateCheckPost();
            this.getDbWatcherSetting().setAutoUpdateCheckPost(autoUpdateCheckPost);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during initialize auto update check post-SQL", (Throwable)e);
        }
    }

    public void initManualUpdatePost() throws IRException {
        try {
            ManualUpdateCheckPost manualUpdatePost = OF.createManualUpdateCheckPost();
            this.getDbWatcherSetting().setManualUpdateCheckPost(manualUpdatePost);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during initialize manual update check post-SQL", (Throwable)e);
        }
    }

    public void initFieldUpdateCollectPre() throws IRException {
        try {
            FieldUpdateCollectSqlPre fieldUpdateCollectPre = OF.createFieldUpdateCollectSqlPre();
            this.getDbWatcherSetting().setFieldUpdateCollectSqlPre(fieldUpdateCollectPre);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during initialize field update check pre-SQL", (Throwable)e);
        }
    }

    public void initFieldUpdateCollectPost() throws IRException {
        try {
            FieldUpdateCollectSqlPost fieldUpdateCollectPost = OF.createFieldUpdateCollectSqlPost();
            this.getDbWatcherSetting().setFieldUpdateCollectSqlPost(fieldUpdateCollectPost);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during initialize field update check post-SQL", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMapping(String dbField, boolean removeHtmlTag, boolean useAttachFileFilter) throws IRException {
        if (Assert.isNullMappingList(this.getDbWatcherSetting())) {
            throw new IRException(2, "Cannot add mapping field, Mapping list did not initialized.");
        }
        if (Assert.isDuplicateSchemaID(this.getDbWatcherSetting(), dbField)) throw new IRException(2, "Cannot add a mapping field. Mapping field name already exists : " + dbField + ".");
        if (!this.getDbWatcherSetting().getMappingList().isUseExtension()) throw new IRException(2, "Cannot add mapping field : " + dbField + ", Extension did not make use");
        Mapping mapping = null;
        try {
            mapping = OF.createMapping();
            mapping.setDbField(dbField);
            mapping.setSchemaID("");
            mapping.setUseExtension(true);
            mapping.setUseAttachFileFilter(useAttachFileFilter);
            mapping.setRemoveHtmlTag(removeHtmlTag);
            this.getDbWatcherSetting().getMappingList().getMapping().add(mapping);
            return;
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred.", (Throwable)e);
        }
    }

    public void addMapping(String schemaID, String dbField, boolean useExtension, boolean removeHtmlTag, boolean useAttachFileFilter, boolean useFieldUpdate, boolean isFileMetaField) throws IRException {
        if (Assert.isNullMappingList(this.getDbWatcherSetting())) {
            throw new IRException(2, "Cannot add mapping field, Mapping list did not initialized.");
        }
        Mapping mapping = this.getMapping(schemaID);
        boolean add = false;
        if (mapping == null) {
            try {
                mapping = OF.createMapping();
                add = true;
            }
            catch (JAXBException e) {
                throw new IRException(2, "JAXBException is occurred.", (Throwable)e);
            }
        }
        mapping.setDbField(dbField);
        mapping.setSchemaID(schemaID);
        mapping.setUseExtension(useExtension);
        mapping.setUseAttachFileFilter(useAttachFileFilter);
        mapping.setRemoveHtmlTag(removeHtmlTag);
        mapping.setUseFieldUpdate(useFieldUpdate);
        mapping.setFileMetaField(isFileMetaField);
        if (add) {
            this.getDbWatcherSetting().getMappingList().getMapping().add(mapping);
        }
    }

    public Mapping getMapping(String schemaID) {
        List mappings = this.getDbWatcherSetting().getMappingList().getMapping();
        int i = 0;
        while (i < mappings.size()) {
            Mapping mapping = (Mapping)mappings.get(i);
            if (mapping.getSchemaID().equals(schemaID)) {
                return mapping;
            }
            ++i;
        }
        return null;
    }

    public void modifyFrame(String description, String dataSourceID, String filterSettingID, String logLevel) {
        this.getDbWatcherSetting().setDescription(description);
        this.getDbWatcherSetting().setDataSourceID(dataSourceID);
        this.getDbWatcherSetting().setDbWatcherFilterSettingID(filterSettingID);
    }

    public void modifyFrame(String description, String dataSourceID, String filterSettingID, String logLevel, int fetchSize) {
        this.getDbWatcherSetting().setDescription(description);
        this.getDbWatcherSetting().setDataSourceID(dataSourceID);
        this.getDbWatcherSetting().setDbWatcherFilterSettingID(filterSettingID);
        this.getDbWatcherSetting().setFetchSize(fetchSize);
    }

    public String getCollectionID() {
        return this.getDbWatcherSetting().getCollectionID();
    }

    public String getID() {
        return this.getDbWatcherSetting().getId();
    }

    public void removeMappings() {
        this.getDbWatcherSetting().getMappingList().getMapping().clear();
    }

    public boolean removeMapping(String schemaID) {
        List mappings = this.getDbWatcherSetting().getMappingList().getMapping();
        int i = 0;
        while (i < mappings.size()) {
            Mapping mapping = (Mapping)mappings.get(i);
            if (mapping.getSchemaID().equals(schemaID)) {
                mappings.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public Transmitable getInstance() {
        return new SingleDBWatcherSettingManager();
    }

    public static SingleDBWatcherSettingManager readFromFile(Object settingObj, String prefix, String fileName) {
        return new SingleDBWatcherSettingManager(prefix, fileName, settingObj);
    }

    public static SettingHandler readFromObject(String packageName, String prefix, String fileName) throws IRException {
        return new SingleDBWatcherSettingManager(packageName, prefix, fileName);
    }

    public void setUseAutoInc(boolean useAutoInc) {
        this.getDbWatcherSetting().setUseAutoInc(useAutoInc);
    }

    public void setUseManualInc(boolean useManualInc) {
        this.getDbWatcherSetting().setUseManualInc(useManualInc);
    }

    public void setUseFieldUpdate(boolean useFieldUpdate) {
        this.getDbWatcherSetting().setUseFieldUpdate(useFieldUpdate);
    }

    public void setMetaField(String schemaId, String filterMetaField, boolean useFilterMetaField) {
        Mapping mapping = this.getMapping(schemaId);
        mapping.setUseFilterMetaField(useFilterMetaField);
        mapping.setFilterMetaField(filterMetaField);
    }

    public List getFilteredMappingList() {
        List mappingList = this.getDbWatcherSetting().getMappingList().getMapping();
        ArrayList<Mapping> filteredMappingList = new ArrayList<Mapping>();
        int i = 0;
        while (i < mappingList.size()) {
            Mapping mapping = (Mapping)mappingList.get(i);
            if (mapping.isUseAttachFileFilter()) {
                filteredMappingList.add(mapping);
            }
            ++i;
        }
        return filteredMappingList;
    }

    public List getDisabledSchemaIdList(List schemaSettingList) {
        ArrayList<SchemaSetting> disabledSchemaIdList = new ArrayList<SchemaSetting>();
        int i = 0;
        while (i < schemaSettingList.size()) {
            SchemaSetting schemaSetting = (SchemaSetting)schemaSettingList.get(i);
            boolean has = false;
            int j = 0;
            while (j < this.getDbWatcherSetting().getMappingList().getMapping().size()) {
                Mapping mapping = (Mapping)this.getDbWatcherSetting().getMappingList().getMapping().get(j);
                if (schemaSetting.getId().equals(mapping.getSchemaID())) {
                    has = true;
                    break;
                }
                ++j;
            }
            if (!has) {
                disabledSchemaIdList.add(schemaSetting);
            }
            ++i;
        }
        return disabledSchemaIdList;
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.dbwatcher";
    }

    public boolean hasDisabledSchemaIdList(List schemaSettingList) {
        return this.getDisabledSchemaIdList(schemaSettingList).size() > 0;
    }

    public boolean hasFileFilterField() {
        return this.getFilteredMappingList().size() > 0;
    }

    public static Mapping createNullMapping() throws IRException {
        try {
            Mapping mapping = OF.createMapping();
            mapping.setDbField("");
            mapping.setSchemaID("");
            mapping.setFilterMetaField("");
            return mapping;
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred.", (Throwable)e);
        }
    }

    public List getFileMetaMappingList() {
        ArrayList<Mapping> fmml = new ArrayList<Mapping>();
        List ms = this.getDbWatcherSetting().getMappingList().getMapping();
        int i = 0;
        while (i < ms.size()) {
            Mapping m = (Mapping)ms.get(i);
            if (m.isFileMetaField()) {
                fmml.add(m);
            }
            ++i;
        }
        return fmml;
    }

    public boolean hasFileMetaField() {
        List ml = this.getDbWatcherSetting().getMappingList().getMapping();
        int i = 0;
        while (i < ml.size()) {
            Mapping m = (Mapping)ml.get(i);
            if (m.isFileMetaField()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DbWatcherSetting frame(String collectionID, String dbWatcherID, String filterSettingID, int fetchSize, String encoding, String extension, String description) throws IRException {
        this.getDbWatcherSetting().setCollectionID(collectionID);
        this.getDbWatcherSetting().setId(dbWatcherID);
        this.getDbWatcherSetting().setDescription(description);
        this.getDbWatcherSetting().setFetchSize(fetchSize);
        this.getDbWatcherSetting().setDbWatcherFilterSettingID(filterSettingID);
        this.getDbWatcherSetting().setEncoding(encoding);
        this.getDbWatcherSetting().setDataSourceID("");
        this.initFullCollectPre();
        this.initFullCollectPost();
        this.initAutoUpdateCheckPre();
        this.initAutoUpdateCheckPost();
        this.initManualUpdatePost();
        this.initFieldUpdateCollectPre();
        this.initFieldUpdateCollectPost();
        this.setMappingList(extension != null, extension == null ? "" : extension);
        return this.getDbWatcherSetting();
    }

    public DbWatcherSetting frame(String collectionID, String dbWatcherID, String filterSettingID, int fetchSize, int bulkFactor, String encoding, String extension, String description) throws IRException {
        this.getDbWatcherSetting().setCollectionID(collectionID);
        this.getDbWatcherSetting().setId(dbWatcherID);
        this.getDbWatcherSetting().setDescription(description);
        this.getDbWatcherSetting().setFetchSize(fetchSize);
        this.getDbWatcherSetting().setBulkFactor(bulkFactor);
        this.getDbWatcherSetting().setDbWatcherFilterSettingID(filterSettingID);
        this.getDbWatcherSetting().setEncoding(encoding);
        this.getDbWatcherSetting().setDataSourceID("");
        this.initFullCollectPre();
        this.initFullCollectPost();
        this.initAutoUpdateCheckPre();
        this.initAutoUpdateCheckPost();
        this.initManualUpdatePost();
        this.initFieldUpdateCollectPre();
        this.initFieldUpdateCollectPost();
        this.setMappingList(extension != null, extension == null ? "" : extension);
        return this.getDbWatcherSetting();
    }

    public DbWatcherSetting modifyFrame(String filterSettingID, int fetchSize, String encoding, String extension, String description) throws IRException {
        this.getDbWatcherSetting().setDescription(description);
        this.getDbWatcherSetting().setFetchSize(fetchSize);
        this.getDbWatcherSetting().setDbWatcherFilterSettingID(filterSettingID);
        this.getDbWatcherSetting().setEncoding(encoding);
        this.setMappingList(extension != null, extension == null ? "" : extension);
        return this.getDbWatcherSetting();
    }

    public DbWatcherSetting modifyFrame(String filterSettingID, int fetchSize, int bulkFactor, String encoding, String extension, String description) throws IRException {
        this.getDbWatcherSetting().setDescription(description);
        this.getDbWatcherSetting().setFetchSize(fetchSize);
        this.getDbWatcherSetting().setBulkFactor(bulkFactor);
        this.getDbWatcherSetting().setDbWatcherFilterSettingID(filterSettingID);
        this.getDbWatcherSetting().setEncoding(encoding);
        this.setMappingList(extension != null, extension == null ? "" : extension);
        return this.getDbWatcherSetting();
    }

    static class Assert {
        Assert() {
        }

        public static boolean isDuplicateSchemaID(DbWatcherSetting settingObj, String schemaID) {
            MappingListType mappingListType = settingObj.getMappingList();
            List mappingList = mappingListType.getMapping();
            int i = 0;
            while (i < mappingList.size()) {
                Mapping mapping = (Mapping)mappingList.get(i);
                if (schemaID.equals(mapping.getSchemaID())) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public static boolean isNullMappingList(DbWatcherSetting settingObj) {
            return settingObj.getMappingList() == null;
        }
    }
}

