/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.setting.manager;

import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.manager.SettingHandler;
import com.diquest.ir.common.setting.startupsetting.AdminServer;
import com.diquest.ir.common.setting.startupsetting.ObjectFactory;
import com.diquest.ir.common.setting.startupsetting.ServerName;
import com.diquest.ir.common.setting.startupsetting.Setting;
import com.diquest.ir.common.setting.startupsetting.SettingList;
import com.diquest.ir.common.setting.startupsetting.StartupSetting;
import com.diquest.ir.util.msg.Transmitable;
import javax.xml.bind.JAXBException;

public class StartupSettingHandler
extends SettingHandler {
    static ObjectFactory FACTORY = new ObjectFactory();
    SettingList settingListNode = null;

    public StartupSettingHandler() {
    }

    private StartupSettingHandler(String prefix, String fileName) throws IRException {
        super(prefix, fileName);
    }

    private StartupSettingHandler(String prefix, String fileName, Object settingObject) {
        super(prefix, fileName, settingObject);
    }

    public static StartupSettingHandler create(String prefix) throws IRException {
        try {
            return new StartupSettingHandler(prefix, FACTORY.createStartupSetting());
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred.", (Throwable)e);
        }
    }

    private StartupSettingHandler(String prefix, Object settingObj) throws IRException {
        super(prefix, "startupSetting.xml", settingObj);
        try {
            this.settingListNode = FACTORY.createSettingList();
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred.", (Throwable)e);
        }
    }

    public static StartupSettingHandler readFromFile(String prefix, String fileName) throws IRException {
        return new StartupSettingHandler(prefix, fileName);
    }

    public static StartupSettingHandler readFromObject(String prefix, String fileName, Object settingObject) {
        return new StartupSettingHandler(prefix, fileName, settingObject);
    }

    private StartupSettingHandler(String prefix) throws IRException {
        super(prefix, "startupSetting.xml", "com.diquest.ir.common.setting.startupsetting");
    }

    public void addAdminServer(String adminIP, int adminPort) throws IRException {
        try {
            AdminServer adminServerNode = FACTORY.createAdminServer();
            adminServerNode.setIp(adminIP);
            adminServerNode.setPort(adminPort);
            StartupSetting startupSetting = (StartupSetting)this.settingObj;
            startupSetting.setAdminServer(adminServerNode);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding adminServer information.", (Throwable)e);
        }
    }

    public void addServerName(String serverName) throws IRException {
        try {
            ServerName serverNameNode = FACTORY.createServerName();
            serverNameNode.setValue(serverName);
            ((StartupSetting)this.settingObj).setServerName(serverNameNode);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during setting serverName.", (Throwable)e);
        }
    }

    public void addSetting(String serverName) throws IRException {
        try {
            Setting settingSvrNameNode = FACTORY.createSetting();
            settingSvrNameNode.setName(serverName);
            this.settingListNode.getSetting().add(settingSvrNameNode);
            ((StartupSetting)this.settingObj).setSettingList(this.settingListNode);
        }
        catch (JAXBException e) {
            throw new IRException(2, "JAXBException is occurred during adding required setting.", (Throwable)e);
        }
    }

    public Transmitable getInstance() {
        return new StartupSettingHandler();
    }

    public String getPackageName() {
        return "com.diquest.ir.common.setting.startupsetting";
    }
}

