/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

public class ArrayUtil {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    protected ArrayUtil() {
    }

    public static boolean isNoneNullExist(Object[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int[] getNoneNullIndices(Object[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] temp = new int[array.length];
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                temp[index++] = i;
            }
            ++i;
        }
        if (index == array.length) {
            return temp;
        }
        int[] trimmed = new int[index];
        System.arraycopy(temp, 0, trimmed, 0, index);
        return trimmed;
    }

    public static boolean isEmpty(byte[] array, int offset, int length) {
        int i = 0;
        while (i < length) {
            if (array[offset + i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] ensureCapacity(byte[] array, int minCapacity) {
        byte[] newArray;
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            newArray = new byte[newCapacity];
            System.arraycopy(array, 0, newArray, 0, oldCapacity);
        } else {
            newArray = array;
        }
        return newArray;
    }

    public static int[] ensureCapacity(int[] array, int minCapacity) {
        int[] newArray;
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            newArray = new int[newCapacity];
            System.arraycopy(array, 0, newArray, 0, oldCapacity);
        } else {
            newArray = array;
        }
        return newArray;
    }

    public static int[] trimToCapacity(int[] array, int maxCapacity) {
        if (array.length > maxCapacity) {
            int[] oldArray = array;
            array = new int[maxCapacity];
            System.arraycopy(oldArray, 0, array, 0, maxCapacity);
        }
        return array;
    }

    public static byte[] trimToCapacity(byte[] array, int maxCapacity) {
        if (array.length > maxCapacity) {
            byte[] oldArray = array;
            array = new byte[maxCapacity];
            System.arraycopy(oldArray, 0, array, 0, maxCapacity);
        }
        return array;
    }

    public static final int[] reallocIncrease(int[] a, int inc) {
        int[] b = new int[a.length + inc];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public static final long[] reallocIncrease(long[] a, int inc) {
        long[] b = new long[a.length + inc];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public static final int[] reallocAs(int[] a, int size) {
        int[] b = new int[size];
        int copySize = a.length < size ? a.length : size;
        System.arraycopy(a, 0, b, 0, copySize);
        return b;
    }

    public static final byte[] reallocAs(byte[] a, int size) {
        return ArrayUtil.reallocAs(a, 0, size);
    }

    public static final byte[] reallocAs(byte[] a, int offset, int size) {
        byte[] b = new byte[size];
        int copySize = a.length < size ? a.length : size;
        System.arraycopy(a, offset, b, 0, copySize);
        return b;
    }

    public static final long[] reallocAs(long[] a, int size) {
        long[] b = new long[size];
        int copySize = a.length < size ? a.length : size;
        System.arraycopy(a, 0, b, 0, copySize);
        return b;
    }
}

