/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import com.diquest.ir.util.common.vector.CharVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.common.ByteUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static final void writeBoolean(OutputStream out, boolean value) throws IOException {
        if (value) {
            out.write(1);
        } else {
            out.write(0);
        }
    }

    public static final boolean readBoolean(InputStream in) throws IOException {
        return in.read() == 1;
    }

    public static final byte[] writeBoolean(boolean value) {
        if (value) {
            return new byte[]{1};
        }
        return new byte[1];
    }

    public static final boolean readBoolean(byte[] in, int offset) {
        return in[offset] == 1;
    }

    public static final void writeBoolean(ByteBuffer buf, boolean value) {
        if (value) {
            buf.put((byte)1);
        } else {
            buf.put((byte)0);
        }
    }

    public static final boolean readBoolean(ByteBuffer buf) {
        byte c = buf.get();
        return c != 0;
    }

    public static final void writeByte(OutputStream out, byte value) throws IOException {
        out.write((value & 0xFF) >>> 0);
    }

    public static final byte readByte(InputStream in) throws IOException {
        return (byte)(in.read() << 0);
    }

    public static final void writeBytes(OutputStream out, byte[] value, int offset, int length) throws IOException {
        ByteUtil.writeVbInt(out, length);
        int i = offset;
        while (i < offset + length) {
            out.write((value[i] & 0xFF) >>> 0);
            ++i;
        }
    }

    public static final byte[] readBytes(InputStream in) throws IOException {
        int length = ByteUtil.readVbInt(in);
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            result[i] = (byte)(in.read() << 0);
            ++i;
        }
        return result;
    }

    public static final void writeBytes(OutputStream out, byte[] value) throws IOException {
        ByteUtil.writeBytes(out, value, 0, value.length);
    }

    public static final void writeBytes(ByteBuffer buf, byte[] value) {
        buf.put(value);
    }

    public static final byte[] writeByte(byte value) {
        return new byte[]{(byte)((value & 0xFF) >>> 0)};
    }

    public static final byte readByte(byte[] in, int offset) {
        return (byte)(in[offset] << 0);
    }

    public static final void writeByte(ByteBuffer buf, byte value) {
        buf.put(value);
    }

    public static final byte readByte(ByteBuffer buf) {
        return buf.get();
    }

    public static final void writeShort(OutputStream out, short value) throws IOException {
        out.write((value & 0xFF00) >>> 8);
        out.write((value & 0xFF) >>> 0);
    }

    public static final short readShort(InputStream in) throws IOException {
        return (short)(in.read() << 8 | in.read() << 0);
    }

    public static final byte[] writeShort(short value) {
        return new byte[]{(byte)((value & 0xFF00) >>> 8), (byte)((value & 0xFF) >>> 0)};
    }

    public static final short readShort(byte[] in, int offset) {
        return (short)((in[offset + 0] & 0xFF) << 8 | (in[offset + 1] & 0xFF) << 0);
    }

    public static final void writeShort(ByteBuffer buf, short value) {
        buf.put((byte)((value & 0xFF00) >>> 8));
        buf.put((byte)((value & 0xFF) >>> 0));
    }

    public static final short readShort(ByteBuffer buf) {
        return (short)((buf.get() & 0xFF) << 8 | (buf.get() & 0xFF) << 0);
    }

    public static final void writeChar(OutputStream out, char value) throws IOException {
        out.write((value & 0xFF00) >>> 8);
        out.write((value & 0xFF) >>> 0);
    }

    public static final char readChar(InputStream in) throws IOException {
        return (char)(in.read() << 8 | in.read() << 0);
    }

    public static final byte[] writeChar(char value) {
        return new byte[]{(byte)((value & 0xFF00) >>> 8), (byte)((value & 0xFF) >>> 0)};
    }

    public static final char readChar(byte[] in, int offset) {
        return (char)(in[offset] << 8 | in[offset + 1] << 0);
    }

    public static final void writeChar(ByteBuffer buf, char value) {
        buf.put((byte)((value & 0xFF00) >>> 8));
        buf.put((byte)((value & 0xFF) >>> 0));
    }

    public static final char readChar(ByteBuffer in) {
        return (char)(in.get() << 8 | in.get() << 0);
    }

    public static final void writeInt(OutputStream out, int value) throws IOException {
        out.write((value & 0xFF000000) >>> 24);
        out.write((value & 0xFF0000) >>> 16);
        out.write((value & 0xFF00) >>> 8);
        out.write((value & 0xFF) >>> 0);
    }

    public static final int readInt(InputStream in) throws IOException {
        return in.read() << 24 | in.read() << 16 | in.read() << 8 | in.read() << 0;
    }

    public static final byte[] writeInt(int value) {
        return new byte[]{(byte)((value & 0xFF000000) >>> 24), (byte)((value & 0xFF0000) >>> 16), (byte)((value & 0xFF00) >>> 8), (byte)((value & 0xFF) >>> 0)};
    }

    public static final int readInt(byte[] in, int offset) {
        return (in[offset + 3] & 0xFF) << 0 | (in[offset + 2] & 0xFF) << 8 | (in[offset + 1] & 0xFF) << 16 | (in[offset + 0] & 0xFF) << 24;
    }

    public static final void writeInt(ByteBuffer buf, int value) {
        buf.put((byte)((value & 0xFF000000) >>> 24));
        buf.put((byte)((value & 0xFF0000) >>> 16));
        buf.put((byte)((value & 0xFF00) >>> 8));
        buf.put((byte)((value & 0xFF) >>> 0));
    }

    public static final int readInt(ByteBuffer buf) {
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            bytes[i] = buf.get();
            ++i;
        }
        return (bytes[3] & 0xFF) << 0 | (bytes[2] & 0xFF) << 8 | (bytes[1] & 0xFF) << 16 | (bytes[0] & 0xFF) << 24;
    }

    public static final void writeFloat(OutputStream out, float value) throws IOException {
        int intValue = Float.floatToIntBits(value);
        out.write((intValue & 0xFF000000) >>> 24);
        out.write((intValue & 0xFF0000) >>> 16);
        out.write((intValue & 0xFF00) >>> 8);
        out.write((intValue & 0xFF) >>> 0);
    }

    public static final float readFloat(InputStream in) throws IOException {
        int intValue = in.read() << 24 | in.read() << 16 | in.read() << 8 | in.read() << 0;
        return Float.intBitsToFloat(intValue);
    }

    public static final byte[] writeFloat(float value) {
        int intValue = Float.floatToIntBits(value);
        return new byte[]{(byte)((intValue & 0xFF000000) >>> 24), (byte)((intValue & 0xFF0000) >>> 16), (byte)((intValue & 0xFF00) >>> 8), (byte)((intValue & 0xFF) >>> 0)};
    }

    public static final float readFloat(byte[] in, int offset) {
        int intValue = (in[offset + 3] & 0xFF) << 0 | (in[offset + 2] & 0xFF) << 8 | (in[offset + 1] & 0xFF) << 16 | (in[offset] & 0xFF) << 24;
        return Float.intBitsToFloat(intValue);
    }

    public static final void writeFloat(ByteBuffer buf, float value) {
        int intValue = Float.floatToIntBits(value);
        buf.put((byte)((intValue & 0xFF000000) >>> 24));
        buf.put((byte)((intValue & 0xFF0000) >>> 16));
        buf.put((byte)((intValue & 0xFF00) >>> 8));
        buf.put((byte)((intValue & 0xFF) >>> 0));
    }

    public static final float readFloat(ByteBuffer buf) {
        byte[] in = new byte[4];
        int i = 0;
        while (i < 4) {
            in[i] = buf.get();
            ++i;
        }
        int intValue = (in[3] & 0xFF) << 0 | (in[2] & 0xFF) << 8 | (in[1] & 0xFF) << 16 | (in[0] & 0xFF) << 24;
        return Float.intBitsToFloat(intValue);
    }

    public static final void writeDouble(OutputStream out, double value) throws IOException {
        long l = Double.doubleToLongBits(value);
        ByteUtil.writeLong(out, l);
    }

    public static final double readDouble(InputStream in) throws IOException {
        long l = ByteUtil.readLong(in);
        return Double.longBitsToDouble(l);
    }

    public static final byte[] writeDouble(double value) {
        long l = Double.doubleToLongBits(value);
        return ByteUtil.writeLong(l);
    }

    public static final double readDouble(byte[] in, int offset) {
        return Double.longBitsToDouble(ByteUtil.readLong(in, offset));
    }

    public static final void writeDouble(ByteBuffer buf, double value) {
        long l = Double.doubleToLongBits(value);
        ByteUtil.writeLong(buf, l);
    }

    public static final double readDouble(ByteBuffer buf) {
        return Double.longBitsToDouble(ByteUtil.readLong(buf));
    }

    public static final void writeLong(OutputStream out, long value) throws IOException {
        out.write((int)((value & 0xFF00000000000000L) >>> 56));
        out.write((int)((value & 0xFF000000000000L) >>> 48));
        out.write((int)((value & 0xFF0000000000L) >>> 40));
        out.write((int)((value & 0xFF00000000L) >>> 32));
        out.write((int)((value & 0xFF000000L) >>> 24));
        out.write((int)((value & 0xFF0000L) >>> 16));
        out.write((int)((value & 0xFF00L) >>> 8));
        out.write((int)((value & 0xFFL) >>> 0));
    }

    public static final long readLong(InputStream in) throws IOException {
        return (long)in.read() << 56 | (long)in.read() << 48 | (long)in.read() << 40 | (long)in.read() << 32 | (long)in.read() << 24 | (long)in.read() << 16 | (long)in.read() << 8 | (long)in.read() << 0;
    }

    public static final byte[] writeLong(long value) {
        return new byte[]{(byte)((value & 0xFF00000000000000L) >>> 56), (byte)((value & 0xFF000000000000L) >>> 48), (byte)((value & 0xFF0000000000L) >>> 40), (byte)((value & 0xFF00000000L) >>> 32), (byte)((value & 0xFF000000L) >>> 24), (byte)((value & 0xFF0000L) >>> 16), (byte)((value & 0xFF00L) >>> 8), (byte)((value & 0xFFL) >>> 0)};
    }

    public static final long readLong(byte[] in, int offset) {
        return (long)(in[offset + 0] & 0xFF) << 56 | (long)(in[offset + 1] & 0xFF) << 48 | (long)(in[offset + 2] & 0xFF) << 40 | (long)(in[offset + 3] & 0xFF) << 32 | (long)(in[offset + 4] & 0xFF) << 24 | (long)(in[offset + 5] & 0xFF) << 16 | (long)(in[offset + 6] & 0xFF) << 8 | (long)(in[offset + 7] & 0xFF) << 0;
    }

    public static final void writeLong(ByteBuffer buf, long value) {
        buf.put((byte)((value & 0xFF00000000000000L) >>> 56));
        buf.put((byte)((value & 0xFF000000000000L) >>> 48));
        buf.put((byte)((value & 0xFF0000000000L) >>> 40));
        buf.put((byte)((value & 0xFF00000000L) >>> 32));
        buf.put((byte)((value & 0xFF000000L) >>> 24));
        buf.put((byte)((value & 0xFF0000L) >>> 16));
        buf.put((byte)((value & 0xFF00L) >>> 8));
        buf.put((byte)((value & 0xFFL) >>> 0));
    }

    public static final long readLong(ByteBuffer buf) {
        byte[] in = new byte[8];
        int i = 0;
        while (i < 8) {
            in[i] = buf.get();
            ++i;
        }
        return (long)(in[0] & 0xFF) << 56 | (long)(in[1] & 0xFF) << 48 | (long)(in[2] & 0xFF) << 40 | (long)(in[3] & 0xFF) << 32 | (long)(in[4] & 0xFF) << 24 | (long)(in[5] & 0xFF) << 16 | (long)(in[6] & 0xFF) << 8 | (long)(in[7] & 0xFF) << 0;
    }

    public static final void writeString(OutputStream out, String value) throws IOException {
        if (value == null) {
            out.write(0);
            return;
        }
        out.write(1);
        int length = value.length();
        ByteUtil.writeVbInt(out, length);
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            out.write((c & 0xFF00) >>> 8);
            out.write((c & 0xFF) >>> 0);
            ++i;
        }
    }

    public static final String readString(InputStream in) throws IOException {
        if (in.read() == 0) {
            return null;
        }
        int length = ByteUtil.readVbInt(in);
        char[] buf = new char[length];
        int i = 0;
        while (i < length) {
            buf[i] = (char)((in.read() << 8) + (in.read() << 0));
            ++i;
        }
        return new String(buf);
    }

    public static final byte[] writeString(String value) {
        if (value == null) {
            return new byte[1];
        }
        byte[] out = new byte[5 + value.length() * 2];
        int writePos = 0;
        out[writePos++] = 1;
        int length = value.length();
        int intwrited = ByteUtil.writeVbInt(out, writePos, length);
        writePos += intwrited;
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            out[writePos++] = (byte)((c & 0xFF00) >>> 8);
            out[writePos++] = (byte)((c & 0xFF) >>> 0);
            ++i;
        }
        byte[] realOut = new byte[writePos];
        System.arraycopy(out, 0, realOut, 0, writePos);
        return realOut;
    }

    public static final String readString(byte[] in, int offset) {
        if (in[offset++] == 0) {
            return null;
        }
        int length = ByteUtil.readVbInt(in, offset);
        offset += ByteUtil.writeVbInt(length).length;
        char[] buf = new char[length];
        int i = 0;
        while (i < length) {
            buf[i] = (char)(((in[offset] & 0xFF) << 8) + ((in[offset + 1] & 0xFF) << 0));
            offset += 2;
            ++i;
        }
        return new String(buf);
    }

    public static final void writeString(ByteBuffer buf, String value) {
        if (value == null) {
            buf.put((byte)0);
        } else {
            buf.put((byte)1);
            int length = value.length();
            ByteUtil.writeVbInt(buf, length);
            int i = 0;
            while (i < length) {
                char c = value.charAt(i);
                buf.put((byte)((c & 0xFF00) >>> 8));
                buf.put((byte)((c & 0xFF) >>> 0));
                ++i;
            }
        }
    }

    public static final String readString(ByteBuffer buf) {
        if ((buf.get() & 0xFF) << 0 == 0) {
            return null;
        }
        int length = ByteUtil.readVbInt(buf);
        char[] cbuf = new char[length];
        int i = 0;
        while (i < length) {
            cbuf[i] = (char)(((buf.get() & 0xFF) << 8) + ((buf.get() & 0xFF) << 0));
            ++i;
        }
        return new String(cbuf);
    }

    public static final void writeChars(OutputStream out, char[] value) throws IOException {
        if (value == null) {
            out.write(0);
            return;
        }
        out.write(1);
        int length = value.length;
        ByteUtil.writeVbInt(out, length);
        int i = 0;
        while (i < length) {
            char c = value[i];
            out.write((c & 0xFF00) >>> 8);
            out.write((c & 0xFF) >>> 0);
            ++i;
        }
    }

    public static final char[] readChars(InputStream in) throws IOException {
        if (in.read() == 0) {
            return null;
        }
        int length = ByteUtil.readVbInt(in);
        if (!$assertionsDisabled && length < 0) {
            throw new AssertionError(length);
        }
        char[] buf = new char[length];
        int i = 0;
        while (i < length) {
            buf[i] = (char)((in.read() << 8) + (in.read() << 0));
            ++i;
        }
        return buf;
    }

    public static final char[] readChars(byte[] in, int offset) {
        if (in[offset++] == 0) {
            return null;
        }
        int length = ByteUtil.readVbInt(in, offset);
        offset += ByteUtil.writeVbInt(length).length;
        char[] buf = new char[length];
        int i = 0;
        while (i < length) {
            buf[i] = (char)(((in[offset] & 0xFF) << 8) + ((in[offset + 1] & 0xFF) << 0));
            offset += 2;
            ++i;
        }
        return buf;
    }

    public static final byte[] writeChars(CharVector value) {
        if (value == null) {
            return new byte[1];
        }
        byte[] out = new byte[5 + value.length * 2];
        int writePos = 0;
        out[writePos] = 0;
        int length = value.length;
        int intwrited = ByteUtil.writeVbInt(out, writePos, length);
        writePos += intwrited;
        int i = value.start;
        while (i < value.length) {
            char c = value.vector[i];
            out[writePos++] = (byte)((c & 0xFF00) >>> 8);
            out[writePos++] = (byte)((c & 0xFF) >>> 0);
            ++i;
        }
        byte[] realOut = new byte[writePos];
        System.arraycopy(out, 0, realOut, 0, writePos);
        return realOut;
    }

    public static final byte[] writeChars(char[] value) {
        if (value == null) {
            return new byte[1];
        }
        byte[] out = new byte[5 + value.length * 2];
        int writePos = 0;
        out[writePos] = 0;
        int length = value.length;
        int intwrited = ByteUtil.writeVbInt(out, writePos, length);
        writePos += intwrited;
        int i = 0;
        while (i < length) {
            char c = value[i];
            out[writePos++] = (byte)((c & 0xFF00) >>> 8);
            out[writePos++] = (byte)((c & 0xFF) >>> 0);
            ++i;
        }
        byte[] realOut = new byte[writePos];
        System.arraycopy(out, 0, realOut, 0, writePos);
        return realOut;
    }

    /*
     * Unable to fully structure code
     */
    public static final void writeVbInt(OutputStream out, int num) throws IOException {
        if (ByteUtil.$assertionsDisabled || num >= 0) ** GOTO lbl5
        throw new AssertionError(num);
lbl-1000:
        // 1 sources

        {
            out.write((byte)(num & 127));
            num >>>= 7;
lbl5:
            // 2 sources

            ** while (num >= 128)
        }
lbl6:
        // 1 sources

        out.write((byte)(num | 128));
    }

    /*
     * Unable to fully structure code
     */
    public static final void writeVbInt(ByteBuffer buffer, int num) {
        if (ByteUtil.$assertionsDisabled || num >= 0) ** GOTO lbl6
        throw new AssertionError(num);
lbl-1000:
        // 1 sources

        {
            buffer.put((byte)(num & 127));
            num >>>= 7;
lbl6:
            // 2 sources

            ** while (num >= 128)
        }
lbl7:
        // 1 sources

        buffer.put((byte)(num | 128));
    }

    /*
     * Unable to fully structure code
     */
    public static final byte[] writeVbInt(int num) {
        out = new byte[ByteUtil.checkVbLengthInt(num)];
        cnt = 0;
        if (ByteUtil.$assertionsDisabled || num >= 0) ** GOTO lbl7
        throw new AssertionError(num);
lbl-1000:
        // 1 sources

        {
            out[cnt++] = (byte)(num & 127);
            num >>>= 7;
lbl7:
            // 2 sources

            ** while (num >= 128)
        }
lbl8:
        // 1 sources

        out[cnt++] = (byte)(num | 128);
        realOut = new byte[cnt];
        System.arraycopy(out, 0, realOut, 0, cnt);
        return realOut;
    }

    /*
     * Unable to fully structure code
     */
    public static final int writeVbInt(byte[] out, int offset, int num) {
        cnt = 0;
        if (ByteUtil.$assertionsDisabled || num >= 0) ** GOTO lbl7
        throw new AssertionError(num);
lbl-1000:
        // 1 sources

        {
            out[offset++] = (byte)(num & 127);
            ++cnt;
            num >>>= 7;
lbl7:
            // 2 sources

            ** while (num >= 128)
        }
lbl8:
        // 1 sources

        out[offset++] = (byte)(num | 128);
        return ++cnt;
    }

    public static final void writeVbLong(OutputStream out, long num) throws IOException {
        byte c = (byte)(num & 0x7FL);
        num >>>= 7;
        while (num > 0L) {
            out.write(c);
            c = (byte)(num & 0x7FL);
            num >>>= 7;
        }
        out.write(c | 0x80);
    }

    public static final void writeVbLong(ByteBuffer buffer, long num) {
        byte c = (byte)(num & 0x7FL);
        num >>>= 7;
        while (num > 0L) {
            buffer.put(c);
            c = (byte)(num & 0x7FL);
            num >>>= 7;
        }
        buffer.put((byte)(c | 0x80));
    }

    public static final byte[] writeVbLong(long num) {
        byte[] out = new byte[ByteUtil.checkVbLengthLong(num)];
        int pos = 0;
        byte c = (byte)(num & 0x7FL);
        num >>>= 7;
        while (num > 0L) {
            out[pos++] = c;
            c = (byte)(num & 0x7FL);
            num >>>= 7;
        }
        out[pos++] = (byte)(c | 0x80);
        byte[] realOut = new byte[pos];
        System.arraycopy(out, 0, realOut, 0, pos);
        return realOut;
    }

    public static final int writeVbLong(byte[] out, int offset, long num) {
        int pos = 0;
        byte c = (byte)(num & 0x7FL);
        num >>>= 7;
        while (num > 0L) {
            out[offset++] = c;
            ++pos;
            c = (byte)(num & 0x7FL);
            num >>>= 7;
        }
        out[offset] = (byte)(c | 0x80);
        return ++pos;
    }

    public static final int readVbInt(InputStream in) throws IOException {
        int num = 0;
        int i = 0;
        int c = in.read();
        while ((c & 0x80) == 0) {
            num |= c << i;
            c = in.read();
            i += 7;
        }
        return num |= (c & 0x7F) << i;
    }

    public static final int readVbInt(byte[] in, int offset) {
        int shift = 0;
        int n = 0;
        while ((in[offset] & 0x80) == 0) {
            n |= in[offset++] << shift;
            shift += 7;
        }
        return n |= (in[offset++] & 0x7F) << shift;
    }

    public static final int readVbInt(ByteBuffer buffer) {
        int shift = 0;
        int n = 0;
        byte c = buffer.get();
        while ((c & 0x80) == 0) {
            n |= c << shift;
            c = buffer.get();
            shift += 7;
        }
        return n |= (c & 0x7F) << shift;
    }

    public static final long readVbLong(InputStream in) throws IOException {
        int i = 0;
        long num = 0L;
        int c = in.read();
        while ((c & 0x80) == 0) {
            num |= (long)c << i;
            c = in.read();
            i += 7;
        }
        return num |= ((long)c & 0x7FL) << i;
    }

    public static final long readVbLong(byte[] in, int offset) {
        int i = 0;
        long num = 0L;
        byte c = in[offset++];
        while ((c & 0x80) == 0) {
            num |= (long)c << i;
            c = in[offset++];
            i += 7;
        }
        return num |= ((long)c & 0x7FL) << i;
    }

    public static final long readVbLong(ByteBuffer buffer) {
        int i = 0;
        long num = 0L;
        byte c = buffer.get();
        while ((c & 0x80) == 0) {
            num |= (long)c << i;
            c = buffer.get();
            i += 7;
        }
        return num |= ((long)c & 0x7FL) << i;
    }

    public static final int checkVbLengthInt(int num) {
        if (!$assertionsDisabled && num < 0) {
            throw new AssertionError(num);
        }
        int i = 1;
        num >>>= 7;
        while (num > 0) {
            ++i;
            num >>>= 7;
        }
        return i;
    }

    public static final int checkVbLengthLong(long num) {
        if (!$assertionsDisabled && num < 0L) {
            throw new AssertionError(num);
        }
        int i = 1;
        num >>>= 7;
        while (num > 0L) {
            ++i;
            num >>>= 7;
        }
        return i;
    }

    public static final int readIntSafe(InputStream in) throws IOException {
        int first = in.read();
        int second = in.read();
        int third = in.read();
        int forth = in.read();
        if (first < 0 || second < 0 || third < 0 || forth < 0) {
            throw new IOException("Stream is reached EOF");
        }
        return first << 24 | second << 16 | third << 8 | forth << 0;
    }

    public static final void readExactBytes(InputStream in, byte[] buffer, int offset, int want) throws IOException {
        int nread;
        int n = 0;
        int left = want;
        do {
            if ((nread = in.read(buffer, offset, left)) < 0) {
                throw new IOException("Cannot read any more : want=" + want + ", read=" + n);
            }
            offset += nread;
            left -= nread;
        } while ((n += nread) < want);
    }

    public static byte[] hexToByteArray(String hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        byte[] ba = new byte[hex.length() / 2];
        int i = 0;
        while (i < ba.length) {
            ba[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return ba;
    }

    public static String byteArrayToHex(byte[] ba) {
        if (ba == null || ba.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(ba.length * 2);
        int x = 0;
        while (x < ba.length) {
            String hexNumber = "0" + Integer.toHexString(0xFF & ba[x]);
            sb.append(hexNumber.substring(hexNumber.length() - 2));
            ++x;
        }
        return sb.toString();
    }
}

