/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

public class CharBuffer {
    private char[] value;
    private int count;

    public CharBuffer(int initialSize) {
        this.value = new char[initialSize];
        this.count = 0;
    }

    public CharBuffer() {
        this(16);
    }

    private void ensureCapacity(int minimumSize) {
        if (this.value.length < (minimumSize += this.count)) {
            this.expandCapacity(minimumSize);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public CharBuffer append(char[] ap, int start, int length) {
        this.ensureCapacity(length);
        System.arraycopy(ap, start, this.value, this.count, length);
        this.count += length;
        return this;
    }

    public CharBuffer append(char[] ap) {
        return this.append(ap, 0, ap.length);
    }

    public CharBuffer append(String ap) {
        char[] cap = ap.toCharArray();
        return this.append(cap, 0, cap.length);
    }

    public CharBuffer append(int ap) {
        char[] cap = String.valueOf(ap).toCharArray();
        return this.append(cap, 0, cap.length);
    }

    public CharBuffer append(char ap) {
        this.ensureCapacity(1);
        this.value[this.count] = ap;
        ++this.count;
        return this;
    }

    public CharBuffer append(long ap) {
        char[] cap = String.valueOf(ap).toCharArray();
        return this.append(cap, 0, cap.length);
    }

    public CharBuffer append(double ap) {
        char[] cap = String.valueOf(ap).toCharArray();
        return this.append(cap, 0, cap.length);
    }

    public CharBuffer append(float ap) {
        char[] cap = String.valueOf(ap).toCharArray();
        return this.append(cap, 0, cap.length);
    }

    public CharBuffer append(Object ap) {
        char[] cap = ap.toString().toCharArray();
        return this.append(cap, 0, cap.length);
    }

    public char[] toCharArray() {
        char[] trimed = new char[this.count];
        System.arraycopy(this.value, 0, trimed, 0, this.count);
        return trimed;
    }

    public String toString() {
        return new String(this.toCharArray());
    }
}

