/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import java.util.Arrays;

public final class CharUtil {
    public static final char[] copyOf(char[] c) {
        return CharUtil.copyOf(c, 0, c.length);
    }

    public static final char[] copyOf(char[] c, int start, int count) {
        char[] copy = new char[count];
        System.arraycopy(c, start, copy, 0, count);
        return copy;
    }

    public static final int digit(char c) {
        return c - 48;
    }

    public static final int digit(char[] c) {
        return CharUtil.digit(c, 0, c.length);
    }

    public static final int digit(char[] c, int start, int length) {
        int val = 0;
        int i = 0;
        while (i < length) {
            val += CharUtil.digit(c[start + i]) * CharUtil.pow(10, length - i);
            ++i;
        }
        return val;
    }

    private static final int pow(int base, int t) {
        int bb = 1;
        int i = 0;
        while (i < t - 1) {
            bb *= base;
            ++i;
        }
        return bb;
    }

    public static final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static final boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static final boolean isAlphaNumeric(char c) {
        return c <= 'z' && c >= '0' && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9');
    }

    public static final char[] trim(char[] ca) {
        int len = ca.length;
        int st = 0;
        char[] val = ca;
        while (st < len && val[st] <= ' ') {
            ++st;
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        char[] nca = new char[len - st];
        if (len > st) {
            System.arraycopy(ca, st, nca, 0, len - st);
            return nca;
        }
        return new char[0];
    }

    public static final boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public static final boolean isValidId(String name) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int compareToIgnoreCase(char[] one, char[] two) {
        int len1 = one.length;
        int len2 = two.length;
        int k = 0;
        int limit = Math.min(len1, len2);
        while (k < limit) {
            char c1 = one[k];
            char c2 = two[k];
            if (c1 != c2 && Character.toUpperCase(c1) != Character.toUpperCase(c2)) {
                return c1 - c2;
            }
            ++k;
        }
        return len1 - len2;
    }

    public static int compareTo(char[] one, char[] two) {
        int len1 = one.length;
        int len2 = two.length;
        int k = 0;
        int limit = Math.min(len1, len2);
        while (k < limit) {
            char c1 = one[k];
            char c2 = two[k];
            if (c1 != c2) {
                return c1 - c2;
            }
            ++k;
        }
        return len1 - len2;
    }

    public static int indexOf(char[] chars, char c) {
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final char[] getUpperCaseCopy(char[] ca) {
        char[] copy = new char[ca.length];
        int i = 0;
        while (i < ca.length) {
            copy[i] = Character.toUpperCase(ca[i]);
            ++i;
        }
        return copy;
    }

    public static final char[] getUpperCase(char[] ca) {
        return CharUtil.getUpperCase(ca, 0, ca.length);
    }

    public static final char[] toUpperCase(char[] ca) {
        int i = 0;
        while (i < ca.length) {
            ca[i] = Character.toUpperCase(ca[i]);
            ++i;
        }
        return ca;
    }

    public static final char[] toUpperCase(char[] ca, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            ca[i] = Character.toUpperCase(ca[i]);
            ++i;
        }
        return ca;
    }

    public static final char[] getUpperCase(char[] ca, int offset, int length) {
        char[] out = new char[length];
        int i = 0;
        while (i < length) {
            out[i] = Character.toUpperCase(ca[i + offset]);
            ++i;
        }
        return out;
    }

    public static final char[] toLowerCase(char[] ca) {
        int i = 0;
        while (i < ca.length) {
            ca[i] = Character.toLowerCase(ca[i]);
            ++i;
        }
        return ca;
    }

    public static final char[] toLowerCase(char[] ca, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            ca[i] = Character.toLowerCase(ca[i]);
            ++i;
        }
        return ca;
    }

    public static final char[] removeWhitespace(char[] ca) {
        char[] new_ca = new char[ca.length];
        int index = 0;
        int i = 0;
        while (i < ca.length) {
            char ch = ca[i];
            if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                new_ca[index++] = ca[i];
            }
            ++i;
        }
        char[] result = new char[index];
        System.arraycopy(new_ca, 0, result, 0, index);
        return result;
    }

    public static final char[] replace(char[] source, char[] changee, char represent) {
        char[] chars = (char[])changee.clone();
        Arrays.sort(chars);
        char[] new_ca = new char[source.length];
        int index = 0;
        int i = 0;
        while (i < source.length) {
            char ch = source[i];
            new_ca[index++] = Arrays.binarySearch(chars, ch) >= 0 ? represent : ch;
            ++i;
        }
        char[] result = new char[index];
        System.arraycopy(new_ca, 0, result, 0, index);
        return result;
    }

    public static final char[] compactWhitespace(char[] ca) {
        boolean flag = false;
        char[] new_ca = new char[ca.length];
        int index = 0;
        int i = 0;
        while (i < ca.length) {
            char ch = ca[i];
            if (ch <= ' ' && (4294981120L >> ch & 1L) != 0L) {
                if (!flag) {
                    new_ca[index++] = ca[i];
                    flag = true;
                }
            } else {
                flag = false;
                new_ca[index++] = ca[i];
            }
            ++i;
        }
        char[] result = new char[index];
        System.arraycopy(new_ca, 0, result, 0, index);
        return result;
    }

    public static final boolean isCharEquals(char[] src, int sStart, int sLength, char[] dest, int dStart, int dLength) {
        if (sLength != dLength) {
            return false;
        }
        int i = sStart;
        while (i < sStart + sLength) {
            if (src[i] != dest[dStart++]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(char[] src, int sStart, int sLength, char[] dest, int dStart, int dLength) {
        if (sLength != dLength) {
            return false;
        }
        int s = sStart;
        int d = dStart;
        int length = sLength;
        while (length-- > 0) {
            if (src[s++] == dest[d++]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equalsIgnoreCase(char[] src, int sStart, int sLength, char[] dest, int dStart, int dLength) {
        if (sLength != dLength) {
            return false;
        }
        int s = sStart;
        int d = dStart;
        int length = sLength;
        while (length-- > 0) {
            char b;
            char a;
            if ((a = src[s++]) == (b = dest[d++]) || Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b)) continue;
            return false;
        }
        return true;
    }

    public static final char[] subChar(char[] src, int start, int length) {
        char[] r = new char[length];
        System.arraycopy(src, start, r, 0, length);
        return r;
    }

    public static final String substring(char[] src, int start, int end) {
        return new String(src, start, end - start);
    }

    public static final int indexOf(char[] src, char f, int start) {
        int i = start;
        while (i < src.length) {
            if (src[i] == f) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final boolean isEmpty(char[] src) {
        return src == null || src.length == 0;
    }
}

