/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    private static final String fullDatePattern = "yyyyMMddHHmmssSSS";
    static RdbmsProperties rdbms = RdbmsPropertiesFactory.load();

    public static Date addDate(int day) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, day);
        return cal.getTime();
    }

    public static Date getDayEnd(Date date) {
        Calendar tlc = Calendar.getInstance();
        tlc.setTime(date);
        tlc.set(11, 24);
        tlc.set(12, 0);
        tlc.set(13, 0);
        tlc.set(14, 0);
        tlc.add(14, -1);
        Date tl = tlc.getTime();
        return tl;
    }

    public static long getDayEnd(long date) {
        Calendar tlc = Calendar.getInstance();
        tlc.setTimeInMillis(date);
        tlc.set(11, 24);
        tlc.set(12, 0);
        tlc.set(13, 0);
        tlc.set(14, 0);
        tlc.add(14, -1);
        long tl = tlc.getTimeInMillis();
        return tl;
    }

    public static Date getDayStart(Date date) {
        Calendar tsc = Calendar.getInstance();
        tsc.setTime(date);
        tsc.set(11, 0);
        tsc.set(12, 0);
        tsc.set(13, 0);
        tsc.set(14, 0);
        Date tc = tsc.getTime();
        return tc;
    }

    public static long getDayStart(long date) {
        Calendar tsc = Calendar.getInstance();
        tsc.setTimeInMillis(date);
        tsc.set(11, 0);
        tsc.set(12, 0);
        tsc.set(13, 0);
        tsc.set(14, 0);
        long tc = tsc.getTimeInMillis();
        return tc;
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        if (year == 0) {
            return null;
        }
        if (month == 0) {
            month = 1;
        }
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDate(String yymmddhhss) {
        String year = null;
        String month = null;
        String day = null;
        String hour = null;
        String minute = null;
        String second = null;
        int iyear = 0;
        int imonth = 0;
        int iday = 0;
        int ihour = 0;
        int iminute = 0;
        int isecond = 0;
        try {
            year = yymmddhhss.substring(0, 4);
            month = yymmddhhss.substring(4, 6);
            day = yymmddhhss.substring(6, 8);
            hour = yymmddhhss.substring(8, 10);
            minute = yymmddhhss.substring(10, 12);
            second = yymmddhhss.substring(12, 14);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iyear = year == null ? 0 : Integer.parseInt(year);
        imonth = month == null ? 1 : Integer.parseInt(month);
        iday = day == null ? 1 : Integer.parseInt(day);
        ihour = hour == null ? 0 : Integer.parseInt(hour);
        iminute = minute == null ? 0 : Integer.parseInt(minute);
        isecond = second == null ? 0 : Integer.parseInt(second);
        return DateUtil.getDate(iyear, imonth, iday, ihour, iminute, isecond);
    }

    public static Date check(String s) throws ParseException {
        return DateUtil.check(s, "yyyyMMdd");
    }

    public static String changeFormat(String s, String format, String toformat) throws ParseException {
        Date date = DateUtil.check(s, format);
        SimpleDateFormat formatter = new SimpleDateFormat(toformat, Locale.KOREA);
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String changeFormat(Date date, String toformat) {
        SimpleDateFormat formatter = new SimpleDateFormat(toformat, Locale.KOREA);
        String dateString = formatter.format(date);
        return dateString;
    }

    public static Date check(String s, String format) throws ParseException {
        if (s == null) {
            throw new ParseException("date string to check is null", 0);
        }
        if (format == null) {
            throw new ParseException("format string to check date is null", 0);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = null;
        try {
            date = formatter.parse(s);
        }
        catch (ParseException e) {
            throw new ParseException(" wrong date:\"" + s + "\" with format \"" + format + "\"", 0);
        }
        if (!formatter.format(date).equals(s)) {
            throw new ParseException("Out of bound date:\"" + s + "\" with format \"" + format + "\"", 0);
        }
        return date;
    }

    public static boolean isValid(String s) {
        return DateUtil.isValid(s, "HH:mm:ss");
    }

    public static Date getDateInstance(String s) throws ParseException {
        String format = "HH:mm";
        if (!DateUtil.isValid(s, "HH:mm")) {
            if (DateUtil.isValid(s, "HH/mm")) {
                format = "HH/mm";
            } else {
                throw new ParseException("wrong data or format", 0);
            }
        }
        return DateUtil.check(s, format);
    }

    public static boolean isValid(String s, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = null;
        try {
            date = formatter.parse(s);
        }
        catch (ParseException e) {
            return false;
        }
        return formatter.format(date).equals(s);
    }

    public static String getDateString(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        return formatter.format(new Date());
    }

    public static int getDay() {
        return DateUtil.getNumberByPattern("dd");
    }

    public static int getYear() {
        return DateUtil.getNumberByPattern("yyyy");
    }

    public static int getMonth() {
        return DateUtil.getNumberByPattern("MM");
    }

    public static int getHour() {
        return DateUtil.getNumberByPattern("HH");
    }

    public static int getMin() {
        return DateUtil.getNumberByPattern("mm");
    }

    public static int getNumberByPattern(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.KOREA);
        String dateString = formatter.format(new Date());
        return Integer.parseInt(dateString);
    }

    public static int getNumberByPattern(String dates, String spattern, String pattern) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.KOREA);
        String dateString = formatter.format(DateUtil.check(dates, spattern));
        return Integer.parseInt(dateString);
    }

    public static String getFormatString(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.KOREA);
        String dateString = formatter.format(new Date());
        return dateString;
    }

    public static String getShortDateString() {
        return DateUtil.getFormatString("yyyyMMdd");
    }

    public static String getShortTimeString() {
        return DateUtil.getFormatString("HHmmss");
    }

    public static String getTimeStampString() {
        return DateUtil.getFormatString("yyyy-MM-dd-HH:mm:ss:SSS");
    }

    public static String getTimeString() {
        return DateUtil.getFormatString("HH:mm:ss");
    }

    public static int whichDay(String s) throws ParseException {
        return DateUtil.whichDay(s, "yyyyMMdd");
    }

    public static int whichDay(String s, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateUtil.check(s, format);
        Calendar calendar = formatter.getCalendar();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static int daysBetween(String from, String to) throws ParseException {
        return DateUtil.daysBetween(from, to, "yyyyMMdd");
    }

    public static int daysBetween(String from, String to, String format) throws ParseException {
        Date d1 = DateUtil.check(from, format);
        Date d2 = DateUtil.check(to, format);
        long duration = d2.getTime() - d1.getTime();
        return (int)(duration / 86400000L);
    }

    public static int weeksBetween(String from, String to) throws ParseException {
        return DateUtil.weeksBetween(from, to, "yyyyMMdd");
    }

    public static int weeksBetween(String from, String to, String format) throws ParseException {
        Date d1 = DateUtil.check(from, format);
        Date d2 = DateUtil.check(to, format);
        Date w1 = DateUtil.getStartCurrentDay(d1);
        Date w2 = DateUtil.getStartCurrentDay(d2);
        long duration = w2.getTime() - w1.getTime();
        return (int)(duration / 604800000L);
    }

    public static int timesBetween(String from, String to) throws ParseException {
        return DateUtil.timesBetween(from, to, "yyyyMMdd");
    }

    public static int timesBetween(String from, String to, String format) throws ParseException {
        Date d1 = DateUtil.check(from, format);
        Date d2 = DateUtil.check(to, format);
        long duration = d2.getTime() - d1.getTime();
        return (int)(duration / 3600000L);
    }

    public static int minsBetween(String from, String to, String format) throws ParseException {
        Date d1 = DateUtil.check(from, format);
        Date d2 = DateUtil.check(to, format);
        long duration = d2.getTime() - d1.getTime();
        return (int)(duration / 60000L);
    }

    public static String timesBetweenStr(String from, String to, String format) throws ParseException {
        int min = DateUtil.minsBetween(from, to, format);
        if (min < 0) {
            throw new RuntimeException("Negative time difference.");
        }
        int time = min / 60;
        return new String(String.valueOf(time) + "hours " + (min %= 60) + "minutes");
    }

    public static int monthsBetween(String from, String to) throws ParseException {
        return DateUtil.monthsBetween(from, to, "yyyyMMdd");
    }

    public static int monthsBetween(String from, String to, String format) throws ParseException {
        Date toDate;
        Date fromDate = DateUtil.check(from, format);
        if (fromDate.compareTo(toDate = DateUtil.check(to, format)) == 0) {
            return 0;
        }
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
        SimpleDateFormat dayFormat = new SimpleDateFormat("dd", Locale.KOREA);
        int fromYear = Integer.parseInt(yearFormat.format(fromDate));
        int toYear = Integer.parseInt(yearFormat.format(toDate));
        int fromMonth = Integer.parseInt(monthFormat.format(fromDate));
        int toMonth = Integer.parseInt(monthFormat.format(toDate));
        int fromDay = Integer.parseInt(dayFormat.format(fromDate));
        int toDay = Integer.parseInt(dayFormat.format(toDate));
        int result = 0;
        result += (toYear - fromYear) * 12;
        result += toMonth - fromMonth;
        if (toDay - fromDay > 0) {
            result += toDate.compareTo(fromDate);
        }
        return result;
    }

    public static int ageBetween(String from, String to) throws ParseException {
        return DateUtil.ageBetween(from, to, "yyyyMMdd");
    }

    public static int age(String birth) throws ParseException {
        return DateUtil.ageBetween(birth, DateUtil.getFormatString("yyyyMMdd"), "yyyyMMdd");
    }

    public static int ageBetween(String from, String to, String format) throws ParseException {
        return DateUtil.daysBetween(from, to, format) / 365;
    }

    public static String addDays(String s, int day) throws ParseException {
        return DateUtil.addDays(s, day, "yyyyMMdd");
    }

    public static String addDays(int day) throws ParseException {
        return DateUtil.addDays(DateUtil.getShortDateString(), day, "yyyyMMdd");
    }

    public static String addDays(int day, String format) throws ParseException {
        String today = DateUtil.getShortDateString();
        String tmp = DateUtil.addDays(today, day, "yyyyMMdd");
        return DateUtil.changeFormat(tmp, "yyyyMMdd", format);
    }

    public static String addDays(String s, int day, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateUtil.check(s, format);
        date.setTime(date.getTime() + (long)day * 1000L * 60L * 60L * 24L);
        return formatter.format(date);
    }

    public static String addTimes(String s, int time, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateUtil.check(s, format);
        date.setTime(date.getTime() + 3600000L * (long)time);
        return formatter.format(date);
    }

    public static String addTimes(int time, String format) throws ParseException {
        String fomatted = DateUtil.getFormatString(format);
        return DateUtil.addTimes(fomatted, time, format);
    }

    public static String getUTCTimeString() {
        String ret = "";
        try {
            ret = DateUtil.addTimes(-9, "yyyy-MM-dd HH:mm:ss:SSS ");
            char[] rets = ret.toCharArray();
            rets[10] = 84;
            rets[23] = 90;
            ret = new String(rets);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String addMonths(String s, int month) throws ParseException {
        return DateUtil.addMonths(s, month, "yyyyMMdd");
    }

    /*
     * Unable to fully structure code
     */
    public static String addMonths(String s, int addMonth, String format) throws ParseException {
        block4: {
            formatter = new SimpleDateFormat(format, Locale.KOREA);
            date = DateUtil.check(s, format);
            yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
            monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
            dayFormat = new SimpleDateFormat("dd", Locale.KOREA);
            year = Integer.parseInt(yearFormat.format(date));
            month = Integer.parseInt(monthFormat.format(date));
            day = Integer.parseInt(dayFormat.format(date));
            month += addMonth;
            if (addMonth <= 0) ** GOTO lbl18
            while (month > 12) {
                month -= 12;
                ++year;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                month += 12;
                --year;
lbl18:
                // 2 sources

                ** while (month <= 0)
            }
        }
        fourDf = new DecimalFormat("0000");
        twoDf = new DecimalFormat("00");
        tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
        targetDate = null;
        try {
            targetDate = DateUtil.check(tempDate, "yyyyMMdd");
        }
        catch (ParseException pe) {
            day = DateUtil.lastDay(year, month);
            tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
            targetDate = DateUtil.check(tempDate, "yyyyMMdd");
        }
        return formatter.format(targetDate);
    }

    public static String addYears(String s, int year) throws ParseException {
        return DateUtil.addYears(s, year, "yyyyMMdd");
    }

    public static String addYears(String s, int year, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateUtil.check(s, format);
        date.setTime(date.getTime() + (long)year * 1000L * 60L * 60L * 24L * 366L);
        return formatter.format(date);
    }

    public static String lastDayOfMonth(String src) throws ParseException {
        return DateUtil.lastDayOfMonth(src, "yyyyMMdd");
    }

    public static String lastDayOfMonth(String src, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateUtil.check(src, format);
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
        int year = Integer.parseInt(yearFormat.format(date));
        int month = Integer.parseInt(monthFormat.format(date));
        int day = DateUtil.lastDay(year, month);
        DecimalFormat fourDf = new DecimalFormat("0000");
        DecimalFormat twoDf = new DecimalFormat("00");
        String tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
        date = DateUtil.check(tempDate, format);
        return formatter.format(date);
    }

    public static int lastDay(int year, int month) {
        int day = 0;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                day = 31;
                break;
            }
            case 2: {
                if (year % 4 == 0) {
                    if (year % 100 == 0 && year % 400 != 0) {
                        day = 28;
                        break;
                    }
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            default: {
                day = 30;
            }
        }
        return day;
    }

    public static String checkDateTime(String s) throws ParseException {
        DateUtil.check(s, "yyyy/MM/dd HH:mm");
        return s;
    }

    public static boolean isMiddleTime(String startTime, String endTime, String checkTime) throws ParseException {
        Date a = DateUtil.getDateInstance(startTime);
        Date b = DateUtil.getDateInstance(endTime);
        Date c = DateUtil.getDateInstance(checkTime);
        return DateUtil.isMiddleTime(a, b, c);
    }

    public static boolean isMiddleTime(Date startTime, Date endTime, Date checkTime) {
        return startTime.before(endTime) ? endTime.after(checkTime) && startTime.before(checkTime) : endTime.after(checkTime) || startTime.before(checkTime);
    }

    public static boolean isMiddleTime(String startTime, String endTime) throws ParseException {
        String curTime = DateUtil.getFormatString("HH:mm");
        return DateUtil.isMiddleTime(startTime, endTime, curTime);
    }

    public static long getNextMinute() {
        long current = System.currentTimeMillis();
        long remainMillis = 60000L - current % 60000L;
        return current + remainMillis;
    }

    public static String[] getTimeStrings(long time) {
        String[] times = new String[7];
        Date date = new Date(time);
        SimpleDateFormat formatter = new SimpleDateFormat(fullDatePattern, Locale.KOREA);
        String dateString = formatter.format(date);
        times[0] = dateString.substring(0, 4);
        times[1] = dateString.substring(4, 6);
        times[2] = dateString.substring(6, 8);
        times[3] = dateString.substring(8, 10);
        times[4] = dateString.substring(10, 12);
        times[5] = dateString.substring(12, 14);
        times[6] = dateString.substring(14, 17);
        return times;
    }

    public static String[] getTimeStrings(Date date) {
        return DateUtil.getTimeStrings(date.getTime());
    }

    public static int[] getTimeInts(long time) {
        String[] times = DateUtil.getTimeStrings(time);
        int[] intTimes = new int[times.length];
        int i = 0;
        while (i < times.length) {
            intTimes[i] = Integer.parseInt(times[i]);
            ++i;
        }
        return intTimes;
    }

    public static int[] getTimeInts(Date date) {
        return DateUtil.getTimeInts(date.getTime());
    }

    public static Date getWeekStart(Date date) {
        Calendar tsc = Calendar.getInstance();
        tsc.setTime(date);
        tsc.set(7, 2);
        DateUtil.resetHHMMSS(tsc);
        return tsc.getTime();
    }

    public static long getWeekStart(long date) {
        Calendar tsc = Calendar.getInstance();
        tsc.setTimeInMillis(date);
        tsc.set(7, 2);
        DateUtil.resetHHMMSS(tsc);
        return tsc.getTimeInMillis();
    }

    public static Date getMonthStart(Date date) {
        Calendar tsc = Calendar.getInstance();
        tsc.setTime(date);
        tsc.set(5, 1);
        DateUtil.resetHHMMSS(tsc);
        return tsc.getTime();
    }

    public static long getMonthStart(long date) {
        Calendar tsc = Calendar.getInstance();
        tsc.setTimeInMillis(date);
        tsc.set(5, 1);
        DateUtil.resetHHMMSS(tsc);
        return tsc.getTimeInMillis();
    }

    private static int calDay2Day(int first, int current) {
        return first - current;
    }

    private static void resetHHMMSS(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static long getStartCurrentDayMills(Date day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        DateUtil.resetHHMMSS(cal);
        return cal.getTimeInMillis();
    }

    public static Date getStartCurrentDay(Date day) {
        return new Date(DateUtil.getStartCurrentDayMills(day));
    }

    public static Date getStartCurrentDay() {
        Date current = new Date(System.currentTimeMillis());
        return DateUtil.getStartCurrentDay(current);
    }

    public static Date getStartNextDay(Date day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        DateUtil.resetHHMMSS(cal);
        cal.add(5, 1);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getStartCurrentWeek(Date day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.set(7, 2);
        DateUtil.resetHHMMSS(cal);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getStartCurrentWeek() {
        Date current = new Date(System.currentTimeMillis());
        return DateUtil.getStartCurrentWeek(current);
    }

    public static Date getStartNextWeek(Date day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.setFirstDayOfWeek(2);
        int plusDay = DateUtil.calDay2Day(cal.get(7), cal.getFirstDayOfWeek());
        cal.add(5, 7 - plusDay);
        DateUtil.resetHHMMSS(cal);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getStartCurrentMonth(Date day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.set(5, 1);
        DateUtil.resetHHMMSS(cal);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getStartCurrentMonth() {
        Date current = new Date(System.currentTimeMillis());
        return DateUtil.getStartCurrentMonth(current);
    }

    public static Date getStartNextMonth(Date day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.set(5, 1);
        cal.add(2, 1);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getStartBeforeDate(Date day, int date) {
        int before = 0 - date;
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.add(5, before);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getStartBeforeWeek(Date day, int week) {
        int before = 0 - week * 7;
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.add(5, before);
        return new Date(cal.getTimeInMillis());
    }

    public static Date getStartBeforeMonth(Date day, int month) {
        int before = 0 - month;
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.add(2, before);
        return new Date(cal.getTimeInMillis());
    }

    public static Timestamp getDefaultTimestamp() {
        if (rdbms.getUrl().indexOf("cubrid") > -1) {
            return new Timestamp(1000L);
        }
        return new Timestamp(0L);
    }

    public static Date getDefaultDate() {
        if (rdbms.getUrl().indexOf("cubrid") > -1) {
            return new Date(1000L);
        }
        return new Date(0L);
    }
}

